/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;

public class LogTransform
extends WigMathTool {
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-b", "--base"}, description="Logarithm base (default = 2)")
    public double base = 2.0;
    WigFileReader reader;
    private double baseChange;

    @Override
    public void setup() {
        this.baseChange = Math.log(this.base);
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] result = this.reader.query(chunk).getValues();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)(Math.log(result[i]) / this.baseChange);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new LogTransform().instanceMain(args);
    }
}

