/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import java.util.Iterator;

class StringIntervalIterator<T extends Interval>
implements Iterator<T> {
    protected Iterator<String> it;
    protected IntervalFactory<T> factory;

    public StringIntervalIterator(Iterator<String> it, IntervalFactory<T> factory) {
        this.it = it;
        this.factory = factory;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public T next() {
        T interval = null;
        while (interval == null && this.it.hasNext()) {
            String line = this.it.next();
            interval = this.factory.parse(line);
        }
        return interval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove lines from TextIntervalFile");
    }
}

