/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class DoubleFFT_3DTest {
    public static final String DEFAULT_MESSAGE = "%d-threaded FFT of size %dx%dx%d: ";
    public static final int SEED = 20110625;
    private final DoubleFFT_3D fft;
    private final int numCols;
    private final int numRows;
    private final int numSlices;
    private final Random random;
    private final DoubleFFT_2D sfft;
    private final DoubleFFT_1D xfft;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    arrayList.add(new Object[]{nArray[i], nArray[j], nArray[k], 1, 20110625});
                    arrayList.add(new Object[]{nArray[i], nArray[j], nArray[k], 4, 20110625});
                }
            }
        }
        return arrayList;
    }

    public DoubleFFT_3DTest(int n, int n2, int n3, int n4, long l) {
        this.numSlices = n;
        this.numRows = n2;
        this.numCols = n3;
        this.fft = new DoubleFFT_3D(n, n2, n3);
        this.xfft = new DoubleFFT_1D(n);
        this.sfft = new DoubleFFT_2D(n2, n3);
        this.random = new Random(l);
        ConcurrencyUtils.setNumberOfThreads(n4);
        ConcurrencyUtils.setThreadsBeginN_3D(4);
    }

    public void complexForward(double[][][] dArray) {
        for (int i = 0; i < this.numSlices; ++i) {
            this.sfft.complexForward(dArray[i]);
        }
        double[] dArray2 = new double[2 * this.numSlices];
        for (int i = 0; i < this.numCols; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                int n;
                for (n = 0; n < this.numSlices; ++n) {
                    dArray2[2 * n] = dArray[n][j][2 * i];
                    dArray2[2 * n + 1] = dArray[n][j][2 * i + 1];
                }
                this.xfft.complexForward(dArray2);
                for (n = 0; n < this.numSlices; ++n) {
                    dArray[n][j][2 * i] = dArray2[2 * n];
                    dArray[n][j][2 * i + 1] = dArray2[2 * n + 1];
                }
            }
        }
    }

    public FloatingPointEqualityChecker createEqualityChecker(double d, double d2) {
        String string = String.format(DEFAULT_MESSAGE, ConcurrencyUtils.getNumberOfThreads(), this.numSlices, this.numRows, this.numCols);
        return new FloatingPointEqualityChecker(string, d, d2, 0.0f, 0.0f);
    }

    @Test
    public void testComplexForward1dInput() {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(Math.ulp(1.0), 0.0);
        double[] dArray = new double[2 * this.numSlices * this.numRows * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        for (n4 = 0; n4 < this.numSlices; ++n4) {
            for (n3 = 0; n3 < this.numRows; ++n3) {
                for (n2 = 0; n2 < 2 * this.numCols; ++n2) {
                    n = 2 * this.numCols * (n3 + this.numRows * n4) + n2;
                    dArray[n] = d = this.random.nextDouble();
                    dArray2[n4][n3][n2] = d;
                }
            }
        }
        this.fft.complexForward(dArray);
        this.complexForward(dArray2);
        for (n4 = 0; n4 < this.numSlices; ++n4) {
            for (n3 = 0; n3 < this.numRows; ++n3) {
                for (n2 = 0; n2 < 2 * this.numCols; ++n2) {
                    n = 2 * this.numCols * (n3 + this.numRows * n4) + n2;
                    d = dArray2[n4][n3][n2];
                    double d2 = dArray[n];
                    floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d2);
                }
            }
        }
    }

    @Test
    public void testComplexForward3dInput() {
        double d;
        int n;
        int n2;
        int n3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(Math.ulp(1.0), 0.0);
        double[][][] dArray = new double[this.numSlices][this.numRows][2 * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    dArray[n3][n2][n] = d = this.random.nextDouble();
                    dArray2[n3][n2][n] = d;
                }
            }
        }
        this.fft.complexForward(dArray);
        this.complexForward(dArray2);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    d = dArray2[n3][n2][n];
                    double d2 = dArray[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n2 + "][" + n + "]", d, d2);
                }
            }
        }
    }

    @Test
    public void testComplexInverseScaled1dInput() {
        double d;
        int n;
        double d2 = 1.0E-8;
        double d3 = 5.0E-8;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[2 * this.numSlices * this.numRows * this.numCols];
        double[] dArray2 = new double[2 * this.numSlices * this.numRows * this.numCols];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = d = this.random.nextDouble();
            dArray[n] = d;
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, true);
        for (n = 0; n < dArray2.length; ++n) {
            d = dArray[n];
            double d5 = dArray2[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d5);
        }
    }

    @Test
    public void testComplexInverseScaled3dInput() {
        double d;
        int n;
        int n2;
        int n3;
        double d2 = 1.0E-8;
        double d3 = 5.0E-8;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][][] dArray = new double[this.numSlices][this.numRows][2 * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    dArray2[n3][n2][n] = d = this.random.nextDouble();
                    dArray[n3][n2][n] = d;
                }
            }
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, true);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    d = dArray[n3][n2][n];
                    double d5 = dArray2[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n2 + "][" + n + "]", d, d5);
                }
            }
        }
    }

    @Test
    public void testComplexInverseUnscaled1dInput() {
        double d = 1.0E-8;
        double d2 = 5.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.numSlices * this.numRows * this.numCols];
        double[] dArray2 = new double[2 * this.numSlices * this.numRows * this.numCols];
        for (int i = 0; i < dArray2.length; ++i) {
            double d4;
            dArray2[i] = d4 = this.random.nextDouble();
            dArray[i] = d4;
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, false);
        double d5 = this.numSlices * this.numRows * this.numCols;
        for (int i = 0; i < dArray2.length; ++i) {
            double d6 = d5 * dArray[i];
            double d7 = dArray2[i];
            floatingPointEqualityChecker.assertEquals("[" + i + "]", d6, d7);
        }
    }

    @Test
    public void testComplexInverseUnscaled3dInput() {
        int n;
        double d = 1.0E-8;
        double d2 = 5.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[][][] dArray = new double[this.numSlices][this.numRows][2 * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        for (int i = 0; i < this.numSlices; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    double d4;
                    dArray2[i][j][n] = d4 = this.random.nextDouble();
                    dArray[i][j][n] = d4;
                }
            }
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, false);
        double d5 = this.numSlices * this.numRows * this.numCols;
        for (n = 0; n < this.numSlices; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < 2 * this.numCols; ++j) {
                    double d6 = d5 * dArray[n][i][j];
                    double d7 = dArray2[n][i][j];
                    floatingPointEqualityChecker.assertEquals("[" + n + "][" + i + "][" + j + "]", d6, d7);
                }
            }
        }
    }

    @Test
    public void testRealForward1dInput() {
        int[] nArray;
        int n;
        int n2;
        int n3;
        int n4;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        double d = 1.0E-8;
        double d2 = 1.0E-5;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[this.numSlices * this.numRows * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        boolean[] blArray = new boolean[this.numSlices * this.numRows * this.numCols];
        for (int i = 0; i < this.numSlices; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    double d4;
                    n4 = k + this.numCols * (j + this.numRows * i);
                    dArray[n4] = d4 = this.random.nextDouble();
                    dArray2[i][j][2 * k] = d4;
                    dArray2[i][j][2 * k + 1] = 0.0;
                    blArray[n4] = false;
                }
            }
        }
        this.fft.realForward(dArray);
        this.complexForward(dArray2);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            double d5;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 2; n < this.numCols; ++n) {
                    n4 = n + this.numCols * (n2 + this.numRows * n3);
                    d5 = dArray[n4];
                    double d6 = dArray2[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n4 + "]", d6, d5);
                    blArray[n4] = true;
                }
            }
            for (n2 = 1; n2 < this.numRows / 2; ++n2) {
                arrayList.clear();
                arrayList.add(new int[]{n3, n2, 0, n3, n2, 0});
                arrayList.add(new int[]{n3, n2, 1, n3, n2, 1});
                n = this.numRows - n2;
                arrayList.add(new int[]{n3, n, 1, n3, n, this.numCols});
                arrayList.add(new int[]{n3, n, 0, n3, n, this.numCols + 1});
                for (int i = 0; i < arrayList.size(); ++i) {
                    nArray = (int[])arrayList.get(i);
                    n4 = nArray[2] + this.numCols * (nArray[1] + this.numRows * nArray[0]);
                    d5 = dArray[n4];
                    double d7 = dArray2[nArray[3]][nArray[4]][nArray[5]];
                    floatingPointEqualityChecker.assertEquals("[" + n4 + "]", d7, d5);
                    blArray[n4] = true;
                }
            }
        }
        for (n3 = 1; n3 < this.numSlices / 2; ++n3) {
            arrayList.clear();
            arrayList.add(new int[]{n3, 0, 0, n3, 0, 0});
            arrayList.add(new int[]{n3, 0, 1, n3, 0, 1});
            arrayList.add(new int[]{n3, this.numRows / 2, 0, n3, this.numRows / 2, 0});
            arrayList.add(new int[]{n3, this.numRows / 2, 1, n3, this.numRows / 2, 1});
            n2 = this.numSlices - n3;
            arrayList.add(new int[]{n2, 0, 1, n2, 0, this.numCols});
            arrayList.add(new int[]{n2, 0, 0, n2, 0, this.numCols + 1});
            arrayList.add(new int[]{n2, this.numRows / 2, 1, n2, this.numRows / 2, this.numCols});
            arrayList.add(new int[]{n2, this.numRows / 2, 0, n2, this.numRows / 2, this.numCols + 1});
            for (n = 0; n < arrayList.size(); ++n) {
                nArray = (int[])arrayList.get(n);
                n4 = nArray[2] + this.numCols * (nArray[1] + this.numRows * nArray[0]);
                double d8 = dArray[n4];
                double d9 = dArray2[nArray[3]][nArray[4]][nArray[5]];
                floatingPointEqualityChecker.assertEquals("[" + n4 + "]", d9, d8);
                blArray[n4] = true;
            }
        }
        arrayList.clear();
        arrayList.add(new int[]{0, 0, 0, 0, 0, 0});
        arrayList.add(new int[]{0, 0, 1, 0, 0, this.numCols});
        arrayList.add(new int[]{0, this.numRows / 2, 0, 0, this.numRows / 2, 0});
        arrayList.add(new int[]{0, this.numRows / 2, 1, 0, this.numRows / 2, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, 0, 0, this.numSlices / 2, 0, 0});
        arrayList.add(new int[]{this.numSlices / 2, 0, 1, this.numSlices / 2, 0, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 0, this.numSlices / 2, this.numRows / 2, 0});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 1, this.numSlices / 2, this.numRows / 2, this.numCols});
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            nArray = (int[])arrayList.get(n3);
            n4 = nArray[2] + this.numCols * (nArray[1] + this.numRows * nArray[0]);
            double d10 = dArray[n4];
            double d11 = dArray2[nArray[3]][nArray[4]][nArray[5]];
            floatingPointEqualityChecker.assertEquals("[" + n4 + "]", d11, d10);
            blArray[n4] = true;
        }
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    n4 = n + this.numCols * (n2 + this.numRows * n3);
                    Assert.assertTrue((String)String.format("[%d][%d][%d]", n3, n2, n), (boolean)blArray[n4]);
                }
            }
        }
    }

    @Test
    public void testRealForward3dInput() {
        int n;
        int n2;
        int n3;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        double d = 1.0E-8;
        double d2 = 1.0E-5;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[][][] dArray = new double[this.numSlices][this.numRows][this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        boolean[][][] blArray = new boolean[this.numSlices][this.numRows][this.numCols];
        for (int i = 0; i < this.numSlices; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    double d4;
                    dArray[i][j][k] = d4 = this.random.nextDouble();
                    dArray2[i][j][2 * k] = d4;
                    dArray2[i][j][2 * k + 1] = 0.0;
                    blArray[i][j][k] = false;
                }
            }
        }
        this.fft.realForward(dArray);
        this.complexForward(dArray2);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            double d5;
            int n4;
            for (n4 = 0; n4 < this.numRows; ++n4) {
                for (int i = 2; i < this.numCols; ++i) {
                    d5 = dArray[n3][n4][i];
                    double d6 = dArray2[n3][n4][i];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n4 + "][" + i + "]", d6, d5);
                    blArray[n3][n4][i] = true;
                }
            }
            for (n4 = 1; n4 < this.numRows / 2; ++n4) {
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                arrayList.add(new int[]{n3, n4, 0, n3, n4, 0});
                arrayList.add(new int[]{n3, n4, 1, n3, n4, 1});
                n2 = this.numRows - n4;
                arrayList.add(new int[]{n3, n2, 1, n3, n2, this.numCols});
                arrayList.add(new int[]{n3, n2, 0, n3, n2, this.numCols + 1});
                for (int i = 0; i < arrayList.size(); ++i) {
                    int[] nArray = (int[])arrayList.get(i);
                    d5 = dArray[nArray[0]][nArray[1]][nArray[2]];
                    double d7 = dArray2[nArray[3]][nArray[4]][nArray[5]];
                    floatingPointEqualityChecker.assertEquals("[" + nArray[0] + "][" + nArray[1] + "][" + nArray[2] + "]", d7, d5);
                    blArray[nArray[0]][nArray[1]][nArray[2]] = true;
                }
            }
        }
        for (n3 = 1; n3 < this.numSlices / 2; ++n3) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            arrayList.add(new int[]{n3, 0, 0, n3, 0, 0});
            arrayList.add(new int[]{n3, 0, 1, n3, 0, 1});
            arrayList.add(new int[]{n3, this.numRows / 2, 0, n3, this.numRows / 2, 0});
            arrayList.add(new int[]{n3, this.numRows / 2, 1, n3, this.numRows / 2, 1});
            int n5 = this.numSlices - n3;
            arrayList.add(new int[]{n5, 0, 1, n5, 0, this.numCols});
            arrayList.add(new int[]{n5, 0, 0, n5, 0, this.numCols + 1});
            arrayList.add(new int[]{n5, this.numRows / 2, 1, n5, this.numRows / 2, this.numCols});
            arrayList.add(new int[]{n5, this.numRows / 2, 0, n5, this.numRows / 2, this.numCols + 1});
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int[] nArray = (int[])arrayList.get(n2);
                double d8 = dArray[nArray[0]][nArray[1]][nArray[2]];
                double d9 = dArray2[nArray[3]][nArray[4]][nArray[5]];
                floatingPointEqualityChecker.assertEquals("[" + nArray[0] + "][" + nArray[1] + "][" + nArray[2] + "]", d9, d8);
                blArray[nArray[0]][nArray[1]][nArray[2]] = true;
            }
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        arrayList.add(new int[]{0, 0, 0, 0, 0, 0});
        arrayList.add(new int[]{0, 0, 1, 0, 0, this.numCols});
        arrayList.add(new int[]{0, this.numRows / 2, 0, 0, this.numRows / 2, 0});
        arrayList.add(new int[]{0, this.numRows / 2, 1, 0, this.numRows / 2, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, 0, 0, this.numSlices / 2, 0, 0});
        arrayList.add(new int[]{this.numSlices / 2, 0, 1, this.numSlices / 2, 0, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 0, this.numSlices / 2, this.numRows / 2, 0});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 1, this.numSlices / 2, this.numRows / 2, this.numCols});
        for (n = 0; n < arrayList.size(); ++n) {
            int[] nArray = (int[])arrayList.get(n);
            double d10 = dArray[nArray[0]][nArray[1]][nArray[2]];
            double d11 = dArray2[nArray[3]][nArray[4]][nArray[5]];
            floatingPointEqualityChecker.assertEquals("[" + nArray[0] + "][" + nArray[1] + "][" + nArray[2] + "]", d11, d10);
            blArray[nArray[0]][nArray[1]][nArray[2]] = true;
        }
        for (n = 0; n < this.numSlices; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                for (n2 = 0; n2 < this.numCols; ++n2) {
                    Assert.assertTrue((String)String.format("[%d][%d][%d]", n, i, n2), (boolean)blArray[n][i][n2]);
                }
            }
        }
    }

    @Test
    public void testRealInverseScaled1dInput() {
        double d;
        int n;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        double d2 = 1.0E-9;
        double d3 = 3.0E-7;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[this.numRows * this.numCols * this.numSlices];
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = d = this.random.nextDouble();
            dArray2[n] = d;
        }
        this.fft.realForward(dArray);
        this.fft.realInverse(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            d = dArray2[n];
            double d5 = dArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d5);
        }
    }

    @Test
    public void testRealInverseScaled3dInput() {
        double d;
        int n;
        int n2;
        int n3;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        double d2 = 1.0E-9;
        double d3 = 3.0E-7;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][][] dArray = new double[this.numSlices][this.numRows][this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][this.numCols];
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    dArray[n3][n2][n] = d = this.random.nextDouble();
                    dArray2[n3][n2][n] = d;
                }
            }
        }
        this.fft.realForward(dArray);
        this.fft.realInverse(dArray, true);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    d = dArray2[n3][n2][n];
                    double d5 = dArray[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n2 + "][" + n + "]", d, d5);
                }
            }
        }
    }

    @Test
    public void testRealForwardFull1dInput() {
        double d;
        int n;
        double d2 = 1.0E-7;
        double d3 = 5.0E-6;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        int n2 = this.numSlices * this.numRows * this.numCols;
        double[] dArray = new double[2 * n2];
        double[] dArray2 = new double[2 * n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = d = this.random.nextDouble();
            dArray2[2 * n] = d;
            dArray2[2 * n + 1] = 0.0;
        }
        this.fft.complexForward(dArray2);
        this.fft.realForwardFull(dArray);
        for (n = 0; n < dArray.length; ++n) {
            d = dArray2[n];
            double d5 = dArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d5);
        }
    }

    @Test
    public void testRealForwardFull3dInput() {
        double d;
        int n;
        int n2;
        int n3;
        double d2 = 1.0E-7;
        double d3 = 5.0E-6;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][][] dArray = new double[this.numSlices][this.numRows][2 * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    dArray[n3][n2][n] = d = this.random.nextDouble();
                    dArray2[n3][n2][2 * n] = d;
                    dArray2[n3][n2][2 * n + 1] = 0.0;
                }
            }
        }
        this.fft.complexForward(dArray2);
        this.fft.realForwardFull(dArray);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    d = dArray2[n3][n2][n];
                    double d5 = dArray[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n2 + "][" + n + "]", d, d5);
                }
            }
        }
    }

    @Test
    public void testRealInverseFullScaled1dInput() {
        double d;
        int n;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(1.0E-14, 1.0E-15);
        int n2 = this.numSlices * this.numRows * this.numCols;
        double[] dArray = new double[2 * n2];
        double[] dArray2 = new double[2 * n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = d = this.random.nextDouble();
            dArray2[2 * n] = d;
            dArray2[2 * n + 1] = 0.0;
        }
        this.fft.complexInverse(dArray2, true);
        this.fft.realInverseFull(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            d = dArray2[n];
            double d2 = dArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d2);
        }
    }

    @Test
    public void testRealInverseFullScaled3dInput() {
        double d;
        int n;
        int n2;
        int n3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(1.0E-14, 1.0E-15);
        double[][][] dArray = new double[this.numSlices][this.numRows][2 * this.numCols];
        double[][][] dArray2 = new double[this.numSlices][this.numRows][2 * this.numCols];
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    dArray[n3][n2][n] = d = this.random.nextDouble();
                    dArray2[n3][n2][2 * n] = d;
                    dArray2[n3][n2][2 * n + 1] = 0.0;
                }
            }
        }
        this.fft.complexInverse(dArray2, true);
        this.fft.realInverseFull(dArray, true);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < 2 * this.numCols; ++n) {
                    d = dArray2[n3][n2][n];
                    double d2 = dArray[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n2 + "][" + n + "]", d, d2);
                }
            }
        }
    }
}

