/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFileFormatException;
import java.util.Comparator;

public class NucleosomeCall
extends ValuedInterval
implements Comparable<NucleosomeCall> {
    private static final long serialVersionUID = 6522702303121259979L;
    private int dyad;
    private double dyadStdev;
    private int dyadMean;
    private double conditionalPosition;
    private int length;
    private double lengthStdev;

    public NucleosomeCall(String chr, int start, int stop) {
        super(chr, start, stop);
    }

    public static NucleosomeCall parse(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        String[] entry = line.split("\t");
        if (entry.length < 10) {
            throw new IntervalFileFormatException("Invalid nucleosome call has < 10 columns");
        }
        String chr = entry[0];
        int start = Integer.parseInt(entry[1]);
        int stop = Integer.parseInt(entry[2]);
        NucleosomeCall call = new NucleosomeCall(chr, start, stop);
        call.setLength(Integer.parseInt(entry[3]));
        call.setLengthStdev(Double.parseDouble(entry[4]));
        call.setDyad(Integer.parseInt(entry[5]));
        call.setDyadStdev(Double.parseDouble(entry[6]));
        call.setConditionalPosition(Double.parseDouble(entry[7]));
        call.setDyadMean(Integer.parseInt(entry[8]));
        call.setValue(Double.parseDouble(entry[9]));
        return call;
    }

    public String toOutput() {
        return this.getChr() + "\t" + this.getStart() + "\t" + this.getStop() + "\t" + this.length() + "\t" + this.lengthStdev + "\t" + this.dyad + "\t" + this.dyadStdev + "\t" + this.conditionalPosition + "\t" + this.dyadMean + "\t" + this.occupancy();
    }

    public int getDyad() {
        return this.dyad;
    }

    public void setDyad(int dyad) {
        this.dyad = dyad;
    }

    public double getDyadStdev() {
        return this.dyadStdev;
    }

    public void setDyadStdev(double dyadStdev) {
        this.dyadStdev = dyadStdev;
    }

    public int getDyadMean() {
        return this.dyadMean;
    }

    public void setDyadMean(int dyadMean) {
        this.dyadMean = dyadMean;
    }

    public double getConditionalPosition() {
        return this.conditionalPosition;
    }

    public void setConditionalPosition(double conditionalPosition) {
        this.conditionalPosition = conditionalPosition;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public double getLengthStdev() {
        return this.lengthStdev;
    }

    public void setLengthStdev(double lengthStdev) {
        this.lengthStdev = lengthStdev;
    }

    public double occupancy() {
        return this.value.doubleValue();
    }

    public void setOccupancy(double value) {
        this.value = value;
    }

    @Override
    public int compareTo(NucleosomeCall o) {
        DyadComparator comparator = new DyadComparator();
        return comparator.compare(this, o);
    }

    public static class DyadComparator
    implements Comparator<NucleosomeCall> {
        @Override
        public int compare(NucleosomeCall o1, NucleosomeCall o2) {
            if (o1.getDyad() == o2.getDyad()) {
                return 0;
            }
            if (o1.getDyad() < o2.getDyad()) {
                return -1;
            }
            return 1;
        }
    }
}

