/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class MovingAverageSmooth
extends WigMathTool {
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-w", "--width"}, description="Width of kernel (bp)")
    public int width = 10;
    WigFileReader reader;

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        int queryStart = Math.max(chunk.getStart() - this.width / 2, this.reader.getChrStart(chunk.getChr()));
        int queryStop = Math.min(chunk.getStop() + this.width / 2, this.reader.getChrStop(chunk.getChr()));
        float[] data = this.reader.query(chunk.getChr(), queryStart, queryStop).getValues();
        float[] smoothed = new float[chunk.length()];
        DescriptiveStatistics stats = new DescriptiveStatistics();
        stats.setWindowSize(this.width);
        for (int bp = chunk.getStart(); bp <= chunk.getStop(); ++bp) {
            stats.addValue((double)data[bp - queryStart]);
            if (bp - chunk.getStart() - this.width / 2 < 0) continue;
            smoothed[bp - chunk.getStart() - this.width / 2] = (float)stats.getMean();
        }
        return smoothed;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new MovingAverageSmooth().instanceMain(args);
    }
}

