/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.utils.WigStatistic;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;

public class Downsample
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Downsample.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-w", "--window"}, description="Window size (bp)")
    public int windowSize = 100;
    @Parameter(names={"-m", "--metric"}, description="Downsampling metric (coverage/total/mean/min/max)")
    public String metric = "mean";
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        WigStatistic dsm = WigStatistic.fromName(this.metric);
        if (dsm == null) {
            log.error((Object)("Unknown downsampling metric: " + this.metric));
            throw new CommandLineToolException("Unknown downsampling metric: " + this.metric + ". Options are mean, min, max, coverage, total");
        }
        log.debug((Object)("Using downsampling metric: " + this.metric));
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);
             PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]));){
            TrackHeader header = TrackHeader.newWiggle();
            header.setName("Downsampled " + this.inputFile.getFileName());
            header.setDescription("Downsampled " + this.inputFile.getFileName());
            writer.println(header);
            for (String chr : reader.chromosomes()) {
                log.debug((Object)("Processing chromosome " + chr));
                int start = reader.getChrStart(chr);
                int stop = reader.getChrStop(chr);
                writer.println("fixedStep chrom=" + chr + " start=" + start + " step=" + this.windowSize + " span=" + this.windowSize);
                int bp = start;
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + this.windowSize - 1, stop);
                    try {
                        SummaryStatistics result = reader.queryStats(chr, chunkStart, chunkStop);
                        float value = Float.NaN;
                        switch (dsm) {
                            case COVERAGE: {
                                value = result.getN();
                                break;
                            }
                            case TOTAL: {
                                value = (float)result.getSum();
                                break;
                            }
                            case MEAN: {
                                value = (float)result.getMean();
                                break;
                            }
                            case MIN: {
                                value = (float)result.getMin();
                                break;
                            }
                            case MAX: {
                                value = (float)result.getMax();
                            }
                        }
                        writer.println(value);
                    }
                    catch (WigFileException e) {
                        log.error((Object)("Error querying Wig file for data from interval " + chr + ":" + chunkStart + "-" + chunkStop));
                        e.printStackTrace();
                        throw new CommandLineToolException("Error querying Wig file for data from interval " + chr + ":" + chunkStart + "-" + chunkStop);
                    }
                    bp = chunkStop + 1;
                }
            }
        }
    }

    public static void main(String[] args) {
        new Downsample().instanceMain(args);
    }
}

