/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.ParameterDescription;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.AssemblyManager;
import edu.unc.genomics.Job;
import edu.unc.genomics.ResourceManager;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.layout.SpringUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JobConfigPanel
extends JPanel {
    private static final long serialVersionUID = 3336295203155728629L;
    private static final Logger log = Logger.getLogger(JobConfigPanel.class);
    private static final ImageIcon fileIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("folder_page.png").toString());
    private Map<ParameterDescription, JComponent> guiMap = new HashMap<ParameterDescription, JComponent>();
    private Map<Component, ParameterDescription> jobMap = new HashMap<Component, ParameterDescription>();
    private Job job;

    public JobConfigPanel() {
        this((Job)null);
    }

    public JobConfigPanel(Job job) {
        this.setJob(job);
        this.setLayout(new SpringLayout());
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
        this.renderJob();
    }

    public void highlightInvalidArguments() {
        for (ParameterDescription param : this.job) {
            JComponent guiComponent = this.guiMap.get(param);
            if (param.getParameter().required() && !this.job.isSet(param)) {
                guiComponent.setBorder(BorderFactory.createLineBorder(Color.RED));
                continue;
            }
            guiComponent.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void renderJob() {
        this.removeAll();
        this.guiMap.clear();
        this.jobMap.clear();
        if (this.job == null) {
            this.validate();
            this.repaint();
            return;
        }
        for (ParameterDescription paramDescription : this.job) {
            String name = paramDescription.getLongestName();
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
            name = StringUtils.capitalize((String)name);
            JLabel label = new JLabel(name);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add(label);
            JPanel fieldPanel = new JPanel();
            fieldPanel.setLayout(new BoxLayout(fieldPanel, 2));
            this.add(fieldPanel);
            Field field = paramDescription.getField();
            Class<?> type = field.getType();
            if (type.equals(Assembly.class)) {
                List<Assembly> availableAssemblies = AssemblyManager.getAvailableAssemblies();
                Assembly[] assemblies = new Assembly[availableAssemblies.size()];
                assemblies = availableAssemblies.toArray(assemblies);
                final JComboBox<Assembly> cbAssemblyChooser = new JComboBox<Assembly>(assemblies);
                cbAssemblyChooser.setPreferredSize(new Dimension(0, 25));
                cbAssemblyChooser.setMaximumSize(new Dimension(Integer.MAX_VALUE, cbAssemblyChooser.getPreferredSize().height));
                cbAssemblyChooser.setSelectedItem(AssemblyManager.getLastUsed());
                cbAssemblyChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        log.debug((Object)"Auto-databinding changed assembly into Job argument");
                        Assembly selectedAssembly = (Assembly)cbAssemblyChooser.getSelectedItem();
                        AssemblyManager.setLastUsed(selectedAssembly);
                        ParameterDescription param = (ParameterDescription)JobConfigPanel.this.jobMap.get(cbAssemblyChooser);
                        JobConfigPanel.this.job.setArgument(param, selectedAssembly.toString());
                    }
                });
                fieldPanel.add(cbAssemblyChooser);
                this.guiMap.put(paramDescription, cbAssemblyChooser);
                this.jobMap.put(cbAssemblyChooser, paramDescription);
                continue;
            }
            final JTextField textField = new JTextField();
            if (this.job.isSet(paramDescription)) {
                textField.setText(this.job.getArgument(paramDescription));
            }
            textField.setPreferredSize(new Dimension(0, 20));
            textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, textField.getPreferredSize().height));
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.pushTextToModel(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.pushTextToModel(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.pushTextToModel(e);
                }

                private void pushTextToModel(DocumentEvent e) {
                    log.debug((Object)"Auto-databinding changed text into Job argument");
                    Document doc = e.getDocument();
                    ParameterDescription param = (ParameterDescription)JobConfigPanel.this.jobMap.get(textField);
                    try {
                        String text = doc.getText(0, doc.getLength());
                        JobConfigPanel.this.job.setArgument(param, text);
                    }
                    catch (BadLocationException e1) {
                        log.error((Object)"Error pushing changed text into Job model");
                        e1.printStackTrace();
                    }
                }
            });
            fieldPanel.add(textField);
            this.guiMap.put(paramDescription, textField);
            this.jobMap.put(textField, paramDescription);
            if (!type.equals(Path.class) && !type.equals(WigFile.class) && !type.equals(IntervalFile.class)) continue;
            JButton btnChooseFile = new JButton(fileIcon);
            btnChooseFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    int retValue = fc.showDialog(JobConfigPanel.this.getParent(), "OK");
                    if (retValue == 0) {
                        textField.setText(fc.getSelectedFile().toString());
                    }
                }
            });
            fieldPanel.add(btnChooseFile);
        }
        SpringUtilities.makeCompactGrid(this, this.job.numParameters(), 2, 5, 5, 5, 5);
        this.validate();
        this.repaint();
    }
}

