/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Job;
import edu.unc.genomics.JobException;
import edu.unc.genomics.JobQueue;
import edu.unc.genomics.SubmittedJob;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class JobQueueManager {
    private static final Logger log = Logger.getLogger(JobQueueManager.class);
    private final JobQueue queue;
    private final ExecutorService exec;
    private final Thread monitor;

    public JobQueueManager(JobQueue queue) {
        this.queue = queue;
        int numProcessors = Runtime.getRuntime().availableProcessors();
        log.debug((Object)("Initializing thread pool with " + numProcessors + " processors"));
        this.exec = Executors.newFixedThreadPool(numProcessors);
        this.monitor = new Thread(new JobMonitor());
        this.monitor.start();
    }

    public List<Runnable> shutdownNow() {
        return this.exec.shutdownNow();
    }

    public SubmittedJob submitJob(Job job) throws JobException {
        if (!job.validateArguments()) {
            throw new JobException("Job arguments are not valid");
        }
        Future<?> future = this.exec.submit(job);
        SubmittedJob submittedJob = new SubmittedJob(job, future);
        log.info((Object)("Submitted job " + submittedJob.getId()));
        this.queue.add(submittedJob);
        return submittedJob;
    }

    public boolean isRunning() {
        for (SubmittedJob job : this.queue) {
            if (job.isDone()) continue;
            return true;
        }
        return false;
    }

    public class JobMonitor
    implements Runnable {
        public static final int JOB_POLL_INTERVAL = 1000;

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Thread.sleep(1000L);
                    Iterator<SubmittedJob> i$ = JobQueueManager.this.queue.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        SubmittedJob job = i$.next();
                        if (!job.isDone()) continue;
                        JobQueueManager.this.queue.update(job);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"JobMonitor crashed");
                e.printStackTrace();
                throw new RuntimeException("JobMonitor crashed");
            }
        }
    }
}

