/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.index.cluster.ContiguousLexicalStrategy;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LexicalStrategies {
    private static final Logger LOGGER = Fast.getLogger(LexicalStrategies.class);

    protected LexicalStrategies() {
    }

    public static ContiguousLexicalStrategy uniform(int numberOfLocalIndices, BitStreamIndex index) throws IOException {
        int k;
        int[] cutPoint = new int[numberOfLocalIndices + 1];
        CharSequence[] cutPointTerm = new CharSequence[numberOfLocalIndices + 1];
        int terms = index.numberOfTerms;
        LOGGER.info((Object)("Computing a contiguous lexical strategy to partition " + index + " into " + numberOfLocalIndices + " parts..."));
        long total = index.hasPositions ? index.numberOfOccurrences : index.numberOfPostings;
        TermMap termMap = index.termMap;
        if (termMap == null) {
            throw new IllegalStateException("Index " + index + " has no term map");
        }
        cutPointTerm[0] = termMap.getTerm(0);
        cutPointTerm[numberOfLocalIndices] = "\uffff";
        int blockSizeDivisor = numberOfLocalIndices;
        do {
            int left = 0;
            long count = 0L;
            IndexReader indexReader = index.getReader();
            long blockSize = total / (long)blockSizeDivisor++;
            k = 0;
            for (int i = 0; i < terms; ++i) {
                IndexIterator indexIterator = indexReader.nextIterator();
                int frequency = indexIterator.frequency();
                if (!index.hasPositions) {
                    count += (long)frequency;
                }
                int j = frequency;
                while (j-- != 0) {
                    indexIterator.nextDocument();
                    if (!index.hasPositions) continue;
                    count += (long)indexIterator.count();
                }
                if (i == terms - 1) {
                    ++i;
                }
                if ((count < blockSize || k >= numberOfLocalIndices - 1) && i != terms) continue;
                LOGGER.info((Object)("New term interval [" + left + ".." + i + "] (" + termMap.getTerm(left) + " -> " + (i == terms ? "" : termMap.getTerm(i)) + ")"));
                cutPoint[++k] = i;
                if (i != terms) {
                    cutPointTerm[k] = termMap.getTerm(i);
                }
                left = i;
                count = 0L;
            }
            indexReader.close();
        } while (k < numberOfLocalIndices);
        return new ContiguousLexicalStrategy(cutPoint, cutPointTerm);
    }
}

