/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.query.MarkingMutableString;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.query.ResultItem;
import it.unimi.dsi.mg4j.query.SelectedInterval;
import it.unimi.dsi.mg4j.query.TextMarker;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.File;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;

public class QueryServlet
extends VelocityServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Fast.getLogger(QueryServlet.class);
    private static final int STD_MAX_NUM_ITEMS = 10;
    private static final String DEFAULT_TEMPLATE = "it/unimi/dsi/mg4j/query/query.velocity";
    protected String template;
    protected QueryEngine queryEngine;
    protected DocumentCollection documentCollection;
    protected List<CharSequence> titleList;
    protected Object2ReferenceMap<String, Index> indexMap;
    private Index[] sortedIndex;
    private String mimeType;
    private boolean useUri;
    private boolean derelativise;

    public void init() throws ServletException {
        ServletContext context = this.getServletContext();
        this.template = (String)this.getServletContext().getAttribute("template");
        if (this.template == null && (this.template = this.getInitParameter("template")) == null) {
            this.template = DEFAULT_TEMPLATE;
        }
        this.queryEngine = (QueryEngine)context.getAttribute("queryEngine");
        this.documentCollection = (DocumentCollection)context.getAttribute("collection");
        this.titleList = (List)context.getAttribute("titleList");
        this.indexMap = this.queryEngine.indexMap;
        this.mimeType = (String)context.getAttribute("mimeType");
        this.useUri = context.getAttribute("uri") == Boolean.TRUE;
        boolean bl = this.derelativise = context.getAttribute("derelativise") == Boolean.TRUE;
        if (this.documentCollection != null) {
            this.sortedIndex = new Index[this.indexMap.size()];
            this.indexMap.values().toArray((Object[])this.sortedIndex);
            Arrays.sort(this.sortedIndex, new Comparator<Index>(){

                @Override
                public int compare(Index x, Index y) {
                    return QueryServlet.this.documentCollection.factory().fieldIndex(x.field) - QueryServlet.this.documentCollection.factory().fieldIndex(y.field);
                }
            });
        }
    }

    public Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) {
        try {
            String query = request.getParameter("q");
            context.put("action", (Object)(request.getContextPath() + request.getServletPath()));
            int start = 0;
            int maxNumItems = 10;
            try {
                maxNumItems = Integer.parseInt(request.getParameter("m"));
            }
            catch (NumberFormatException dontCare) {
                // empty catch block
            }
            try {
                start = Integer.parseInt(request.getParameter("s"));
            }
            catch (NumberFormatException dontCare) {
                // empty catch block
            }
            if (maxNumItems < 0 || maxNumItems > 1000) {
                maxNumItems = 10;
            }
            if (start < 0) {
                start = 0;
            }
            if (query != null && query.length() != 0) {
                int globNumItems;
                context.put("q", (Object)StringEscapeUtils.escapeHtml((String)query));
                context.put("qUrl", (Object)URLEncoder.encode(query, "UTF-8"));
                context.put("firstItem", (Object)new Integer(start));
                long time = -System.currentTimeMillis();
                ObjectArrayList results = new ObjectArrayList();
                try {
                    globNumItems = this.queryEngine.copy().process(query, start, maxNumItems, (ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>>)results);
                }
                catch (QueryBuilderVisitorException e) {
                    context.put("errmsg", (Object)StringEscapeUtils.escapeHtml((String)e.getCause().toString()));
                    return Velocity.getTemplate((String)this.template);
                }
                catch (QueryParserException e) {
                    context.put("errmsg", (Object)StringEscapeUtils.escapeHtml((String)e.getCause().toString()));
                    return Velocity.getTemplate((String)this.template);
                }
                catch (Exception e) {
                    context.put("errmsg", (Object)StringEscapeUtils.escapeHtml((String)e.toString()));
                    return Velocity.getTemplate((String)this.template);
                }
                time += System.currentTimeMillis();
                ObjectArrayList resultItems = new ObjectArrayList();
                if (!results.isEmpty()) {
                    SelectedInterval[] selectedInterval = null;
                    DocumentCollection collection = this.documentCollection != null ? this.documentCollection.copy() : null;
                    for (int i = 0; i < results.size(); ++i) {
                        DocumentScoreInfo dsi = (DocumentScoreInfo)results.get(i);
                        LOGGER.debug((Object)("Intervals for item " + i));
                        ResultItem resultItem = new ResultItem(dsi.document, dsi.score);
                        resultItems.add((Object)resultItem);
                        if (collection != null) {
                            Document document = collection.document(dsi.document);
                            resultItem.title = StringEscapeUtils.escapeHtml((String)(this.titleList != null ? ((Object)this.titleList.get(resultItem.doc)).toString() : ((Object)document.title()).toString()));
                            if (this.useUri) {
                                resultItem.uri = StringEscapeUtils.escapeHtml((String)((Object)document.uri()).toString());
                            } else {
                                String stringUri = ((Object)document.uri()).toString();
                                String documentUri = this.derelativise ? StringEscapeUtils.escapeHtml((String)new File(stringUri.startsWith("file:") ? stringUri.substring(5) : stringUri).getAbsoluteFile().toURI().toASCIIString()) : StringEscapeUtils.escapeHtml((String)((Object)document.uri()).toString());
                                resultItem.uri = new MutableString("./Item?doc=").append(resultItem.doc).append("&m=").append(this.mimeType).append("&uri=").append(documentUri);
                            }
                            MarkingMutableString snippet = new MarkingMutableString(TextMarker.HTML_STRONG, MarkingMutableString.HTML_ESCAPE);
                            for (int j = 0; j < this.sortedIndex.length; ++j) {
                                if (!this.sortedIndex[j].hasPositions || dsi.info == null) continue;
                                selectedInterval = (SelectedInterval[])((Reference2ObjectMap)dsi.info).get((Object)this.sortedIndex[j]);
                                if (selectedInterval != null) {
                                    int field = this.documentCollection.factory().fieldIndex(this.sortedIndex[j].field);
                                    if (field == -1 || this.documentCollection.factory().fieldType(field) != DocumentFactory.FieldType.TEXT) continue;
                                    LOGGER.debug((Object)("Found intervals for " + this.sortedIndex[j].field + " (" + field + ")"));
                                    Reader content = (Reader)document.content(field);
                                    snippet.startField(selectedInterval).appendAndMark(document.wordReader(field).setReader(content)).endField();
                                }
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)(this.sortedIndex[j].field + ": " + (selectedInterval == null ? null : Arrays.asList(selectedInterval))));
                                }
                                document.close();
                            }
                            resultItem.text = snippet;
                            continue;
                        }
                        if (this.titleList != null) {
                            resultItem.title = resultItem.uri = this.titleList.get(resultItem.doc);
                        } else {
                            resultItem.title = "Document #" + resultItem.doc;
                            resultItem.uri = new MutableString("./Item?doc=").append(resultItem.doc).append("&m=").append(this.mimeType);
                        }
                        MutableString text = new MutableString();
                        for (Index index : this.indexMap.values()) {
                            selectedInterval = (SelectedInterval[])((Reference2ObjectMap)dsi.info).get((Object)index);
                            if (selectedInterval != null) {
                                text.append("<p>").append(index.field).append(": ").append(Arrays.asList(selectedInterval));
                            }
                            LOGGER.debug((Object)(index.field + ": " + (selectedInterval == null ? null : Arrays.asList(selectedInterval))));
                        }
                        resultItem.text = text;
                    }
                    if (collection != null) {
                        collection.close();
                    }
                }
                context.put("result", (Object)resultItems);
                context.put("globNumItems", (Object)new Integer(globNumItems));
                context.put("start", (Object)new Integer(start));
                context.put("maxNumItems", (Object)new Integer(maxNumItems));
                context.put("time", (Object)new Integer((int)time));
                context.put("speed", (Object)new Long((int)((long)globNumItems * 1000L / (time + 1L))));
            }
            return Velocity.getTemplate((String)this.template);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

