/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.JSAPException;
import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.tool.Combine;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Merge
extends Combine {
    private static final Logger LOGGER = Fast.getLogger(Merge.class);
    protected int[] doc;
    protected IntHeapSemiIndirectPriorityQueue documentQueue;

    public Merge(String outputBasename, String[] inputBasename, boolean metadataOnly, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        super(outputBasename, inputBasename, metadataOnly, bufferSize, writerFlags, interleaved, skips, quantum, height, skipBufferSize, logInterval);
        this.doc = new int[this.numIndices];
        this.documentQueue = new IntHeapSemiIndirectPriorityQueue(this.doc, this.numIndices);
    }

    @Override
    protected int combineNumberOfDocuments() {
        int n = 0;
        for (int i = 0; i < this.numIndices; ++i) {
            n = Math.max(n, this.index[i].numberOfDocuments);
        }
        return n;
    }

    @Override
    protected int combineSizes() throws IOException {
        int currDoc = 0;
        int maxDocSize = 0;
        for (int i = 0; i < this.numIndices; ++i) {
            IntIterator sizes = this.sizes(i);
            currDoc = 0;
            int j = this.index[i].numberOfDocuments;
            while (j-- != 0) {
                int s = sizes.nextInt();
                if (s != 0) {
                    if (this.size[currDoc] != 0) {
                        throw new IllegalArgumentException("Document " + currDoc + " has nonzero length in two indices");
                    }
                    this.size[currDoc] = s;
                    if (s > maxDocSize) {
                        maxDocSize = s;
                    }
                }
                ++currDoc;
            }
            if (!(sizes instanceof Closeable)) continue;
            ((Closeable)sizes).close();
        }
        return maxDocSize;
    }

    @Override
    protected int combine(int numUsedIndices) throws IOException {
        int currIndex;
        int totalFrequency = 0;
        int lastIndex = -1;
        int k = numUsedIndices;
        while (k-- != 0) {
            currIndex = this.usedIndex[k];
            this.frequency[currIndex] = this.indexIterator[currIndex].frequency();
            totalFrequency += this.frequency[currIndex];
            this.doc[currIndex] = this.indexIterator[currIndex].nextDocument();
            this.documentQueue.enqueue(currIndex);
        }
        this.indexWriter.newInvertedList();
        this.indexWriter.writeFrequency(totalFrequency);
        int currDoc = -1;
        while (!this.documentQueue.isEmpty()) {
            currIndex = this.documentQueue.first();
            if (currDoc == this.doc[currIndex]) {
                throw new IllegalStateException("The indices to be merged contain document " + currDoc + " at least twice (once in index " + this.inputBasename[lastIndex] + " and once in index " + this.inputBasename[currIndex] + ")");
            }
            currDoc = this.doc[currIndex];
            OutputBitStream obs = this.indexWriter.newDocumentRecord();
            this.indexWriter.writeDocumentPointer(obs, currDoc);
            BitStreamIndex i = this.index[currIndex];
            IndexIterator ir = this.indexIterator[currIndex];
            if (i.hasPayloads) {
                this.indexWriter.writePayload(obs, ir.payload());
            }
            if (i.hasCounts) {
                int count = ir.count();
                if (this.hasCounts) {
                    this.indexWriter.writePositionCount(obs, count);
                }
                if (i.hasPositions && this.hasPositions) {
                    this.indexWriter.writeDocumentPositions(obs, ir.positionArray(), 0, count, this.size[currDoc]);
                }
            }
            int n = currIndex;
            this.frequency[n] = this.frequency[n] - 1;
            if (this.frequency[n] == 0) {
                this.documentQueue.dequeue();
            } else {
                this.doc[currIndex] = ir.nextDocument();
                this.documentQueue.changed();
            }
            lastIndex = currIndex;
        }
        return totalFrequency;
    }

    public static void main(String[] arg) throws ConfigurationException, SecurityException, JSAPException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Combine.main(arg, Merge.class);
    }
}

