/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MapDyads
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(MapDyads.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true)
    public IntervalFile<? extends Interval> inputFile;
    @Parameter(names={"-s", "--size"}, description="Mononucleosome length (default: read length)")
    public Integer nucleosomeSize;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing output file");
        int mapped = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader header = new TrackHeader("wiggle_0");
            header.setName("Converted " + this.inputFile.getPath().getFileName());
            header.setDescription("Converted " + this.inputFile.getPath().getFileName());
            writer.write(header.toString());
            writer.newLine();
            for (String chr : this.inputFile.chromosomes()) {
                if (!this.assembly.includes(chr)) continue;
                log.debug((Object)("Processing chromosome " + chr));
                writer.write("fixedStep chrom=" + chr + " start=1 step=1 span=1");
                writer.newLine();
                int start = 1;
                while (start < this.assembly.getChrLength(chr)) {
                    int stop = Math.min(start + 300000 - 1, this.assembly.getChrLength(chr));
                    int length = stop - start + 1;
                    int[] count = new int[length];
                    Iterator it = this.inputFile.query(chr, start, stop);
                    while (it.hasNext()) {
                        Interval entry = (Interval)it.next();
                        int center = this.nucleosomeSize == null || this.nucleosomeSize == -1 ? entry.center() : entry.getStart() + this.nucleosomeSize / 2;
                        if (start > center || center > stop) continue;
                        int n = center - start;
                        count[n] = count[n] + 1;
                        ++mapped;
                    }
                    for (int i = 0; i < count.length; ++i) {
                        writer.write(Integer.toString(count[i]));
                        writer.newLine();
                    }
                    start = stop + 1;
                }
            }
        }
        log.info((Object)("Mapped " + mapped + " reads"));
    }

    public static void main(String[] args) {
        new MapDyads().instanceMain(args);
    }
}

