/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.BitStreamIndexReader;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.MultiTermIndexIterator;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BitStreamIndex
extends Index {
    private static final long serialVersionUID = 0L;
    private static final Logger LOGGER = Fast.getLogger(BitStreamIndex.class);
    public static final int DEFAULT_HEIGHT = 8;
    public static final int DEFAULT_QUANTUM = 64;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public final CompressionFlags.Coding frequencyCoding;
    public final CompressionFlags.Coding pointerCoding;
    public final CompressionFlags.Coding countCoding;
    public final CompressionFlags.Coding positionCoding;
    public final LongList offsets;
    public final TermMap termMap;
    public final PrefixMap prefixMap;
    public final int height;
    public final int quantum;
    public final int bufferSize;
    public final Constructor<? extends IndexReader> readerConstructor;

    public BitStreamIndex(int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, CompressionFlags.Coding frequencyCoding, CompressionFlags.Coding pointerCoding, CompressionFlags.Coding countCoding, CompressionFlags.Coding positionCoding, int quantum, int height, int bufferSize, TermProcessor termProcessor, String field, Properties properties, TermMap termMap, PrefixMap prefixMap, IntList sizes, LongList offsets) {
        super(numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, countCoding != null, positionCoding != null, termProcessor, field, sizes, properties);
        this.frequencyCoding = frequencyCoding;
        this.pointerCoding = pointerCoding;
        this.countCoding = countCoding;
        this.positionCoding = positionCoding;
        this.termMap = termMap;
        this.prefixMap = prefixMap;
        this.offsets = offsets;
        this.quantum = quantum;
        this.height = height;
        this.bufferSize = bufferSize;
        if (quantum != -1) {
            if (height < 0) {
                throw new IllegalArgumentException("Illegal height " + height);
            }
            if (quantum <= 0 || (quantum & -quantum) != quantum) {
                throw new IllegalArgumentException("Illegal quantum " + quantum);
            }
        }
        this.readerConstructor = this.getConstructor();
    }

    protected Constructor<? extends IndexReader> getConstructor() {
        Class readerClass = BitStreamIndexReader.class;
        String className = BitStreamIndexReader.class.getPackage().getName() + ".wired." + (this.quantum != -1 ? "Skip" : "") + BitStreamIndex.featureName(this.frequencyCoding) + BitStreamIndex.featureName(this.pointerCoding) + (this.hasPayloads ? "Payloads " : BitStreamIndex.featureName(this.countCoding) + BitStreamIndex.featureName(this.positionCoding)) + BitStreamIndexReader.class.getSimpleName();
        try {
            readerClass = Class.forName(className);
            LOGGER.info((Object)("Dynamically fetched reader class " + readerClass.getSimpleName()));
        }
        catch (Exception e) {
            LOGGER.info((Object)("Cannot fetch dynamically class " + className + "; falling back to generic (slower) class " + BitStreamIndexReader.class.getSimpleName()));
        }
        try {
            return readerClass.getConstructor(BitStreamIndex.class, InputBitStream.class);
        }
        catch (Exception shouldntReallyHappen) {
            throw new RuntimeException("Cannot find suitable constructor in " + readerClass.getSimpleName());
        }
    }

    protected static String featureName(CompressionFlags.Coding coding) {
        return StringUtils.capitalize((String)(coding == null ? "NONE" : coding.toString()).toLowerCase());
    }

    public abstract InputBitStream getInputBitStream(int var1) throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public IndexReader getReader(int bufferSize) throws IOException {
        try {
            return this.readerConstructor.newInstance(this, this.getInputBitStream(bufferSize == -1 ? this.bufferSize : bufferSize));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IndexIterator documents(CharSequence prefix, int limit) throws IOException, TooManyTermsException {
        if (this.prefixMap != null) {
            IndexIterator result;
            Interval interval = this.prefixMap.getInterval(prefix);
            if (interval == Intervals.EMPTY_INTERVAL) {
                return this.emptyIndexIterator;
            }
            if (interval.length() > limit) {
                throw new TooManyTermsException(interval.length());
            }
            if (interval.length() == 1) {
                result = this.documents(interval.left);
            } else {
                IndexIterator[] baseIterator = new IndexIterator[interval.length()];
                int k = 0;
                IntBidirectionalIterator i = interval.iterator();
                while (i.hasNext()) {
                    baseIterator[k++] = this.documents(i.nextInt());
                }
                result = MultiTermIndexIterator.getInstance(this, baseIterator);
            }
            result.term(prefix + "*");
            return result;
        }
        throw new UnsupportedOperationException("Index " + this + " has no prefix map");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        SKIPQUANTUM,
        SKIPHEIGHT,
        BUFFERSIZE;

    }
}

