/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.io.DebugOutputBitStream;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.PrintStream;

public class DebugInputBitStream
extends InputBitStream {
    private final PrintStream pw;
    private final InputBitStream ibs;

    public DebugInputBitStream(InputBitStream ibs, PrintStream pw) {
        this.ibs = ibs;
        this.pw = pw;
        pw.print("[");
    }

    public DebugInputBitStream(InputBitStream ibs) {
        this(ibs, System.err);
    }

    public void align() {
        this.pw.print(" |");
        this.ibs.align();
    }

    public long available() throws IOException {
        return this.ibs.available();
    }

    public void close() throws IOException {
        this.pw.print(" |]");
        this.ibs.close();
    }

    public void flush() {
        this.pw.print(" |");
        this.ibs.flush();
    }

    public void position(long position) throws IOException {
        this.pw.print(" ->" + position);
        this.ibs.position(position);
    }

    public void read(byte[] bits, int len) throws IOException {
        this.ibs.read(bits, len);
        MutableString s = new MutableString(" {");
        for (int i = 0; i < bits.length; ++i) {
            s.append(DebugOutputBitStream.byte2Binary(bits[i]));
        }
        this.pw.print(s.length(len).append("}"));
    }

    public int readBit() throws IOException {
        int bit = this.ibs.readBit();
        this.pw.print(" {" + bit + "}");
        return bit;
    }

    public long readBits() {
        return this.ibs.readBits();
    }

    public void readBits(long readBits) {
        this.ibs.readBits(readBits);
    }

    public int readDelta() throws IOException {
        int x = this.ibs.readDelta();
        this.pw.print(" {d:" + x + "}");
        return x;
    }

    public int readGamma() throws IOException {
        int x = this.ibs.readGamma();
        this.pw.print(" {g:" + x + "}");
        return x;
    }

    public int readGolomb(int b, int log2b) throws IOException {
        int x = this.ibs.readGolomb(b, log2b);
        this.pw.print(" {G:" + x + ":" + b + "}");
        return x;
    }

    public int readGolomb(int b) throws IOException {
        int x = this.ibs.readGolomb(b);
        this.pw.print(" {G:" + x + ":" + b + "}");
        return x;
    }

    public int readInt(int len) throws IOException {
        int x = this.ibs.readInt(len);
        this.pw.print(" {" + DebugOutputBitStream.int2Binary(x, len) + "}");
        return x;
    }

    public long readLong(int len) throws IOException {
        long x = this.ibs.readLong(len);
        this.pw.print(" {" + DebugOutputBitStream.int2Binary(x, len) + "}");
        return x;
    }

    public long readLongDelta() throws IOException {
        long x = this.ibs.readLongDelta();
        this.pw.print(" {d:" + x + "}");
        return x;
    }

    public long readLongGamma() throws IOException {
        long x = this.ibs.readLongGamma();
        this.pw.print(" {g:" + x + "}");
        return x;
    }

    public long readLongGolomb(long b, int log2b) throws IOException {
        long x = this.ibs.readLongGolomb(b, log2b);
        this.pw.print(" {G:" + x + ":" + b + "}");
        return x;
    }

    public long readLongGolomb(long b) throws IOException {
        long x = this.ibs.readLongGolomb(b);
        this.pw.print(" {G:" + x + ":" + b + "}");
        return x;
    }

    public long readLongMinimalBinary(long b, int log2b) throws IOException {
        long x = this.ibs.readLongMinimalBinary(b, log2b);
        this.pw.print(" {m:" + x + "<" + b + "}");
        return x;
    }

    public long readLongMinimalBinary(long b) throws IOException {
        long x = this.ibs.readLongMinimalBinary(b);
        this.pw.print(" {m:" + x + "<" + b + "}");
        return x;
    }

    public long readLongNibble() throws IOException {
        long x = this.ibs.readLongNibble();
        this.pw.print(" {N:" + x + "}");
        return x;
    }

    public long readLongSkewedGolomb(long b) throws IOException {
        long x = this.ibs.readLongSkewedGolomb(b);
        this.pw.print(" {SG:" + x + ":" + b + "}");
        return x;
    }

    public long readLongUnary() throws IOException {
        long x = this.ibs.readLongUnary();
        this.pw.print(" {U:" + x + "}");
        return x;
    }

    public long readLongZeta(int k) throws IOException {
        long x = this.ibs.readLongZeta(k);
        this.pw.print(" {z" + k + ":" + x + "}");
        return x;
    }

    public int readMinimalBinary(int b, int log2b) throws IOException {
        int x = this.ibs.readMinimalBinary(b, log2b);
        this.pw.print(" {m:" + x + "<" + b + "}");
        return x;
    }

    public int readMinimalBinary(int b) throws IOException {
        int x = this.ibs.readMinimalBinary(b);
        this.pw.print(" {m:" + x + "<" + b + "}");
        return x;
    }

    public int readNibble() throws IOException {
        int x = this.ibs.readNibble();
        this.pw.print(" {N:" + x + "}");
        return x;
    }

    public int readSkewedGolomb(int b) throws IOException {
        int x = this.ibs.readSkewedGolomb(b);
        this.pw.print(" {SG:" + x + ":" + b + "}");
        return x;
    }

    public int readUnary() throws IOException {
        int x = this.ibs.readUnary();
        this.pw.print(" {U:" + x + "}");
        return x;
    }

    public int readZeta(int k) throws IOException {
        int x = this.ibs.readZeta(k);
        this.pw.print(" {z" + k + ":" + x + "}");
        return x;
    }

    public void reset() throws IOException {
        this.pw.print(" {!}");
        this.ibs.reset();
    }

    @Deprecated
    public int skip(int n) {
        this.pw.print(" {+>" + n + "}");
        return this.ibs.skip(n);
    }

    public long skip(long n) throws IOException {
        this.pw.print(" {+>" + n + "}");
        return this.ibs.skip(n);
    }
}

