/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.math.RoundingMode;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.picard.PicardException;
import net.sf.samtools.util.Iso8601Date;

public class FormatUtil {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    private NumberFormat floatFormat;

    public FormatUtil() {
        this.integerFormat.setGroupingUsed(false);
        this.floatFormat = NumberFormat.getNumberInstance();
        this.floatFormat.setGroupingUsed(false);
        this.floatFormat.setMaximumFractionDigits(6);
        this.floatFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        if (this.floatFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.floatFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("?");
            decimalFormatSymbols.setInfinity("?");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public String format(short value) {
        return this.integerFormat.format(value);
    }

    public String format(int value) {
        return this.integerFormat.format(value);
    }

    public String format(long value) {
        return this.integerFormat.format(value);
    }

    public String format(float value) {
        return this.floatFormat.format(value);
    }

    public String format(double value) {
        return this.floatFormat.format(value);
    }

    public String format(Enum value) {
        return value.name();
    }

    public String format(Date value) {
        return this.dateFormat.format(value);
    }

    public String format(Iso8601Date value) {
        return value.toString();
    }

    public String format(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Short) {
            return this.format((Short)value);
        }
        if (value instanceof Integer) {
            return this.format((Integer)value);
        }
        if (value instanceof Long) {
            return this.format((Long)value);
        }
        if (value instanceof Float) {
            return this.format(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.format((Double)value);
        }
        if (value instanceof Enum) {
            return this.format((Enum)value);
        }
        if (value instanceof Iso8601Date) {
            return this.format((Iso8601Date)value);
        }
        if (value instanceof Date) {
            return this.format((Date)value);
        }
        if (value instanceof Boolean) {
            return this.format((Boolean)value);
        }
        return value.toString();
    }

    public short parseShort(String value) {
        return Short.parseShort(value);
    }

    public int parseInt(String value) {
        return Integer.parseInt(value);
    }

    public long parseLong(String value) {
        return Long.parseLong(value);
    }

    public float parseFloat(String value) {
        if ("?".equals(value)) {
            return Float.NaN;
        }
        return Float.parseFloat(value);
    }

    public double parseDouble(String value) {
        if ("?".equals(value)) {
            return Double.NaN;
        }
        return Double.parseDouble(value);
    }

    public <E extends Enum> E parseEnum(String value, Class<E> type) {
        return Enum.valueOf(type, value);
    }

    public Date parseDate(String value) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException pe) {
            throw new PicardException("Could not parse value as date: " + value, pe);
        }
    }

    public Iso8601Date parseIso8601Date(String value) {
        return new Iso8601Date(value);
    }

    public boolean parseBoolean(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char ch = Character.toUpperCase(value.charAt(0));
        return ch == 'Y';
    }

    public Object parseObject(String value, Class<?> returnType) {
        if (returnType == Short.class || returnType == Short.TYPE) {
            return this.parseShort(value);
        }
        if (returnType == Integer.class || returnType == Integer.TYPE) {
            return this.parseInt(value);
        }
        if (returnType == Long.class || returnType == Long.TYPE) {
            return this.parseLong(value);
        }
        if (returnType == Float.class || returnType == Float.TYPE) {
            return Float.valueOf(this.parseFloat(value));
        }
        if (returnType == Double.class || returnType == Double.TYPE) {
            return this.parseDouble(value);
        }
        if (returnType == Boolean.class || returnType == Boolean.TYPE) {
            return this.parseBoolean(value);
        }
        if (returnType == Iso8601Date.class) {
            return this.parseIso8601Date(value);
        }
        if (returnType == Date.class) {
            return this.parseDate(value);
        }
        if (returnType == Byte.class || returnType == Byte.TYPE) {
            return this.parseInt(value);
        }
        if (returnType == File.class) {
            return new File(value);
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return this.parseEnum(value, returnType);
        }
        if (returnType == String.class) {
            return value;
        }
        throw new InvalidParameterException("Don't know how to convert a String to a " + returnType.getName());
    }
}

