/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalException;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public abstract class WigAnalysisTool
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(WigAnalysisTool.class);
    @Parameter(names={"-c", "--chunk"}, description="Maximum number of data values to load per thread (bp)")
    public int chunkSize = 10000000;
    @Parameter(names={"-p", "--threads"}, description="Number of threads to use")
    public int nThreads = 1;
    private ExecutorService pool;
    protected boolean unionExtents = false;
    protected List<WigFileReader> inputs = new ArrayList<WigFileReader>();

    protected void addInputFile(WigFileReader wig) {
        this.inputs.add(wig);
    }

    protected abstract void prepare();

    protected void shutdown() throws IOException {
    }

    private void close() throws IOException {
        for (WigFileReader wig : this.inputs) {
            wig.close();
        }
    }

    protected abstract void process(Interval var1) throws IOException, WigFileException;

    @Override
    public final void run() throws IOException {
        log.debug((Object)"Executing setup operations");
        this.prepare();
        Set<String> chromosomes = null;
        if (this.unionExtents) {
            chromosomes = WigAnalysisTool.getUnionChromosomes(this.inputs);
            log.debug((Object)("Found " + chromosomes.size() + " chromosomes in the union of all inputs"));
        } else {
            chromosomes = WigAnalysisTool.getIntersectionChromosomes(this.inputs);
            log.debug((Object)("Found " + chromosomes.size() + " chromosomes in the intersection of all inputs"));
        }
        log.debug((Object)("Initializing thread pool with " + this.nThreads + " threads"));
        this.pool = Executors.newFixedThreadPool(this.nThreads);
        log.debug((Object)"Performing main computation");
        ArrayList futures = new ArrayList();
        try {
            for (String string : chromosomes) {
                Interval interval;
                Interval interval2 = interval = this.unionExtents ? WigAnalysisTool.getUnion(this.inputs, string) : WigAnalysisTool.getIntersection(this.inputs, string);
                if (interval == null) continue;
                int bp = interval.low();
                while (bp < interval.high()) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + this.chunkSize - 1, interval.high());
                    final Interval chunk = new Interval(string, chunkStart, chunkStop);
                    futures.add(this.pool.submit(new Runnable(){

                        @Override
                        public void run() {
                            log.debug((Object)("Processing chunk " + chunk));
                            try {
                                WigAnalysisTool.this.process(chunk);
                            }
                            catch (Exception e) {
                                throw new CommandLineToolException("Exception while processing chunk " + chunk, e);
                            }
                        }
                    }));
                    bp = chunkStop + 1;
                }
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CommandLineToolException(e);
        }
        catch (IntervalException e) {
            throw new CommandLineToolException(e);
        }
        finally {
            this.pool.shutdownNow();
            this.shutdown();
            this.close();
        }
    }

    public static Set<String> getIntersectionChromosomes(List<WigFileReader> wigs) {
        if (wigs == null || wigs.isEmpty()) {
            return new HashSet<String>();
        }
        Set chromosomes = wigs.get(0).chromosomes();
        Iterator it = chromosomes.iterator();
        block0: while (it.hasNext()) {
            String chr = (String)it.next();
            for (WigFileReader wig : wigs) {
                if (wig.includes(chr)) continue;
                it.remove();
                continue block0;
            }
        }
        return chromosomes;
    }

    public static Interval getIntersection(List<WigFileReader> wigs, String chr) {
        if (wigs == null || wigs.isEmpty()) {
            return null;
        }
        Interval intersection = wigs.get(0).getChrExtents(chr);
        for (int i = 1; i < wigs.size() && intersection != null; intersection = intersection.intersection(wigs.get(i).getChrExtents(chr)), ++i) {
        }
        return intersection;
    }

    public static Set<String> getUnionChromosomes(List<WigFileReader> wigs) {
        HashSet<String> chromosomes = new HashSet<String>();
        for (WigFileReader wig : wigs) {
            chromosomes.addAll(wig.chromosomes());
        }
        return chromosomes;
    }

    public static Interval getUnion(List<WigFileReader> wigs, String chr) throws IntervalException {
        if (wigs == null || wigs.isEmpty()) {
            return null;
        }
        Interval union = null;
        for (WigFileReader wig : wigs) {
            if (!wig.includes(chr)) continue;
            union = wig.getChrExtents(chr).union(union);
        }
        return union;
    }
}

