/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;

public class MovingAverageSmooth
extends WigMathTool {
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-w", "--width"}, description="Width of kernel (bp)")
    public int width = 11;
    WigFileReader reader;

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        int queryStart = Math.max(chunk.getStart() - this.width / 2, this.reader.getChrStart(chunk.getChr()));
        int queryStop = Math.min(chunk.getStop() + this.width / 2, this.reader.getChrStop(chunk.getChr()));
        Contig contig = this.reader.query(chunk.getChr(), queryStart, queryStop);
        int nValues = (int)Math.ceil((float)chunk.length() / (float)this.step);
        float[] result = new float[nValues];
        for (int i = 0; i < result.length; ++i) {
            int stop;
            int start;
            int n;
            float x = 0.0f;
            if (this.step < this.width) {
                n = this.width;
                start = contig.getStart() + i * this.step + this.step / 2 - this.width / 2;
                stop = contig.getStart() + i * this.step + n;
            } else {
                n = this.step;
                start = contig.getStart() + i * this.step;
                stop = contig.getStart() + n;
            }
            for (int bp = start; bp <= stop; ++bp) {
                x += contig.get(bp);
            }
            result[i] = x / (float)n;
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new MovingAverageSmooth().instanceMain(args);
    }
}

