/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

public class FFTUtils {
    public static float[] abs2(float[] f) {
        int n = f.length;
        float[] ps = new float[n / 2 + 1];
        ps[0] = f[0] * f[0] / (float)(n * n);
        if (n % 2 == 0) {
            for (int k = 1; k < n / 2; ++k) {
                ps[k] = f[2 * k] * f[2 * k] + f[2 * k + 1] * f[2 * k + 1];
            }
            ps[n / 2] = f[1] * f[1];
        } else {
            for (int k = 1; k < (n - 1) / 2; ++k) {
                ps[k] = f[2 * k] * f[2 * k] + f[2 * k + 1] * f[2 * k + 1];
            }
            ps[(n - 1) / 2] = f[n - 1] * f[n - 1] + f[1] * f[1];
        }
        return ps;
    }

    public static float[] autocovariance(float[] x, int maxShift) {
        float total = 0.0f;
        for (int i = 0; i < x.length; ++i) {
            total += x[i];
        }
        float mean = total / (float)x.length;
        int stop = Math.min(x.length, maxShift);
        float[] auto = new float[stop];
        for (int i = 0; i < stop; ++i) {
            for (int j = 0; j < x.length - i; ++j) {
                int n = i;
                auto[n] = auto[n] + (x[j] - mean) * (x[j + i] - mean);
            }
        }
        return auto;
    }

    public static float[] autocovariance(float[] x) {
        return FFTUtils.autocovariance(x, x.length);
    }
}

