/*
 * Decompiled with CFR 0.152.
 */
package org.genomeview.dnaproperties;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;

public final class ConversionMap
extends HashMap<Integer, Double> {
    private static final long serialVersionUID = 6218177437128101213L;
    private double defaultValue = 0.0;
    private int length = 0;

    private ConversionMap() {
    }

    public static byte lowercase(byte bytes) {
        switch (bytes) {
            case 65: {
                bytes = (byte)97;
            }
            case 84: {
                return 116;
            }
            case 67: {
                return 99;
            }
            case 71: {
                return 103;
            }
        }
        return bytes;
    }

    static byte[] lowercase(byte[] bytes) {
        block6: for (int i = 0; i < bytes.length; ++i) {
            switch (bytes[i]) {
                case 65: {
                    bytes[i] = 97;
                    continue block6;
                }
                case 84: {
                    bytes[i] = 116;
                    continue block6;
                }
                case 67: {
                    bytes[i] = 99;
                    continue block6;
                }
                case 71: {
                    bytes[i] = 103;
                }
            }
        }
        return bytes;
    }

    static int translate(byte ... seq) {
        int out = 0;
        for (byte b : seq) {
            out *= 255;
            out += b;
        }
        return out;
    }

    static ConversionMap create(String file) {
        ConversionMap out = new ConversionMap();
        URL url = ConversionMap.class.getResource("data/" + file);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = in.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    String[] arr = line.split("\t");
                    try {
                        double value = Double.parseDouble(arr[1]);
                        out.put(ConversionMap.translate(ConversionMap.lowercase(arr[0].getBytes())), value);
                        out.defaultValue += value;
                        out.length = arr[0].length();
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Something is wrong with in conversion file: " + e);
                    }
                }
                line = in.readLine();
            }
            in.close();
            out.defaultValue /= Math.pow(4.0, out.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Their was an error while reading the conversion map: " + e);
        }
        return out;
    }

    @Override
    public Double get(Object key) {
        Double value = (Double)super.get((Integer)key);
        if (value != null) {
            return value;
        }
        return this.defaultValue;
    }

    int length() {
        return this.length;
    }

    void normalize() {
        double upperBound = 1.0;
        double lowerBound = -1.0;
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (Double d : super.values()) {
            if (d > max) {
                max = d;
            }
            if (!(d < min)) continue;
            min = d;
        }
        for (Integer s : super.keySet()) {
            Double d = (Double)super.get(s);
            Double tmp = (d - min) / (max - min) * (upperBound - lowerBound) + lowerBound;
            super.put(s, tmp);
        }
        this.defaultValue = (this.defaultValue - min) / (max - min) * (upperBound - lowerBound) + lowerBound;
    }
}

