/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public abstract class ReadMapperTool
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(ReadMapperTool.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path intervalFile;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-c", "--chunk"}, description="Size to chunk each chromosome into when processing (bp)")
    public int chunkSize = 10000000;
    @Parameter(names={"-f", "--fixedstep"}, description="Force fixedStep output")
    public boolean fixedStep = false;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    @Parameter(names={"-b", "--split"}, description="Write each chromosome into its own output file")
    public boolean split = false;

    public abstract float[] compute(IntervalFileReader<? extends Interval> var1, Interval var2) throws IOException;

    @Override
    public final void run() throws IOException {
        block19: {
            log.debug((Object)"Processing reads and writing result to disk");
            TrackHeader header = TrackHeader.newWiggle();
            header.setName("Processed " + this.intervalFile.getFileName());
            header.setDescription("Processed " + this.intervalFile.getFileName());
            try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.intervalFile);){
                if (this.split) {
                    for (String chr : reader.chromosomes()) {
                        String outputFileStr = this.outputFile.getFileName().toString();
                        String base = outputFileStr.substring(0, outputFileStr.lastIndexOf(46));
                        String ext = outputFileStr.substring(outputFileStr.lastIndexOf(46));
                        try (WigFileWriter writer = new WigFileWriter(this.outputFile.resolveSibling(base + "." + chr + ext), header);){
                            this.processChromosome((IntervalFileReader<? extends Interval>)reader, writer, chr);
                        }
                    }
                    break block19;
                }
                try (WigFileWriter writer = new WigFileWriter(this.outputFile, header);){
                    for (String chr : reader.chromosomes()) {
                        this.processChromosome((IntervalFileReader<? extends Interval>)reader, writer, chr);
                    }
                }
            }
        }
    }

    private void processChromosome(IntervalFileReader<? extends Interval> reader, WigFileWriter writer, String chr) throws IOException {
        if (!this.assembly.includes(chr)) {
            log.info((Object)("Skipping " + chr + " not in assembly " + this.assembly));
            return;
        }
        log.debug((Object)("Processing chromosome " + chr));
        int chunkStart = 1;
        while (chunkStart < this.assembly.getChrLength(chr)) {
            int chunkStop = Math.min(chunkStart + this.chunkSize - 1, this.assembly.getChrLength(chr));
            Interval chunk = new Interval(chr, chunkStart, chunkStop);
            log.debug((Object)("Processing chunk " + chunk));
            float[] result = this.compute(reader, chunk);
            if (result.length != chunk.length()) {
                log.error((Object)("Expected result length=" + chunk.length() + ", got=" + result.length));
                throw new CommandLineToolException("Result of mapping computation is not the expected length!");
            }
            if (this.fixedStep) {
                writer.writeFixedStepContig(new Contig(chunk, result));
            } else {
                writer.write(new Contig(chunk, result));
            }
            chunkStart = chunkStop + 1;
        }
    }
}

