/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadMapperTool;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.IOException;
import java.util.Iterator;

public class MapDyads
extends ReadMapperTool {
    @Parameter(names={"-s", "--size"}, description="Mononucleosome length (default: read length)")
    public Integer nucleosomeSize;

    @Override
    public float[] compute(IntervalFileReader<? extends Interval> reader, Interval chunk) throws IOException {
        float[] count = new float[chunk.length()];
        int paddedStart = chunk.getStart();
        int paddedStop = chunk.getStop();
        if (this.nucleosomeSize != null && this.nucleosomeSize > 0) {
            paddedStart = Math.max(chunk.getStart() - this.nucleosomeSize - 1, 1);
            paddedStop = Math.min(chunk.getStop() + this.nucleosomeSize + 1, this.assembly.getChrLength(chunk.getChr()));
        }
        Iterator it = reader.query(chunk.getChr(), paddedStart, paddedStop);
        while (it.hasNext()) {
            Interval entry = (Interval)it.next();
            int center = this.nucleosomeSize == null || this.nucleosomeSize <= 0 ? entry.center() : (entry.isWatson() ? entry.getStart() + this.nucleosomeSize / 2 : entry.getStart() - this.nucleosomeSize / 2);
            if (chunk.getStart() > center || center > chunk.getStop()) continue;
            int n = center - chunk.getStart();
            count[n] = count[n] + 1.0f;
        }
        return count;
    }

    public static void main(String[] args) {
        new MapDyads().instanceMain(args);
    }
}

