/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.Future;
import org.jtransforms.dht.DoubleDHT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class DoubleDHT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDHT_1D dhtSlices;
    private DoubleDHT_1D dhtRows;
    private DoubleDHT_1D dhtColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDHT_3D(long l, long l2, long l3) {
        if (l <= 1L || l2 <= 1L || l3 <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)l;
        this.rows = (int)l2;
        this.columns = (int)l3;
        this.slicesl = l;
        this.rowsl = l2;
        this.columnsl = l3;
        this.sliceStride = (int)(l2 * l3);
        this.rowStride = (int)l3;
        this.sliceStridel = l2 * l3;
        this.rowStridel = l3;
        if (l * l2 * l3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2) && ConcurrencyUtils.isPowerOf2(l3)) {
            this.isPowerOfTwo = true;
        }
        long l4 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 * l3 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(Math.min(l2, l3), l));
        }
        this.dhtSlices = new DoubleDHT_1D(l);
        this.dhtRows = l == l2 ? this.dhtSlices : new DoubleDHT_1D(l2);
        this.dhtColumns = l == l3 ? this.dhtSlices : (l2 == l3 ? this.dhtRows : new DoubleDHT_1D(l3));
        ConcurrencyUtils.setLargeArraysBeginN(l4);
    }

    public void forward(final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, dArray, true);
                this.ddxt3db_subth(-1, dArray, true);
            } else {
                this.ddxt3da_sub(-1, dArray, true);
                this.ddxt3db_sub(-1, dArray, true);
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.slices / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                int n = i * DoubleDHT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleDHT_3D.this.rows; ++j) {
                                    DoubleDHT_3D.this.dhtColumns.forward(dArray, n + j * DoubleDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n = i * DoubleDHT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n22;
                                    int n32;
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.rows; ++n32) {
                                        n22 = n + n32 * DoubleDHT_3D.this.rowStride + j;
                                        dArray2[n32] = dArray[n22];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2);
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.rows; ++n32) {
                                        n22 = n + n32 * DoubleDHT_3D.this.rowStride + j;
                                        dArray[n22] = dArray2[n32];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.slices];
                            for (int i = n3; i < n2; ++i) {
                                int n = i * DoubleDHT_3D.this.rowStride;
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n22;
                                    int n32;
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.slices; ++n32) {
                                        n22 = n32 * DoubleDHT_3D.this.sliceStride + n + j;
                                        dArray2[n32] = dArray[n22];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(dArray2);
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.slices; ++n32) {
                                        n22 = n32 * DoubleDHT_3D.this.sliceStride + n + j;
                                        dArray[n22] = dArray2[n32];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                for (int i = 0; i < this.slices; ++i) {
                    n10 = i * this.sliceStride;
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        this.dhtColumns.forward(dArray, n10 + n9 * this.rowStride);
                    }
                }
                double[] dArray2 = new double[this.rows];
                for (n10 = 0; n10 < this.slices; ++n10) {
                    n9 = n10 * this.sliceStride;
                    for (n8 = 0; n8 < this.columns; ++n8) {
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n9 + n7 * this.rowStride + n8;
                            dArray2[n7] = dArray[n6];
                        }
                        this.dhtRows.forward(dArray2);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n9 + n7 * this.rowStride + n8;
                            dArray[n6] = dArray2[n7];
                        }
                    }
                }
                dArray2 = new double[this.slices];
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = n10 * this.rowStride;
                    for (n8 = 0; n8 < this.columns; ++n8) {
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = n7 * this.sliceStride + n9 + n8;
                            dArray2[n7] = dArray[n6];
                        }
                        this.dhtSlices.forward(dArray2);
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = n7 * this.sliceStride + n9 + n8;
                            dArray[n6] = dArray2[n7];
                        }
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    public void forward(final DoubleLargeArray doubleLargeArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, doubleLargeArray, true);
                this.ddxt3db_subth(-1, doubleLargeArray, true);
            } else {
                this.ddxt3da_sub(-1, doubleLargeArray, true);
                this.ddxt3db_sub(-1, doubleLargeArray, true);
            }
            this.yTransform(doubleLargeArray);
        } else {
            if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.slicesl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                long l3 = i * (long)DoubleDHT_3D.this.sliceStride;
                                for (long j = 0L; j < DoubleDHT_3D.this.rowsl; ++j) {
                                    DoubleDHT_3D.this.dhtColumns.forward(doubleLargeArray, l3 + j * (long)DoubleDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDHT_3D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l4 = i * (long)DoubleDHT_3D.this.sliceStride;
                                for (long j = 0L; j < DoubleDHT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.rowsl; ++l3) {
                                        l22 = l4 + l3 * (long)DoubleDHT_3D.this.rowStride + j;
                                        doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2);
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.rowsl; ++l3) {
                                        l22 = l4 + l3 * (long)DoubleDHT_3D.this.rowStride + j;
                                        doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDHT_3D.this.slicesl, false);
                            for (long i = l2; i < l; ++i) {
                                long l4 = i * (long)DoubleDHT_3D.this.rowStride;
                                for (long j = 0L; j < DoubleDHT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.slicesl; ++l3) {
                                        l22 = l3 * (long)DoubleDHT_3D.this.sliceStride + l4 + j;
                                        doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2);
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.slicesl; ++l3) {
                                        l22 = l3 * (long)DoubleDHT_3D.this.sliceStride + l4 + j;
                                        doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                long l;
                long l4;
                long l5;
                long l6;
                long l7;
                for (long i = 0L; i < this.slicesl; ++i) {
                    long l8 = i * (long)this.sliceStride;
                    for (long j = 0L; j < this.rowsl; ++j) {
                        this.dhtColumns.forward(doubleLargeArray, l8 + j * (long)this.rowStride);
                    }
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.rowsl, false);
                for (l7 = 0L; l7 < this.slicesl; ++l7) {
                    l6 = l7 * (long)this.sliceStride;
                    for (l5 = 0L; l5 < this.columnsl; ++l5) {
                        for (l4 = 0L; l4 < this.rowsl; ++l4) {
                            l = l6 + l4 * (long)this.rowStride + l5;
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                        }
                        this.dhtRows.forward(doubleLargeArray2);
                        for (l4 = 0L; l4 < this.rowsl; ++l4) {
                            l = l6 + l4 * (long)this.rowStride + l5;
                            doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                        }
                    }
                }
                doubleLargeArray2 = new DoubleLargeArray(this.slicesl, false);
                for (l7 = 0L; l7 < this.rowsl; ++l7) {
                    l6 = l7 * (long)this.rowStride;
                    for (l5 = 0L; l5 < this.columnsl; ++l5) {
                        for (l4 = 0L; l4 < this.slicesl; ++l4) {
                            l = l4 * (long)this.sliceStride + l6 + l5;
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                        }
                        this.dhtSlices.forward(doubleLargeArray2);
                        for (l4 = 0L; l4 < this.slicesl; ++l4) {
                            l = l4 * (long)this.sliceStride + l6 + l5;
                            doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                        }
                    }
                }
            }
            this.yTransform(doubleLargeArray);
        }
    }

    public void forward(final double[][][] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, dArray, true);
                this.ddxt3db_subth(-1, dArray, true);
            } else {
                this.ddxt3da_sub(-1, dArray, true);
                this.ddxt3db_sub(-1, dArray, true);
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.slices / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                for (int j = 0; j < DoubleDHT_3D.this.rows; ++j) {
                                    DoubleDHT_3D.this.dhtColumns.forward(dArray[i][j]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n;
                                    for (n = 0; n < DoubleDHT_3D.this.rows; ++n) {
                                        dArray2[n] = dArray[i][n][j];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2);
                                    for (n = 0; n < DoubleDHT_3D.this.rows; ++n) {
                                        dArray[i][n][j] = dArray2[n];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.slices];
                            for (int i = n3; i < n2; ++i) {
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n;
                                    for (n = 0; n < DoubleDHT_3D.this.slices; ++n) {
                                        dArray2[n] = dArray[n][i][j];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(dArray2);
                                    for (n = 0; n < DoubleDHT_3D.this.slices; ++n) {
                                        dArray[n][i][j] = dArray2[n];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6;
                int n7;
                int n8;
                for (int i = 0; i < this.slices; ++i) {
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        this.dhtColumns.forward(dArray[i][n8]);
                    }
                }
                double[] dArray2 = new double[this.rows];
                for (n8 = 0; n8 < this.slices; ++n8) {
                    for (n7 = 0; n7 < this.columns; ++n7) {
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            dArray2[n6] = dArray[n8][n6][n7];
                        }
                        this.dhtRows.forward(dArray2);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            dArray[n8][n6][n7] = dArray2[n6];
                        }
                    }
                }
                dArray2 = new double[this.slices];
                for (n8 = 0; n8 < this.rows; ++n8) {
                    for (n7 = 0; n7 < this.columns; ++n7) {
                        for (n6 = 0; n6 < this.slices; ++n6) {
                            dArray2[n6] = dArray[n6][n8][n7];
                        }
                        this.dhtSlices.forward(dArray2);
                        for (n6 = 0; n6 < this.slices; ++n6) {
                            dArray[n6][n8][n7] = dArray2[n6];
                        }
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    public void inverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, dArray, bl);
                this.ddxt3db_subth(1, dArray, bl);
            } else {
                this.ddxt3da_sub(1, dArray, bl);
                this.ddxt3db_sub(1, dArray, bl);
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.slices / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                int n = i * DoubleDHT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleDHT_3D.this.rows; ++j) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(dArray, n + j * DoubleDHT_3D.this.rowStride, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n = i * DoubleDHT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n22;
                                    int n32;
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.rows; ++n32) {
                                        n22 = n + n32 * DoubleDHT_3D.this.rowStride + j;
                                        dArray2[n32] = dArray[n22];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, bl);
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.rows; ++n32) {
                                        n22 = n + n32 * DoubleDHT_3D.this.rowStride + j;
                                        dArray[n22] = dArray2[n32];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.slices];
                            for (int i = n3; i < n2; ++i) {
                                int n = i * DoubleDHT_3D.this.rowStride;
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n22;
                                    int n32;
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.slices; ++n32) {
                                        n22 = n32 * DoubleDHT_3D.this.sliceStride + n + j;
                                        dArray2[n32] = dArray[n22];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, bl);
                                    for (n32 = 0; n32 < DoubleDHT_3D.this.slices; ++n32) {
                                        n22 = n32 * DoubleDHT_3D.this.sliceStride + n + j;
                                        dArray[n22] = dArray2[n32];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                for (int i = 0; i < this.slices; ++i) {
                    n10 = i * this.sliceStride;
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        this.dhtColumns.inverse(dArray, n10 + n9 * this.rowStride, bl);
                    }
                }
                double[] dArray2 = new double[this.rows];
                for (n10 = 0; n10 < this.slices; ++n10) {
                    n9 = n10 * this.sliceStride;
                    for (n8 = 0; n8 < this.columns; ++n8) {
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n9 + n7 * this.rowStride + n8;
                            dArray2[n7] = dArray[n6];
                        }
                        this.dhtRows.inverse(dArray2, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n9 + n7 * this.rowStride + n8;
                            dArray[n6] = dArray2[n7];
                        }
                    }
                }
                dArray2 = new double[this.slices];
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = n10 * this.rowStride;
                    for (n8 = 0; n8 < this.columns; ++n8) {
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = n7 * this.sliceStride + n9 + n8;
                            dArray2[n7] = dArray[n6];
                        }
                        this.dhtSlices.inverse(dArray2, bl);
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = n7 * this.sliceStride + n9 + n8;
                            dArray[n6] = dArray2[n7];
                        }
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    public void inverse(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, doubleLargeArray, bl);
                this.ddxt3db_subth(1, doubleLargeArray, bl);
            } else {
                this.ddxt3da_sub(1, doubleLargeArray, bl);
                this.ddxt3db_sub(1, doubleLargeArray, bl);
            }
            this.yTransform(doubleLargeArray);
        } else {
            if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.slicesl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                long l3 = i * DoubleDHT_3D.this.sliceStridel;
                                for (long j = 0L; j < DoubleDHT_3D.this.rowsl; ++j) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(doubleLargeArray, l3 + j * DoubleDHT_3D.this.rowStridel, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDHT_3D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l4 = i * DoubleDHT_3D.this.sliceStridel;
                                for (long j = 0L; j < DoubleDHT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.rowsl; ++l3) {
                                        l22 = l4 + l3 * DoubleDHT_3D.this.rowStridel + j;
                                        doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, bl);
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.rowsl; ++l3) {
                                        l22 = l4 + l3 * DoubleDHT_3D.this.rowStridel + j;
                                        doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDHT_3D.this.slicesl, false);
                            for (long i = l2; i < l; ++i) {
                                long l4 = i * DoubleDHT_3D.this.rowStridel;
                                for (long j = 0L; j < DoubleDHT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.slicesl; ++l3) {
                                        l22 = l3 * DoubleDHT_3D.this.sliceStridel + l4 + j;
                                        doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, bl);
                                    for (l3 = 0L; l3 < DoubleDHT_3D.this.slicesl; ++l3) {
                                        l22 = l3 * DoubleDHT_3D.this.sliceStridel + l4 + j;
                                        doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                long l;
                long l4;
                long l5;
                long l6;
                long l7;
                for (long i = 0L; i < this.slicesl; ++i) {
                    long l8 = i * this.sliceStridel;
                    for (long j = 0L; j < this.rowsl; ++j) {
                        this.dhtColumns.inverse(doubleLargeArray, l8 + j * this.rowStridel, bl);
                    }
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.rowsl, false);
                for (l7 = 0L; l7 < this.slicesl; ++l7) {
                    l6 = l7 * this.sliceStridel;
                    for (l5 = 0L; l5 < this.columnsl; ++l5) {
                        for (l4 = 0L; l4 < this.rowsl; ++l4) {
                            l = l6 + l4 * this.rowStridel + l5;
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                        }
                        this.dhtRows.inverse(doubleLargeArray2, bl);
                        for (l4 = 0L; l4 < this.rowsl; ++l4) {
                            l = l6 + l4 * this.rowStridel + l5;
                            doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                        }
                    }
                }
                doubleLargeArray2 = new DoubleLargeArray(this.slicesl, false);
                for (l7 = 0L; l7 < this.rowsl; ++l7) {
                    l6 = l7 * this.rowStridel;
                    for (l5 = 0L; l5 < this.columnsl; ++l5) {
                        for (l4 = 0L; l4 < this.slicesl; ++l4) {
                            l = l4 * this.sliceStridel + l6 + l5;
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                        }
                        this.dhtSlices.inverse(doubleLargeArray2, bl);
                        for (l4 = 0L; l4 < this.slicesl; ++l4) {
                            l = l4 * this.sliceStridel + l6 + l5;
                            doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                        }
                    }
                }
            }
            this.yTransform(doubleLargeArray);
        }
    }

    public void inverse(final double[][][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, dArray, bl);
                this.ddxt3db_subth(1, dArray, bl);
            } else {
                this.ddxt3da_sub(1, dArray, bl);
                this.ddxt3db_sub(1, dArray, bl);
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.slices / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                for (int j = 0; j < DoubleDHT_3D.this.rows; ++j) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(dArray[i][j], bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.slices : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n;
                                    for (n = 0; n < DoubleDHT_3D.this.rows; ++n) {
                                        dArray2[n] = dArray[i][n][j];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, bl);
                                    for (n = 0; n < DoubleDHT_3D.this.rows; ++n) {
                                        dArray[i][n][j] = dArray2[n];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_3D.this.slices];
                            for (int i = n3; i < n2; ++i) {
                                for (int j = 0; j < DoubleDHT_3D.this.columns; ++j) {
                                    int n;
                                    for (n = 0; n < DoubleDHT_3D.this.slices; ++n) {
                                        dArray2[n] = dArray[n][i][j];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, bl);
                                    for (n = 0; n < DoubleDHT_3D.this.slices; ++n) {
                                        dArray[n][i][j] = dArray2[n];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6;
                int n7;
                int n8;
                for (int i = 0; i < this.slices; ++i) {
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        this.dhtColumns.inverse(dArray[i][n8], bl);
                    }
                }
                double[] dArray2 = new double[this.rows];
                for (n8 = 0; n8 < this.slices; ++n8) {
                    for (n7 = 0; n7 < this.columns; ++n7) {
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            dArray2[n6] = dArray[n8][n6][n7];
                        }
                        this.dhtRows.inverse(dArray2, bl);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            dArray[n8][n6][n7] = dArray2[n6];
                        }
                    }
                }
                dArray2 = new double[this.slices];
                for (n8 = 0; n8 < this.rows; ++n8) {
                    for (n7 = 0; n7 < this.columns; ++n7) {
                        for (n6 = 0; n6 < this.slices; ++n6) {
                            dArray2[n6] = dArray[n6][n8][n7];
                        }
                        this.dhtSlices.inverse(dArray2, bl);
                        for (n6 = 0; n6 < this.slices; ++n6) {
                            dArray[n6][n8][n7] = dArray2[n6];
                        }
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    private void ddxt3da_sub(int n, double[] dArray, boolean bl) {
        int n2 = 4 * this.rows;
        if (this.columns == 2) {
            n2 >>= 1;
        }
        double[] dArray2 = new double[n2];
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5 = i * this.sliceStride;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    this.dhtColumns.forward(dArray, n5 + n4 * this.rowStride);
                }
                if (this.columns > 2) {
                    for (n4 = 0; n4 < this.columns; n4 += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n3 = n5 + n7 * this.rowStride + n4;
                            n6 = this.rows + n7;
                            dArray2[n7] = dArray[n3];
                            dArray2[n6] = dArray[n3 + 1];
                            dArray2[n6 + this.rows] = dArray[n3 + 2];
                            dArray2[n6 + 2 * this.rows] = dArray[n3 + 3];
                        }
                        this.dhtRows.forward(dArray2, 0);
                        this.dhtRows.forward(dArray2, this.rows);
                        this.dhtRows.forward(dArray2, 2 * this.rows);
                        this.dhtRows.forward(dArray2, 3 * this.rows);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n3 = n5 + n7 * this.rowStride + n4;
                            n6 = this.rows + n7;
                            dArray[n3] = dArray2[n7];
                            dArray[n3 + 1] = dArray2[n6];
                            dArray[n3 + 2] = dArray2[n6 + this.rows];
                            dArray[n3 + 3] = dArray2[n6 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n5 + n4 * this.rowStride;
                    dArray2[n4] = dArray[n3];
                    dArray2[this.rows + n4] = dArray[n3 + 1];
                }
                this.dhtRows.forward(dArray2, 0);
                this.dhtRows.forward(dArray2, this.rows);
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n5 + n4 * this.rowStride;
                    dArray[n3] = dArray2[n4];
                    dArray[n3 + 1] = dArray2[this.rows + n4];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n8;
                int n9;
                int n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dhtColumns.inverse(dArray, n10 + n9 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n9 = 0; n9 < this.columns; n9 += 4) {
                        int n11;
                        int n12;
                        for (n12 = 0; n12 < this.rows; ++n12) {
                            n8 = n10 + n12 * this.rowStride + n9;
                            n11 = this.rows + n12;
                            dArray2[n12] = dArray[n8];
                            dArray2[n11] = dArray[n8 + 1];
                            dArray2[n11 + this.rows] = dArray[n8 + 2];
                            dArray2[n11 + 2 * this.rows] = dArray[n8 + 3];
                        }
                        this.dhtRows.inverse(dArray2, 0, bl);
                        this.dhtRows.inverse(dArray2, this.rows, bl);
                        this.dhtRows.inverse(dArray2, 2 * this.rows, bl);
                        this.dhtRows.inverse(dArray2, 3 * this.rows, bl);
                        for (n12 = 0; n12 < this.rows; ++n12) {
                            n8 = n10 + n12 * this.rowStride + n9;
                            n11 = this.rows + n12;
                            dArray[n8] = dArray2[n12];
                            dArray[n8 + 1] = dArray2[n11];
                            dArray[n8 + 2] = dArray2[n11 + this.rows];
                            dArray[n8 + 3] = dArray2[n11 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    n8 = n10 + n9 * this.rowStride;
                    dArray2[n9] = dArray[n8];
                    dArray2[this.rows + n9] = dArray[n8 + 1];
                }
                this.dhtRows.inverse(dArray2, 0, bl);
                this.dhtRows.inverse(dArray2, this.rows, bl);
                for (n9 = 0; n9 < this.rows; ++n9) {
                    n8 = n10 + n9 * this.rowStride;
                    dArray[n8] = dArray2[n9];
                    dArray[n8 + 1] = dArray2[this.rows + n9];
                }
            }
        }
    }

    private void ddxt3da_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l2;
                long l3;
                long l4 = i * this.sliceStridel;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    this.dhtColumns.forward(doubleLargeArray, l4 + l3 * this.rowStridel);
                }
                if (this.columnsl > 2L) {
                    for (l3 = 0L; l3 < this.columnsl; l3 += 4L) {
                        long l5;
                        long l6;
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l2 = l4 + l6 * this.rowStridel + l3;
                            l5 = this.rowsl + l6;
                            doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l2));
                            doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l2 + 1L));
                            doubleLargeArray2.setDouble(l5 + this.rowsl, doubleLargeArray.getDouble(l2 + 2L));
                            doubleLargeArray2.setDouble(l5 + 2L * this.rowsl, doubleLargeArray.getDouble(l2 + 3L));
                        }
                        this.dhtRows.forward(doubleLargeArray2, 0L);
                        this.dhtRows.forward(doubleLargeArray2, this.rowsl);
                        this.dhtRows.forward(doubleLargeArray2, 2L * this.rowsl);
                        this.dhtRows.forward(doubleLargeArray2, 3L * this.rowsl);
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l2 = l4 + l6 * this.rowStridel + l3;
                            l5 = this.rowsl + l6;
                            doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l6));
                            doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(l5));
                            doubleLargeArray.setDouble(l2 + 2L, doubleLargeArray2.getDouble(l5 + this.rowsl));
                            doubleLargeArray.setDouble(l2 + 3L, doubleLargeArray2.getDouble(l5 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l4 + l3 * this.rowStridel;
                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l2));
                    doubleLargeArray2.setDouble(this.rowsl + l3, doubleLargeArray.getDouble(l2 + 1L));
                }
                this.dhtRows.forward(doubleLargeArray2, 0L);
                this.dhtRows.forward(doubleLargeArray2, this.rowsl);
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l4 + l3 * this.rowStridel;
                    doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l3));
                    doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(this.rowsl + l3));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l7;
                long l8;
                long l9 = i * this.sliceStridel;
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    this.dhtColumns.inverse(doubleLargeArray, l9 + l8 * this.rowStridel, bl);
                }
                if (this.columnsl > 2L) {
                    for (l8 = 0L; l8 < this.columnsl; l8 += 4L) {
                        long l10;
                        long l11;
                        for (l11 = 0L; l11 < this.rowsl; ++l11) {
                            l7 = l9 + l11 * this.rowStridel + l8;
                            l10 = this.rowsl + l11;
                            doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l7));
                            doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l7 + 1L));
                            doubleLargeArray2.setDouble(l10 + this.rowsl, doubleLargeArray.getDouble(l7 + 2L));
                            doubleLargeArray2.setDouble(l10 + 2L * this.rowsl, doubleLargeArray.getDouble(l7 + 3L));
                        }
                        this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                        this.dhtRows.inverse(doubleLargeArray2, this.rowsl, bl);
                        this.dhtRows.inverse(doubleLargeArray2, 2L * this.rowsl, bl);
                        this.dhtRows.inverse(doubleLargeArray2, 3L * this.rowsl, bl);
                        for (l11 = 0L; l11 < this.rowsl; ++l11) {
                            l7 = l9 + l11 * this.rowStridel + l8;
                            l10 = this.rowsl + l11;
                            doubleLargeArray.setDouble(l7, doubleLargeArray2.getDouble(l11));
                            doubleLargeArray.setDouble(l7 + 1L, doubleLargeArray2.getDouble(l10));
                            doubleLargeArray.setDouble(l7 + 2L, doubleLargeArray2.getDouble(l10 + this.rowsl));
                            doubleLargeArray.setDouble(l7 + 3L, doubleLargeArray2.getDouble(l10 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    l7 = l9 + l8 * this.rowStridel;
                    doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l7));
                    doubleLargeArray2.setDouble(this.rowsl + l8, doubleLargeArray.getDouble(l7 + 1L));
                }
                this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                this.dhtRows.inverse(doubleLargeArray2, this.rowsl, bl);
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    l7 = l9 + l8 * this.rowStridel;
                    doubleLargeArray.setDouble(l7, doubleLargeArray2.getDouble(l8));
                    doubleLargeArray.setDouble(l7 + 1L, doubleLargeArray2.getDouble(this.rowsl + l8));
                }
            }
        }
    }

    private void ddxt3da_sub(int n, double[][][] dArray, boolean bl) {
        int n2 = 4 * this.rows;
        if (this.columnsl == 2L) {
            n2 >>= 1;
        }
        double[] dArray2 = new double[n2];
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    this.dhtColumns.forward(dArray[i][n3]);
                }
                if (this.columns > 2) {
                    for (n3 = 0; n3 < this.columns; n3 += 4) {
                        int n4;
                        int n5;
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            dArray2[n5] = dArray[i][n5][n3];
                            dArray2[n4] = dArray[i][n5][n3 + 1];
                            dArray2[n4 + this.rows] = dArray[i][n5][n3 + 2];
                            dArray2[n4 + 2 * this.rows] = dArray[i][n5][n3 + 3];
                        }
                        this.dhtRows.forward(dArray2, 0);
                        this.dhtRows.forward(dArray2, this.rows);
                        this.dhtRows.forward(dArray2, 2 * this.rows);
                        this.dhtRows.forward(dArray2, 3 * this.rows);
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            dArray[i][n5][n3] = dArray2[n5];
                            dArray[i][n5][n3 + 1] = dArray2[n4];
                            dArray[i][n5][n3 + 2] = dArray2[n4 + this.rows];
                            dArray[i][n5][n3 + 3] = dArray2[n4 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    dArray2[n3] = dArray[i][n3][0];
                    dArray2[this.rows + n3] = dArray[i][n3][1];
                }
                this.dhtRows.forward(dArray2, 0);
                this.dhtRows.forward(dArray2, this.rows);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    dArray[i][n3][0] = dArray2[n3];
                    dArray[i][n3][1] = dArray2[this.rows + n3];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    this.dhtColumns.inverse(dArray[i][n6], bl);
                }
                if (this.columns > 2) {
                    for (n6 = 0; n6 < this.columns; n6 += 4) {
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n7 = this.rows + n8;
                            dArray2[n8] = dArray[i][n8][n6];
                            dArray2[n7] = dArray[i][n8][n6 + 1];
                            dArray2[n7 + this.rows] = dArray[i][n8][n6 + 2];
                            dArray2[n7 + 2 * this.rows] = dArray[i][n8][n6 + 3];
                        }
                        this.dhtRows.inverse(dArray2, 0, bl);
                        this.dhtRows.inverse(dArray2, this.rows, bl);
                        this.dhtRows.inverse(dArray2, 2 * this.rows, bl);
                        this.dhtRows.inverse(dArray2, 3 * this.rows, bl);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n7 = this.rows + n8;
                            dArray[i][n8][n6] = dArray2[n8];
                            dArray[i][n8][n6 + 1] = dArray2[n7];
                            dArray[i][n8][n6 + 2] = dArray2[n7 + this.rows];
                            dArray[i][n8][n6 + 3] = dArray2[n7 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n6] = dArray[i][n6][0];
                    dArray2[this.rows + n6] = dArray[i][n6][1];
                }
                this.dhtRows.inverse(dArray2, 0, bl);
                this.dhtRows.inverse(dArray2, this.rows, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray[i][n6][0] = dArray2[n6];
                    dArray[i][n6][1] = dArray2[this.rows + n6];
                }
            }
        }
    }

    private void ddxt3db_sub(int n, double[] dArray, boolean bl) {
        block20: {
            double[] dArray2;
            block18: {
                block19: {
                    int n2 = 4 * this.slices;
                    if (this.columns == 2) {
                        n2 >>= 1;
                    }
                    dArray2 = new double[n2];
                    if (n != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int i = 0; i < this.rows; ++i) {
                        int n3 = i * this.rowStride;
                        for (int j = 0; j < this.columns; j += 4) {
                            int n4;
                            int n5;
                            int n6;
                            for (n6 = 0; n6 < this.slices; ++n6) {
                                n5 = n6 * this.sliceStride + n3 + j;
                                n4 = this.slices + n6;
                                dArray2[n6] = dArray[n5];
                                dArray2[n4] = dArray[n5 + 1];
                                dArray2[n4 + this.slices] = dArray[n5 + 2];
                                dArray2[n4 + 2 * this.slices] = dArray[n5 + 3];
                            }
                            this.dhtSlices.forward(dArray2, 0);
                            this.dhtSlices.forward(dArray2, this.slices);
                            this.dhtSlices.forward(dArray2, 2 * this.slices);
                            this.dhtSlices.forward(dArray2, 3 * this.slices);
                            for (n6 = 0; n6 < this.slices; ++n6) {
                                n5 = n6 * this.sliceStride + n3 + j;
                                n4 = this.slices + n6;
                                dArray[n5] = dArray2[n6];
                                dArray[n5 + 1] = dArray2[n4];
                                dArray[n5 + 2] = dArray2[n4 + this.slices];
                                dArray[n5 + 3] = dArray2[n4 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int i = 0; i < this.rows; ++i) {
                    int n7;
                    int n8;
                    int n9 = i * this.rowStride;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = n8 * this.sliceStride + n9;
                        dArray2[n8] = dArray[n7];
                        dArray2[this.slices + n8] = dArray[n7 + 1];
                    }
                    this.dhtSlices.forward(dArray2, 0);
                    this.dhtSlices.forward(dArray2, this.slices);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = n8 * this.sliceStride + n9;
                        dArray[n7] = dArray2[n8];
                        dArray[n7 + 1] = dArray2[this.slices + n8];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n10 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 4) {
                        int n11;
                        int n12;
                        int n13;
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n10 + j;
                            n11 = this.slices + n13;
                            dArray2[n13] = dArray[n12];
                            dArray2[n11] = dArray[n12 + 1];
                            dArray2[n11 + this.slices] = dArray[n12 + 2];
                            dArray2[n11 + 2 * this.slices] = dArray[n12 + 3];
                        }
                        this.dhtSlices.inverse(dArray2, 0, bl);
                        this.dhtSlices.inverse(dArray2, this.slices, bl);
                        this.dhtSlices.inverse(dArray2, 2 * this.slices, bl);
                        this.dhtSlices.inverse(dArray2, 3 * this.slices, bl);
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n10 + j;
                            n11 = this.slices + n13;
                            dArray[n12] = dArray2[n13];
                            dArray[n12 + 1] = dArray2[n11];
                            dArray[n12 + 2] = dArray2[n11 + this.slices];
                            dArray[n12 + 3] = dArray2[n11 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n14;
                    int n15;
                    int n16 = i * this.rowStride;
                    for (n15 = 0; n15 < this.slices; ++n15) {
                        n14 = n15 * this.sliceStride + n16;
                        dArray2[n15] = dArray[n14];
                        dArray2[this.slices + n15] = dArray[n14 + 1];
                    }
                    this.dhtSlices.inverse(dArray2, 0, bl);
                    this.dhtSlices.inverse(dArray2, this.slices, bl);
                    for (n15 = 0; n15 < this.slices; ++n15) {
                        n14 = n15 * this.sliceStride + n16;
                        dArray[n14] = dArray2[n15];
                        dArray[n14 + 1] = dArray2[this.slices + n15];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        block20: {
            DoubleLargeArray doubleLargeArray2;
            block18: {
                block19: {
                    long l = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        l >>= 1;
                    }
                    doubleLargeArray2 = new DoubleLargeArray(l, false);
                    if (n != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long i = 0L; i < this.rowsl; ++i) {
                        long l2 = i * this.rowStridel;
                        for (long j = 0L; j < this.columnsl; j += 4L) {
                            long l3;
                            long l4;
                            long l5;
                            for (l5 = 0L; l5 < this.slicesl; ++l5) {
                                l4 = l5 * this.sliceStridel + l2 + j;
                                l3 = this.slicesl + l5;
                                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l4));
                                doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l4 + 1L));
                                doubleLargeArray2.setDouble(l3 + this.slicesl, doubleLargeArray.getDouble(l4 + 2L));
                                doubleLargeArray2.setDouble(l3 + 2L * this.slicesl, doubleLargeArray.getDouble(l4 + 3L));
                            }
                            this.dhtSlices.forward(doubleLargeArray2, 0L);
                            this.dhtSlices.forward(doubleLargeArray2, this.slicesl);
                            this.dhtSlices.forward(doubleLargeArray2, 2L * this.slicesl);
                            this.dhtSlices.forward(doubleLargeArray2, 3L * this.slicesl);
                            for (l5 = 0L; l5 < this.slicesl; ++l5) {
                                l4 = l5 * this.sliceStridel + l2 + j;
                                l3 = this.slicesl + l5;
                                doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l5));
                                doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l3));
                                doubleLargeArray.setDouble(l4 + 2L, doubleLargeArray2.getDouble(l3 + this.slicesl));
                                doubleLargeArray.setDouble(l4 + 3L, doubleLargeArray2.getDouble(l3 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l6;
                    long l7 = i * this.rowStridel;
                    for (l6 = 0L; l6 < this.slicesl; ++l6) {
                        l = l6 * this.sliceStridel + l7;
                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l));
                        doubleLargeArray2.setDouble(this.slicesl + l6, doubleLargeArray.getDouble(l + 1L));
                    }
                    this.dhtSlices.forward(doubleLargeArray2, 0L);
                    this.dhtSlices.forward(doubleLargeArray2, this.slicesl);
                    for (l6 = 0L; l6 < this.slicesl; ++l6) {
                        l = l6 * this.sliceStridel + l7;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l6));
                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(this.slicesl + l6));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l = i * this.rowStridel;
                    for (long j = 0L; j < this.columnsl; j += 4L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.slicesl; ++l10) {
                            l9 = l10 * this.sliceStridel + l + j;
                            l8 = this.slicesl + l10;
                            doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l9));
                            doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l9 + 1L));
                            doubleLargeArray2.setDouble(l8 + this.slicesl, doubleLargeArray.getDouble(l9 + 2L));
                            doubleLargeArray2.setDouble(l8 + 2L * this.slicesl, doubleLargeArray.getDouble(l9 + 3L));
                        }
                        this.dhtSlices.inverse(doubleLargeArray2, 0L, bl);
                        this.dhtSlices.inverse(doubleLargeArray2, this.slicesl, bl);
                        this.dhtSlices.inverse(doubleLargeArray2, 2L * this.slicesl, bl);
                        this.dhtSlices.inverse(doubleLargeArray2, 3L * this.slicesl, bl);
                        for (l10 = 0L; l10 < this.slicesl; ++l10) {
                            l9 = l10 * this.sliceStridel + l + j;
                            l8 = this.slicesl + l10;
                            doubleLargeArray.setDouble(l9, doubleLargeArray2.getDouble(l10));
                            doubleLargeArray.setDouble(l9 + 1L, doubleLargeArray2.getDouble(l8));
                            doubleLargeArray.setDouble(l9 + 2L, doubleLargeArray2.getDouble(l8 + this.slicesl));
                            doubleLargeArray.setDouble(l9 + 3L, doubleLargeArray2.getDouble(l8 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l11;
                    long l12 = i * this.rowStridel;
                    for (l11 = 0L; l11 < this.slicesl; ++l11) {
                        l = l11 * this.sliceStridel + l12;
                        doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l));
                        doubleLargeArray2.setDouble(this.slicesl + l11, doubleLargeArray.getDouble(l + 1L));
                    }
                    this.dhtSlices.inverse(doubleLargeArray2, 0L, bl);
                    this.dhtSlices.inverse(doubleLargeArray2, this.slicesl, bl);
                    for (l11 = 0L; l11 < this.slicesl; ++l11) {
                        l = l11 * this.sliceStridel + l12;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l11));
                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(this.slicesl + l11));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, double[][][] dArray, boolean bl) {
        block20: {
            double[] dArray2;
            block18: {
                block19: {
                    int n2 = 4 * this.slices;
                    if (this.columns == 2) {
                        n2 >>= 1;
                    }
                    dArray2 = new double[n2];
                    if (n != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int i = 0; i < this.rows; ++i) {
                        for (int j = 0; j < this.columns; j += 4) {
                            int n3;
                            int n4;
                            for (n4 = 0; n4 < this.slices; ++n4) {
                                n3 = this.slices + n4;
                                dArray2[n4] = dArray[n4][i][j];
                                dArray2[n3] = dArray[n4][i][j + 1];
                                dArray2[n3 + this.slices] = dArray[n4][i][j + 2];
                                dArray2[n3 + 2 * this.slices] = dArray[n4][i][j + 3];
                            }
                            this.dhtSlices.forward(dArray2, 0);
                            this.dhtSlices.forward(dArray2, this.slices);
                            this.dhtSlices.forward(dArray2, 2 * this.slices);
                            this.dhtSlices.forward(dArray2, 3 * this.slices);
                            for (n4 = 0; n4 < this.slices; ++n4) {
                                n3 = this.slices + n4;
                                dArray[n4][i][j] = dArray2[n4];
                                dArray[n4][i][j + 1] = dArray2[n3];
                                dArray[n4][i][j + 2] = dArray2[n3 + this.slices];
                                dArray[n4][i][j + 3] = dArray2[n3 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int i = 0; i < this.rows; ++i) {
                    int n5;
                    for (n5 = 0; n5 < this.slices; ++n5) {
                        dArray2[n5] = dArray[n5][i][0];
                        dArray2[this.slices + n5] = dArray[n5][i][1];
                    }
                    this.dhtSlices.forward(dArray2, 0);
                    this.dhtSlices.forward(dArray2, this.slices);
                    for (n5 = 0; n5 < this.slices; ++n5) {
                        dArray[n5][i][0] = dArray2[n5];
                        dArray[n5][i][1] = dArray2[this.slices + n5];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = this.slices + n7;
                            dArray2[n7] = dArray[n7][i][j];
                            dArray2[n6] = dArray[n7][i][j + 1];
                            dArray2[n6 + this.slices] = dArray[n7][i][j + 2];
                            dArray2[n6 + 2 * this.slices] = dArray[n7][i][j + 3];
                        }
                        this.dhtSlices.inverse(dArray2, 0, bl);
                        this.dhtSlices.inverse(dArray2, this.slices, bl);
                        this.dhtSlices.inverse(dArray2, 2 * this.slices, bl);
                        this.dhtSlices.inverse(dArray2, 3 * this.slices, bl);
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = this.slices + n7;
                            dArray[n7][i][j] = dArray2[n7];
                            dArray[n7][i][j + 1] = dArray2[n6];
                            dArray[n7][i][j + 2] = dArray2[n6 + this.slices];
                            dArray[n7][i][j + 3] = dArray2[n6 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n8;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        dArray2[n8] = dArray[n8][i][0];
                        dArray2[this.slices + n8] = dArray[n8][i][1];
                    }
                    this.dhtSlices.inverse(dArray2, 0, bl);
                    this.dhtSlices.inverse(dArray2, this.slices, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        dArray[n8][i][0] = dArray2[n8];
                        dArray[n8][i][1] = dArray2[this.slices + n8];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n4];
                    if (n == -1) {
                        for (int i = n5; i < DoubleDHT_3D.this.slices; i += n2) {
                            int n10;
                            int n22;
                            int n3 = i * DoubleDHT_3D.this.sliceStride;
                            for (n22 = 0; n22 < DoubleDHT_3D.this.rows; ++n22) {
                                DoubleDHT_3D.this.dhtColumns.forward(dArray, n3 + n22 * DoubleDHT_3D.this.rowStride);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (n22 = 0; n22 < DoubleDHT_3D.this.columns; n22 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < DoubleDHT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * DoubleDHT_3D.this.rowStride + n22;
                                        n42 = DoubleDHT_3D.this.rows + n52;
                                        dArray2[n52] = dArray[n10];
                                        dArray2[n42] = dArray[n10 + 1];
                                        dArray2[n42 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[n10 + 2];
                                        dArray2[n42 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[n10 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, 0);
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, 2 * DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, 3 * DoubleDHT_3D.this.rows);
                                    for (n52 = 0; n52 < DoubleDHT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * DoubleDHT_3D.this.rowStride + n22;
                                        n42 = DoubleDHT_3D.this.rows + n52;
                                        dArray[n10] = dArray2[n52];
                                        dArray[n10 + 1] = dArray2[n42];
                                        dArray[n10 + 2] = dArray2[n42 + DoubleDHT_3D.this.rows];
                                        dArray[n10 + 3] = dArray2[n42 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (n22 = 0; n22 < DoubleDHT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * DoubleDHT_3D.this.rowStride;
                                dArray2[n22] = dArray[n10];
                                dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + n22] = dArray[n10 + 1];
                            }
                            DoubleDHT_3D.this.dhtRows.forward(dArray2, 0);
                            DoubleDHT_3D.this.dhtRows.forward(dArray2, DoubleDHT_3D.this.rows);
                            for (n22 = 0; n22 < DoubleDHT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * DoubleDHT_3D.this.rowStride;
                                dArray[n10] = dArray2[n22];
                                dArray[n10 + 1] = dArray2[DoubleDHT_3D.this.rows + n22];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleDHT_3D.this.slices; i += n2) {
                            int n11;
                            int n6;
                            int n7 = i * DoubleDHT_3D.this.sliceStride;
                            for (n6 = 0; n6 < DoubleDHT_3D.this.rows; ++n6) {
                                DoubleDHT_3D.this.dhtColumns.inverse(dArray, n7 + n6 * DoubleDHT_3D.this.rowStride, bl);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < DoubleDHT_3D.this.columns; n6 += 4) {
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < DoubleDHT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * DoubleDHT_3D.this.rowStride + n6;
                                        n8 = DoubleDHT_3D.this.rows + n9;
                                        dArray2[n9] = dArray[n11];
                                        dArray2[n8] = dArray[n11 + 1];
                                        dArray2[n8 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[n11 + 2];
                                        dArray2[n8 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[n11 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, 0, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, DoubleDHT_3D.this.rows, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, 2 * DoubleDHT_3D.this.rows, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, 3 * DoubleDHT_3D.this.rows, bl);
                                    for (n9 = 0; n9 < DoubleDHT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * DoubleDHT_3D.this.rowStride + n6;
                                        n8 = DoubleDHT_3D.this.rows + n9;
                                        dArray[n11] = dArray2[n9];
                                        dArray[n11 + 1] = dArray2[n8];
                                        dArray[n11 + 2] = dArray2[n8 + DoubleDHT_3D.this.rows];
                                        dArray[n11 + 3] = dArray2[n8 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < DoubleDHT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * DoubleDHT_3D.this.rowStride;
                                dArray2[n6] = dArray[n11];
                                dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + n6] = dArray[n11 + 1];
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(dArray2, 0, bl);
                            DoubleDHT_3D.this.dhtRows.inverse(dArray2, DoubleDHT_3D.this.rows, bl);
                            for (n6 = 0; n6 < DoubleDHT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * DoubleDHT_3D.this.rowStride;
                                dArray[n11] = dArray2[n6];
                                dArray[n11 + 1] = dArray2[DoubleDHT_3D.this.rows + n6];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2, false);
                    if (n == -1) {
                        for (long i = l3; i < DoubleDHT_3D.this.slicesl; i += (long)n2) {
                            long l;
                            long l22;
                            long l32 = i * (long)DoubleDHT_3D.this.sliceStride;
                            for (l22 = 0L; l22 < DoubleDHT_3D.this.rowsl; ++l22) {
                                DoubleDHT_3D.this.dhtColumns.forward(doubleLargeArray, l32 + l22 * (long)DoubleDHT_3D.this.rowStride);
                            }
                            if (DoubleDHT_3D.this.columnsl > 2L) {
                                for (l22 = 0L; l22 < DoubleDHT_3D.this.columnsl; l22 += 4L) {
                                    long l4;
                                    long l5;
                                    for (l5 = 0L; l5 < DoubleDHT_3D.this.rowsl; ++l5) {
                                        l = l32 + l5 * (long)DoubleDHT_3D.this.rowStride + l22;
                                        l4 = DoubleDHT_3D.this.rowsl + l5;
                                        doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l));
                                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l + 1L));
                                        doubleLargeArray2.setDouble(l4 + DoubleDHT_3D.this.rowsl, doubleLargeArray.getDouble(l + 2L));
                                        doubleLargeArray2.setDouble(l4 + 2L * DoubleDHT_3D.this.rowsl, doubleLargeArray.getDouble(l + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2, 0L);
                                    DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2, DoubleDHT_3D.this.rowsl);
                                    DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2, 2L * DoubleDHT_3D.this.rowsl);
                                    DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2, 3L * DoubleDHT_3D.this.rowsl);
                                    for (l5 = 0L; l5 < DoubleDHT_3D.this.rowsl; ++l5) {
                                        l = l32 + l5 * (long)DoubleDHT_3D.this.rowStride + l22;
                                        l4 = DoubleDHT_3D.this.rowsl + l5;
                                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l5));
                                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(l4));
                                        doubleLargeArray.setDouble(l + 2L, doubleLargeArray2.getDouble(l4 + DoubleDHT_3D.this.rowsl));
                                        doubleLargeArray.setDouble(l + 3L, doubleLargeArray2.getDouble(l4 + 2L * DoubleDHT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) continue;
                            for (l22 = 0L; l22 < DoubleDHT_3D.this.rowsl; ++l22) {
                                l = l32 + l22 * (long)DoubleDHT_3D.this.rowStride;
                                doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l));
                                doubleLargeArray2.setDouble(DoubleDHT_3D.this.rowsl + l22, doubleLargeArray.getDouble(l + 1L));
                            }
                            DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2, 0L);
                            DoubleDHT_3D.this.dhtRows.forward(doubleLargeArray2, DoubleDHT_3D.this.rowsl);
                            for (l22 = 0L; l22 < DoubleDHT_3D.this.rowsl; ++l22) {
                                l = l32 + l22 * (long)DoubleDHT_3D.this.rowStride;
                                doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l22));
                                doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDHT_3D.this.rowsl + l22));
                            }
                        }
                    } else {
                        for (long i = l3; i < DoubleDHT_3D.this.slicesl; i += (long)n2) {
                            long l;
                            long l6;
                            long l7 = i * (long)DoubleDHT_3D.this.sliceStride;
                            for (l6 = 0L; l6 < DoubleDHT_3D.this.rowsl; ++l6) {
                                DoubleDHT_3D.this.dhtColumns.inverse(doubleLargeArray, l7 + l6 * (long)DoubleDHT_3D.this.rowStride, bl);
                            }
                            if (DoubleDHT_3D.this.columnsl > 2L) {
                                for (l6 = 0L; l6 < DoubleDHT_3D.this.columnsl; l6 += 4L) {
                                    long l8;
                                    long l9;
                                    for (l9 = 0L; l9 < DoubleDHT_3D.this.rowsl; ++l9) {
                                        l = l7 + l9 * (long)DoubleDHT_3D.this.rowStride + l6;
                                        l8 = DoubleDHT_3D.this.rowsl + l9;
                                        doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l));
                                        doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l + 1L));
                                        doubleLargeArray2.setDouble(l8 + DoubleDHT_3D.this.rowsl, doubleLargeArray.getDouble(l + 2L));
                                        doubleLargeArray2.setDouble(l8 + 2L * DoubleDHT_3D.this.rowsl, doubleLargeArray.getDouble(l + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, DoubleDHT_3D.this.rowsl, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, 2L * DoubleDHT_3D.this.rowsl, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, 3L * DoubleDHT_3D.this.rowsl, bl);
                                    for (l9 = 0L; l9 < DoubleDHT_3D.this.rowsl; ++l9) {
                                        l = l7 + l9 * (long)DoubleDHT_3D.this.rowStride + l6;
                                        l8 = DoubleDHT_3D.this.rowsl + l9;
                                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l9));
                                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(l8));
                                        doubleLargeArray.setDouble(l + 2L, doubleLargeArray2.getDouble(l8 + DoubleDHT_3D.this.rowsl));
                                        doubleLargeArray.setDouble(l + 3L, doubleLargeArray2.getDouble(l8 + 2L * DoubleDHT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) continue;
                            for (l6 = 0L; l6 < DoubleDHT_3D.this.rowsl; ++l6) {
                                l = l7 + l6 * (long)DoubleDHT_3D.this.rowStride;
                                doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l));
                                doubleLargeArray2.setDouble(DoubleDHT_3D.this.rowsl + l6, doubleLargeArray.getDouble(l + 1L));
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                            DoubleDHT_3D.this.dhtRows.inverse(doubleLargeArray2, DoubleDHT_3D.this.rowsl, bl);
                            for (l6 = 0L; l6 < DoubleDHT_3D.this.rowsl; ++l6) {
                                l = l7 + l6 * (long)DoubleDHT_3D.this.rowStride;
                                doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l6));
                                doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDHT_3D.this.rowsl + l6));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final double[][][] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n4];
                    if (n == -1) {
                        for (int i = n5; i < DoubleDHT_3D.this.slices; i += n2) {
                            int n6;
                            for (n6 = 0; n6 < DoubleDHT_3D.this.rows; ++n6) {
                                DoubleDHT_3D.this.dhtColumns.forward(dArray[i][n6]);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < DoubleDHT_3D.this.columns; n6 += 4) {
                                    int n22;
                                    int n3;
                                    for (n3 = 0; n3 < DoubleDHT_3D.this.rows; ++n3) {
                                        n22 = DoubleDHT_3D.this.rows + n3;
                                        dArray2[n3] = dArray[i][n3][n6];
                                        dArray2[n22] = dArray[i][n3][n6 + 1];
                                        dArray2[n22 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[i][n3][n6 + 2];
                                        dArray2[n22 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[i][n3][n6 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, 0);
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, 2 * DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(dArray2, 3 * DoubleDHT_3D.this.rows);
                                    for (n3 = 0; n3 < DoubleDHT_3D.this.rows; ++n3) {
                                        n22 = DoubleDHT_3D.this.rows + n3;
                                        dArray[i][n3][n6] = dArray2[n3];
                                        dArray[i][n3][n6 + 1] = dArray2[n22];
                                        dArray[i][n3][n6 + 2] = dArray2[n22 + DoubleDHT_3D.this.rows];
                                        dArray[i][n3][n6 + 3] = dArray2[n22 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < DoubleDHT_3D.this.rows; ++n6) {
                                dArray2[n6] = dArray[i][n6][0];
                                dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + n6] = dArray[i][n6][1];
                            }
                            DoubleDHT_3D.this.dhtRows.forward(dArray2, 0);
                            DoubleDHT_3D.this.dhtRows.forward(dArray2, DoubleDHT_3D.this.rows);
                            for (n6 = 0; n6 < DoubleDHT_3D.this.rows; ++n6) {
                                dArray[i][n6][0] = dArray2[n6];
                                dArray[i][n6][1] = dArray2[DoubleDHT_3D.this.rows + n6];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleDHT_3D.this.slices; i += n2) {
                            int n7;
                            for (n7 = 0; n7 < DoubleDHT_3D.this.rows; ++n7) {
                                DoubleDHT_3D.this.dhtColumns.inverse(dArray[i][n7], bl);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (n7 = 0; n7 < DoubleDHT_3D.this.columns; n7 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < DoubleDHT_3D.this.rows; ++n52) {
                                        n42 = DoubleDHT_3D.this.rows + n52;
                                        dArray2[n52] = dArray[i][n52][n7];
                                        dArray2[n42] = dArray[i][n52][n7 + 1];
                                        dArray2[n42 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[i][n52][n7 + 2];
                                        dArray2[n42 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = dArray[i][n52][n7 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, 0, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, DoubleDHT_3D.this.rows, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, 2 * DoubleDHT_3D.this.rows, bl);
                                    DoubleDHT_3D.this.dhtRows.inverse(dArray2, 3 * DoubleDHT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < DoubleDHT_3D.this.rows; ++n52) {
                                        n42 = DoubleDHT_3D.this.rows + n52;
                                        dArray[i][n52][n7] = dArray2[n52];
                                        dArray[i][n52][n7 + 1] = dArray2[n42];
                                        dArray[i][n52][n7 + 2] = dArray2[n42 + DoubleDHT_3D.this.rows];
                                        dArray[i][n52][n7 + 3] = dArray2[n42 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (n7 = 0; n7 < DoubleDHT_3D.this.rows; ++n7) {
                                dArray2[n7] = dArray[i][n7][0];
                                dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + n7] = dArray[i][n7][1];
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(dArray2, 0, bl);
                            DoubleDHT_3D.this.dhtRows.inverse(dArray2, DoubleDHT_3D.this.rows, bl);
                            for (n7 = 0; n7 < DoubleDHT_3D.this.rows; ++n7) {
                                dArray[i][n7][0] = dArray2[n7];
                                dArray[i][n7][1] = dArray2[DoubleDHT_3D.this.rows + n7];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] dArray2;
                        block17: {
                            block18: {
                                dArray2 = new double[n4];
                                if (n != -1) break block17;
                                if (DoubleDHT_3D.this.columns <= 2) break block18;
                                for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                    int n12 = i * DoubleDHT_3D.this.rowStride;
                                    for (int j = 0; j < DoubleDHT_3D.this.columns; j += 4) {
                                        int n22;
                                        int n3;
                                        int n42;
                                        for (n42 = 0; n42 < DoubleDHT_3D.this.slices; ++n42) {
                                            n3 = n42 * DoubleDHT_3D.this.sliceStride + n12 + j;
                                            n22 = DoubleDHT_3D.this.slices + n42;
                                            dArray2[n42] = dArray[n3];
                                            dArray2[n22] = dArray[n3 + 1];
                                            dArray2[n22 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n3 + 2];
                                            dArray2[n22 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n3 + 3];
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, 0);
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, 2 * DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, 3 * DoubleDHT_3D.this.slices);
                                        for (n42 = 0; n42 < DoubleDHT_3D.this.slices; ++n42) {
                                            n3 = n42 * DoubleDHT_3D.this.sliceStride + n12 + j;
                                            n22 = DoubleDHT_3D.this.slices + n42;
                                            dArray[n3] = dArray2[n42];
                                            dArray[n3 + 1] = dArray2[n22];
                                            dArray[n3 + 2] = dArray2[n22 + DoubleDHT_3D.this.slices];
                                            dArray[n3 + 3] = dArray2[n22 + 2 * DoubleDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columns != 2) break block19;
                            for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                int n13;
                                int n52;
                                int n6 = i * DoubleDHT_3D.this.rowStride;
                                for (n52 = 0; n52 < DoubleDHT_3D.this.slices; ++n52) {
                                    n13 = n52 * DoubleDHT_3D.this.sliceStride + n6;
                                    dArray2[n52] = dArray[n13];
                                    dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + n52] = dArray[n13 + 1];
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(dArray2, 0);
                                DoubleDHT_3D.this.dhtSlices.forward(dArray2, DoubleDHT_3D.this.slices);
                                for (n52 = 0; n52 < DoubleDHT_3D.this.slices; ++n52) {
                                    n13 = n52 * DoubleDHT_3D.this.sliceStride + n6;
                                    dArray[n13] = dArray2[n52];
                                    dArray[n13 + 1] = dArray2[DoubleDHT_3D.this.slices + n52];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columns > 2) {
                            for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                int n14 = i * DoubleDHT_3D.this.rowStride;
                                for (int j = 0; j < DoubleDHT_3D.this.columns; j += 4) {
                                    int n7;
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < DoubleDHT_3D.this.slices; ++n9) {
                                        n8 = n9 * DoubleDHT_3D.this.sliceStride + n14 + j;
                                        n7 = DoubleDHT_3D.this.slices + n9;
                                        dArray2[n9] = dArray[n8];
                                        dArray2[n7] = dArray[n8 + 1];
                                        dArray2[n7 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n8 + 2];
                                        dArray2[n7 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n8 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 0, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, DoubleDHT_3D.this.slices, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 2 * DoubleDHT_3D.this.slices, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 3 * DoubleDHT_3D.this.slices, bl);
                                    for (n9 = 0; n9 < DoubleDHT_3D.this.slices; ++n9) {
                                        n8 = n9 * DoubleDHT_3D.this.sliceStride + n14 + j;
                                        n7 = DoubleDHT_3D.this.slices + n9;
                                        dArray[n8] = dArray2[n9];
                                        dArray[n8 + 1] = dArray2[n7];
                                        dArray[n8 + 2] = dArray2[n7 + DoubleDHT_3D.this.slices];
                                        dArray[n8 + 3] = dArray2[n7 + 2 * DoubleDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columns == 2) {
                            for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                int n15;
                                int n10;
                                int n11 = i * DoubleDHT_3D.this.rowStride;
                                for (n10 = 0; n10 < DoubleDHT_3D.this.slices; ++n10) {
                                    n15 = n10 * DoubleDHT_3D.this.sliceStride + n11;
                                    dArray2[n10] = dArray[n15];
                                    dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + n10] = dArray[n15 + 1];
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 0, bl);
                                DoubleDHT_3D.this.dhtSlices.inverse(dArray2, DoubleDHT_3D.this.slices, bl);
                                for (n10 = 0; n10 < DoubleDHT_3D.this.slices; ++n10) {
                                    n15 = n10 * DoubleDHT_3D.this.sliceStride + n11;
                                    dArray[n15] = dArray2[n10];
                                    dArray[n15 + 1] = dArray2[DoubleDHT_3D.this.slices + n10];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray doubleLargeArray2;
                        block17: {
                            block18: {
                                doubleLargeArray2 = new DoubleLargeArray(l2, false);
                                if (n != -1) break block17;
                                if (DoubleDHT_3D.this.columnsl <= 2L) break block18;
                                for (long i = l3; i < DoubleDHT_3D.this.rowsl; i += (long)n2) {
                                    long l = i * DoubleDHT_3D.this.rowStridel;
                                    for (long j = 0L; j < DoubleDHT_3D.this.columnsl; j += 4L) {
                                        long l22;
                                        long l32;
                                        long l4;
                                        for (l4 = 0L; l4 < DoubleDHT_3D.this.slicesl; ++l4) {
                                            l32 = l4 * DoubleDHT_3D.this.sliceStridel + l + j;
                                            l22 = DoubleDHT_3D.this.slicesl + l4;
                                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l32));
                                            doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l32 + 1L));
                                            doubleLargeArray2.setDouble(l22 + DoubleDHT_3D.this.slicesl, doubleLargeArray.getDouble(l32 + 2L));
                                            doubleLargeArray2.setDouble(l22 + 2L * DoubleDHT_3D.this.slicesl, doubleLargeArray.getDouble(l32 + 3L));
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2, 0L);
                                        DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2, DoubleDHT_3D.this.slicesl);
                                        DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2, 2L * DoubleDHT_3D.this.slicesl);
                                        DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2, 3L * DoubleDHT_3D.this.slicesl);
                                        for (l4 = 0L; l4 < DoubleDHT_3D.this.slicesl; ++l4) {
                                            l32 = l4 * DoubleDHT_3D.this.sliceStridel + l + j;
                                            l22 = DoubleDHT_3D.this.slicesl + l4;
                                            doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l4));
                                            doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l22));
                                            doubleLargeArray.setDouble(l32 + 2L, doubleLargeArray2.getDouble(l22 + DoubleDHT_3D.this.slicesl));
                                            doubleLargeArray.setDouble(l32 + 3L, doubleLargeArray2.getDouble(l22 + 2L * DoubleDHT_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) break block19;
                            for (long i = l3; i < DoubleDHT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l5;
                                long l6 = i * DoubleDHT_3D.this.rowStridel;
                                for (l5 = 0L; l5 < DoubleDHT_3D.this.slicesl; ++l5) {
                                    l = l5 * DoubleDHT_3D.this.sliceStridel + l6;
                                    doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l));
                                    doubleLargeArray2.setDouble(DoubleDHT_3D.this.slicesl + l5, doubleLargeArray.getDouble(l + 1L));
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2, 0L);
                                DoubleDHT_3D.this.dhtSlices.forward(doubleLargeArray2, DoubleDHT_3D.this.slicesl);
                                for (l5 = 0L; l5 < DoubleDHT_3D.this.slicesl; ++l5) {
                                    l = l5 * DoubleDHT_3D.this.sliceStridel + l6;
                                    doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l5));
                                    doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDHT_3D.this.slicesl + l5));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columnsl > 2L) {
                            for (long i = l3; i < DoubleDHT_3D.this.rowsl; i += (long)n2) {
                                long l = i * DoubleDHT_3D.this.rowStridel;
                                for (long j = 0L; j < DoubleDHT_3D.this.columnsl; j += 4L) {
                                    long l7;
                                    long l8;
                                    long l9;
                                    for (l9 = 0L; l9 < DoubleDHT_3D.this.slicesl; ++l9) {
                                        l8 = l9 * DoubleDHT_3D.this.sliceStridel + l + j;
                                        l7 = DoubleDHT_3D.this.slicesl + l9;
                                        doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l8));
                                        doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l8 + 1L));
                                        doubleLargeArray2.setDouble(l7 + DoubleDHT_3D.this.slicesl, doubleLargeArray.getDouble(l8 + 2L));
                                        doubleLargeArray2.setDouble(l7 + 2L * DoubleDHT_3D.this.slicesl, doubleLargeArray.getDouble(l8 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, 0L, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, DoubleDHT_3D.this.slicesl, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, 2L * DoubleDHT_3D.this.slicesl, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, 3L * DoubleDHT_3D.this.slicesl, bl);
                                    for (l9 = 0L; l9 < DoubleDHT_3D.this.slicesl; ++l9) {
                                        l8 = l9 * DoubleDHT_3D.this.sliceStridel + l + j;
                                        l7 = DoubleDHT_3D.this.slicesl + l9;
                                        doubleLargeArray.setDouble(l8, doubleLargeArray2.getDouble(l9));
                                        doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray2.getDouble(l7));
                                        doubleLargeArray.setDouble(l8 + 2L, doubleLargeArray2.getDouble(l7 + DoubleDHT_3D.this.slicesl));
                                        doubleLargeArray.setDouble(l8 + 3L, doubleLargeArray2.getDouble(l7 + 2L * DoubleDHT_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columnsl == 2L) {
                            for (long i = l3; i < DoubleDHT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l10;
                                long l11 = i * DoubleDHT_3D.this.rowStridel;
                                for (l10 = 0L; l10 < DoubleDHT_3D.this.slicesl; ++l10) {
                                    l = l10 * DoubleDHT_3D.this.sliceStridel + l11;
                                    doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l));
                                    doubleLargeArray2.setDouble(DoubleDHT_3D.this.slicesl + l10, doubleLargeArray.getDouble(l + 1L));
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, 0L, bl);
                                DoubleDHT_3D.this.dhtSlices.inverse(doubleLargeArray2, DoubleDHT_3D.this.slicesl, bl);
                                for (l10 = 0L; l10 < DoubleDHT_3D.this.slicesl; ++l10) {
                                    l = l10 * DoubleDHT_3D.this.sliceStridel + l11;
                                    doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l10));
                                    doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDHT_3D.this.slicesl + l10));
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final double[][][] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] dArray2;
                        block17: {
                            block18: {
                                dArray2 = new double[n4];
                                if (n != -1) break block17;
                                if (DoubleDHT_3D.this.columns <= 2) break block18;
                                for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                    for (int j = 0; j < DoubleDHT_3D.this.columns; j += 4) {
                                        int n6;
                                        int n22;
                                        for (n22 = 0; n22 < DoubleDHT_3D.this.slices; ++n22) {
                                            n6 = DoubleDHT_3D.this.slices + n22;
                                            dArray2[n22] = dArray[n22][i][j];
                                            dArray2[n6] = dArray[n22][i][j + 1];
                                            dArray2[n6 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n22][i][j + 2];
                                            dArray2[n6 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n22][i][j + 3];
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, 0);
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, 2 * DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(dArray2, 3 * DoubleDHT_3D.this.slices);
                                        for (n22 = 0; n22 < DoubleDHT_3D.this.slices; ++n22) {
                                            n6 = DoubleDHT_3D.this.slices + n22;
                                            dArray[n22][i][j] = dArray2[n22];
                                            dArray[n22][i][j + 1] = dArray2[n6];
                                            dArray[n22][i][j + 2] = dArray2[n6 + DoubleDHT_3D.this.slices];
                                            dArray[n22][i][j + 3] = dArray2[n6 + 2 * DoubleDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columns != 2) break block19;
                            for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                int n7;
                                for (n7 = 0; n7 < DoubleDHT_3D.this.slices; ++n7) {
                                    dArray2[n7] = dArray[n7][i][0];
                                    dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + n7] = dArray[n7][i][1];
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(dArray2, 0);
                                DoubleDHT_3D.this.dhtSlices.forward(dArray2, DoubleDHT_3D.this.slices);
                                for (n7 = 0; n7 < DoubleDHT_3D.this.slices; ++n7) {
                                    dArray[n7][i][0] = dArray2[n7];
                                    dArray[n7][i][1] = dArray2[DoubleDHT_3D.this.slices + n7];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columns > 2) {
                            for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                for (int j = 0; j < DoubleDHT_3D.this.columns; j += 4) {
                                    int n8;
                                    int n3;
                                    for (n3 = 0; n3 < DoubleDHT_3D.this.slices; ++n3) {
                                        n8 = DoubleDHT_3D.this.slices + n3;
                                        dArray2[n3] = dArray[n3][i][j];
                                        dArray2[n8] = dArray[n3][i][j + 1];
                                        dArray2[n8 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n3][i][j + 2];
                                        dArray2[n8 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = dArray[n3][i][j + 3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 0, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, DoubleDHT_3D.this.slices, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 2 * DoubleDHT_3D.this.slices, bl);
                                    DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 3 * DoubleDHT_3D.this.slices, bl);
                                    for (n3 = 0; n3 < DoubleDHT_3D.this.slices; ++n3) {
                                        n8 = DoubleDHT_3D.this.slices + n3;
                                        dArray[n3][i][j] = dArray2[n3];
                                        dArray[n3][i][j + 1] = dArray2[n8];
                                        dArray[n3][i][j + 2] = dArray2[n8 + DoubleDHT_3D.this.slices];
                                        dArray[n3][i][j + 3] = dArray2[n8 + 2 * DoubleDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columns == 2) {
                            for (int i = n5; i < DoubleDHT_3D.this.rows; i += n2) {
                                int n9;
                                for (n9 = 0; n9 < DoubleDHT_3D.this.slices; ++n9) {
                                    dArray2[n9] = dArray[n9][i][0];
                                    dArray2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + n9] = dArray[n9][i][1];
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(dArray2, 0, bl);
                                DoubleDHT_3D.this.dhtSlices.inverse(dArray2, DoubleDHT_3D.this.slices, bl);
                                for (n9 = 0; n9 < DoubleDHT_3D.this.slices; ++n9) {
                                    dArray[n9][i][0] = dArray2[n9];
                                    dArray[n9][i][1] = dArray2[DoubleDHT_3D.this.slices + n9];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void yTransform(double[] dArray) {
        for (int i = 0; i <= this.slices / 2; ++i) {
            int n = (this.slices - i) % this.slices;
            int n2 = i * this.sliceStride;
            int n3 = n * this.sliceStride;
            for (int j = 0; j <= this.rows / 2; ++j) {
                int n4 = (this.rows - j) % this.rows;
                int n5 = j * this.rowStride;
                int n6 = n4 * this.rowStride;
                for (int k = 0; k <= this.columns / 2; ++k) {
                    int n7 = (this.columns - k) % this.columns;
                    int n8 = n2 + n6 + k;
                    int n9 = n2 + n5 + n7;
                    int n10 = n3 + n5 + k;
                    int n11 = n3 + n6 + n7;
                    int n12 = n3 + n6 + k;
                    int n13 = n3 + n5 + n7;
                    int n14 = n2 + n5 + k;
                    int n15 = n2 + n6 + n7;
                    double d = dArray[n8];
                    double d2 = dArray[n9];
                    double d3 = dArray[n10];
                    double d4 = dArray[n11];
                    double d5 = dArray[n12];
                    double d6 = dArray[n13];
                    double d7 = dArray[n14];
                    double d8 = dArray[n15];
                    dArray[n14] = (d + d2 + d3 - d4) / 2.0;
                    dArray[n10] = (d5 + d6 + d7 - d8) / 2.0;
                    dArray[n8] = (d7 + d8 + d5 - d6) / 2.0;
                    dArray[n12] = (d3 + d4 + d - d2) / 2.0;
                    dArray[n9] = (d8 + d7 + d6 - d5) / 2.0;
                    dArray[n13] = (d4 + d3 + d2 - d) / 2.0;
                    dArray[n15] = (d2 + d + d4 - d3) / 2.0;
                    dArray[n11] = (d6 + d5 + d8 - d7) / 2.0;
                }
            }
        }
    }

    private void yTransform(DoubleLargeArray doubleLargeArray) {
        for (long i = 0L; i <= this.slicesl / 2L; ++i) {
            long l = (this.slicesl - i) % this.slicesl;
            long l2 = i * this.sliceStridel;
            long l3 = l * this.sliceStridel;
            for (long j = 0L; j <= this.rowsl / 2L; ++j) {
                long l4 = (this.rowsl - j) % this.rowsl;
                long l5 = j * this.rowStridel;
                long l6 = l4 * this.rowStridel;
                for (long k = 0L; k <= this.columnsl / 2L; ++k) {
                    long l7 = (this.columnsl - k) % this.columnsl;
                    long l8 = l2 + l6 + k;
                    long l9 = l2 + l5 + l7;
                    long l10 = l3 + l5 + k;
                    long l11 = l3 + l6 + l7;
                    long l12 = l3 + l6 + k;
                    long l13 = l3 + l5 + l7;
                    long l14 = l2 + l5 + k;
                    long l15 = l2 + l6 + l7;
                    double d = doubleLargeArray.getDouble(l8);
                    double d2 = doubleLargeArray.getDouble(l9);
                    double d3 = doubleLargeArray.getDouble(l10);
                    double d4 = doubleLargeArray.getDouble(l11);
                    double d5 = doubleLargeArray.getDouble(l12);
                    double d6 = doubleLargeArray.getDouble(l13);
                    double d7 = doubleLargeArray.getDouble(l14);
                    double d8 = doubleLargeArray.getDouble(l15);
                    doubleLargeArray.setDouble(l14, (d + d2 + d3 - d4) / 2.0);
                    doubleLargeArray.setDouble(l10, (d5 + d6 + d7 - d8) / 2.0);
                    doubleLargeArray.setDouble(l8, (d7 + d8 + d5 - d6) / 2.0);
                    doubleLargeArray.setDouble(l12, (d3 + d4 + d - d2) / 2.0);
                    doubleLargeArray.setDouble(l9, (d8 + d7 + d6 - d5) / 2.0);
                    doubleLargeArray.setDouble(l13, (d4 + d3 + d2 - d) / 2.0);
                    doubleLargeArray.setDouble(l15, (d2 + d + d4 - d3) / 2.0);
                    doubleLargeArray.setDouble(l11, (d6 + d5 + d8 - d7) / 2.0);
                }
            }
        }
    }

    private void yTransform(double[][][] dArray) {
        for (int i = 0; i <= this.slices / 2; ++i) {
            int n = (this.slices - i) % this.slices;
            for (int j = 0; j <= this.rows / 2; ++j) {
                int n2 = (this.rows - j) % this.rows;
                for (int k = 0; k <= this.columns / 2; ++k) {
                    int n3 = (this.columns - k) % this.columns;
                    double d = dArray[i][n2][k];
                    double d2 = dArray[i][j][n3];
                    double d3 = dArray[n][j][k];
                    double d4 = dArray[n][n2][n3];
                    double d5 = dArray[n][n2][k];
                    double d6 = dArray[n][j][n3];
                    double d7 = dArray[i][j][k];
                    double d8 = dArray[i][n2][n3];
                    dArray[i][j][k] = (d + d2 + d3 - d4) / 2.0;
                    dArray[n][j][k] = (d5 + d6 + d7 - d8) / 2.0;
                    dArray[i][n2][k] = (d7 + d8 + d5 - d6) / 2.0;
                    dArray[n][n2][k] = (d3 + d4 + d - d2) / 2.0;
                    dArray[i][j][n3] = (d8 + d7 + d6 - d5) / 2.0;
                    dArray[n][j][n3] = (d4 + d3 + d2 - d) / 2.0;
                    dArray[i][n2][n3] = (d2 + d + d4 - d3) / 2.0;
                    dArray[n][n2][n3] = (d6 + d5 + d8 - d7) / 2.0;
                }
            }
        }
    }
}

