/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.Future;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public class FloatFFT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private FloatFFT_1D fftSlices;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_3D(long l, long l2, long l3) {
        if (l <= 1L || l2 <= 1L || l3 <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)l;
        this.rows = (int)l2;
        this.columns = (int)l3;
        this.slicesl = l;
        this.rowsl = l2;
        this.columnsl = l3;
        this.sliceStride = (int)(l2 * l3);
        this.rowStride = (int)l3;
        this.sliceStridel = l2 * l3;
        this.rowStridel = l3;
        if (l * l2 * l3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2) && ConcurrencyUtils.isPowerOf2(l3)) {
            this.isPowerOfTwo = true;
        }
        long l4 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 * l3 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(Math.min(l2, l3), l));
        }
        this.fftSlices = new FloatFFT_1D(l);
        this.fftRows = l == l2 ? this.fftSlices : new FloatFFT_1D(l2);
        this.fftColumns = l == l3 ? this.fftSlices : (l2 == l3 ? this.fftRows : new FloatFFT_1D(l3));
        ConcurrencyUtils.setLargeArraysBeginN(l4);
    }

    public void complexForward(final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
            } else {
                this.xdft3da_sub2(0, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray, n + j * FloatFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.rowStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexForward(fArray, n13 + n12 * this.rowStride);
                    }
                }
                float[] fArray2 = new float[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftRows.complexForward(fArray2);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
                fArray2 = new float[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftSlices.complexForward(fArray2);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final FloatLargeArray floatLargeArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            long l = this.columnsl;
            this.columnsl = 2L * this.columnsl;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0L, -1, floatLargeArray, true);
                this.cdft3db_subth(-1, floatLargeArray, true);
            } else {
                this.xdft3da_sub2(0L, -1, floatLargeArray, true);
                this.cdft3db_sub(-1, floatLargeArray, true);
            }
            this.columnsl = l;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        } else {
            this.sliceStridel = 2L * this.rowsl * this.columnsl;
            this.rowStridel = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.slicesl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                long l3 = i * FloatFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                    FloatFFT_3D.this.fftColumns.complexForward(floatLargeArray, l3 + j * FloatFFT_3D.this.rowStridel);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * FloatFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * FloatFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l3));
                                        floatLargeArray2.setFloat(l22 + 1L, floatLargeArray.getFloat(l3 + 1L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2);
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * FloatFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        floatLargeArray.setFloat(l3, floatLargeArray2.getFloat(l22));
                                        floatLargeArray.setFloat(l3 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * FloatFFT_3D.this.rowStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * FloatFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l3));
                                        floatLargeArray2.setFloat(l22 + 1L, floatLargeArray.getFloat(l3 + 1L));
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2);
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * FloatFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        floatLargeArray.setFloat(l3, floatLargeArray2.getFloat(l22));
                                        floatLargeArray.setFloat(l3 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                long l;
                long l4;
                long l5;
                long l6;
                long l7;
                long l8;
                long l9;
                for (long i = 0L; i < this.slicesl; ++i) {
                    long l10 = i * this.sliceStridel;
                    for (long j = 0L; j < this.rowsl; ++j) {
                        this.fftColumns.complexForward(floatLargeArray, l10 + j * this.rowStridel);
                    }
                }
                FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * this.rowsl, false);
                for (l9 = 0L; l9 < this.slicesl; ++l9) {
                    l8 = l9 * this.sliceStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l4));
                            floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l4 + 1L));
                        }
                        this.fftRows.complexForward(floatLargeArray2);
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            floatLargeArray.setFloat(l4, floatLargeArray2.getFloat(l));
                            floatLargeArray.setFloat(l4 + 1L, floatLargeArray2.getFloat(l + 1L));
                        }
                    }
                }
                floatLargeArray2 = new FloatLargeArray(2L * this.slicesl, false);
                for (l9 = 0L; l9 < this.rowsl; ++l9) {
                    l8 = l9 * this.rowStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l4));
                            floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l4 + 1L));
                        }
                        this.fftSlices.complexForward(floatLargeArray2);
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            floatLargeArray.setFloat(l4, floatLargeArray2.getFloat(l));
                            floatLargeArray.setFloat(l4 + 1L, floatLargeArray2.getFloat(l + 1L));
                        }
                    }
                }
            }
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        }
    }

    public void complexForward(final float[][][] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
            } else {
                this.xdft3da_sub2(0, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.complexForward(fArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n32];
                                    fArray2[n + 1] = fArray[i][n2][n32 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n32] = fArray2[n];
                                    fArray[i][n2][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n32];
                                    fArray2[n + 1] = fArray[n2][i][n32 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n32] = fArray2[n];
                                    fArray[n2][i][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexForward(fArray[i][n11]);
                }
            }
            float[] fArray2 = new float[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n11][n8][n9];
                        fArray2[n7 + 1] = fArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray[n11][n8][n9] = fArray2[n7];
                        fArray[n11][n8][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n8][n11][n9];
                        fArray2[n7 + 1] = fArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexForward(fArray2);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray[n8][n11][n9] = fArray2[n7];
                        fArray[n8][n11][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray, n + j * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.rowStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(fArray, n13 + n12 * this.rowStride, bl);
                    }
                }
                float[] fArray2 = new float[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftRows.complexInverse(fArray2, bl);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
                fArray2 = new float[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftSlices.complexInverse(fArray2, bl);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final FloatLargeArray floatLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            long l = this.columnsl;
            this.columnsl = 2L * this.columnsl;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0L, 1, floatLargeArray, bl);
                this.cdft3db_subth(1, floatLargeArray, bl);
            } else {
                this.xdft3da_sub2(0L, 1, floatLargeArray, bl);
                this.cdft3db_sub(1, floatLargeArray, bl);
            }
            this.columnsl = l;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        } else {
            this.sliceStridel = 2L * this.rowsl * this.columnsl;
            this.rowStridel = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.slicesl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                long l3 = i * FloatFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(floatLargeArray, l3 + j * FloatFFT_3D.this.rowStridel, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * FloatFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * FloatFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l3));
                                        floatLargeArray2.setFloat(l22 + 1L, floatLargeArray.getFloat(l3 + 1L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, bl);
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * FloatFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        floatLargeArray.setFloat(l3, floatLargeArray2.getFloat(l22));
                                        floatLargeArray.setFloat(l3 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * FloatFFT_3D.this.rowStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * FloatFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l3));
                                        floatLargeArray2.setFloat(l22 + 1L, floatLargeArray.getFloat(l3 + 1L));
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, bl);
                                    for (l4 = 0L; l4 < FloatFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * FloatFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        floatLargeArray.setFloat(l3, floatLargeArray2.getFloat(l22));
                                        floatLargeArray.setFloat(l3 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                long l;
                long l4;
                long l5;
                long l6;
                long l7;
                long l8;
                long l9;
                for (long i = 0L; i < this.slicesl; ++i) {
                    long l10 = i * this.sliceStridel;
                    for (long j = 0L; j < this.rowsl; ++j) {
                        this.fftColumns.complexInverse(floatLargeArray, l10 + j * this.rowStridel, bl);
                    }
                }
                FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * this.rowsl, false);
                for (l9 = 0L; l9 < this.slicesl; ++l9) {
                    l8 = l9 * this.sliceStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l4));
                            floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l4 + 1L));
                        }
                        this.fftRows.complexInverse(floatLargeArray2, bl);
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            floatLargeArray.setFloat(l4, floatLargeArray2.getFloat(l));
                            floatLargeArray.setFloat(l4 + 1L, floatLargeArray2.getFloat(l + 1L));
                        }
                    }
                }
                floatLargeArray2 = new FloatLargeArray(2L * this.slicesl, false);
                for (l9 = 0L; l9 < this.rowsl; ++l9) {
                    l8 = l9 * this.rowStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l4));
                            floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l4 + 1L));
                        }
                        this.fftSlices.complexInverse(floatLargeArray2, bl);
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            floatLargeArray.setFloat(l4, floatLargeArray2.getFloat(l));
                            floatLargeArray.setFloat(l4 + 1L, floatLargeArray2.getFloat(l + 1L));
                        }
                    }
                }
            }
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        }
    }

    public void complexInverse(final float[][][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.complexInverse(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n32];
                                    fArray2[n + 1] = fArray[i][n2][n32 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n32] = fArray2[n];
                                    fArray[i][n2][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n32];
                                    fArray2[n + 1] = fArray[n2][i][n32 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n32] = fArray2[n];
                                    fArray[n2][i][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexInverse(fArray[i][n11], bl);
                }
            }
            float[] fArray2 = new float[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n11][n8][n9];
                        fArray2[n7 + 1] = fArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray[n11][n8][n9] = fArray2[n7];
                        fArray[n11][n8][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n8][n11][n9];
                        fArray2[n7 + 1] = fArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray[n8][n11][n9] = fArray2[n7];
                        fArray[n8][n11][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void realForward(float[] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, fArray, true);
            this.cdft3db_subth(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        } else {
            this.xdft3da_sub1(1, -1, fArray, true);
            this.cdft3db_sub(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        }
    }

    public void realForward(FloatLargeArray floatLargeArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1L, -1, floatLargeArray, true);
            this.cdft3db_subth(-1, floatLargeArray, true);
            this.rdft3d_sub(1, floatLargeArray);
        } else {
            this.xdft3da_sub1(1L, -1, floatLargeArray, true);
            this.cdft3db_sub(-1, floatLargeArray, true);
            this.rdft3d_sub(1, floatLargeArray);
        }
    }

    public void realForward(float[][][] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, fArray, true);
            this.cdft3db_subth(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        } else {
            this.xdft3da_sub1(1, -1, fArray, true);
            this.cdft3db_sub(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        }
    }

    public void realForwardFull(float[] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realForwardFull(FloatLargeArray floatLargeArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, -1, floatLargeArray, true);
                this.cdft3db_subth(-1, floatLargeArray, true);
                this.rdft3d_sub(1, floatLargeArray);
            } else {
                this.xdft3da_sub2(1L, -1, floatLargeArray, true);
                this.cdft3db_sub(-1, floatLargeArray, true);
                this.rdft3d_sub(1, floatLargeArray);
            }
            this.fillSymmetric(floatLargeArray);
        } else {
            this.mixedRadixRealForwardFull(floatLargeArray);
        }
    }

    public void realForwardFull(float[][][] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realInverse(float[] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_subth(1, fArray, bl);
            this.xdft3da_subth1(1, 1, fArray, bl);
        } else {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_sub(1, fArray, bl);
            this.xdft3da_sub1(1, 1, fArray, bl);
        }
    }

    public void realInverse(FloatLargeArray floatLargeArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, floatLargeArray);
            this.cdft3db_subth(1, floatLargeArray, bl);
            this.xdft3da_subth1(1L, 1, floatLargeArray, bl);
        } else {
            this.rdft3d_sub(-1, floatLargeArray);
            this.cdft3db_sub(1, floatLargeArray, bl);
            this.xdft3da_sub1(1L, 1, floatLargeArray, bl);
        }
    }

    public void realInverse(float[][][] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_subth(1, fArray, bl);
            this.xdft3da_subth1(1, 1, fArray, bl);
        } else {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_sub(1, fArray, bl);
            this.xdft3da_sub1(1, 1, fArray, bl);
        }
    }

    public void realInverseFull(float[] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    public void realInverseFull(FloatLargeArray floatLargeArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, 1, floatLargeArray, bl);
                this.cdft3db_subth(1, floatLargeArray, bl);
                this.rdft3d_sub(1, floatLargeArray);
            } else {
                this.xdft3da_sub2(1L, 1, floatLargeArray, bl);
                this.cdft3db_sub(1, floatLargeArray, bl);
                this.rdft3d_sub(1, floatLargeArray);
            }
            this.fillSymmetric(floatLargeArray);
        } else {
            this.mixedRadixRealInverseFull(floatLargeArray, bl);
        }
    }

    public void realInverseFull(float[][][] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final float[][][] fArray) {
        float[] fArray2 = new float[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.realForwardFull(fArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n3];
                                    fArray2[n + 1] = fArray[i][n2][n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n3] = fArray2[n];
                                    fArray[i][n2][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n3];
                                    fArray2[n + 1] = fArray[n2][i][n3 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n3] = fArray2[n];
                                    fArray[n2][i][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    fArray[n][n22][n4 % n2] = fArray[i][j][n32];
                                    fArray[n][n22][(n4 + 1) % n2] = -fArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realForwardFull(fArray[n13][n12]);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n13][n10][n11];
                        fArray2[n9 + 1] = fArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray[n13][n10][n11] = fArray2[n9];
                        fArray[n13][n10][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n10][n13][n11];
                        fArray2[n9 + 1] = fArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexForward(fArray2);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray[n10][n13][n11] = fArray2[n9];
                        fArray[n10][n13][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        fArray[n12][n10][n15 % n2] = fArray[n13][n11][n14];
                        fArray[n12][n10][(n15 + 1) % n2] = -fArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][][] fArray, final boolean bl) {
        float[] fArray2 = new float[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.realInverseFull(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n3];
                                    fArray2[n + 1] = fArray[i][n2][n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n3] = fArray2[n];
                                    fArray[i][n2][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n3];
                                    fArray2[n + 1] = fArray[n2][i][n3 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n3] = fArray2[n];
                                    fArray[n2][i][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    fArray[n][n22][n4 % n2] = fArray[i][j][n32];
                                    fArray[n][n22][(n4 + 1) % n2] = -fArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realInverseFull(fArray[n13][n12], bl);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n13][n10][n11];
                        fArray2[n9 + 1] = fArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray[n13][n10][n11] = fArray2[n9];
                        fArray[n13][n10][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n10][n13][n11];
                        fArray2[n9 + 1] = fArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, bl);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray[n10][n13][n11] = fArray2[n9];
                        fArray[n10][n13][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        fArray[n12][n10][n15 % n2] = fArray[n13][n11][n14];
                        fArray[n12][n10][(n15 + 1) % n2] = -fArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] fArray) {
        final int n = 2 * this.columns;
        float[] fArray2 = new float[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * FloatFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = FloatFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(fArray, n3 + j * FloatFFT_3D.this.rowStride, fArray2, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(fArray2);
                                System.arraycopy(fArray2, 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final float[][][] fArray3 = new float[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * FloatFFT_3D.this.sliceStride;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray, n + j * FloatFFT_3D.this.rowStride, fArray3[i][j], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(fArray3[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray3[i][j], 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray2[n2] = fArray[n3];
                                    fArray2[n2 + 1] = fArray[n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray[n3] = fArray2[n2];
                                    fArray[n3 + 1] = fArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray2[n3] = fArray[n2];
                                    fArray2[n3 + 1] = fArray[n2 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray[n2] = fArray2[n3];
                                    fArray[n2 + 1] = fArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = FloatFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    fArray[n7 + n92 % n] = fArray[n10];
                                    fArray[n7 + (n92 + 1) % n] = -fArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(fArray, n17 + n15 * this.rowStride, fArray2, 0, this.columns);
                    this.fftColumns.realForwardFull(fArray2);
                    System.arraycopy(fArray2, 0, fArray, n16 + n15 * n5, n);
                }
            }
            fArray2 = new float[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftSlices.complexForward(fArray2);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        fArray[n20 + n22 % n] = fArray[n23];
                        fArray[n20 + (n22 + 1) % n] = -fArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final FloatLargeArray floatLargeArray) {
        final long l = 2L * this.columnsl;
        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l, false);
        long l2 = this.rowsl / 2L + 1L;
        final long l3 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long l4 = 2L * this.sliceStridel;
        final long l5 = 2L * this.rowStridel;
        long l6 = this.slicesl / 2L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && l6 >= (long)n && this.columnsl >= (long)n && l2 >= (long)n) {
            long l7;
            long l8;
            int n2;
            Future[] futureArray = new Future[n];
            long l9 = l6 / (long)n;
            for (int i = 0; i < n; ++i) {
                final long l10 = this.slicesl - 1L - (long)i * l9;
                final long l11 = i == n - 1 ? l6 + 1L : l10 - l9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l, false);
                        for (long i = l10; i >= l11; --i) {
                            long l3 = i * FloatFFT_3D.this.sliceStridel;
                            long l2 = i * l4;
                            for (long j = FloatFFT_3D.this.rowsl - 1L; j >= 0L; --j) {
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray, (long)(l3 + j * FloatFFT_3D.this.rowStridel), (FloatLargeArray)floatLargeArray2, (long)0L, (long)FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realForwardFull(floatLargeArray2);
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray2, (long)0L, (FloatLargeArray)floatLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final FloatLargeArray floatLargeArray3 = new FloatLargeArray((l6 + 1L) * this.rowsl * l, false);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * FloatFFT_3D.this.sliceStridel;
                            for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray, (long)(l2 + j * FloatFFT_3D.this.rowStridel), (FloatLargeArray)floatLargeArray3, (long)(i * FloatFFT_3D.this.rowsl * l + j * l), (long)FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realForwardFull(floatLargeArray3, i * FloatFFT_3D.this.rowsl * l + j * l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * l4;
                            for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray3, (long)(i * FloatFFT_3D.this.rowsl * l + j * l), (FloatLargeArray)floatLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l4;
                            for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l3));
                                    floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l3 + 1L));
                                }
                                FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2);
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    floatLargeArray.setFloat(l3, floatLargeArray2.getFloat(l2));
                                    floatLargeArray.setFloat(l3 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = l2 / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l2 : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l5;
                            for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < FloatFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l2));
                                    floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l2 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2);
                                for (l42 = 0L; l42 < FloatFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    floatLargeArray.setFloat(l2, floatLargeArray2.getFloat(l3));
                                    floatLargeArray.setFloat(l2 + 1L, floatLargeArray2.getFloat(l3 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l11 = (FloatFFT_3D.this.slicesl - i) % FloatFFT_3D.this.slicesl;
                            long l2 = l11 * l4;
                            long l32 = i * l4;
                            for (long j = 1L; j < l3; ++j) {
                                long l42 = FloatFFT_3D.this.rowsl - j;
                                long l52 = l42 * l5;
                                long l6 = j * l5;
                                long l72 = l2 + l52;
                                for (long k = 0L; k < FloatFFT_3D.this.columnsl; ++k) {
                                    long l82 = 2L * k;
                                    long l9 = l - l82;
                                    long l10 = l32 + l6 + l82;
                                    floatLargeArray.setFloat(l72 + l9 % l, floatLargeArray.getFloat(l10));
                                    floatLargeArray.setFloat(l72 + (l9 + 1L) % l, -floatLargeArray.getFloat(l10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l12;
            long l13;
            long l14;
            long l15;
            long l16;
            long l17;
            long l18;
            for (l18 = this.slicesl - 1L; l18 >= 0L; --l18) {
                l17 = l18 * this.sliceStridel;
                l16 = l18 * l4;
                for (l15 = this.rowsl - 1L; l15 >= 0L; --l15) {
                    Utilities.arraycopy((FloatLargeArray)floatLargeArray, (long)(l17 + l15 * this.rowStridel), (FloatLargeArray)floatLargeArray2, (long)0L, (long)this.columnsl);
                    this.fftColumns.realForwardFull(floatLargeArray2);
                    Utilities.arraycopy((FloatLargeArray)floatLargeArray2, (long)0L, (FloatLargeArray)floatLargeArray, (long)(l16 + l15 * l5), (long)l);
                }
            }
            floatLargeArray2 = new FloatLargeArray(2L * this.rowsl, false);
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = l18 * l4;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        floatLargeArray2.setFloat(l13, floatLargeArray.getFloat(l12));
                        floatLargeArray2.setFloat(l13 + 1L, floatLargeArray.getFloat(l12 + 1L));
                    }
                    this.fftRows.complexForward(floatLargeArray2);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        floatLargeArray.setFloat(l12, floatLargeArray2.getFloat(l13));
                        floatLargeArray.setFloat(l12 + 1L, floatLargeArray2.getFloat(l13 + 1L));
                    }
                }
            }
            floatLargeArray2 = new FloatLargeArray(2L * this.slicesl, false);
            for (l18 = 0L; l18 < l2; ++l18) {
                l17 = l18 * l5;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        floatLargeArray2.setFloat(l13, floatLargeArray.getFloat(l12));
                        floatLargeArray2.setFloat(l13 + 1L, floatLargeArray.getFloat(l12 + 1L));
                    }
                    this.fftSlices.complexForward(floatLargeArray2);
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        floatLargeArray.setFloat(l12, floatLargeArray2.getFloat(l13));
                        floatLargeArray.setFloat(l12 + 1L, floatLargeArray2.getFloat(l13 + 1L));
                    }
                }
            }
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = (this.slicesl - l18) % this.slicesl;
                l16 = l17 * l4;
                l15 = l18 * l4;
                for (l14 = 1L; l14 < l3; ++l14) {
                    l13 = this.rowsl - l14;
                    l12 = l13 * l5;
                    long l19 = l14 * l5;
                    long l20 = l16 + l12;
                    for (long i = 0L; i < this.columnsl; ++i) {
                        long l21 = 2L * i;
                        long l22 = l - l21;
                        long l23 = l15 + l19 + l21;
                        floatLargeArray.setFloat(l20 + l22 % l, floatLargeArray.getFloat(l23));
                        floatLargeArray.setFloat(l20 + (l22 + 1L) % l, -floatLargeArray.getFloat(l23 + 1L));
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] fArray, final boolean bl) {
        final int n = 2 * this.columns;
        float[] fArray2 = new float[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * FloatFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = FloatFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(fArray, n3 + j * FloatFFT_3D.this.rowStride, fArray2, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(fArray2, bl);
                                System.arraycopy(fArray2, 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final float[][][] fArray3 = new float[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * FloatFFT_3D.this.sliceStride;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray, n + j * FloatFFT_3D.this.rowStride, fArray3[i][j], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(fArray3[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray3[i][j], 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray2[n2] = fArray[n3];
                                    fArray2[n2 + 1] = fArray[n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray[n3] = fArray2[n2];
                                    fArray[n3 + 1] = fArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray2[n3] = fArray[n2];
                                    fArray2[n3 + 1] = fArray[n2 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray[n2] = fArray2[n3];
                                    fArray[n2 + 1] = fArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = FloatFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    fArray[n7 + n92 % n] = fArray[n10];
                                    fArray[n7 + (n92 + 1) % n] = -fArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(fArray, n17 + n15 * this.rowStride, fArray2, 0, this.columns);
                    this.fftColumns.realInverseFull(fArray2, bl);
                    System.arraycopy(fArray2, 0, fArray, n16 + n15 * n5, n);
                }
            }
            fArray2 = new float[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, bl);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        fArray[n20 + n22 % n] = fArray[n23];
                        fArray[n20 + (n22 + 1) % n] = -fArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final FloatLargeArray floatLargeArray, final boolean bl) {
        final long l = 2L * this.columnsl;
        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l, false);
        long l2 = this.rowsl / 2L + 1L;
        final long l3 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long l4 = 2L * this.sliceStridel;
        final long l5 = 2L * this.rowStridel;
        long l6 = this.slicesl / 2L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && l6 >= (long)n && this.columnsl >= (long)n && l2 >= (long)n) {
            long l7;
            long l8;
            int n2;
            Future[] futureArray = new Future[n];
            long l9 = l6 / (long)n;
            for (int i = 0; i < n; ++i) {
                final long l10 = this.slicesl - 1L - (long)i * l9;
                final long l11 = i == n - 1 ? l6 + 1L : l10 - l9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l, false);
                        for (long i = l10; i >= l11; --i) {
                            long l3 = i * FloatFFT_3D.this.sliceStridel;
                            long l2 = i * l4;
                            for (long j = FloatFFT_3D.this.rowsl - 1L; j >= 0L; --j) {
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray, (long)(l3 + j * FloatFFT_3D.this.rowStridel), (FloatLargeArray)floatLargeArray2, (long)0L, (long)FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realInverseFull(floatLargeArray2, bl);
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray2, (long)0L, (FloatLargeArray)floatLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final FloatLargeArray floatLargeArray3 = new FloatLargeArray((l6 + 1L) * this.rowsl * l, false);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * FloatFFT_3D.this.sliceStridel;
                            for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray, (long)(l2 + j * FloatFFT_3D.this.rowStridel), (FloatLargeArray)floatLargeArray3, (long)(i * FloatFFT_3D.this.rowsl * l + j * l), (long)FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realInverseFull(floatLargeArray3, i * FloatFFT_3D.this.rowsl * l + j * l, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * l4;
                            for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((FloatLargeArray)floatLargeArray3, (long)(i * FloatFFT_3D.this.rowsl * l + j * l), (FloatLargeArray)floatLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l4;
                            for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l3));
                                    floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l3 + 1L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, bl);
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    floatLargeArray.setFloat(l3, floatLargeArray2.getFloat(l2));
                                    floatLargeArray.setFloat(l3 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = l2 / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l2 : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l5;
                            for (long j = 0L; j < FloatFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < FloatFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l2));
                                    floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l2 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, bl);
                                for (l42 = 0L; l42 < FloatFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    floatLargeArray.setFloat(l2, floatLargeArray2.getFloat(l3));
                                    floatLargeArray.setFloat(l2 + 1L, floatLargeArray2.getFloat(l3 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l11 = (FloatFFT_3D.this.slicesl - i) % FloatFFT_3D.this.slicesl;
                            long l2 = l11 * l4;
                            long l32 = i * l4;
                            for (long j = 1L; j < l3; ++j) {
                                long l42 = FloatFFT_3D.this.rowsl - j;
                                long l52 = l42 * l5;
                                long l6 = j * l5;
                                long l72 = l2 + l52;
                                for (long k = 0L; k < FloatFFT_3D.this.columnsl; ++k) {
                                    long l82 = 2L * k;
                                    long l9 = l - l82;
                                    long l10 = l32 + l6 + l82;
                                    floatLargeArray.setFloat(l72 + l9 % l, floatLargeArray.getFloat(l10));
                                    floatLargeArray.setFloat(l72 + (l9 + 1L) % l, -floatLargeArray.getFloat(l10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l12;
            long l13;
            long l14;
            long l15;
            long l16;
            long l17;
            long l18;
            for (l18 = this.slicesl - 1L; l18 >= 0L; --l18) {
                l17 = l18 * this.sliceStridel;
                l16 = l18 * l4;
                for (l15 = this.rowsl - 1L; l15 >= 0L; --l15) {
                    Utilities.arraycopy((FloatLargeArray)floatLargeArray, (long)(l17 + l15 * this.rowStridel), (FloatLargeArray)floatLargeArray2, (long)0L, (long)this.columnsl);
                    this.fftColumns.realInverseFull(floatLargeArray2, bl);
                    Utilities.arraycopy((FloatLargeArray)floatLargeArray2, (long)0L, (FloatLargeArray)floatLargeArray, (long)(l16 + l15 * l5), (long)l);
                }
            }
            floatLargeArray2 = new FloatLargeArray(2L * this.rowsl, false);
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = l18 * l4;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        floatLargeArray2.setFloat(l13, floatLargeArray.getFloat(l12));
                        floatLargeArray2.setFloat(l13 + 1L, floatLargeArray.getFloat(l12 + 1L));
                    }
                    this.fftRows.complexInverse(floatLargeArray2, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        floatLargeArray.setFloat(l12, floatLargeArray2.getFloat(l13));
                        floatLargeArray.setFloat(l12 + 1L, floatLargeArray2.getFloat(l13 + 1L));
                    }
                }
            }
            floatLargeArray2 = new FloatLargeArray(2L * this.slicesl, false);
            for (l18 = 0L; l18 < l2; ++l18) {
                l17 = l18 * l5;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        floatLargeArray2.setFloat(l13, floatLargeArray.getFloat(l12));
                        floatLargeArray2.setFloat(l13 + 1L, floatLargeArray.getFloat(l12 + 1L));
                    }
                    this.fftSlices.complexInverse(floatLargeArray2, bl);
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        floatLargeArray.setFloat(l12, floatLargeArray2.getFloat(l13));
                        floatLargeArray.setFloat(l12 + 1L, floatLargeArray2.getFloat(l13 + 1L));
                    }
                }
            }
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = (this.slicesl - l18) % this.slicesl;
                l16 = l17 * l4;
                l15 = l18 * l4;
                for (l14 = 1L; l14 < l3; ++l14) {
                    l13 = this.rowsl - l14;
                    l12 = l13 * l5;
                    long l19 = l14 * l5;
                    long l20 = l16 + l12;
                    for (long i = 0L; i < this.columnsl; ++i) {
                        long l21 = 2L * i;
                        long l22 = l - l21;
                        long l23 = l15 + l19 + l21;
                        floatLargeArray.setFloat(l20 + l22 % l, floatLargeArray.getFloat(l23));
                        floatLargeArray.setFloat(l20 + (l22 + 1L) % l, -floatLargeArray.getFloat(l23 + 1L));
                    }
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, float[] fArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        float[] fArray2 = new float[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = i * this.sliceStride;
                if (n == 0) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.complexForward(fArray, n8 + n7 * this.rowStride);
                    }
                } else {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.realForward(fArray, n8 + n7 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n7 = 0; n7 < this.columns; n7 += 8) {
                        int n9;
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            fArray2[n5] = fArray[n6];
                            fArray2[n5 + 1] = fArray[n6 + 1];
                            fArray2[n4] = fArray[n6 + 2];
                            fArray2[n4 + 1] = fArray[n6 + 3];
                            fArray2[n10] = fArray[n6 + 4];
                            fArray2[n10 + 1] = fArray[n6 + 5];
                            fArray2[n9] = fArray[n6 + 6];
                            fArray2[n9 + 1] = fArray[n6 + 7];
                        }
                        this.fftRows.complexForward(fArray2, 0);
                        this.fftRows.complexForward(fArray2, 2 * this.rows);
                        this.fftRows.complexForward(fArray2, 4 * this.rows);
                        this.fftRows.complexForward(fArray2, 6 * this.rows);
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            fArray[n6] = fArray2[n5];
                            fArray[n6 + 1] = fArray2[n5 + 1];
                            fArray[n6 + 2] = fArray2[n4];
                            fArray[n6 + 3] = fArray2[n4 + 1];
                            fArray[n6 + 4] = fArray2[n10];
                            fArray[n6 + 5] = fArray2[n10 + 1];
                            fArray[n6 + 6] = fArray2[n9];
                            fArray[n6 + 7] = fArray2[n9 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        fArray2[n5] = fArray[n6];
                        fArray2[n5 + 1] = fArray[n6 + 1];
                        fArray2[n4] = fArray[n6 + 2];
                        fArray2[n4 + 1] = fArray[n6 + 3];
                    }
                    this.fftRows.complexForward(fArray2, 0);
                    this.fftRows.complexForward(fArray2, 2 * this.rows);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        fArray[n6] = fArray2[n5];
                        fArray[n6 + 1] = fArray2[n5 + 1];
                        fArray[n6 + 2] = fArray2[n4];
                        fArray[n6 + 3] = fArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    fArray2[n5] = fArray[n6];
                    fArray2[n5 + 1] = fArray[n6 + 1];
                }
                this.fftRows.complexForward(fArray2, 0);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    fArray[n6] = fArray2[n5];
                    fArray[n6 + 1] = fArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = i * this.sliceStride;
                if (n == 0) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        this.fftColumns.complexInverse(fArray, n16 + n15 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n15 = 0; n15 < this.columns; n15 += 8) {
                        int n17;
                        int n18;
                        int n19;
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            fArray2[n13] = fArray[n14];
                            fArray2[n13 + 1] = fArray[n14 + 1];
                            fArray2[n12] = fArray[n14 + 2];
                            fArray2[n12 + 1] = fArray[n14 + 3];
                            fArray2[n18] = fArray[n14 + 4];
                            fArray2[n18 + 1] = fArray[n14 + 5];
                            fArray2[n17] = fArray[n14 + 6];
                            fArray2[n17 + 1] = fArray[n14 + 7];
                        }
                        this.fftRows.complexInverse(fArray2, 0, bl);
                        this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 6 * this.rows, bl);
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            fArray[n14] = fArray2[n13];
                            fArray[n14 + 1] = fArray2[n13 + 1];
                            fArray[n14 + 2] = fArray2[n12];
                            fArray[n14 + 3] = fArray2[n12 + 1];
                            fArray[n14 + 4] = fArray2[n18];
                            fArray[n14 + 5] = fArray2[n18 + 1];
                            fArray[n14 + 6] = fArray2[n17];
                            fArray[n14 + 7] = fArray2[n17 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        fArray2[n13] = fArray[n14];
                        fArray2[n13 + 1] = fArray[n14 + 1];
                        fArray2[n12] = fArray[n14 + 2];
                        fArray2[n12 + 1] = fArray[n14 + 3];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        fArray[n14] = fArray2[n13];
                        fArray[n14 + 1] = fArray2[n13 + 1];
                        fArray[n14 + 2] = fArray2[n12];
                        fArray[n14 + 3] = fArray2[n12 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        fArray2[n13] = fArray[n14];
                        fArray2[n13 + 1] = fArray[n14 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        fArray[n14] = fArray2[n13];
                        fArray[n14 + 1] = fArray2[n13 + 1];
                    }
                }
                if (n == 0) continue;
                for (n15 = 0; n15 < this.rows; ++n15) {
                    this.fftColumns.realInverse(fArray, n16 + n15 * this.rowStride, bl);
                }
            }
        }
    }

    private void xdft3da_sub1(long l, int n, FloatLargeArray floatLargeArray, boolean bl) {
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l2, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l3;
                long l4;
                long l5;
                long l6;
                long l7 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.complexForward(floatLargeArray, l7 + l6 * this.rowStridel);
                    }
                } else {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.realForward(floatLargeArray, l7 + l6 * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l6 = 0L; l6 < this.columnsl; l6 += 8L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5));
                            floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l5 + 1L));
                            floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l5 + 2L));
                            floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l5 + 3L));
                            floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l5 + 4L));
                            floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l5 + 5L));
                            floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l5 + 6L));
                            floatLargeArray2.setFloat(l8 + 1L, floatLargeArray.getFloat(l5 + 7L));
                        }
                        this.fftRows.complexForward(floatLargeArray2, 0L);
                        this.fftRows.complexForward(floatLargeArray2, 2L * this.rowsl);
                        this.fftRows.complexForward(floatLargeArray2, 4L * this.rowsl);
                        this.fftRows.complexForward(floatLargeArray2, 6L * this.rowsl);
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l4));
                            floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4 + 1L));
                            floatLargeArray.setFloat(l5 + 2L, floatLargeArray2.getFloat(l3));
                            floatLargeArray.setFloat(l5 + 3L, floatLargeArray2.getFloat(l3 + 1L));
                            floatLargeArray.setFloat(l5 + 4L, floatLargeArray2.getFloat(l9));
                            floatLargeArray.setFloat(l5 + 5L, floatLargeArray2.getFloat(l9 + 1L));
                            floatLargeArray.setFloat(l5 + 6L, floatLargeArray2.getFloat(l8));
                            floatLargeArray.setFloat(l5 + 7L, floatLargeArray2.getFloat(l8 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5));
                        floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l5 + 1L));
                        floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l5 + 2L));
                        floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l5 + 3L));
                    }
                    this.fftRows.complexForward(floatLargeArray2, 0L);
                    this.fftRows.complexForward(floatLargeArray2, 2L * this.rowsl);
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l4));
                        floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4 + 1L));
                        floatLargeArray.setFloat(l5 + 2L, floatLargeArray2.getFloat(l3));
                        floatLargeArray.setFloat(l5 + 3L, floatLargeArray2.getFloat(l3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5));
                    floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l5 + 1L));
                }
                this.fftRows.complexForward(floatLargeArray2, 0L);
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l4));
                    floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4 + 1L));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l11;
                long l12;
                long l13;
                long l14;
                long l15 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        this.fftColumns.complexInverse(floatLargeArray, l15 + l14 * this.rowStridel, bl);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l14 = 0L; l14 < this.columnsl; l14 += 8L) {
                        long l16;
                        long l17;
                        long l18;
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            floatLargeArray2.setFloat(l12, floatLargeArray.getFloat(l13));
                            floatLargeArray2.setFloat(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                            floatLargeArray2.setFloat(l11, floatLargeArray.getFloat(l13 + 2L));
                            floatLargeArray2.setFloat(l11 + 1L, floatLargeArray.getFloat(l13 + 3L));
                            floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l13 + 4L));
                            floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l13 + 5L));
                            floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l13 + 6L));
                            floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l13 + 7L));
                        }
                        this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                        this.fftRows.complexInverse(floatLargeArray2, 2L * this.rowsl, bl);
                        this.fftRows.complexInverse(floatLargeArray2, 4L * this.rowsl, bl);
                        this.fftRows.complexInverse(floatLargeArray2, 6L * this.rowsl, bl);
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l12));
                            floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                            floatLargeArray.setFloat(l13 + 2L, floatLargeArray2.getFloat(l11));
                            floatLargeArray.setFloat(l13 + 3L, floatLargeArray2.getFloat(l11 + 1L));
                            floatLargeArray.setFloat(l13 + 4L, floatLargeArray2.getFloat(l17));
                            floatLargeArray.setFloat(l13 + 5L, floatLargeArray2.getFloat(l17 + 1L));
                            floatLargeArray.setFloat(l13 + 6L, floatLargeArray2.getFloat(l16));
                            floatLargeArray.setFloat(l13 + 7L, floatLargeArray2.getFloat(l16 + 1L));
                        }
                    }
                } else if (this.columnsl == 4L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        floatLargeArray2.setFloat(l12, floatLargeArray.getFloat(l13));
                        floatLargeArray2.setFloat(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                        floatLargeArray2.setFloat(l11, floatLargeArray.getFloat(l13 + 2L));
                        floatLargeArray2.setFloat(l11 + 1L, floatLargeArray.getFloat(l13 + 3L));
                    }
                    this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                    this.fftRows.complexInverse(floatLargeArray2, 2L * this.rowsl, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l12));
                        floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                        floatLargeArray.setFloat(l13 + 2L, floatLargeArray2.getFloat(l11));
                        floatLargeArray.setFloat(l13 + 3L, floatLargeArray2.getFloat(l11 + 1L));
                    }
                } else if (this.columnsl == 2L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        floatLargeArray2.setFloat(l12, floatLargeArray.getFloat(l13));
                        floatLargeArray2.setFloat(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                    }
                    this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l12));
                        floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                    }
                }
                if (l == 0L) continue;
                for (l14 = 0L; l14 < this.rowsl; ++l14) {
                    this.fftColumns.realInverse(floatLargeArray, l15 + l14 * this.rowStridel, bl);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, float[] fArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        float[] fArray2 = new float[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = i * this.sliceStride;
                if (n == 0) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.complexForward(fArray, n8 + n7 * this.rowStride);
                    }
                } else {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.realForward(fArray, n8 + n7 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n7 = 0; n7 < this.columns; n7 += 8) {
                        int n9;
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            fArray2[n5] = fArray[n6];
                            fArray2[n5 + 1] = fArray[n6 + 1];
                            fArray2[n4] = fArray[n6 + 2];
                            fArray2[n4 + 1] = fArray[n6 + 3];
                            fArray2[n10] = fArray[n6 + 4];
                            fArray2[n10 + 1] = fArray[n6 + 5];
                            fArray2[n9] = fArray[n6 + 6];
                            fArray2[n9 + 1] = fArray[n6 + 7];
                        }
                        this.fftRows.complexForward(fArray2, 0);
                        this.fftRows.complexForward(fArray2, 2 * this.rows);
                        this.fftRows.complexForward(fArray2, 4 * this.rows);
                        this.fftRows.complexForward(fArray2, 6 * this.rows);
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            fArray[n6] = fArray2[n5];
                            fArray[n6 + 1] = fArray2[n5 + 1];
                            fArray[n6 + 2] = fArray2[n4];
                            fArray[n6 + 3] = fArray2[n4 + 1];
                            fArray[n6 + 4] = fArray2[n10];
                            fArray[n6 + 5] = fArray2[n10 + 1];
                            fArray[n6 + 6] = fArray2[n9];
                            fArray[n6 + 7] = fArray2[n9 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        fArray2[n5] = fArray[n6];
                        fArray2[n5 + 1] = fArray[n6 + 1];
                        fArray2[n4] = fArray[n6 + 2];
                        fArray2[n4 + 1] = fArray[n6 + 3];
                    }
                    this.fftRows.complexForward(fArray2, 0);
                    this.fftRows.complexForward(fArray2, 2 * this.rows);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        fArray[n6] = fArray2[n5];
                        fArray[n6 + 1] = fArray2[n5 + 1];
                        fArray[n6 + 2] = fArray2[n4];
                        fArray[n6 + 3] = fArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    fArray2[n5] = fArray[n6];
                    fArray2[n5 + 1] = fArray[n6 + 1];
                }
                this.fftRows.complexForward(fArray2, 0);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    fArray[n6] = fArray2[n5];
                    fArray[n6 + 1] = fArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = i * this.sliceStride;
                if (n == 0) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        this.fftColumns.complexInverse(fArray, n16 + n15 * this.rowStride, bl);
                    }
                } else {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        this.fftColumns.realInverse2(fArray, n16 + n15 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n15 = 0; n15 < this.columns; n15 += 8) {
                        int n17;
                        int n18;
                        int n19;
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            fArray2[n13] = fArray[n14];
                            fArray2[n13 + 1] = fArray[n14 + 1];
                            fArray2[n12] = fArray[n14 + 2];
                            fArray2[n12 + 1] = fArray[n14 + 3];
                            fArray2[n18] = fArray[n14 + 4];
                            fArray2[n18 + 1] = fArray[n14 + 5];
                            fArray2[n17] = fArray[n14 + 6];
                            fArray2[n17 + 1] = fArray[n14 + 7];
                        }
                        this.fftRows.complexInverse(fArray2, 0, bl);
                        this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 6 * this.rows, bl);
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            fArray[n14] = fArray2[n13];
                            fArray[n14 + 1] = fArray2[n13 + 1];
                            fArray[n14 + 2] = fArray2[n12];
                            fArray[n14 + 3] = fArray2[n12 + 1];
                            fArray[n14 + 4] = fArray2[n18];
                            fArray[n14 + 5] = fArray2[n18 + 1];
                            fArray[n14 + 6] = fArray2[n17];
                            fArray[n14 + 7] = fArray2[n17 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        fArray2[n13] = fArray[n14];
                        fArray2[n13 + 1] = fArray[n14 + 1];
                        fArray2[n12] = fArray[n14 + 2];
                        fArray2[n12 + 1] = fArray[n14 + 3];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        fArray[n14] = fArray2[n13];
                        fArray[n14 + 1] = fArray2[n13 + 1];
                        fArray[n14 + 2] = fArray2[n12];
                        fArray[n14 + 3] = fArray2[n12 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n15 = 0; n15 < this.rows; ++n15) {
                    n14 = n16 + n15 * this.rowStride;
                    n13 = 2 * n15;
                    fArray2[n13] = fArray[n14];
                    fArray2[n13 + 1] = fArray[n14 + 1];
                }
                this.fftRows.complexInverse(fArray2, 0, bl);
                for (n15 = 0; n15 < this.rows; ++n15) {
                    n14 = n16 + n15 * this.rowStride;
                    n13 = 2 * n15;
                    fArray[n14] = fArray2[n13];
                    fArray[n14 + 1] = fArray2[n13 + 1];
                }
            }
        }
    }

    private void xdft3da_sub2(long l, int n, FloatLargeArray floatLargeArray, boolean bl) {
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l2, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l3;
                long l4;
                long l5;
                long l6;
                long l7 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.complexForward(floatLargeArray, l7 + l6 * this.rowStridel);
                    }
                } else {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.realForward(floatLargeArray, l7 + l6 * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l6 = 0L; l6 < this.columnsl; l6 += 8L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5));
                            floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l5 + 1L));
                            floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l5 + 2L));
                            floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l5 + 3L));
                            floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l5 + 4L));
                            floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l5 + 5L));
                            floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l5 + 6L));
                            floatLargeArray2.setFloat(l8 + 1L, floatLargeArray.getFloat(l5 + 7L));
                        }
                        this.fftRows.complexForward(floatLargeArray2, 0L);
                        this.fftRows.complexForward(floatLargeArray2, 2L * this.rowsl);
                        this.fftRows.complexForward(floatLargeArray2, 4L * this.rowsl);
                        this.fftRows.complexForward(floatLargeArray2, 6L * this.rowsl);
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l4));
                            floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4 + 1L));
                            floatLargeArray.setFloat(l5 + 2L, floatLargeArray2.getFloat(l3));
                            floatLargeArray.setFloat(l5 + 3L, floatLargeArray2.getFloat(l3 + 1L));
                            floatLargeArray.setFloat(l5 + 4L, floatLargeArray2.getFloat(l9));
                            floatLargeArray.setFloat(l5 + 5L, floatLargeArray2.getFloat(l9 + 1L));
                            floatLargeArray.setFloat(l5 + 6L, floatLargeArray2.getFloat(l8));
                            floatLargeArray.setFloat(l5 + 7L, floatLargeArray2.getFloat(l8 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5));
                        floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l5 + 1L));
                        floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l5 + 2L));
                        floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l5 + 3L));
                    }
                    this.fftRows.complexForward(floatLargeArray2, 0L);
                    this.fftRows.complexForward(floatLargeArray2, 2L * this.rowsl);
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l4));
                        floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4 + 1L));
                        floatLargeArray.setFloat(l5 + 2L, floatLargeArray2.getFloat(l3));
                        floatLargeArray.setFloat(l5 + 3L, floatLargeArray2.getFloat(l3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5));
                    floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l5 + 1L));
                }
                this.fftRows.complexForward(floatLargeArray2, 0L);
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l4));
                    floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4 + 1L));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l11;
                long l12;
                long l13;
                long l14;
                long l15 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        this.fftColumns.complexInverse(floatLargeArray, l15 + l14 * this.rowStridel, bl);
                    }
                } else {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        this.fftColumns.realInverse2(floatLargeArray, l15 + l14 * this.rowStridel, bl);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l14 = 0L; l14 < this.columnsl; l14 += 8L) {
                        long l16;
                        long l17;
                        long l18;
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            floatLargeArray2.setFloat(l12, floatLargeArray.getFloat(l13));
                            floatLargeArray2.setFloat(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                            floatLargeArray2.setFloat(l11, floatLargeArray.getFloat(l13 + 2L));
                            floatLargeArray2.setFloat(l11 + 1L, floatLargeArray.getFloat(l13 + 3L));
                            floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l13 + 4L));
                            floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l13 + 5L));
                            floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l13 + 6L));
                            floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l13 + 7L));
                        }
                        this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                        this.fftRows.complexInverse(floatLargeArray2, 2L * this.rowsl, bl);
                        this.fftRows.complexInverse(floatLargeArray2, 4L * this.rowsl, bl);
                        this.fftRows.complexInverse(floatLargeArray2, 6L * this.rowsl, bl);
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l12));
                            floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                            floatLargeArray.setFloat(l13 + 2L, floatLargeArray2.getFloat(l11));
                            floatLargeArray.setFloat(l13 + 3L, floatLargeArray2.getFloat(l11 + 1L));
                            floatLargeArray.setFloat(l13 + 4L, floatLargeArray2.getFloat(l17));
                            floatLargeArray.setFloat(l13 + 5L, floatLargeArray2.getFloat(l17 + 1L));
                            floatLargeArray.setFloat(l13 + 6L, floatLargeArray2.getFloat(l16));
                            floatLargeArray.setFloat(l13 + 7L, floatLargeArray2.getFloat(l16 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        floatLargeArray2.setFloat(l12, floatLargeArray.getFloat(l13));
                        floatLargeArray2.setFloat(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                        floatLargeArray2.setFloat(l11, floatLargeArray.getFloat(l13 + 2L));
                        floatLargeArray2.setFloat(l11 + 1L, floatLargeArray.getFloat(l13 + 3L));
                    }
                    this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                    this.fftRows.complexInverse(floatLargeArray2, 2L * this.rowsl, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l12));
                        floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                        floatLargeArray.setFloat(l13 + 2L, floatLargeArray2.getFloat(l11));
                        floatLargeArray.setFloat(l13 + 3L, floatLargeArray2.getFloat(l11 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l14 = 0L; l14 < this.rowsl; ++l14) {
                    l13 = l15 + l14 * this.rowStridel;
                    l12 = 2L * l14;
                    floatLargeArray2.setFloat(l12, floatLargeArray.getFloat(l13));
                    floatLargeArray2.setFloat(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                }
                this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                for (l14 = 0L; l14 < this.rowsl; ++l14) {
                    l13 = l15 + l14 * this.rowStridel;
                    l12 = 2L * l14;
                    floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l12));
                    floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, float[][][] fArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        float[] fArray2 = new float[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(fArray[i][n6]);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(fArray[i][n6], 0);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            fArray2[n5] = fArray[i][n9][n6];
                            fArray2[n5 + 1] = fArray[i][n9][n6 + 1];
                            fArray2[n4] = fArray[i][n9][n6 + 2];
                            fArray2[n4 + 1] = fArray[i][n9][n6 + 3];
                            fArray2[n8] = fArray[i][n9][n6 + 4];
                            fArray2[n8 + 1] = fArray[i][n9][n6 + 5];
                            fArray2[n7] = fArray[i][n9][n6 + 6];
                            fArray2[n7 + 1] = fArray[i][n9][n6 + 7];
                        }
                        this.fftRows.complexForward(fArray2, 0);
                        this.fftRows.complexForward(fArray2, 2 * this.rows);
                        this.fftRows.complexForward(fArray2, 4 * this.rows);
                        this.fftRows.complexForward(fArray2, 6 * this.rows);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            fArray[i][n9][n6] = fArray2[n5];
                            fArray[i][n9][n6 + 1] = fArray2[n5 + 1];
                            fArray[i][n9][n6 + 2] = fArray2[n4];
                            fArray[i][n9][n6 + 3] = fArray2[n4 + 1];
                            fArray[i][n9][n6 + 4] = fArray2[n8];
                            fArray[i][n9][n6 + 5] = fArray2[n8 + 1];
                            fArray[i][n9][n6 + 6] = fArray2[n7];
                            fArray[i][n9][n6 + 7] = fArray2[n7 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray2[n5] = fArray[i][n6][0];
                        fArray2[n5 + 1] = fArray[i][n6][1];
                        fArray2[n4] = fArray[i][n6][2];
                        fArray2[n4 + 1] = fArray[i][n6][3];
                    }
                    this.fftRows.complexForward(fArray2, 0);
                    this.fftRows.complexForward(fArray2, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray[i][n6][0] = fArray2[n5];
                        fArray[i][n6][1] = fArray2[n5 + 1];
                        fArray[i][n6][2] = fArray2[n4];
                        fArray[i][n6][3] = fArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    fArray2[n5] = fArray[i][n6][0];
                    fArray2[n5 + 1] = fArray[i][n6][1];
                }
                this.fftRows.complexForward(fArray2, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    fArray[i][n6][0] = fArray2[n5];
                    fArray[i][n6][1] = fArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n10;
                int n11;
                int n12;
                if (n == 0) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(fArray[i][n12], bl);
                    }
                }
                if (this.columns > 4) {
                    for (n12 = 0; n12 < this.columns; n12 += 8) {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            fArray2[n11] = fArray[i][n15][n12];
                            fArray2[n11 + 1] = fArray[i][n15][n12 + 1];
                            fArray2[n10] = fArray[i][n15][n12 + 2];
                            fArray2[n10 + 1] = fArray[i][n15][n12 + 3];
                            fArray2[n14] = fArray[i][n15][n12 + 4];
                            fArray2[n14 + 1] = fArray[i][n15][n12 + 5];
                            fArray2[n13] = fArray[i][n15][n12 + 6];
                            fArray2[n13 + 1] = fArray[i][n15][n12 + 7];
                        }
                        this.fftRows.complexInverse(fArray2, 0, bl);
                        this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 6 * this.rows, bl);
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            fArray[i][n15][n12] = fArray2[n11];
                            fArray[i][n15][n12 + 1] = fArray2[n11 + 1];
                            fArray[i][n15][n12 + 2] = fArray2[n10];
                            fArray[i][n15][n12 + 3] = fArray2[n10 + 1];
                            fArray[i][n15][n12 + 4] = fArray2[n14];
                            fArray[i][n15][n12 + 5] = fArray2[n14 + 1];
                            fArray[i][n15][n12 + 6] = fArray2[n13];
                            fArray[i][n15][n12 + 7] = fArray2[n13 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        fArray2[n11] = fArray[i][n12][0];
                        fArray2[n11 + 1] = fArray[i][n12][1];
                        fArray2[n10] = fArray[i][n12][2];
                        fArray2[n10 + 1] = fArray[i][n12][3];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        fArray[i][n12][0] = fArray2[n11];
                        fArray[i][n12][1] = fArray2[n11 + 1];
                        fArray[i][n12][2] = fArray2[n10];
                        fArray[i][n12][3] = fArray2[n10 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        fArray2[n11] = fArray[i][n12][0];
                        fArray2[n11 + 1] = fArray[i][n12][1];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        fArray[i][n12][0] = fArray2[n11];
                        fArray[i][n12][1] = fArray2[n11 + 1];
                    }
                }
                if (n == 0) continue;
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realInverse(fArray[i][n12], bl);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, float[][][] fArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        float[] fArray2 = new float[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(fArray[i][n6]);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(fArray[i][n6]);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            fArray2[n5] = fArray[i][n9][n6];
                            fArray2[n5 + 1] = fArray[i][n9][n6 + 1];
                            fArray2[n4] = fArray[i][n9][n6 + 2];
                            fArray2[n4 + 1] = fArray[i][n9][n6 + 3];
                            fArray2[n8] = fArray[i][n9][n6 + 4];
                            fArray2[n8 + 1] = fArray[i][n9][n6 + 5];
                            fArray2[n7] = fArray[i][n9][n6 + 6];
                            fArray2[n7 + 1] = fArray[i][n9][n6 + 7];
                        }
                        this.fftRows.complexForward(fArray2, 0);
                        this.fftRows.complexForward(fArray2, 2 * this.rows);
                        this.fftRows.complexForward(fArray2, 4 * this.rows);
                        this.fftRows.complexForward(fArray2, 6 * this.rows);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            fArray[i][n9][n6] = fArray2[n5];
                            fArray[i][n9][n6 + 1] = fArray2[n5 + 1];
                            fArray[i][n9][n6 + 2] = fArray2[n4];
                            fArray[i][n9][n6 + 3] = fArray2[n4 + 1];
                            fArray[i][n9][n6 + 4] = fArray2[n8];
                            fArray[i][n9][n6 + 5] = fArray2[n8 + 1];
                            fArray[i][n9][n6 + 6] = fArray2[n7];
                            fArray[i][n9][n6 + 7] = fArray2[n7 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray2[n5] = fArray[i][n6][0];
                        fArray2[n5 + 1] = fArray[i][n6][1];
                        fArray2[n4] = fArray[i][n6][2];
                        fArray2[n4 + 1] = fArray[i][n6][3];
                    }
                    this.fftRows.complexForward(fArray2, 0);
                    this.fftRows.complexForward(fArray2, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray[i][n6][0] = fArray2[n5];
                        fArray[i][n6][1] = fArray2[n5 + 1];
                        fArray[i][n6][2] = fArray2[n4];
                        fArray[i][n6][3] = fArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    fArray2[n5] = fArray[i][n6][0];
                    fArray2[n5 + 1] = fArray[i][n6][1];
                }
                this.fftRows.complexForward(fArray2, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    fArray[i][n6][0] = fArray2[n5];
                    fArray[i][n6][1] = fArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n10;
                int n11;
                int n12;
                if (n == 0) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(fArray[i][n12], bl);
                    }
                } else {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.realInverse2(fArray[i][n12], 0, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n12 = 0; n12 < this.columns; n12 += 8) {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            fArray2[n11] = fArray[i][n15][n12];
                            fArray2[n11 + 1] = fArray[i][n15][n12 + 1];
                            fArray2[n10] = fArray[i][n15][n12 + 2];
                            fArray2[n10 + 1] = fArray[i][n15][n12 + 3];
                            fArray2[n14] = fArray[i][n15][n12 + 4];
                            fArray2[n14 + 1] = fArray[i][n15][n12 + 5];
                            fArray2[n13] = fArray[i][n15][n12 + 6];
                            fArray2[n13 + 1] = fArray[i][n15][n12 + 7];
                        }
                        this.fftRows.complexInverse(fArray2, 0, bl);
                        this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(fArray2, 6 * this.rows, bl);
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            fArray[i][n15][n12] = fArray2[n11];
                            fArray[i][n15][n12 + 1] = fArray2[n11 + 1];
                            fArray[i][n15][n12 + 2] = fArray2[n10];
                            fArray[i][n15][n12 + 3] = fArray2[n10 + 1];
                            fArray[i][n15][n12 + 4] = fArray2[n14];
                            fArray[i][n15][n12 + 5] = fArray2[n14 + 1];
                            fArray[i][n15][n12 + 6] = fArray2[n13];
                            fArray[i][n15][n12 + 7] = fArray2[n13 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        fArray2[n11] = fArray[i][n12][0];
                        fArray2[n11 + 1] = fArray[i][n12][1];
                        fArray2[n10] = fArray[i][n12][2];
                        fArray2[n10 + 1] = fArray[i][n12][3];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        fArray[i][n12][0] = fArray2[n11];
                        fArray[i][n12][1] = fArray2[n11 + 1];
                        fArray[i][n12][2] = fArray2[n10];
                        fArray[i][n12][3] = fArray2[n10 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n12 = 0; n12 < this.rows; ++n12) {
                    n11 = 2 * n12;
                    fArray2[n11] = fArray[i][n12][0];
                    fArray2[n11 + 1] = fArray[i][n12][1];
                }
                this.fftRows.complexInverse(fArray2, 0, bl);
                for (n12 = 0; n12 < this.rows; ++n12) {
                    n11 = 2 * n12;
                    fArray[i][n12][0] = fArray2[n11];
                    fArray[i][n12][1] = fArray2[n11 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int n, float[] fArray, boolean bl) {
        block31: {
            float[] fArray2;
            block29: {
                block32: {
                    block30: {
                        int n2 = this.slices;
                        if (n2 < this.rows) {
                            n2 = this.rows;
                        }
                        n2 *= 8;
                        if (this.columns == 4) {
                            n2 >>= 1;
                        } else if (this.columns < 4) {
                            n2 >>= 2;
                        }
                        fArray2 = new float[n2];
                        if (n != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int i = 0; i < this.rows; ++i) {
                            int n3 = i * this.rowStride;
                            for (int j = 0; j < this.columns; j += 8) {
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8;
                                int n9;
                                for (n9 = 0; n9 < this.slices; ++n9) {
                                    n8 = n9 * this.sliceStride + n3 + j;
                                    n7 = 2 * n9;
                                    n6 = 2 * this.slices + 2 * n9;
                                    n5 = n6 + 2 * this.slices;
                                    n4 = n5 + 2 * this.slices;
                                    fArray2[n7] = fArray[n8];
                                    fArray2[n7 + 1] = fArray[n8 + 1];
                                    fArray2[n6] = fArray[n8 + 2];
                                    fArray2[n6 + 1] = fArray[n8 + 3];
                                    fArray2[n5] = fArray[n8 + 4];
                                    fArray2[n5 + 1] = fArray[n8 + 5];
                                    fArray2[n4] = fArray[n8 + 6];
                                    fArray2[n4 + 1] = fArray[n8 + 7];
                                }
                                this.fftSlices.complexForward(fArray2, 0);
                                this.fftSlices.complexForward(fArray2, 2 * this.slices);
                                this.fftSlices.complexForward(fArray2, 4 * this.slices);
                                this.fftSlices.complexForward(fArray2, 6 * this.slices);
                                for (n9 = 0; n9 < this.slices; ++n9) {
                                    n8 = n9 * this.sliceStride + n3 + j;
                                    n7 = 2 * n9;
                                    n6 = 2 * this.slices + 2 * n9;
                                    n5 = n6 + 2 * this.slices;
                                    n4 = n5 + 2 * this.slices;
                                    fArray[n8] = fArray2[n7];
                                    fArray[n8 + 1] = fArray2[n7 + 1];
                                    fArray[n8 + 2] = fArray2[n6];
                                    fArray[n8 + 3] = fArray2[n6 + 1];
                                    fArray[n8 + 4] = fArray2[n5];
                                    fArray[n8 + 5] = fArray2[n5 + 1];
                                    fArray[n8 + 6] = fArray2[n4];
                                    fArray[n8 + 7] = fArray2[n4 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int i = 0; i < this.rows; ++i) {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14 = i * this.rowStride;
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n14;
                            n11 = 2 * n13;
                            n10 = 2 * this.slices + 2 * n13;
                            fArray2[n11] = fArray[n12];
                            fArray2[n11 + 1] = fArray[n12 + 1];
                            fArray2[n10] = fArray[n12 + 2];
                            fArray2[n10 + 1] = fArray[n12 + 3];
                        }
                        this.fftSlices.complexForward(fArray2, 0);
                        this.fftSlices.complexForward(fArray2, 2 * this.slices);
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n14;
                            n11 = 2 * n13;
                            n10 = 2 * this.slices + 2 * n13;
                            fArray[n12] = fArray2[n11];
                            fArray[n12 + 1] = fArray2[n11 + 1];
                            fArray[n12 + 2] = fArray2[n10];
                            fArray[n12 + 3] = fArray2[n10 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int i = 0; i < this.rows; ++i) {
                    int n15;
                    int n16;
                    int n17;
                    int n18 = i * this.rowStride;
                    for (n17 = 0; n17 < this.slices; ++n17) {
                        n16 = n17 * this.sliceStride + n18;
                        n15 = 2 * n17;
                        fArray2[n15] = fArray[n16];
                        fArray2[n15 + 1] = fArray[n16 + 1];
                    }
                    this.fftSlices.complexForward(fArray2, 0);
                    for (n17 = 0; n17 < this.slices; ++n17) {
                        n16 = n17 * this.sliceStride + n18;
                        n15 = 2 * n17;
                        fArray[n16] = fArray2[n15];
                        fArray[n16 + 1] = fArray2[n15 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n19 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 8) {
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        for (n25 = 0; n25 < this.slices; ++n25) {
                            n24 = n25 * this.sliceStride + n19 + j;
                            n23 = 2 * n25;
                            n22 = 2 * this.slices + 2 * n25;
                            n21 = n22 + 2 * this.slices;
                            n20 = n21 + 2 * this.slices;
                            fArray2[n23] = fArray[n24];
                            fArray2[n23 + 1] = fArray[n24 + 1];
                            fArray2[n22] = fArray[n24 + 2];
                            fArray2[n22 + 1] = fArray[n24 + 3];
                            fArray2[n21] = fArray[n24 + 4];
                            fArray2[n21 + 1] = fArray[n24 + 5];
                            fArray2[n20] = fArray[n24 + 6];
                            fArray2[n20 + 1] = fArray[n24 + 7];
                        }
                        this.fftSlices.complexInverse(fArray2, 0, bl);
                        this.fftSlices.complexInverse(fArray2, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(fArray2, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(fArray2, 6 * this.slices, bl);
                        for (n25 = 0; n25 < this.slices; ++n25) {
                            n24 = n25 * this.sliceStride + n19 + j;
                            n23 = 2 * n25;
                            n22 = 2 * this.slices + 2 * n25;
                            n21 = n22 + 2 * this.slices;
                            n20 = n21 + 2 * this.slices;
                            fArray[n24] = fArray2[n23];
                            fArray[n24 + 1] = fArray2[n23 + 1];
                            fArray[n24 + 2] = fArray2[n22];
                            fArray[n24 + 3] = fArray2[n22 + 1];
                            fArray[n24 + 4] = fArray2[n21];
                            fArray[n24 + 5] = fArray2[n21 + 1];
                            fArray[n24 + 6] = fArray2[n20];
                            fArray[n24 + 7] = fArray2[n20 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n26;
                    int n27;
                    int n28;
                    int n29;
                    int n30 = i * this.rowStride;
                    for (n29 = 0; n29 < this.slices; ++n29) {
                        n28 = n29 * this.sliceStride + n30;
                        n27 = 2 * n29;
                        n26 = 2 * this.slices + 2 * n29;
                        fArray2[n27] = fArray[n28];
                        fArray2[n27 + 1] = fArray[n28 + 1];
                        fArray2[n26] = fArray[n28 + 2];
                        fArray2[n26 + 1] = fArray[n28 + 3];
                    }
                    this.fftSlices.complexInverse(fArray2, 0, bl);
                    this.fftSlices.complexInverse(fArray2, 2 * this.slices, bl);
                    for (n29 = 0; n29 < this.slices; ++n29) {
                        n28 = n29 * this.sliceStride + n30;
                        n27 = 2 * n29;
                        n26 = 2 * this.slices + 2 * n29;
                        fArray[n28] = fArray2[n27];
                        fArray[n28 + 1] = fArray2[n27 + 1];
                        fArray[n28 + 2] = fArray2[n26];
                        fArray[n28 + 3] = fArray2[n26 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n31;
                    int n32;
                    int n33;
                    int n34 = i * this.rowStride;
                    for (n33 = 0; n33 < this.slices; ++n33) {
                        n32 = n33 * this.sliceStride + n34;
                        n31 = 2 * n33;
                        fArray2[n31] = fArray[n32];
                        fArray2[n31 + 1] = fArray[n32 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, 0, bl);
                    for (n33 = 0; n33 < this.slices; ++n33) {
                        n32 = n33 * this.sliceStride + n34;
                        n31 = 2 * n33;
                        fArray[n32] = fArray2[n31];
                        fArray[n32 + 1] = fArray2[n31 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, FloatLargeArray floatLargeArray, boolean bl) {
        block31: {
            FloatLargeArray floatLargeArray2;
            block29: {
                block32: {
                    block30: {
                        long l = this.slicesl;
                        if (l < this.rowsl) {
                            l = this.rowsl;
                        }
                        l *= 8L;
                        if (this.columnsl == 4L) {
                            l >>= 1;
                        } else if (this.columnsl < 4L) {
                            l >>= 2;
                        }
                        floatLargeArray2 = new FloatLargeArray(l, false);
                        if (n != -1) break block29;
                        if (this.columnsl <= 4L) break block30;
                        for (long i = 0L; i < this.rowsl; ++i) {
                            long l2 = i * this.rowStridel;
                            for (long j = 0L; j < this.columnsl; j += 8L) {
                                long l3;
                                long l4;
                                long l5;
                                long l6;
                                long l7;
                                long l8;
                                for (l8 = 0L; l8 < this.slicesl; ++l8) {
                                    l7 = l8 * this.sliceStridel + l2 + j;
                                    l6 = 2L * l8;
                                    l5 = 2L * this.slicesl + 2L * l8;
                                    l4 = l5 + 2L * this.slicesl;
                                    l3 = l4 + 2L * this.slicesl;
                                    floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l7));
                                    floatLargeArray2.setFloat(l6 + 1L, floatLargeArray.getFloat(l7 + 1L));
                                    floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l7 + 2L));
                                    floatLargeArray2.setFloat(l5 + 1L, floatLargeArray.getFloat(l7 + 3L));
                                    floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l7 + 4L));
                                    floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l7 + 5L));
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l7 + 6L));
                                    floatLargeArray2.setFloat(l3 + 1L, floatLargeArray.getFloat(l7 + 7L));
                                }
                                this.fftSlices.complexForward(floatLargeArray2, 0L);
                                this.fftSlices.complexForward(floatLargeArray2, 2L * this.slicesl);
                                this.fftSlices.complexForward(floatLargeArray2, 4L * this.slicesl);
                                this.fftSlices.complexForward(floatLargeArray2, 6L * this.slicesl);
                                for (l8 = 0L; l8 < this.slicesl; ++l8) {
                                    l7 = l8 * this.sliceStridel + l2 + j;
                                    l6 = 2L * l8;
                                    l5 = 2L * this.slicesl + 2L * l8;
                                    l4 = l5 + 2L * this.slicesl;
                                    l3 = l4 + 2L * this.slicesl;
                                    floatLargeArray.setFloat(l7, floatLargeArray2.getFloat(l6));
                                    floatLargeArray.setFloat(l7 + 1L, floatLargeArray2.getFloat(l6 + 1L));
                                    floatLargeArray.setFloat(l7 + 2L, floatLargeArray2.getFloat(l5));
                                    floatLargeArray.setFloat(l7 + 3L, floatLargeArray2.getFloat(l5 + 1L));
                                    floatLargeArray.setFloat(l7 + 4L, floatLargeArray2.getFloat(l4));
                                    floatLargeArray.setFloat(l7 + 5L, floatLargeArray2.getFloat(l4 + 1L));
                                    floatLargeArray.setFloat(l7 + 6L, floatLargeArray2.getFloat(l3));
                                    floatLargeArray.setFloat(l7 + 7L, floatLargeArray2.getFloat(l3 + 1L));
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columnsl != 4L) break block32;
                    for (long i = 0L; i < this.rowsl; ++i) {
                        long l;
                        long l9;
                        long l10;
                        long l11;
                        long l12 = i * this.rowStridel;
                        for (l11 = 0L; l11 < this.slicesl; ++l11) {
                            l10 = l11 * this.sliceStridel + l12;
                            l9 = 2L * l11;
                            l = 2L * this.slicesl + 2L * l11;
                            floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                            floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                            floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l10 + 2L));
                            floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l10 + 3L));
                        }
                        this.fftSlices.complexForward(floatLargeArray2, 0L);
                        this.fftSlices.complexForward(floatLargeArray2, 2L * this.slicesl);
                        for (l11 = 0L; l11 < this.slicesl; ++l11) {
                            l10 = l11 * this.sliceStridel + l12;
                            l9 = 2L * l11;
                            l = 2L * this.slicesl + 2L * l11;
                            floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                            floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                            floatLargeArray.setFloat(l10 + 2L, floatLargeArray2.getFloat(l));
                            floatLargeArray.setFloat(l10 + 3L, floatLargeArray2.getFloat(l + 1L));
                        }
                    }
                    break block31;
                }
                if (this.columnsl != 2L) break block31;
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l13;
                    long l14;
                    long l15 = i * this.rowStridel;
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = l14 * this.sliceStridel + l15;
                        l = 2L * l14;
                        floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l13));
                        floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l13 + 1L));
                    }
                    this.fftSlices.complexForward(floatLargeArray2, 0L);
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = l14 * this.sliceStridel + l15;
                        l = 2L * l14;
                        floatLargeArray.setFloat(l13, floatLargeArray2.getFloat(l));
                        floatLargeArray.setFloat(l13 + 1L, floatLargeArray2.getFloat(l + 1L));
                    }
                }
                break block31;
            }
            if (this.columnsl > 4L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l = i * this.rowStridel;
                    for (long j = 0L; j < this.columnsl; j += 8L) {
                        long l16;
                        long l17;
                        long l18;
                        long l19;
                        long l20;
                        long l21;
                        for (l21 = 0L; l21 < this.slicesl; ++l21) {
                            l20 = l21 * this.sliceStridel + l + j;
                            l19 = 2L * l21;
                            l18 = 2L * this.slicesl + 2L * l21;
                            l17 = l18 + 2L * this.slicesl;
                            l16 = l17 + 2L * this.slicesl;
                            floatLargeArray2.setFloat(l19, floatLargeArray.getFloat(l20));
                            floatLargeArray2.setFloat(l19 + 1L, floatLargeArray.getFloat(l20 + 1L));
                            floatLargeArray2.setFloat(l18, floatLargeArray.getFloat(l20 + 2L));
                            floatLargeArray2.setFloat(l18 + 1L, floatLargeArray.getFloat(l20 + 3L));
                            floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l20 + 4L));
                            floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l20 + 5L));
                            floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l20 + 6L));
                            floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l20 + 7L));
                        }
                        this.fftSlices.complexInverse(floatLargeArray2, 0L, bl);
                        this.fftSlices.complexInverse(floatLargeArray2, 2L * this.slicesl, bl);
                        this.fftSlices.complexInverse(floatLargeArray2, 4L * this.slicesl, bl);
                        this.fftSlices.complexInverse(floatLargeArray2, 6L * this.slicesl, bl);
                        for (l21 = 0L; l21 < this.slicesl; ++l21) {
                            l20 = l21 * this.sliceStridel + l + j;
                            l19 = 2L * l21;
                            l18 = 2L * this.slicesl + 2L * l21;
                            l17 = l18 + 2L * this.slicesl;
                            l16 = l17 + 2L * this.slicesl;
                            floatLargeArray.setFloat(l20, floatLargeArray2.getFloat(l19));
                            floatLargeArray.setFloat(l20 + 1L, floatLargeArray2.getFloat(l19 + 1L));
                            floatLargeArray.setFloat(l20 + 2L, floatLargeArray2.getFloat(l18));
                            floatLargeArray.setFloat(l20 + 3L, floatLargeArray2.getFloat(l18 + 1L));
                            floatLargeArray.setFloat(l20 + 4L, floatLargeArray2.getFloat(l17));
                            floatLargeArray.setFloat(l20 + 5L, floatLargeArray2.getFloat(l17 + 1L));
                            floatLargeArray.setFloat(l20 + 6L, floatLargeArray2.getFloat(l16));
                            floatLargeArray.setFloat(l20 + 7L, floatLargeArray2.getFloat(l16 + 1L));
                        }
                    }
                }
            } else if (this.columnsl == 4L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l22;
                    long l23;
                    long l24;
                    long l25 = i * this.rowStridel;
                    for (l24 = 0L; l24 < this.slicesl; ++l24) {
                        l23 = l24 * this.sliceStridel + l25;
                        l22 = 2L * l24;
                        l = 2L * this.slicesl + 2L * l24;
                        floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l23));
                        floatLargeArray2.setFloat(l22 + 1L, floatLargeArray.getFloat(l23 + 1L));
                        floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l23 + 2L));
                        floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l23 + 3L));
                    }
                    this.fftSlices.complexInverse(floatLargeArray2, 0L, bl);
                    this.fftSlices.complexInverse(floatLargeArray2, 2L * this.slicesl, bl);
                    for (l24 = 0L; l24 < this.slicesl; ++l24) {
                        l23 = l24 * this.sliceStridel + l25;
                        l22 = 2L * l24;
                        l = 2L * this.slicesl + 2L * l24;
                        floatLargeArray.setFloat(l23, floatLargeArray2.getFloat(l22));
                        floatLargeArray.setFloat(l23 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                        floatLargeArray.setFloat(l23 + 2L, floatLargeArray2.getFloat(l));
                        floatLargeArray.setFloat(l23 + 3L, floatLargeArray2.getFloat(l + 1L));
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l26;
                    long l27;
                    long l28 = i * this.rowStridel;
                    for (l27 = 0L; l27 < this.slicesl; ++l27) {
                        l26 = l27 * this.sliceStridel + l28;
                        l = 2L * l27;
                        floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l26));
                        floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l26 + 1L));
                    }
                    this.fftSlices.complexInverse(floatLargeArray2, 0L, bl);
                    for (l27 = 0L; l27 < this.slicesl; ++l27) {
                        l26 = l27 * this.sliceStridel + l28;
                        l = 2L * l27;
                        floatLargeArray.setFloat(l26, floatLargeArray2.getFloat(l));
                        floatLargeArray.setFloat(l26 + 1L, floatLargeArray2.getFloat(l + 1L));
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, float[][][] fArray, boolean bl) {
        block31: {
            float[] fArray2;
            block29: {
                block32: {
                    block30: {
                        int n2 = this.slices;
                        if (n2 < this.rows) {
                            n2 = this.rows;
                        }
                        n2 *= 8;
                        if (this.columns == 4) {
                            n2 >>= 1;
                        } else if (this.columns < 4) {
                            n2 >>= 2;
                        }
                        fArray2 = new float[n2];
                        if (n != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int i = 0; i < this.rows; ++i) {
                            for (int j = 0; j < this.columns; j += 8) {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                for (n7 = 0; n7 < this.slices; ++n7) {
                                    n6 = 2 * n7;
                                    n5 = 2 * this.slices + 2 * n7;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    fArray2[n6] = fArray[n7][i][j];
                                    fArray2[n6 + 1] = fArray[n7][i][j + 1];
                                    fArray2[n5] = fArray[n7][i][j + 2];
                                    fArray2[n5 + 1] = fArray[n7][i][j + 3];
                                    fArray2[n4] = fArray[n7][i][j + 4];
                                    fArray2[n4 + 1] = fArray[n7][i][j + 5];
                                    fArray2[n3] = fArray[n7][i][j + 6];
                                    fArray2[n3 + 1] = fArray[n7][i][j + 7];
                                }
                                this.fftSlices.complexForward(fArray2, 0);
                                this.fftSlices.complexForward(fArray2, 2 * this.slices);
                                this.fftSlices.complexForward(fArray2, 4 * this.slices);
                                this.fftSlices.complexForward(fArray2, 6 * this.slices);
                                for (n7 = 0; n7 < this.slices; ++n7) {
                                    n6 = 2 * n7;
                                    n5 = 2 * this.slices + 2 * n7;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    fArray[n7][i][j] = fArray2[n6];
                                    fArray[n7][i][j + 1] = fArray2[n6 + 1];
                                    fArray[n7][i][j + 2] = fArray2[n5];
                                    fArray[n7][i][j + 3] = fArray2[n5 + 1];
                                    fArray[n7][i][j + 4] = fArray2[n4];
                                    fArray[n7][i][j + 5] = fArray2[n4 + 1];
                                    fArray[n7][i][j + 6] = fArray2[n3];
                                    fArray[n7][i][j + 7] = fArray2[n3 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int i = 0; i < this.rows; ++i) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.slices; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.slices + 2 * n10;
                            fArray2[n9] = fArray[n10][i][0];
                            fArray2[n9 + 1] = fArray[n10][i][1];
                            fArray2[n8] = fArray[n10][i][2];
                            fArray2[n8 + 1] = fArray[n10][i][3];
                        }
                        this.fftSlices.complexForward(fArray2, 0);
                        this.fftSlices.complexForward(fArray2, 2 * this.slices);
                        for (n10 = 0; n10 < this.slices; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.slices + 2 * n10;
                            fArray[n10][i][0] = fArray2[n9];
                            fArray[n10][i][1] = fArray2[n9 + 1];
                            fArray[n10][i][2] = fArray2[n8];
                            fArray[n10][i][3] = fArray2[n8 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int i = 0; i < this.rows; ++i) {
                    int n11;
                    int n12;
                    for (n12 = 0; n12 < this.slices; ++n12) {
                        n11 = 2 * n12;
                        fArray2[n11] = fArray[n12][i][0];
                        fArray2[n11 + 1] = fArray[n12][i][1];
                    }
                    this.fftSlices.complexForward(fArray2, 0);
                    for (n12 = 0; n12 < this.slices; ++n12) {
                        n11 = 2 * n12;
                        fArray[n12][i][0] = fArray2[n11];
                        fArray[n12][i][1] = fArray2[n11 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 8) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        for (n17 = 0; n17 < this.slices; ++n17) {
                            n16 = 2 * n17;
                            n15 = 2 * this.slices + 2 * n17;
                            n14 = n15 + 2 * this.slices;
                            n13 = n14 + 2 * this.slices;
                            fArray2[n16] = fArray[n17][i][j];
                            fArray2[n16 + 1] = fArray[n17][i][j + 1];
                            fArray2[n15] = fArray[n17][i][j + 2];
                            fArray2[n15 + 1] = fArray[n17][i][j + 3];
                            fArray2[n14] = fArray[n17][i][j + 4];
                            fArray2[n14 + 1] = fArray[n17][i][j + 5];
                            fArray2[n13] = fArray[n17][i][j + 6];
                            fArray2[n13 + 1] = fArray[n17][i][j + 7];
                        }
                        this.fftSlices.complexInverse(fArray2, 0, bl);
                        this.fftSlices.complexInverse(fArray2, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(fArray2, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(fArray2, 6 * this.slices, bl);
                        for (n17 = 0; n17 < this.slices; ++n17) {
                            n16 = 2 * n17;
                            n15 = 2 * this.slices + 2 * n17;
                            n14 = n15 + 2 * this.slices;
                            n13 = n14 + 2 * this.slices;
                            fArray[n17][i][j] = fArray2[n16];
                            fArray[n17][i][j + 1] = fArray2[n16 + 1];
                            fArray[n17][i][j + 2] = fArray2[n15];
                            fArray[n17][i][j + 3] = fArray2[n15 + 1];
                            fArray[n17][i][j + 4] = fArray2[n14];
                            fArray[n17][i][j + 5] = fArray2[n14 + 1];
                            fArray[n17][i][j + 6] = fArray2[n13];
                            fArray[n17][i][j + 7] = fArray2[n13 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n18;
                    int n19;
                    int n20;
                    for (n20 = 0; n20 < this.slices; ++n20) {
                        n19 = 2 * n20;
                        n18 = 2 * this.slices + 2 * n20;
                        fArray2[n19] = fArray[n20][i][0];
                        fArray2[n19 + 1] = fArray[n20][i][1];
                        fArray2[n18] = fArray[n20][i][2];
                        fArray2[n18 + 1] = fArray[n20][i][3];
                    }
                    this.fftSlices.complexInverse(fArray2, 0, bl);
                    this.fftSlices.complexInverse(fArray2, 2 * this.slices, bl);
                    for (n20 = 0; n20 < this.slices; ++n20) {
                        n19 = 2 * n20;
                        n18 = 2 * this.slices + 2 * n20;
                        fArray[n20][i][0] = fArray2[n19];
                        fArray[n20][i][1] = fArray2[n19 + 1];
                        fArray[n20][i][2] = fArray2[n18];
                        fArray[n20][i][3] = fArray2[n18 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n21;
                    int n22;
                    for (n22 = 0; n22 < this.slices; ++n22) {
                        n21 = 2 * n22;
                        fArray2[n21] = fArray[n22][i][0];
                        fArray2[n21 + 1] = fArray[n22][i][1];
                    }
                    this.fftSlices.complexInverse(fArray2, 0, bl);
                    for (n22 = 0; n22 < this.slices; ++n22) {
                        n21 = 2 * n22;
                        fArray[n22][i][0] = fArray2[n21];
                        fArray[n22][i][1] = fArray2[n21 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] fArray2 = new float[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.realForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n22] = fArray[n32];
                                        fArray2[n22 + 1] = fArray[n32 + 1];
                                        fArray2[n16] = fArray[n32 + 2];
                                        fArray2[n16 + 1] = fArray[n32 + 3];
                                        fArray2[n7] = fArray[n32 + 4];
                                        fArray2[n7 + 1] = fArray[n32 + 5];
                                        fArray2[n62] = fArray[n32 + 6];
                                        fArray2[n62 + 1] = fArray[n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 6 * FloatFFT_3D.this.rows);
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n32] = fArray2[n22];
                                        fArray[n32 + 1] = fArray2[n22 + 1];
                                        fArray[n32 + 2] = fArray2[n16];
                                        fArray[n32 + 3] = fArray2[n16 + 1];
                                        fArray[n32 + 4] = fArray2[n7];
                                        fArray[n32 + 5] = fArray2[n7 + 1];
                                        fArray[n32 + 6] = fArray2[n62];
                                        fArray[n32 + 7] = fArray2[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    fArray2[n22] = fArray[n32];
                                    fArray2[n22 + 1] = fArray[n32 + 1];
                                    fArray2[n16] = fArray[n32 + 2];
                                    fArray2[n16 + 1] = fArray[n32 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    fArray[n32] = fArray2[n22];
                                    fArray[n32 + 1] = fArray2[n22 + 1];
                                    fArray[n32 + 2] = fArray2[n16];
                                    fArray[n32 + 3] = fArray2[n16 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                fArray2[n22] = fArray[n32];
                                fArray2[n22 + 1] = fArray[n32 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                fArray[n32] = fArray2[n22];
                                fArray[n32 + 1] = fArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n9] = fArray[n10];
                                        fArray2[n9 + 1] = fArray[n10 + 1];
                                        fArray2[n17] = fArray[n10 + 2];
                                        fArray2[n17 + 1] = fArray[n10 + 3];
                                        fArray2[n14] = fArray[n10 + 4];
                                        fArray2[n14 + 1] = fArray[n10 + 5];
                                        fArray2[n13] = fArray[n10 + 6];
                                        fArray2[n13 + 1] = fArray[n10 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 6 * FloatFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n10] = fArray2[n9];
                                        fArray[n10 + 1] = fArray2[n9 + 1];
                                        fArray[n10 + 2] = fArray2[n17];
                                        fArray[n10 + 3] = fArray2[n17 + 1];
                                        fArray[n10 + 4] = fArray2[n14];
                                        fArray[n10 + 5] = fArray2[n14 + 1];
                                        fArray[n10 + 6] = fArray2[n13];
                                        fArray[n10 + 7] = fArray2[n13 + 1];
                                    }
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    fArray2[n9] = fArray[n10];
                                    fArray2[n9 + 1] = fArray[n10 + 1];
                                    fArray2[n17] = fArray[n10 + 2];
                                    fArray2[n17 + 1] = fArray[n10 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    fArray[n10] = fArray2[n9];
                                    fArray[n10 + 1] = fArray2[n9 + 1];
                                    fArray[n10 + 2] = fArray2[n17];
                                    fArray[n10 + 3] = fArray2[n17 + 1];
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    fArray2[n9] = fArray[n10];
                                    fArray2[n9 + 1] = fArray[n10 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    fArray[n10] = fArray2[n9];
                                    fArray[n10 + 1] = fArray2[n9 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                FloatFFT_3D.this.fftColumns.realInverse(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth1(final long l, final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)Math.min((long)ConcurrencyUtils.getNumberOfThreads(), this.slicesl);
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        final long l3 = l2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    FloatLargeArray floatLargeArray2 = new FloatLargeArray(l3, false);
                    if (n == -1) {
                        for (long i = l4; i < FloatFFT_3D.this.slicesl; i += (long)n2) {
                            long l16;
                            long l2;
                            long l32;
                            long l42;
                            long l5 = i * FloatFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    FloatFFT_3D.this.fftColumns.complexForward(floatLargeArray, l5 + l42 * FloatFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    FloatFFT_3D.this.fftColumns.realForward(floatLargeArray, l5 + l42 * FloatFFT_3D.this.rowStridel);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.columnsl; l42 += 8L) {
                                    long l6;
                                    long l7;
                                    long l8;
                                    for (l8 = 0L; l8 < FloatFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * FloatFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * FloatFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l32));
                                        floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                                        floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l32 + 2L));
                                        floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l32 + 3L));
                                        floatLargeArray2.setFloat(l7, floatLargeArray.getFloat(l32 + 4L));
                                        floatLargeArray2.setFloat(l7 + 1L, floatLargeArray.getFloat(l32 + 5L));
                                        floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l32 + 6L));
                                        floatLargeArray2.setFloat(l6 + 1L, floatLargeArray.getFloat(l32 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 0L);
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 4L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 6L * FloatFFT_3D.this.rowsl);
                                    for (l8 = 0L; l8 < FloatFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * FloatFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * FloatFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l2));
                                        floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                                        floatLargeArray.setFloat(l32 + 2L, floatLargeArray2.getFloat(l16));
                                        floatLargeArray.setFloat(l32 + 3L, floatLargeArray2.getFloat(l16 + 1L));
                                        floatLargeArray.setFloat(l32 + 4L, floatLargeArray2.getFloat(l7));
                                        floatLargeArray.setFloat(l32 + 5L, floatLargeArray2.getFloat(l7 + 1L));
                                        floatLargeArray.setFloat(l32 + 6L, floatLargeArray2.getFloat(l6));
                                        floatLargeArray.setFloat(l32 + 7L, floatLargeArray2.getFloat(l6 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl == 4L) {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l42;
                                    floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l32));
                                    floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                                    floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l32 + 2L));
                                    floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l32 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 0L);
                                FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl);
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l42;
                                    floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l2));
                                    floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                                    floatLargeArray.setFloat(l32 + 2L, floatLargeArray2.getFloat(l16));
                                    floatLargeArray.setFloat(l32 + 3L, floatLargeArray2.getFloat(l16 + 1L));
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) continue;
                            for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l32));
                                floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                            }
                            FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 0L);
                            for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l2));
                                floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                            }
                        }
                    } else {
                        for (long i = l4; i < FloatFFT_3D.this.slicesl; i += (long)n2) {
                            long l17;
                            long l9;
                            long l10;
                            long l11;
                            long l12 = i * FloatFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(floatLargeArray, l12 + l11 * FloatFFT_3D.this.rowStridel, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.columnsl; l11 += 8L) {
                                    long l13;
                                    long l14;
                                    long l15;
                                    for (l15 = 0L; l15 < FloatFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * FloatFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * FloatFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                                        floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                                        floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l10 + 2L));
                                        floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l10 + 3L));
                                        floatLargeArray2.setFloat(l14, floatLargeArray.getFloat(l10 + 4L));
                                        floatLargeArray2.setFloat(l14 + 1L, floatLargeArray.getFloat(l10 + 5L));
                                        floatLargeArray2.setFloat(l13, floatLargeArray.getFloat(l10 + 6L));
                                        floatLargeArray2.setFloat(l13 + 1L, floatLargeArray.getFloat(l10 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 4L * FloatFFT_3D.this.rowsl, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 6L * FloatFFT_3D.this.rowsl, bl);
                                    for (l15 = 0L; l15 < FloatFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * FloatFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * FloatFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                                        floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                                        floatLargeArray.setFloat(l10 + 2L, floatLargeArray2.getFloat(l17));
                                        floatLargeArray.setFloat(l10 + 3L, floatLargeArray2.getFloat(l17 + 1L));
                                        floatLargeArray.setFloat(l10 + 4L, floatLargeArray2.getFloat(l14));
                                        floatLargeArray.setFloat(l10 + 5L, floatLargeArray2.getFloat(l14 + 1L));
                                        floatLargeArray.setFloat(l10 + 6L, floatLargeArray2.getFloat(l13));
                                        floatLargeArray.setFloat(l10 + 7L, floatLargeArray2.getFloat(l13 + 1L));
                                    }
                                }
                            } else if (FloatFFT_3D.this.columnsl == 4L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l11;
                                    floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                                    floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                                    floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l10 + 2L));
                                    floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l10 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl, bl);
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l11;
                                    floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                                    floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                                    floatLargeArray.setFloat(l10 + 2L, floatLargeArray2.getFloat(l17));
                                    floatLargeArray.setFloat(l10 + 3L, floatLargeArray2.getFloat(l17 + 1L));
                                }
                            } else if (FloatFFT_3D.this.columnsl == 2L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                                    floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                                    floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                                }
                            }
                            if (l == 0L) continue;
                            for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                FloatFFT_3D.this.fftColumns.realInverse(floatLargeArray, l12 + l11 * FloatFFT_3D.this.rowStridel, bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] fArray2 = new float[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.realForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n22] = fArray[n32];
                                        fArray2[n22 + 1] = fArray[n32 + 1];
                                        fArray2[n16] = fArray[n32 + 2];
                                        fArray2[n16 + 1] = fArray[n32 + 3];
                                        fArray2[n7] = fArray[n32 + 4];
                                        fArray2[n7 + 1] = fArray[n32 + 5];
                                        fArray2[n62] = fArray[n32 + 6];
                                        fArray2[n62 + 1] = fArray[n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 6 * FloatFFT_3D.this.rows);
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n32] = fArray2[n22];
                                        fArray[n32 + 1] = fArray2[n22 + 1];
                                        fArray[n32 + 2] = fArray2[n16];
                                        fArray[n32 + 3] = fArray2[n16 + 1];
                                        fArray[n32 + 4] = fArray2[n7];
                                        fArray[n32 + 5] = fArray2[n7 + 1];
                                        fArray[n32 + 6] = fArray2[n62];
                                        fArray[n32 + 7] = fArray2[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    fArray2[n22] = fArray[n32];
                                    fArray2[n22 + 1] = fArray[n32 + 1];
                                    fArray2[n16] = fArray[n32 + 2];
                                    fArray2[n16 + 1] = fArray[n32 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    fArray[n32] = fArray2[n22];
                                    fArray[n32 + 1] = fArray2[n22 + 1];
                                    fArray[n32 + 2] = fArray2[n16];
                                    fArray[n32 + 3] = fArray2[n16 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                fArray2[n22] = fArray[n32];
                                fArray2[n22 + 1] = fArray[n32 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                fArray[n32] = fArray2[n22];
                                fArray[n32 + 1] = fArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                                }
                            } else {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n9] = fArray[n10];
                                        fArray2[n9 + 1] = fArray[n10 + 1];
                                        fArray2[n17] = fArray[n10 + 2];
                                        fArray2[n17 + 1] = fArray[n10 + 3];
                                        fArray2[n14] = fArray[n10 + 4];
                                        fArray2[n14 + 1] = fArray[n10 + 5];
                                        fArray2[n13] = fArray[n10 + 6];
                                        fArray2[n13 + 1] = fArray[n10 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 6 * FloatFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n10] = fArray2[n9];
                                        fArray[n10 + 1] = fArray2[n9 + 1];
                                        fArray[n10 + 2] = fArray2[n17];
                                        fArray[n10 + 3] = fArray2[n17 + 1];
                                        fArray[n10 + 4] = fArray2[n14];
                                        fArray[n10 + 5] = fArray2[n14 + 1];
                                        fArray[n10 + 6] = fArray2[n13];
                                        fArray[n10 + 7] = fArray2[n13 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    fArray2[n9] = fArray[n10];
                                    fArray2[n9 + 1] = fArray[n10 + 1];
                                    fArray2[n17] = fArray[n10 + 2];
                                    fArray2[n17 + 1] = fArray[n10 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    fArray[n10] = fArray2[n9];
                                    fArray[n10 + 1] = fArray2[n9 + 1];
                                    fArray[n10 + 2] = fArray2[n17];
                                    fArray[n10 + 3] = fArray2[n17 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                n9 = 2 * n11;
                                fArray2[n9] = fArray[n10];
                                fArray2[n9 + 1] = fArray[n10 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                            for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                n9 = 2 * n11;
                                fArray[n10] = fArray2[n9];
                                fArray[n10 + 1] = fArray2[n9 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final long l, final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)Math.min((long)ConcurrencyUtils.getNumberOfThreads(), this.slicesl);
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        final long l3 = l2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    FloatLargeArray floatLargeArray2 = new FloatLargeArray(l3, false);
                    if (n == -1) {
                        for (long i = l4; i < FloatFFT_3D.this.slicesl; i += (long)n2) {
                            long l16;
                            long l2;
                            long l32;
                            long l42;
                            long l5 = i * FloatFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    FloatFFT_3D.this.fftColumns.complexForward(floatLargeArray, l5 + l42 * FloatFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    FloatFFT_3D.this.fftColumns.realForward(floatLargeArray, l5 + l42 * FloatFFT_3D.this.rowStridel);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.columnsl; l42 += 8L) {
                                    long l6;
                                    long l7;
                                    long l8;
                                    for (l8 = 0L; l8 < FloatFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * FloatFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * FloatFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l32));
                                        floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                                        floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l32 + 2L));
                                        floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l32 + 3L));
                                        floatLargeArray2.setFloat(l7, floatLargeArray.getFloat(l32 + 4L));
                                        floatLargeArray2.setFloat(l7 + 1L, floatLargeArray.getFloat(l32 + 5L));
                                        floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l32 + 6L));
                                        floatLargeArray2.setFloat(l6 + 1L, floatLargeArray.getFloat(l32 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 0L);
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 4L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 6L * FloatFFT_3D.this.rowsl);
                                    for (l8 = 0L; l8 < FloatFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * FloatFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * FloatFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l2));
                                        floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                                        floatLargeArray.setFloat(l32 + 2L, floatLargeArray2.getFloat(l16));
                                        floatLargeArray.setFloat(l32 + 3L, floatLargeArray2.getFloat(l16 + 1L));
                                        floatLargeArray.setFloat(l32 + 4L, floatLargeArray2.getFloat(l7));
                                        floatLargeArray.setFloat(l32 + 5L, floatLargeArray2.getFloat(l7 + 1L));
                                        floatLargeArray.setFloat(l32 + 6L, floatLargeArray2.getFloat(l6));
                                        floatLargeArray.setFloat(l32 + 7L, floatLargeArray2.getFloat(l6 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl == 4L) {
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l42;
                                    floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l32));
                                    floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                                    floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l32 + 2L));
                                    floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l32 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 0L);
                                FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl);
                                for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * FloatFFT_3D.this.rowsl + 2L * l42;
                                    floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l2));
                                    floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                                    floatLargeArray.setFloat(l32 + 2L, floatLargeArray2.getFloat(l16));
                                    floatLargeArray.setFloat(l32 + 3L, floatLargeArray2.getFloat(l16 + 1L));
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) continue;
                            for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l32));
                                floatLargeArray2.setFloat(l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                            }
                            FloatFFT_3D.this.fftRows.complexForward(floatLargeArray2, 0L);
                            for (l42 = 0L; l42 < FloatFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * FloatFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l2));
                                floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l2 + 1L));
                            }
                        }
                    } else {
                        for (long i = l4; i < FloatFFT_3D.this.slicesl; i += (long)n2) {
                            long l17;
                            long l9;
                            long l10;
                            long l11;
                            long l12 = i * FloatFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(floatLargeArray, l12 + l11 * FloatFFT_3D.this.rowStridel, bl);
                                }
                            } else {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(floatLargeArray, l12 + l11 * FloatFFT_3D.this.rowStridel, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.columnsl; l11 += 8L) {
                                    long l13;
                                    long l14;
                                    long l15;
                                    for (l15 = 0L; l15 < FloatFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * FloatFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * FloatFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                                        floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                                        floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l10 + 2L));
                                        floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l10 + 3L));
                                        floatLargeArray2.setFloat(l14, floatLargeArray.getFloat(l10 + 4L));
                                        floatLargeArray2.setFloat(l14 + 1L, floatLargeArray.getFloat(l10 + 5L));
                                        floatLargeArray2.setFloat(l13, floatLargeArray.getFloat(l10 + 6L));
                                        floatLargeArray2.setFloat(l13 + 1L, floatLargeArray.getFloat(l10 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 4L * FloatFFT_3D.this.rowsl, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 6L * FloatFFT_3D.this.rowsl, bl);
                                    for (l15 = 0L; l15 < FloatFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * FloatFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * FloatFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * FloatFFT_3D.this.rowsl;
                                        floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                                        floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                                        floatLargeArray.setFloat(l10 + 2L, floatLargeArray2.getFloat(l17));
                                        floatLargeArray.setFloat(l10 + 3L, floatLargeArray2.getFloat(l17 + 1L));
                                        floatLargeArray.setFloat(l10 + 4L, floatLargeArray2.getFloat(l14));
                                        floatLargeArray.setFloat(l10 + 5L, floatLargeArray2.getFloat(l14 + 1L));
                                        floatLargeArray.setFloat(l10 + 6L, floatLargeArray2.getFloat(l13));
                                        floatLargeArray.setFloat(l10 + 7L, floatLargeArray2.getFloat(l13 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl == 4L) {
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l11;
                                    floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                                    floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                                    floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l10 + 2L));
                                    floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l10 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 2L * FloatFFT_3D.this.rowsl, bl);
                                for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * FloatFFT_3D.this.rowsl + 2L * l11;
                                    floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                                    floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                                    floatLargeArray.setFloat(l10 + 2L, floatLargeArray2.getFloat(l17));
                                    floatLargeArray.setFloat(l10 + 3L, floatLargeArray2.getFloat(l17 + 1L));
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) continue;
                            for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                l9 = 2L * l11;
                                floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l10));
                                floatLargeArray2.setFloat(l9 + 1L, floatLargeArray.getFloat(l10 + 1L));
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                            for (l11 = 0L; l11 < FloatFFT_3D.this.rowsl; ++l11) {
                                l10 = l12 + l11 * FloatFFT_3D.this.rowStridel;
                                l9 = 2L * l11;
                                floatLargeArray.setFloat(l10, floatLargeArray2.getFloat(l9));
                                floatLargeArray.setFloat(l10 + 1L, floatLargeArray2.getFloat(l9 + 1L));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth1(final int n, final int n2, final float[][][] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] fArray2 = new float[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.realForward(fArray[i][n32], 0);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n22] = fArray[i][n62][n32];
                                        fArray2[n22 + 1] = fArray[i][n62][n32 + 1];
                                        fArray2[n12] = fArray[i][n62][n32 + 2];
                                        fArray2[n12 + 1] = fArray[i][n62][n32 + 3];
                                        fArray2[n52] = fArray[i][n62][n32 + 4];
                                        fArray2[n52 + 1] = fArray[i][n62][n32 + 5];
                                        fArray2[n4] = fArray[i][n62][n32 + 6];
                                        fArray2[n4 + 1] = fArray[i][n62][n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 6 * FloatFFT_3D.this.rows);
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n62][n32] = fArray2[n22];
                                        fArray[i][n62][n32 + 1] = fArray2[n22 + 1];
                                        fArray[i][n62][n32 + 2] = fArray2[n12];
                                        fArray[i][n62][n32 + 3] = fArray2[n12 + 1];
                                        fArray[i][n62][n32 + 4] = fArray2[n52];
                                        fArray[i][n62][n32 + 5] = fArray2[n52 + 1];
                                        fArray[i][n62][n32 + 6] = fArray2[n4];
                                        fArray[i][n62][n32 + 7] = fArray2[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    fArray2[n22] = fArray[i][n32][0];
                                    fArray2[n22 + 1] = fArray[i][n32][1];
                                    fArray2[n12] = fArray[i][n32][2];
                                    fArray2[n12 + 1] = fArray[i][n32][3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    fArray[i][n32][0] = fArray2[n22];
                                    fArray[i][n32][1] = fArray2[n22 + 1];
                                    fArray[i][n32][2] = fArray2[n12];
                                    fArray[i][n32][3] = fArray2[n12 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                fArray2[n22] = fArray[i][n32][0];
                                fArray2[n22 + 1] = fArray[i][n32][1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                fArray[i][n32][0] = fArray2[n22];
                                fArray[i][n32][1] = fArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray[i][n8], bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n7] = fArray[i][n11][n8];
                                        fArray2[n7 + 1] = fArray[i][n11][n8 + 1];
                                        fArray2[n13] = fArray[i][n11][n8 + 2];
                                        fArray2[n13 + 1] = fArray[i][n11][n8 + 3];
                                        fArray2[n10] = fArray[i][n11][n8 + 4];
                                        fArray2[n10 + 1] = fArray[i][n11][n8 + 5];
                                        fArray2[n9] = fArray[i][n11][n8 + 6];
                                        fArray2[n9 + 1] = fArray[i][n11][n8 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 6 * FloatFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n11][n8] = fArray2[n7];
                                        fArray[i][n11][n8 + 1] = fArray2[n7 + 1];
                                        fArray[i][n11][n8 + 2] = fArray2[n13];
                                        fArray[i][n11][n8 + 3] = fArray2[n13 + 1];
                                        fArray[i][n11][n8 + 4] = fArray2[n10];
                                        fArray[i][n11][n8 + 5] = fArray2[n10 + 1];
                                        fArray[i][n11][n8 + 6] = fArray2[n9];
                                        fArray[i][n11][n8 + 7] = fArray2[n9 + 1];
                                    }
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    fArray2[n7] = fArray[i][n8][0];
                                    fArray2[n7 + 1] = fArray[i][n8][1];
                                    fArray2[n13] = fArray[i][n8][2];
                                    fArray2[n13 + 1] = fArray[i][n8][3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    fArray[i][n8][0] = fArray2[n7];
                                    fArray[i][n8][1] = fArray2[n7 + 1];
                                    fArray[i][n8][2] = fArray2[n13];
                                    fArray[i][n8][3] = fArray2[n13 + 1];
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    fArray2[n7] = fArray[i][n8][0];
                                    fArray2[n7 + 1] = fArray[i][n8][1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    fArray[i][n8][0] = fArray2[n7];
                                    fArray[i][n8][1] = fArray2[n7 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                FloatFFT_3D.this.fftColumns.realInverse(fArray[i][n8], bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final float[][][] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] fArray2 = new float[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.realForward(fArray[i][n32]);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n22] = fArray[i][n62][n32];
                                        fArray2[n22 + 1] = fArray[i][n62][n32 + 1];
                                        fArray2[n12] = fArray[i][n62][n32 + 2];
                                        fArray2[n12 + 1] = fArray[i][n62][n32 + 3];
                                        fArray2[n52] = fArray[i][n62][n32 + 4];
                                        fArray2[n52 + 1] = fArray[i][n62][n32 + 5];
                                        fArray2[n4] = fArray[i][n62][n32 + 6];
                                        fArray2[n4 + 1] = fArray[i][n62][n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2, 6 * FloatFFT_3D.this.rows);
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n62][n32] = fArray2[n22];
                                        fArray[i][n62][n32 + 1] = fArray2[n22 + 1];
                                        fArray[i][n62][n32 + 2] = fArray2[n12];
                                        fArray[i][n62][n32 + 3] = fArray2[n12 + 1];
                                        fArray[i][n62][n32 + 4] = fArray2[n52];
                                        fArray[i][n62][n32 + 5] = fArray2[n52 + 1];
                                        fArray[i][n62][n32 + 6] = fArray2[n4];
                                        fArray[i][n62][n32 + 7] = fArray2[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    fArray2[n22] = fArray[i][n32][0];
                                    fArray2[n22 + 1] = fArray[i][n32][1];
                                    fArray2[n12] = fArray[i][n32][2];
                                    fArray2[n12 + 1] = fArray[i][n32][3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_3D.this.rows);
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    fArray[i][n32][0] = fArray2[n22];
                                    fArray[i][n32][1] = fArray2[n22 + 1];
                                    fArray[i][n32][2] = fArray2[n12];
                                    fArray[i][n32][3] = fArray2[n12 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                fArray2[n22] = fArray[i][n32][0];
                                fArray2[n22 + 1] = fArray[i][n32][1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(fArray2, 0);
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                fArray[i][n32][0] = fArray2[n22];
                                fArray[i][n32][1] = fArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < FloatFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray[i][n8], bl);
                                }
                            } else {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(fArray[i][n8], 0, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        fArray2[n7] = fArray[i][n11][n8];
                                        fArray2[n7 + 1] = fArray[i][n11][n8 + 1];
                                        fArray2[n13] = fArray[i][n11][n8 + 2];
                                        fArray2[n13 + 1] = fArray[i][n11][n8 + 3];
                                        fArray2[n10] = fArray[i][n11][n8 + 4];
                                        fArray2[n10 + 1] = fArray[i][n11][n8 + 5];
                                        fArray2[n9] = fArray[i][n11][n8 + 6];
                                        fArray2[n9 + 1] = fArray[i][n11][n8 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, 6 * FloatFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n11][n8] = fArray2[n7];
                                        fArray[i][n11][n8 + 1] = fArray2[n7 + 1];
                                        fArray[i][n11][n8 + 2] = fArray2[n13];
                                        fArray[i][n11][n8 + 3] = fArray2[n13 + 1];
                                        fArray[i][n11][n8 + 4] = fArray2[n10];
                                        fArray[i][n11][n8 + 5] = fArray2[n10 + 1];
                                        fArray[i][n11][n8 + 6] = fArray2[n9];
                                        fArray[i][n11][n8 + 7] = fArray2[n9 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    fArray2[n7] = fArray[i][n8][0];
                                    fArray2[n7 + 1] = fArray[i][n8][1];
                                    fArray2[n13] = fArray[i][n8][2];
                                    fArray2[n13 + 1] = fArray[i][n8][3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    fArray[i][n8][0] = fArray2[n7];
                                    fArray[i][n8][1] = fArray2[n7 + 1];
                                    fArray[i][n8][2] = fArray2[n13];
                                    fArray[i][n8][3] = fArray2[n13 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                n7 = 2 * n8;
                                fArray2[n7] = fArray[i][n8][0];
                                fArray2[n7 + 1] = fArray[i][n8][1];
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(fArray2, 0, bl);
                            for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                n7 = 2 * n8;
                                fArray[i][n8][0] = fArray2[n7];
                                fArray[i][n8][1] = fArray2[n7 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        float[] fArray2;
                        block25: {
                            block28: {
                                block26: {
                                    fArray2 = new float[n4];
                                    if (n != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                        int n28 = i * FloatFFT_3D.this.rowStride;
                                        for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                            int n29;
                                            int n3;
                                            int n42;
                                            int n52;
                                            int n6;
                                            int n7;
                                            for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * FloatFFT_3D.this.sliceStride + n28 + j;
                                                n52 = 2 * n7;
                                                n42 = 2 * FloatFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * FloatFFT_3D.this.slices;
                                                n29 = n3 + 2 * FloatFFT_3D.this.slices;
                                                fArray2[n52] = fArray[n6];
                                                fArray2[n52 + 1] = fArray[n6 + 1];
                                                fArray2[n42] = fArray[n6 + 2];
                                                fArray2[n42 + 1] = fArray[n6 + 3];
                                                fArray2[n3] = fArray[n6 + 4];
                                                fArray2[n3 + 1] = fArray[n6 + 5];
                                                fArray2[n29] = fArray[n6 + 6];
                                                fArray2[n29 + 1] = fArray[n6 + 7];
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 0);
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 6 * FloatFFT_3D.this.slices);
                                            for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * FloatFFT_3D.this.sliceStride + n28 + j;
                                                n52 = 2 * n7;
                                                n42 = 2 * FloatFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * FloatFFT_3D.this.slices;
                                                n29 = n3 + 2 * FloatFFT_3D.this.slices;
                                                fArray[n6] = fArray2[n52];
                                                fArray[n6 + 1] = fArray2[n52 + 1];
                                                fArray[n6 + 2] = fArray2[n42];
                                                fArray[n6 + 3] = fArray2[n42 + 1];
                                                fArray[n6 + 4] = fArray2[n3];
                                                fArray[n6 + 5] = fArray2[n3 + 1];
                                                fArray[n6 + 6] = fArray2[n29];
                                                fArray[n6 + 7] = fArray2[n29 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                    int n30;
                                    int n8;
                                    int n9;
                                    int n10;
                                    int n11 = i * FloatFFT_3D.this.rowStride;
                                    for (n10 = 0; n10 < FloatFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * FloatFFT_3D.this.sliceStride + n11;
                                        n8 = 2 * n10;
                                        n30 = 2 * FloatFFT_3D.this.slices + 2 * n10;
                                        fArray2[n8] = fArray[n9];
                                        fArray2[n8 + 1] = fArray[n9 + 1];
                                        fArray2[n30] = fArray[n9 + 2];
                                        fArray2[n30 + 1] = fArray[n9 + 3];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(fArray2, 0);
                                    FloatFFT_3D.this.fftSlices.complexForward(fArray2, 2 * FloatFFT_3D.this.slices);
                                    for (n10 = 0; n10 < FloatFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * FloatFFT_3D.this.sliceStride + n11;
                                        n8 = 2 * n10;
                                        n30 = 2 * FloatFFT_3D.this.slices + 2 * n10;
                                        fArray[n9] = fArray2[n8];
                                        fArray[n9 + 1] = fArray2[n8 + 1];
                                        fArray[n9 + 2] = fArray2[n30];
                                        fArray[n9 + 3] = fArray2[n30 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n31;
                                int n12;
                                int n13;
                                int n14 = i * FloatFFT_3D.this.rowStride;
                                for (n13 = 0; n13 < FloatFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * FloatFFT_3D.this.sliceStride + n14;
                                    n31 = 2 * n13;
                                    fArray2[n31] = fArray[n12];
                                    fArray2[n31 + 1] = fArray[n12 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2, 0);
                                for (n13 = 0; n13 < FloatFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * FloatFFT_3D.this.sliceStride + n14;
                                    n31 = 2 * n13;
                                    fArray[n12] = fArray2[n31];
                                    fArray[n12 + 1] = fArray2[n31 + 1];
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n32 = i * FloatFFT_3D.this.rowStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                    int n15;
                                    int n16;
                                    int n17;
                                    int n18;
                                    int n19;
                                    int n20;
                                    for (n20 = 0; n20 < FloatFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * FloatFFT_3D.this.sliceStride + n32 + j;
                                        n18 = 2 * n20;
                                        n17 = 2 * FloatFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * FloatFFT_3D.this.slices;
                                        n15 = n16 + 2 * FloatFFT_3D.this.slices;
                                        fArray2[n18] = fArray[n19];
                                        fArray2[n18 + 1] = fArray[n19 + 1];
                                        fArray2[n17] = fArray[n19 + 2];
                                        fArray2[n17 + 1] = fArray[n19 + 3];
                                        fArray2[n16] = fArray[n19 + 4];
                                        fArray2[n16 + 1] = fArray[n19 + 5];
                                        fArray2[n15] = fArray[n19 + 6];
                                        fArray2[n15 + 1] = fArray[n19 + 7];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 0, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 2 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 4 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 6 * FloatFFT_3D.this.slices, bl);
                                    for (n20 = 0; n20 < FloatFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * FloatFFT_3D.this.sliceStride + n32 + j;
                                        n18 = 2 * n20;
                                        n17 = 2 * FloatFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * FloatFFT_3D.this.slices;
                                        n15 = n16 + 2 * FloatFFT_3D.this.slices;
                                        fArray[n19] = fArray2[n18];
                                        fArray[n19 + 1] = fArray2[n18 + 1];
                                        fArray[n19 + 2] = fArray2[n17];
                                        fArray[n19 + 3] = fArray2[n17 + 1];
                                        fArray[n19 + 4] = fArray2[n16];
                                        fArray[n19 + 5] = fArray2[n16 + 1];
                                        fArray[n19 + 6] = fArray2[n15];
                                        fArray[n19 + 7] = fArray2[n15 + 1];
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n33;
                                int n21;
                                int n22;
                                int n23;
                                int n24 = i * FloatFFT_3D.this.rowStride;
                                for (n23 = 0; n23 < FloatFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * FloatFFT_3D.this.sliceStride + n24;
                                    n21 = 2 * n23;
                                    n33 = 2 * FloatFFT_3D.this.slices + 2 * n23;
                                    fArray2[n21] = fArray[n22];
                                    fArray2[n21 + 1] = fArray[n22 + 1];
                                    fArray2[n33] = fArray[n22 + 2];
                                    fArray2[n33 + 1] = fArray[n22 + 3];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 0, bl);
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 2 * FloatFFT_3D.this.slices, bl);
                                for (n23 = 0; n23 < FloatFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * FloatFFT_3D.this.sliceStride + n24;
                                    n21 = 2 * n23;
                                    n33 = 2 * FloatFFT_3D.this.slices + 2 * n23;
                                    fArray[n22] = fArray2[n21];
                                    fArray[n22 + 1] = fArray2[n21 + 1];
                                    fArray[n22 + 2] = fArray2[n33];
                                    fArray[n22 + 3] = fArray2[n33 + 1];
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n34;
                                int n25;
                                int n26;
                                int n27 = i * FloatFFT_3D.this.rowStride;
                                for (n26 = 0; n26 < FloatFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * FloatFFT_3D.this.sliceStride + n27;
                                    n34 = 2 * n26;
                                    fArray2[n34] = fArray[n25];
                                    fArray2[n34 + 1] = fArray[n25 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 0, bl);
                                for (n26 = 0; n26 < FloatFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * FloatFFT_3D.this.sliceStride + n27;
                                    n34 = 2 * n26;
                                    fArray[n25] = fArray2[n34];
                                    fArray[n25 + 1] = fArray2[n34 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)Math.min((long)ConcurrencyUtils.getNumberOfThreads(), this.rowsl);
        long l = this.slicesl;
        if (l < this.rowsl) {
            l = this.rowsl;
        }
        l *= 8L;
        if (this.columnsl == 4L) {
            l >>= 1;
        } else if (this.columnsl < 4L) {
            l >>= 2;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        FloatLargeArray floatLargeArray2;
                        block25: {
                            block28: {
                                block26: {
                                    floatLargeArray2 = new FloatLargeArray(l2, false);
                                    if (n != -1) break block25;
                                    if (FloatFFT_3D.this.columnsl <= 4L) break block26;
                                    for (long i = l3; i < FloatFFT_3D.this.rowsl; i += (long)n2) {
                                        long l = i * FloatFFT_3D.this.rowStridel;
                                        for (long j = 0L; j < FloatFFT_3D.this.columnsl; j += 8L) {
                                            long l28;
                                            long l32;
                                            long l4;
                                            long l5;
                                            long l6;
                                            long l7;
                                            for (l7 = 0L; l7 < FloatFFT_3D.this.slicesl; ++l7) {
                                                l6 = l7 * FloatFFT_3D.this.sliceStridel + l + j;
                                                l5 = 2L * l7;
                                                l4 = 2L * FloatFFT_3D.this.slicesl + 2L * l7;
                                                l32 = l4 + 2L * FloatFFT_3D.this.slicesl;
                                                l28 = l32 + 2L * FloatFFT_3D.this.slicesl;
                                                floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l6));
                                                floatLargeArray2.setFloat(l5 + 1L, floatLargeArray.getFloat(l6 + 1L));
                                                floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l6 + 2L));
                                                floatLargeArray2.setFloat(l4 + 1L, floatLargeArray.getFloat(l6 + 3L));
                                                floatLargeArray2.setFloat(l32, floatLargeArray.getFloat(l6 + 4L));
                                                floatLargeArray2.setFloat(l32 + 1L, floatLargeArray.getFloat(l6 + 5L));
                                                floatLargeArray2.setFloat(l28, floatLargeArray.getFloat(l6 + 6L));
                                                floatLargeArray2.setFloat(l28 + 1L, floatLargeArray.getFloat(l6 + 7L));
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 0L);
                                            FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 2L * FloatFFT_3D.this.slicesl);
                                            FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 4L * FloatFFT_3D.this.slicesl);
                                            FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 6L * FloatFFT_3D.this.slicesl);
                                            for (l7 = 0L; l7 < FloatFFT_3D.this.slicesl; ++l7) {
                                                l6 = l7 * FloatFFT_3D.this.sliceStridel + l + j;
                                                l5 = 2L * l7;
                                                l4 = 2L * FloatFFT_3D.this.slicesl + 2L * l7;
                                                l32 = l4 + 2L * FloatFFT_3D.this.slicesl;
                                                l28 = l32 + 2L * FloatFFT_3D.this.slicesl;
                                                floatLargeArray.setFloat(l6, floatLargeArray2.getFloat(l5));
                                                floatLargeArray.setFloat(l6 + 1L, floatLargeArray2.getFloat(l5 + 1L));
                                                floatLargeArray.setFloat(l6 + 2L, floatLargeArray2.getFloat(l4));
                                                floatLargeArray.setFloat(l6 + 3L, floatLargeArray2.getFloat(l4 + 1L));
                                                floatLargeArray.setFloat(l6 + 4L, floatLargeArray2.getFloat(l32));
                                                floatLargeArray.setFloat(l6 + 5L, floatLargeArray2.getFloat(l32 + 1L));
                                                floatLargeArray.setFloat(l6 + 6L, floatLargeArray2.getFloat(l28));
                                                floatLargeArray.setFloat(l6 + 7L, floatLargeArray2.getFloat(l28 + 1L));
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columnsl != 4L) break block28;
                                for (long i = l3; i < FloatFFT_3D.this.rowsl; i += (long)n2) {
                                    long l;
                                    long l8;
                                    long l9;
                                    long l10;
                                    long l11 = i * FloatFFT_3D.this.rowStridel;
                                    for (l10 = 0L; l10 < FloatFFT_3D.this.slicesl; ++l10) {
                                        l9 = l10 * FloatFFT_3D.this.sliceStridel + l11;
                                        l8 = 2L * l10;
                                        l = 2L * FloatFFT_3D.this.slicesl + 2L * l10;
                                        floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l9));
                                        floatLargeArray2.setFloat(l8 + 1L, floatLargeArray.getFloat(l9 + 1L));
                                        floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l9 + 2L));
                                        floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l9 + 3L));
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 0L);
                                    FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 2L * FloatFFT_3D.this.slicesl);
                                    for (l10 = 0L; l10 < FloatFFT_3D.this.slicesl; ++l10) {
                                        l9 = l10 * FloatFFT_3D.this.sliceStridel + l11;
                                        l8 = 2L * l10;
                                        l = 2L * FloatFFT_3D.this.slicesl + 2L * l10;
                                        floatLargeArray.setFloat(l9, floatLargeArray2.getFloat(l8));
                                        floatLargeArray.setFloat(l9 + 1L, floatLargeArray2.getFloat(l8 + 1L));
                                        floatLargeArray.setFloat(l9 + 2L, floatLargeArray2.getFloat(l));
                                        floatLargeArray.setFloat(l9 + 3L, floatLargeArray2.getFloat(l + 1L));
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) break block27;
                            for (long i = l3; i < FloatFFT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l12;
                                long l13;
                                long l14 = i * FloatFFT_3D.this.rowStridel;
                                for (l13 = 0L; l13 < FloatFFT_3D.this.slicesl; ++l13) {
                                    l12 = l13 * FloatFFT_3D.this.sliceStridel + l14;
                                    l = 2L * l13;
                                    floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l12));
                                    floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l12 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(floatLargeArray2, 0L);
                                for (l13 = 0L; l13 < FloatFFT_3D.this.slicesl; ++l13) {
                                    l12 = l13 * FloatFFT_3D.this.sliceStridel + l14;
                                    l = 2L * l13;
                                    floatLargeArray.setFloat(l12, floatLargeArray2.getFloat(l));
                                    floatLargeArray.setFloat(l12 + 1L, floatLargeArray2.getFloat(l + 1L));
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columnsl > 4L) {
                            for (long i = l3; i < FloatFFT_3D.this.rowsl; i += (long)n2) {
                                long l = i * FloatFFT_3D.this.rowStridel;
                                for (long j = 0L; j < FloatFFT_3D.this.columnsl; j += 8L) {
                                    long l15;
                                    long l16;
                                    long l17;
                                    long l18;
                                    long l19;
                                    long l20;
                                    for (l20 = 0L; l20 < FloatFFT_3D.this.slicesl; ++l20) {
                                        l19 = l20 * FloatFFT_3D.this.sliceStridel + l + j;
                                        l18 = 2L * l20;
                                        l17 = 2L * FloatFFT_3D.this.slicesl + 2L * l20;
                                        l16 = l17 + 2L * FloatFFT_3D.this.slicesl;
                                        l15 = l16 + 2L * FloatFFT_3D.this.slicesl;
                                        floatLargeArray2.setFloat(l18, floatLargeArray.getFloat(l19));
                                        floatLargeArray2.setFloat(l18 + 1L, floatLargeArray.getFloat(l19 + 1L));
                                        floatLargeArray2.setFloat(l17, floatLargeArray.getFloat(l19 + 2L));
                                        floatLargeArray2.setFloat(l17 + 1L, floatLargeArray.getFloat(l19 + 3L));
                                        floatLargeArray2.setFloat(l16, floatLargeArray.getFloat(l19 + 4L));
                                        floatLargeArray2.setFloat(l16 + 1L, floatLargeArray.getFloat(l19 + 5L));
                                        floatLargeArray2.setFloat(l15, floatLargeArray.getFloat(l19 + 6L));
                                        floatLargeArray2.setFloat(l15 + 1L, floatLargeArray.getFloat(l19 + 7L));
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 0L, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 2L * FloatFFT_3D.this.slicesl, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 4L * FloatFFT_3D.this.slicesl, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 6L * FloatFFT_3D.this.slicesl, bl);
                                    for (l20 = 0L; l20 < FloatFFT_3D.this.slicesl; ++l20) {
                                        l19 = l20 * FloatFFT_3D.this.sliceStridel + l + j;
                                        l18 = 2L * l20;
                                        l17 = 2L * FloatFFT_3D.this.slicesl + 2L * l20;
                                        l16 = l17 + 2L * FloatFFT_3D.this.slicesl;
                                        l15 = l16 + 2L * FloatFFT_3D.this.slicesl;
                                        floatLargeArray.setFloat(l19, floatLargeArray2.getFloat(l18));
                                        floatLargeArray.setFloat(l19 + 1L, floatLargeArray2.getFloat(l18 + 1L));
                                        floatLargeArray.setFloat(l19 + 2L, floatLargeArray2.getFloat(l17));
                                        floatLargeArray.setFloat(l19 + 3L, floatLargeArray2.getFloat(l17 + 1L));
                                        floatLargeArray.setFloat(l19 + 4L, floatLargeArray2.getFloat(l16));
                                        floatLargeArray.setFloat(l19 + 5L, floatLargeArray2.getFloat(l16 + 1L));
                                        floatLargeArray.setFloat(l19 + 6L, floatLargeArray2.getFloat(l15));
                                        floatLargeArray.setFloat(l19 + 7L, floatLargeArray2.getFloat(l15 + 1L));
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columnsl == 4L) {
                            for (long i = l3; i < FloatFFT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l21;
                                long l22;
                                long l23;
                                long l24 = i * FloatFFT_3D.this.rowStridel;
                                for (l23 = 0L; l23 < FloatFFT_3D.this.slicesl; ++l23) {
                                    l22 = l23 * FloatFFT_3D.this.sliceStridel + l24;
                                    l21 = 2L * l23;
                                    l = 2L * FloatFFT_3D.this.slicesl + 2L * l23;
                                    floatLargeArray2.setFloat(l21, floatLargeArray.getFloat(l22));
                                    floatLargeArray2.setFloat(l21 + 1L, floatLargeArray.getFloat(l22 + 1L));
                                    floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l22 + 2L));
                                    floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l22 + 3L));
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 0L, bl);
                                FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 2L * FloatFFT_3D.this.slicesl, bl);
                                for (l23 = 0L; l23 < FloatFFT_3D.this.slicesl; ++l23) {
                                    l22 = l23 * FloatFFT_3D.this.sliceStridel + l24;
                                    l21 = 2L * l23;
                                    l = 2L * FloatFFT_3D.this.slicesl + 2L * l23;
                                    floatLargeArray.setFloat(l22, floatLargeArray2.getFloat(l21));
                                    floatLargeArray.setFloat(l22 + 1L, floatLargeArray2.getFloat(l21 + 1L));
                                    floatLargeArray.setFloat(l22 + 2L, floatLargeArray2.getFloat(l));
                                    floatLargeArray.setFloat(l22 + 3L, floatLargeArray2.getFloat(l + 1L));
                                }
                            }
                        } else if (FloatFFT_3D.this.columnsl == 2L) {
                            for (long i = l3; i < FloatFFT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l25;
                                long l26;
                                long l27 = i * FloatFFT_3D.this.rowStridel;
                                for (l26 = 0L; l26 < FloatFFT_3D.this.slicesl; ++l26) {
                                    l25 = l26 * FloatFFT_3D.this.sliceStridel + l27;
                                    l = 2L * l26;
                                    floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l25));
                                    floatLargeArray2.setFloat(l + 1L, floatLargeArray.getFloat(l25 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(floatLargeArray2, 0L, bl);
                                for (l26 = 0L; l26 < FloatFFT_3D.this.slicesl; ++l26) {
                                    l25 = l26 * FloatFFT_3D.this.sliceStridel + l27;
                                    l = 2L * l26;
                                    floatLargeArray.setFloat(l25, floatLargeArray2.getFloat(l));
                                    floatLargeArray.setFloat(l25 + 1L, floatLargeArray2.getFloat(l + 1L));
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final float[][][] fArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        float[] fArray2;
                        block25: {
                            block28: {
                                block26: {
                                    fArray2 = new float[n4];
                                    if (n != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                        for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                            int n16;
                                            int n22;
                                            int n3;
                                            int n42;
                                            int n52;
                                            for (n52 = 0; n52 < FloatFFT_3D.this.slices; ++n52) {
                                                n42 = 2 * n52;
                                                n3 = 2 * FloatFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * FloatFFT_3D.this.slices;
                                                n16 = n22 + 2 * FloatFFT_3D.this.slices;
                                                fArray2[n42] = fArray[n52][i][j];
                                                fArray2[n42 + 1] = fArray[n52][i][j + 1];
                                                fArray2[n3] = fArray[n52][i][j + 2];
                                                fArray2[n3 + 1] = fArray[n52][i][j + 3];
                                                fArray2[n22] = fArray[n52][i][j + 4];
                                                fArray2[n22 + 1] = fArray[n52][i][j + 5];
                                                fArray2[n16] = fArray[n52][i][j + 6];
                                                fArray2[n16 + 1] = fArray[n52][i][j + 7];
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 0);
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(fArray2, 6 * FloatFFT_3D.this.slices);
                                            for (n52 = 0; n52 < FloatFFT_3D.this.slices; ++n52) {
                                                n42 = 2 * n52;
                                                n3 = 2 * FloatFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * FloatFFT_3D.this.slices;
                                                n16 = n22 + 2 * FloatFFT_3D.this.slices;
                                                fArray[n52][i][j] = fArray2[n42];
                                                fArray[n52][i][j + 1] = fArray2[n42 + 1];
                                                fArray[n52][i][j + 2] = fArray2[n3];
                                                fArray[n52][i][j + 3] = fArray2[n3 + 1];
                                                fArray[n52][i][j + 4] = fArray2[n22];
                                                fArray[n52][i][j + 5] = fArray2[n22 + 1];
                                                fArray[n52][i][j + 6] = fArray2[n16];
                                                fArray[n52][i][j + 7] = fArray2[n16 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                    int n17;
                                    int n6;
                                    int n7;
                                    for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                        n6 = 2 * n7;
                                        n17 = 2 * FloatFFT_3D.this.slices + 2 * n7;
                                        fArray2[n6] = fArray[n7][i][0];
                                        fArray2[n6 + 1] = fArray[n7][i][1];
                                        fArray2[n17] = fArray[n7][i][2];
                                        fArray2[n17 + 1] = fArray[n7][i][3];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(fArray2, 0);
                                    FloatFFT_3D.this.fftSlices.complexForward(fArray2, 2 * FloatFFT_3D.this.slices);
                                    for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                        n6 = 2 * n7;
                                        n17 = 2 * FloatFFT_3D.this.slices + 2 * n7;
                                        fArray[n7][i][0] = fArray2[n6];
                                        fArray[n7][i][1] = fArray2[n6 + 1];
                                        fArray[n7][i][2] = fArray2[n17];
                                        fArray[n7][i][3] = fArray2[n17 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n18;
                                int n8;
                                for (n8 = 0; n8 < FloatFFT_3D.this.slices; ++n8) {
                                    n18 = 2 * n8;
                                    fArray2[n18] = fArray[n8][i][0];
                                    fArray2[n18 + 1] = fArray[n8][i][1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2, 0);
                                for (n8 = 0; n8 < FloatFFT_3D.this.slices; ++n8) {
                                    n18 = 2 * n8;
                                    fArray[n8][i][0] = fArray2[n18];
                                    fArray[n8][i][1] = fArray2[n18 + 1];
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                    int n19;
                                    int n9;
                                    int n10;
                                    int n11;
                                    int n12;
                                    for (n12 = 0; n12 < FloatFFT_3D.this.slices; ++n12) {
                                        n11 = 2 * n12;
                                        n10 = 2 * FloatFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * FloatFFT_3D.this.slices;
                                        n19 = n9 + 2 * FloatFFT_3D.this.slices;
                                        fArray2[n11] = fArray[n12][i][j];
                                        fArray2[n11 + 1] = fArray[n12][i][j + 1];
                                        fArray2[n10] = fArray[n12][i][j + 2];
                                        fArray2[n10 + 1] = fArray[n12][i][j + 3];
                                        fArray2[n9] = fArray[n12][i][j + 4];
                                        fArray2[n9 + 1] = fArray[n12][i][j + 5];
                                        fArray2[n19] = fArray[n12][i][j + 6];
                                        fArray2[n19 + 1] = fArray[n12][i][j + 7];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 0, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 2 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 4 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 6 * FloatFFT_3D.this.slices, bl);
                                    for (n12 = 0; n12 < FloatFFT_3D.this.slices; ++n12) {
                                        n11 = 2 * n12;
                                        n10 = 2 * FloatFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * FloatFFT_3D.this.slices;
                                        n19 = n9 + 2 * FloatFFT_3D.this.slices;
                                        fArray[n12][i][j] = fArray2[n11];
                                        fArray[n12][i][j + 1] = fArray2[n11 + 1];
                                        fArray[n12][i][j + 2] = fArray2[n10];
                                        fArray[n12][i][j + 3] = fArray2[n10 + 1];
                                        fArray[n12][i][j + 4] = fArray2[n9];
                                        fArray[n12][i][j + 5] = fArray2[n9 + 1];
                                        fArray[n12][i][j + 6] = fArray2[n19];
                                        fArray[n12][i][j + 7] = fArray2[n19 + 1];
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n20;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < FloatFFT_3D.this.slices; ++n14) {
                                    n13 = 2 * n14;
                                    n20 = 2 * FloatFFT_3D.this.slices + 2 * n14;
                                    fArray2[n13] = fArray[n14][i][0];
                                    fArray2[n13 + 1] = fArray[n14][i][1];
                                    fArray2[n20] = fArray[n14][i][2];
                                    fArray2[n20 + 1] = fArray[n14][i][3];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 0, bl);
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 2 * FloatFFT_3D.this.slices, bl);
                                for (n14 = 0; n14 < FloatFFT_3D.this.slices; ++n14) {
                                    n13 = 2 * n14;
                                    n20 = 2 * FloatFFT_3D.this.slices + 2 * n14;
                                    fArray[n14][i][0] = fArray2[n13];
                                    fArray[n14][i][1] = fArray2[n13 + 1];
                                    fArray[n14][i][2] = fArray2[n20];
                                    fArray[n14][i][3] = fArray2[n20 + 1];
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            for (int i = n5; i < FloatFFT_3D.this.rows; i += n2) {
                                int n21;
                                int n15;
                                for (n15 = 0; n15 < FloatFFT_3D.this.slices; ++n15) {
                                    n21 = 2 * n15;
                                    fArray2[n21] = fArray[n15][i][0];
                                    fArray2[n21 + 1] = fArray[n15][i][1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, 0, bl);
                                for (n15 = 0; n15 < FloatFFT_3D.this.slices; ++n15) {
                                    n21 = 2 * n15;
                                    fArray[n15][i][0] = fArray2[n21];
                                    fArray[n15][i][1] = fArray2[n21 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void rdft3d_sub(int n, float[] fArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            float f;
            int n6;
            int n7;
            int n8;
            int n9;
            for (int i = 1; i < n2; ++i) {
                int n10 = this.slices - i;
                n9 = i * this.sliceStride;
                n8 = n10 * this.sliceStride;
                n7 = i * this.sliceStride + n3 * this.rowStride;
                n6 = n10 * this.sliceStride + n3 * this.rowStride;
                f = fArray[n9] - fArray[n8];
                int n11 = n9;
                fArray[n11] = fArray[n11] + fArray[n8];
                fArray[n8] = f;
                f = fArray[n8 + 1] - fArray[n9 + 1];
                int n12 = n9 + 1;
                fArray[n12] = fArray[n12] + fArray[n8 + 1];
                fArray[n8 + 1] = f;
                f = fArray[n7] - fArray[n6];
                int n13 = n7;
                fArray[n13] = fArray[n13] + fArray[n6];
                fArray[n6] = f;
                f = fArray[n6 + 1] - fArray[n7 + 1];
                int n14 = n7 + 1;
                fArray[n14] = fArray[n14] + fArray[n6 + 1];
                fArray[n6 + 1] = f;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    n9 = i * this.sliceStride + n5 * this.rowStride;
                    n8 = n10 * this.sliceStride + n4 * this.rowStride;
                    f = fArray[n9] - fArray[n8];
                    int n15 = n9;
                    fArray[n15] = fArray[n15] + fArray[n8];
                    fArray[n8] = f;
                    f = fArray[n8 + 1] - fArray[n9 + 1];
                    int n16 = n9 + 1;
                    fArray[n16] = fArray[n16] + fArray[n8 + 1];
                    fArray[n8 + 1] = f;
                    n7 = n10 * this.sliceStride + n5 * this.rowStride;
                    n6 = i * this.sliceStride + n4 * this.rowStride;
                    f = fArray[n7] - fArray[n6];
                    int n17 = n7;
                    fArray[n17] = fArray[n17] + fArray[n6];
                    fArray[n6] = f;
                    f = fArray[n6 + 1] - fArray[n7 + 1];
                    int n18 = n7 + 1;
                    fArray[n18] = fArray[n18] + fArray[n6 + 1];
                    fArray[n6 + 1] = f;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                n9 = n5 * this.rowStride;
                n8 = n4 * this.rowStride;
                f = fArray[n9] - fArray[n8];
                int n19 = n9;
                fArray[n19] = fArray[n19] + fArray[n8];
                fArray[n8] = f;
                f = fArray[n8 + 1] - fArray[n9 + 1];
                int n20 = n9 + 1;
                fArray[n20] = fArray[n20] + fArray[n8 + 1];
                fArray[n8 + 1] = f;
                n7 = n2 * this.sliceStride + n5 * this.rowStride;
                n6 = n2 * this.sliceStride + n4 * this.rowStride;
                f = fArray[n7] - fArray[n6];
                int n21 = n7;
                fArray[n21] = fArray[n21] + fArray[n6];
                fArray[n6] = f;
                f = fArray[n6 + 1] - fArray[n7 + 1];
                int n22 = n7 + 1;
                fArray[n22] = fArray[n22] + fArray[n6 + 1];
                fArray[n6 + 1] = f;
            }
        } else {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            for (int i = 1; i < n2; ++i) {
                int n29 = this.slices - i;
                n28 = n29 * this.sliceStride;
                n27 = i * this.sliceStride;
                fArray[n28] = 0.5f * (fArray[n27] - fArray[n28]);
                int n30 = n27;
                fArray[n30] = fArray[n30] - fArray[n28];
                fArray[n28 + 1] = 0.5f * (fArray[n27 + 1] + fArray[n28 + 1]);
                int n31 = n27 + 1;
                fArray[n31] = fArray[n31] - fArray[n28 + 1];
                n26 = n29 * this.sliceStride + n3 * this.rowStride;
                n25 = i * this.sliceStride + n3 * this.rowStride;
                fArray[n26] = 0.5f * (fArray[n25] - fArray[n26]);
                int n32 = n25;
                fArray[n32] = fArray[n32] - fArray[n26];
                fArray[n26 + 1] = 0.5f * (fArray[n25 + 1] + fArray[n26 + 1]);
                int n33 = n25 + 1;
                fArray[n33] = fArray[n33] - fArray[n26 + 1];
                for (n24 = 1; n24 < n3; ++n24) {
                    n23 = this.rows - n24;
                    n28 = n29 * this.sliceStride + n23 * this.rowStride;
                    n27 = i * this.sliceStride + n24 * this.rowStride;
                    fArray[n28] = 0.5f * (fArray[n27] - fArray[n28]);
                    int n34 = n27;
                    fArray[n34] = fArray[n34] - fArray[n28];
                    fArray[n28 + 1] = 0.5f * (fArray[n27 + 1] + fArray[n28 + 1]);
                    int n35 = n27 + 1;
                    fArray[n35] = fArray[n35] - fArray[n28 + 1];
                    n26 = i * this.sliceStride + n23 * this.rowStride;
                    n25 = n29 * this.sliceStride + n24 * this.rowStride;
                    fArray[n26] = 0.5f * (fArray[n25] - fArray[n26]);
                    int n36 = n25;
                    fArray[n36] = fArray[n36] - fArray[n26];
                    fArray[n26 + 1] = 0.5f * (fArray[n25 + 1] + fArray[n26 + 1]);
                    int n37 = n25 + 1;
                    fArray[n37] = fArray[n37] - fArray[n26 + 1];
                }
            }
            for (n24 = 1; n24 < n3; ++n24) {
                n23 = this.rows - n24;
                n28 = n23 * this.rowStride;
                n27 = n24 * this.rowStride;
                fArray[n28] = 0.5f * (fArray[n27] - fArray[n28]);
                int n38 = n27;
                fArray[n38] = fArray[n38] - fArray[n28];
                fArray[n28 + 1] = 0.5f * (fArray[n27 + 1] + fArray[n28 + 1]);
                int n39 = n27 + 1;
                fArray[n39] = fArray[n39] - fArray[n28 + 1];
                n26 = n2 * this.sliceStride + n23 * this.rowStride;
                n25 = n2 * this.sliceStride + n24 * this.rowStride;
                fArray[n26] = 0.5f * (fArray[n25] - fArray[n26]);
                int n40 = n25;
                fArray[n40] = fArray[n40] - fArray[n26];
                fArray[n26 + 1] = 0.5f * (fArray[n25 + 1] + fArray[n26 + 1]);
                int n41 = n25 + 1;
                fArray[n41] = fArray[n41] - fArray[n26 + 1];
            }
        }
    }

    private void rdft3d_sub(int n, FloatLargeArray floatLargeArray) {
        long l = this.slicesl >> 1;
        long l2 = this.rowsl >> 1;
        if (n < 0) {
            long l3;
            long l4;
            float f;
            long l5;
            long l6;
            long l7;
            long l8;
            for (long i = 1L; i < l; ++i) {
                long l9 = this.slicesl - i;
                l8 = i * this.sliceStridel;
                l7 = l9 * this.sliceStridel;
                l6 = i * this.sliceStridel + l2 * this.rowStridel;
                l5 = l9 * this.sliceStridel + l2 * this.rowStridel;
                f = floatLargeArray.getFloat(l8) - floatLargeArray.getFloat(l7);
                floatLargeArray.setFloat(l8, floatLargeArray.getFloat(l8) + floatLargeArray.getFloat(l7));
                floatLargeArray.setFloat(l7, f);
                f = floatLargeArray.getFloat(l7 + 1L) - floatLargeArray.getFloat(l8 + 1L);
                floatLargeArray.setFloat(l8 + 1L, floatLargeArray.getFloat(l8 + 1L) + floatLargeArray.getFloat(l7 + 1L));
                floatLargeArray.setFloat(l7 + 1L, f);
                f = floatLargeArray.getFloat(l6) - floatLargeArray.getFloat(l5);
                floatLargeArray.setFloat(l6, floatLargeArray.getFloat(l6) + floatLargeArray.getFloat(l5));
                floatLargeArray.setFloat(l5, f);
                f = floatLargeArray.getFloat(l5 + 1L) - floatLargeArray.getFloat(l6 + 1L);
                floatLargeArray.setFloat(l6 + 1L, floatLargeArray.getFloat(l6 + 1L) + floatLargeArray.getFloat(l5 + 1L));
                floatLargeArray.setFloat(l5 + 1L, f);
                for (l4 = 1L; l4 < l2; ++l4) {
                    l3 = this.rowsl - l4;
                    l8 = i * this.sliceStridel + l4 * this.rowStridel;
                    l7 = l9 * this.sliceStridel + l3 * this.rowStridel;
                    f = floatLargeArray.getFloat(l8) - floatLargeArray.getFloat(l7);
                    floatLargeArray.setFloat(l8, floatLargeArray.getFloat(l8) + floatLargeArray.getFloat(l7));
                    floatLargeArray.setFloat(l7, f);
                    f = floatLargeArray.getFloat(l7 + 1L) - floatLargeArray.getFloat(l8 + 1L);
                    floatLargeArray.setFloat(l8 + 1L, floatLargeArray.getFloat(l8 + 1L) + floatLargeArray.getFloat(l7 + 1L));
                    floatLargeArray.setFloat(l7 + 1L, f);
                    l6 = l9 * this.sliceStridel + l4 * this.rowStridel;
                    l5 = i * this.sliceStridel + l3 * this.rowStridel;
                    f = floatLargeArray.getFloat(l6) - floatLargeArray.getFloat(l5);
                    floatLargeArray.setFloat(l6, floatLargeArray.getFloat(l6) + floatLargeArray.getFloat(l5));
                    floatLargeArray.setFloat(l5, f);
                    f = floatLargeArray.getFloat(l5 + 1L) - floatLargeArray.getFloat(l6 + 1L);
                    floatLargeArray.setFloat(l6 + 1L, floatLargeArray.getFloat(l6 + 1L) + floatLargeArray.getFloat(l5 + 1L));
                    floatLargeArray.setFloat(l5 + 1L, f);
                }
            }
            for (l4 = 1L; l4 < l2; ++l4) {
                l3 = this.rowsl - l4;
                l8 = l4 * this.rowStridel;
                l7 = l3 * this.rowStridel;
                f = floatLargeArray.getFloat(l8) - floatLargeArray.getFloat(l7);
                floatLargeArray.setFloat(l8, floatLargeArray.getFloat(l8) + floatLargeArray.getFloat(l7));
                floatLargeArray.setFloat(l7, f);
                f = floatLargeArray.getFloat(l7 + 1L) - floatLargeArray.getFloat(l8 + 1L);
                floatLargeArray.setFloat(l8 + 1L, floatLargeArray.getFloat(l8 + 1L) + floatLargeArray.getFloat(l7 + 1L));
                floatLargeArray.setFloat(l7 + 1L, f);
                l6 = l * this.sliceStridel + l4 * this.rowStridel;
                l5 = l * this.sliceStridel + l3 * this.rowStridel;
                f = floatLargeArray.getFloat(l6) - floatLargeArray.getFloat(l5);
                floatLargeArray.setFloat(l6, floatLargeArray.getFloat(l6) + floatLargeArray.getFloat(l5));
                floatLargeArray.setFloat(l5, f);
                f = floatLargeArray.getFloat(l5 + 1L) - floatLargeArray.getFloat(l6 + 1L);
                floatLargeArray.setFloat(l6 + 1L, floatLargeArray.getFloat(l6 + 1L) + floatLargeArray.getFloat(l5 + 1L));
                floatLargeArray.setFloat(l5 + 1L, f);
            }
        } else {
            long l10;
            long l11;
            long l12;
            long l13;
            long l14;
            long l15;
            for (long i = 1L; i < l; ++i) {
                long l16 = this.slicesl - i;
                l15 = l16 * this.sliceStridel;
                l14 = i * this.sliceStridel;
                floatLargeArray.setFloat(l15, 0.5f * (floatLargeArray.getFloat(l14) - floatLargeArray.getFloat(l15)));
                floatLargeArray.setFloat(l14, floatLargeArray.getFloat(l14) - floatLargeArray.getFloat(l15));
                floatLargeArray.setFloat(l15 + 1L, 0.5f * (floatLargeArray.getFloat(l14 + 1L) + floatLargeArray.getFloat(l15 + 1L)));
                floatLargeArray.setFloat(l14 + 1L, floatLargeArray.getFloat(l14 + 1L) - floatLargeArray.getFloat(l15 + 1L));
                l13 = l16 * this.sliceStridel + l2 * this.rowStridel;
                l12 = i * this.sliceStridel + l2 * this.rowStridel;
                floatLargeArray.setFloat(l13, 0.5f * (floatLargeArray.getFloat(l12) - floatLargeArray.getFloat(l13)));
                floatLargeArray.setFloat(l12, floatLargeArray.getFloat(l12) - floatLargeArray.getFloat(l13));
                floatLargeArray.setFloat(l13 + 1L, 0.5f * (floatLargeArray.getFloat(l12 + 1L) + floatLargeArray.getFloat(l13 + 1L)));
                floatLargeArray.setFloat(l12 + 1L, floatLargeArray.getFloat(l12 + 1L) - floatLargeArray.getFloat(l13 + 1L));
                for (l11 = 1L; l11 < l2; ++l11) {
                    l10 = this.rowsl - l11;
                    l15 = l16 * this.sliceStridel + l10 * this.rowStridel;
                    l14 = i * this.sliceStridel + l11 * this.rowStridel;
                    floatLargeArray.setFloat(l15, 0.5f * (floatLargeArray.getFloat(l14) - floatLargeArray.getFloat(l15)));
                    floatLargeArray.setFloat(l14, floatLargeArray.getFloat(l14) - floatLargeArray.getFloat(l15));
                    floatLargeArray.setFloat(l15 + 1L, 0.5f * (floatLargeArray.getFloat(l14 + 1L) + floatLargeArray.getFloat(l15 + 1L)));
                    floatLargeArray.setFloat(l14 + 1L, floatLargeArray.getFloat(l14 + 1L) - floatLargeArray.getFloat(l15 + 1L));
                    l13 = i * this.sliceStridel + l10 * this.rowStridel;
                    l12 = l16 * this.sliceStridel + l11 * this.rowStridel;
                    floatLargeArray.setFloat(l13, 0.5f * (floatLargeArray.getFloat(l12) - floatLargeArray.getFloat(l13)));
                    floatLargeArray.setFloat(l12, floatLargeArray.getFloat(l12) - floatLargeArray.getFloat(l13));
                    floatLargeArray.setFloat(l13 + 1L, 0.5f * (floatLargeArray.getFloat(l12 + 1L) + floatLargeArray.getFloat(l13 + 1L)));
                    floatLargeArray.setFloat(l12 + 1L, floatLargeArray.getFloat(l12 + 1L) - floatLargeArray.getFloat(l13 + 1L));
                }
            }
            for (l11 = 1L; l11 < l2; ++l11) {
                l10 = this.rowsl - l11;
                l15 = l10 * this.rowStridel;
                l14 = l11 * this.rowStridel;
                floatLargeArray.setFloat(l15, 0.5f * (floatLargeArray.getFloat(l14) - floatLargeArray.getFloat(l15)));
                floatLargeArray.setFloat(l14, floatLargeArray.getFloat(l14) - floatLargeArray.getFloat(l15));
                floatLargeArray.setFloat(l15 + 1L, 0.5f * (floatLargeArray.getFloat(l14 + 1L) + floatLargeArray.getFloat(l15 + 1L)));
                floatLargeArray.setFloat(l14 + 1L, floatLargeArray.getFloat(l14 + 1L) - floatLargeArray.getFloat(l15 + 1L));
                l13 = l * this.sliceStridel + l10 * this.rowStridel;
                l12 = l * this.sliceStridel + l11 * this.rowStridel;
                floatLargeArray.setFloat(l13, 0.5f * (floatLargeArray.getFloat(l12) - floatLargeArray.getFloat(l13)));
                floatLargeArray.setFloat(l12, floatLargeArray.getFloat(l12) - floatLargeArray.getFloat(l13));
                floatLargeArray.setFloat(l13 + 1L, 0.5f * (floatLargeArray.getFloat(l12 + 1L) + floatLargeArray.getFloat(l13 + 1L)));
                floatLargeArray.setFloat(l12 + 1L, floatLargeArray.getFloat(l12 + 1L) - floatLargeArray.getFloat(l13 + 1L));
            }
        }
    }

    private void rdft3d_sub(int n, float[][][] fArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            float f;
            for (int i = 1; i < n2; ++i) {
                int n6 = this.slices - i;
                f = fArray[i][0][0] - fArray[n6][0][0];
                float[] fArray2 = fArray[i][0];
                fArray2[0] = fArray2[0] + fArray[n6][0][0];
                fArray[n6][0][0] = f;
                f = fArray[n6][0][1] - fArray[i][0][1];
                float[] fArray3 = fArray[i][0];
                fArray3[1] = fArray3[1] + fArray[n6][0][1];
                fArray[n6][0][1] = f;
                f = fArray[i][n3][0] - fArray[n6][n3][0];
                float[] fArray4 = fArray[i][n3];
                fArray4[0] = fArray4[0] + fArray[n6][n3][0];
                fArray[n6][n3][0] = f;
                f = fArray[n6][n3][1] - fArray[i][n3][1];
                float[] fArray5 = fArray[i][n3];
                fArray5[1] = fArray5[1] + fArray[n6][n3][1];
                fArray[n6][n3][1] = f;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    f = fArray[i][n5][0] - fArray[n6][n4][0];
                    float[] fArray6 = fArray[i][n5];
                    fArray6[0] = fArray6[0] + fArray[n6][n4][0];
                    fArray[n6][n4][0] = f;
                    f = fArray[n6][n4][1] - fArray[i][n5][1];
                    float[] fArray7 = fArray[i][n5];
                    fArray7[1] = fArray7[1] + fArray[n6][n4][1];
                    fArray[n6][n4][1] = f;
                    f = fArray[n6][n5][0] - fArray[i][n4][0];
                    float[] fArray8 = fArray[n6][n5];
                    fArray8[0] = fArray8[0] + fArray[i][n4][0];
                    fArray[i][n4][0] = f;
                    f = fArray[i][n4][1] - fArray[n6][n5][1];
                    float[] fArray9 = fArray[n6][n5];
                    fArray9[1] = fArray9[1] + fArray[i][n4][1];
                    fArray[i][n4][1] = f;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                f = fArray[0][n5][0] - fArray[0][n4][0];
                float[] fArray10 = fArray[0][n5];
                fArray10[0] = fArray10[0] + fArray[0][n4][0];
                fArray[0][n4][0] = f;
                f = fArray[0][n4][1] - fArray[0][n5][1];
                float[] fArray11 = fArray[0][n5];
                fArray11[1] = fArray11[1] + fArray[0][n4][1];
                fArray[0][n4][1] = f;
                f = fArray[n2][n5][0] - fArray[n2][n4][0];
                float[] fArray12 = fArray[n2][n5];
                fArray12[0] = fArray12[0] + fArray[n2][n4][0];
                fArray[n2][n4][0] = f;
                f = fArray[n2][n4][1] - fArray[n2][n5][1];
                float[] fArray13 = fArray[n2][n5];
                fArray13[1] = fArray13[1] + fArray[n2][n4][1];
                fArray[n2][n4][1] = f;
            }
        } else {
            int n7;
            int n8;
            for (int i = 1; i < n2; ++i) {
                int n9 = this.slices - i;
                fArray[n9][0][0] = 0.5f * (fArray[i][0][0] - fArray[n9][0][0]);
                float[] fArray14 = fArray[i][0];
                fArray14[0] = fArray14[0] - fArray[n9][0][0];
                fArray[n9][0][1] = 0.5f * (fArray[i][0][1] + fArray[n9][0][1]);
                float[] fArray15 = fArray[i][0];
                fArray15[1] = fArray15[1] - fArray[n9][0][1];
                fArray[n9][n3][0] = 0.5f * (fArray[i][n3][0] - fArray[n9][n3][0]);
                float[] fArray16 = fArray[i][n3];
                fArray16[0] = fArray16[0] - fArray[n9][n3][0];
                fArray[n9][n3][1] = 0.5f * (fArray[i][n3][1] + fArray[n9][n3][1]);
                float[] fArray17 = fArray[i][n3];
                fArray17[1] = fArray17[1] - fArray[n9][n3][1];
                for (n8 = 1; n8 < n3; ++n8) {
                    n7 = this.rows - n8;
                    fArray[n9][n7][0] = 0.5f * (fArray[i][n8][0] - fArray[n9][n7][0]);
                    float[] fArray18 = fArray[i][n8];
                    fArray18[0] = fArray18[0] - fArray[n9][n7][0];
                    fArray[n9][n7][1] = 0.5f * (fArray[i][n8][1] + fArray[n9][n7][1]);
                    float[] fArray19 = fArray[i][n8];
                    fArray19[1] = fArray19[1] - fArray[n9][n7][1];
                    fArray[i][n7][0] = 0.5f * (fArray[n9][n8][0] - fArray[i][n7][0]);
                    float[] fArray20 = fArray[n9][n8];
                    fArray20[0] = fArray20[0] - fArray[i][n7][0];
                    fArray[i][n7][1] = 0.5f * (fArray[n9][n8][1] + fArray[i][n7][1]);
                    float[] fArray21 = fArray[n9][n8];
                    fArray21[1] = fArray21[1] - fArray[i][n7][1];
                }
            }
            for (n8 = 1; n8 < n3; ++n8) {
                n7 = this.rows - n8;
                fArray[0][n7][0] = 0.5f * (fArray[0][n8][0] - fArray[0][n7][0]);
                float[] fArray22 = fArray[0][n8];
                fArray22[0] = fArray22[0] - fArray[0][n7][0];
                fArray[0][n7][1] = 0.5f * (fArray[0][n8][1] + fArray[0][n7][1]);
                float[] fArray23 = fArray[0][n8];
                fArray23[1] = fArray23[1] - fArray[0][n7][1];
                fArray[n2][n7][0] = 0.5f * (fArray[n2][n8][0] - fArray[n2][n7][0]);
                float[] fArray24 = fArray[n2][n8];
                fArray24[0] = fArray24[0] - fArray[n2][n7][0];
                fArray[n2][n7][1] = 0.5f * (fArray[n2][n8][1] + fArray[n2][n7][1]);
                float[] fArray25 = fArray[n2][n8];
                fArray25[1] = fArray25[1] - fArray[n2][n7][1];
            }
        }
    }

    private void fillSymmetric(final float[][][] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        final int n5 = 2 * this.columns;
        final int n6 = this.rows / 2;
        int n7 = this.slices / 2;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.useThreads && this.slices >= n8) {
            Future[] futureArray = new Future[n8];
            n4 = this.slices / n8;
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n4 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                int n22 = (FloatFFT_3D.this.rows - j) % FloatFFT_3D.this.rows;
                                for (int k = 1; k < FloatFFT_3D.this.columns; k += 2) {
                                    int n3 = n5 - k;
                                    fArray[n4][n22][n3] = -fArray[i][j][k + 2];
                                    fArray[n4][n22][n3 - 1] = fArray[i][j][k + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                fArray[n3][j][((FloatFFT_3D)FloatFFT_3D.this).columns] = fArray[i][n22][1];
                                fArray[i][n22][((FloatFFT_3D)FloatFFT_3D.this).columns] = fArray[i][n22][1];
                                fArray[n3][j][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = -fArray[i][n22][0];
                                fArray[i][n22][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = fArray[i][n22][0];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                fArray[n3][n22][0] = fArray[i][j][0];
                                fArray[n3][n22][1] = -fArray[i][j][1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = (this.rows - n3) % this.rows;
                    for (n = 1; n < this.columns; n += 2) {
                        int n10 = n5 - n;
                        fArray[n4][n2][n10] = -fArray[n9][n3][n + 2];
                        fArray[n4][n2][n10 - 1] = fArray[n9][n3][n + 1];
                    }
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    fArray[n4][n3][this.columns] = fArray[n9][n2][1];
                    fArray[n9][n2][this.columns] = fArray[n9][n2][1];
                    fArray[n4][n3][this.columns + 1] = -fArray[n9][n2][0];
                    fArray[n9][n2][this.columns + 1] = fArray[n9][n2][0];
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    fArray[n4][n2][0] = fArray[n9][n3][0];
                    fArray[n4][n2][1] = -fArray[n9][n3][1];
                }
            }
        }
        for (int i = 1; i < n7; ++i) {
            n4 = this.slices - i;
            fArray[i][0][this.columns] = fArray[n4][0][1];
            fArray[n4][0][this.columns] = fArray[n4][0][1];
            fArray[i][0][this.columns + 1] = -fArray[n4][0][0];
            fArray[n4][0][this.columns + 1] = fArray[n4][0][0];
            fArray[i][n6][this.columns] = fArray[n4][n6][1];
            fArray[n4][n6][this.columns] = fArray[n4][n6][1];
            fArray[i][n6][this.columns + 1] = -fArray[n4][n6][0];
            fArray[n4][n6][this.columns + 1] = fArray[n4][n6][0];
            fArray[n4][0][0] = fArray[i][0][0];
            fArray[n4][0][1] = -fArray[i][0][1];
            fArray[n4][n6][0] = fArray[i][n6][0];
            fArray[n4][n6][1] = -fArray[i][n6][1];
        }
        fArray[0][0][this.columns] = fArray[0][0][1];
        fArray[0][0][1] = 0.0f;
        fArray[0][n6][this.columns] = fArray[0][n6][1];
        fArray[0][n6][1] = 0.0f;
        fArray[n7][0][this.columns] = fArray[n7][0][1];
        fArray[n7][0][1] = 0.0f;
        fArray[n7][n6][this.columns] = fArray[n7][n6][1];
        fArray[n7][n6][1] = 0.0f;
        fArray[n7][0][this.columns + 1] = 0.0f;
        fArray[n7][n6][this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        final int n11 = 2 * this.columns;
        final int n12 = this.rows / 2;
        int n13 = this.slices / 2;
        final int n14 = this.rows * n11;
        final int n15 = n11;
        for (n10 = this.slices - 1; n10 >= 1; --n10) {
            n9 = n10 * this.sliceStride;
            n8 = 2 * n9;
            for (n7 = 0; n7 < this.rows; ++n7) {
                n6 = n7 * this.rowStride;
                n5 = 2 * n6;
                for (n4 = 0; n4 < this.columns; n4 += 2) {
                    n3 = n9 + n6 + n4;
                    n2 = n8 + n5 + n4;
                    fArray[n2] = fArray[n3];
                    fArray[n3] = 0.0f;
                    fArray[++n2] = fArray[++n3];
                    fArray[n3] = 0.0f;
                }
            }
        }
        for (n10 = 1; n10 < this.rows; ++n10) {
            n9 = (this.rows - n10) * this.rowStride;
            n8 = (this.rows - n10) * n15;
            for (n7 = 0; n7 < this.columns; n7 += 2) {
                n3 = n9 + n7;
                n2 = n8 + n7;
                fArray[n2] = fArray[n3];
                fArray[n3] = 0.0f;
                fArray[++n2] = fArray[++n3];
                fArray[n3] = 0.0f;
            }
        }
        n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.useThreads && this.slices >= n10) {
            int n16;
            int n17;
            Future[] futureArray = new Future[n10];
            n4 = this.slices / n10;
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                int n3 = (FloatFFT_3D.this.rows - j) % FloatFFT_3D.this.rows * n15;
                                int n4 = j * n15;
                                for (int k = 1; k < FloatFFT_3D.this.columns; k += 2) {
                                    int n5 = n + n3 + n11 - k;
                                    int n6 = n2 + n4 + k;
                                    fArray[n5] = -fArray[n6 + 2];
                                    fArray[n5 - 1] = fArray[n6 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n2 + (FloatFFT_3D.this.rows - j) * n15;
                                int n4 = n + j * n15 + FloatFFT_3D.this.columns;
                                int n5 = n3 + FloatFFT_3D.this.columns;
                                int n6 = n3 + 1;
                                fArray[n4] = fArray[n6];
                                fArray[n5] = fArray[n6];
                                fArray[n4 + 1] = -fArray[n3];
                                fArray[n5 + 1] = fArray[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n + (FloatFFT_3D.this.rows - j) * n15;
                                int n4 = n2 + j * n15;
                                fArray[n3] = fArray[n4];
                                fArray[n3 + 1] = -fArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n6 = n7 * n14;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n8 = (this.rows - n4) % this.rows * n15;
                    n5 = n4 * n15;
                    for (n = 1; n < this.columns; n += 2) {
                        n3 = n9 + n8 + n11 - n;
                        n2 = n6 + n5 + n;
                        fArray[n3] = -fArray[n2 + 2];
                        fArray[n3 - 1] = fArray[n2 + 1];
                    }
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n6 = (this.slices - n7) % this.slices * n14;
                n5 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n8 = n5 + (this.rows - n4) * n15;
                    n3 = n6 + n4 * n15 + this.columns;
                    n2 = n8 + this.columns;
                    n9 = n8 + 1;
                    fArray[n3] = fArray[n9];
                    fArray[n2] = fArray[n9];
                    fArray[n3 + 1] = -fArray[n8];
                    fArray[n2 + 1] = fArray[n8];
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n8 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n3 = n9 + (this.rows - n4) * n15;
                    n2 = n8 + n4 * n15;
                    fArray[n3] = fArray[n2];
                    fArray[n3 + 1] = -fArray[n2 + 1];
                }
            }
        }
        for (int i = 1; i < n13; ++i) {
            n3 = i * n14;
            n2 = (this.slices - i) * n14;
            n9 = n12 * n15;
            n8 = n3 + n9;
            n6 = n2 + n9;
            fArray[n3 + this.columns] = fArray[n2 + 1];
            fArray[n2 + this.columns] = fArray[n2 + 1];
            fArray[n3 + this.columns + 1] = -fArray[n2];
            fArray[n2 + this.columns + 1] = fArray[n2];
            fArray[n8 + this.columns] = fArray[n6 + 1];
            fArray[n6 + this.columns] = fArray[n6 + 1];
            fArray[n8 + this.columns + 1] = -fArray[n6];
            fArray[n6 + this.columns + 1] = fArray[n6];
            fArray[n2] = fArray[n3];
            fArray[n2 + 1] = -fArray[n3 + 1];
            fArray[n6] = fArray[n8];
            fArray[n6 + 1] = -fArray[n8 + 1];
        }
        fArray[this.columns] = fArray[1];
        fArray[1] = 0.0f;
        n3 = n12 * n15;
        n2 = n13 * n14;
        n9 = n3 + n2;
        fArray[n3 + this.columns] = fArray[n3 + 1];
        fArray[n3 + 1] = 0.0f;
        fArray[n2 + this.columns] = fArray[n2 + 1];
        fArray[n2 + 1] = 0.0f;
        fArray[n9 + this.columns] = fArray[n9 + 1];
        fArray[n9 + 1] = 0.0f;
        fArray[n2 + this.columns + 1] = 0.0f;
        fArray[n9 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final FloatLargeArray floatLargeArray) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        final long l10 = 2L * this.columnsl;
        final long l11 = this.rowsl / 2L;
        long l12 = this.slicesl / 2L;
        final long l13 = this.rowsl * l10;
        final long l14 = l10;
        for (l9 = this.slicesl - 1L; l9 >= 1L; --l9) {
            l8 = l9 * this.sliceStridel;
            l7 = 2L * l8;
            for (l6 = 0L; l6 < this.rowsl; ++l6) {
                l5 = l6 * this.rowStridel;
                l4 = 2L * l5;
                for (long i = 0L; i < this.columnsl; i += 2L) {
                    l3 = l8 + l5 + i;
                    l2 = l7 + l4 + i;
                    floatLargeArray.setFloat(l2, floatLargeArray.getFloat(l3));
                    floatLargeArray.setFloat(l3, 0.0f);
                    floatLargeArray.setFloat(++l2, floatLargeArray.getFloat(++l3));
                    floatLargeArray.setFloat(l3, 0.0f);
                }
            }
        }
        for (l9 = 1L; l9 < this.rowsl; ++l9) {
            l8 = (this.rowsl - l9) * this.rowStridel;
            l7 = (this.rowsl - l9) * l14;
            for (l6 = 0L; l6 < this.columnsl; l6 += 2L) {
                l3 = l8 + l6;
                l2 = l7 + l6;
                floatLargeArray.setFloat(l2, floatLargeArray.getFloat(l3));
                floatLargeArray.setFloat(l3, 0.0f);
                floatLargeArray.setFloat(++l2, floatLargeArray.getFloat(++l3));
                floatLargeArray.setFloat(l3, 0.0f);
            }
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && this.slicesl >= (long)n) {
            long l15;
            int n2;
            Future[] futureArray = new Future[n];
            l6 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l = (long)n2 * l6;
                l15 = n2 == n - 1 ? this.slicesl : l + l6;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l; i < l15; ++i) {
                            long l7 = (FloatFFT_3D.this.slicesl - i) % FloatFFT_3D.this.slicesl * l13;
                            long l2 = i * l13;
                            for (long j = 0L; j < FloatFFT_3D.this.rowsl; ++j) {
                                long l3 = (FloatFFT_3D.this.rowsl - j) % FloatFFT_3D.this.rowsl * l14;
                                long l4 = j * l14;
                                for (long k = 1L; k < FloatFFT_3D.this.columnsl; k += 2L) {
                                    long l5 = l7 + l3 + l10 - k;
                                    long l6 = l2 + l4 + k;
                                    floatLargeArray.setFloat(l5, -floatLargeArray.getFloat(l6 + 2L));
                                    floatLargeArray.setFloat(l5 - 1L, floatLargeArray.getFloat(l6 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l = (long)n2 * l6;
                l15 = n2 == n - 1 ? this.slicesl : l + l6;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l; i < l15; ++i) {
                            long l7 = (FloatFFT_3D.this.slicesl - i) % FloatFFT_3D.this.slicesl * l13;
                            long l2 = i * l13;
                            for (long j = 1L; j < l11; ++j) {
                                long l3 = l2 + (FloatFFT_3D.this.rowsl - j) * l14;
                                long l4 = l7 + j * l14 + FloatFFT_3D.this.columnsl;
                                long l5 = l3 + FloatFFT_3D.this.columnsl;
                                long l6 = l3 + 1L;
                                floatLargeArray.setFloat(l4, floatLargeArray.getFloat(l6));
                                floatLargeArray.setFloat(l5, floatLargeArray.getFloat(l6));
                                floatLargeArray.setFloat(l4 + 1L, -floatLargeArray.getFloat(l3));
                                floatLargeArray.setFloat(l5 + 1L, floatLargeArray.getFloat(l3));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l = (long)n2 * l6;
                l15 = n2 == n - 1 ? this.slicesl : l + l6;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l; i < l15; ++i) {
                            long l5 = (FloatFFT_3D.this.slicesl - i) % FloatFFT_3D.this.slicesl * l13;
                            long l2 = i * l13;
                            for (long j = 1L; j < l11; ++j) {
                                long l3 = l5 + (FloatFFT_3D.this.rowsl - j) * l14;
                                long l4 = l2 + j * l14;
                                floatLargeArray.setFloat(l3, floatLargeArray.getFloat(l4));
                                floatLargeArray.setFloat(l3 + 1L, -floatLargeArray.getFloat(l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l16;
            long l17;
            for (l17 = 0L; l17 < this.slicesl; ++l17) {
                l8 = (this.slicesl - l17) % this.slicesl * l13;
                l5 = l17 * l13;
                for (l16 = 0L; l16 < this.rowsl; ++l16) {
                    l7 = (this.rowsl - l16) % this.rowsl * l14;
                    l4 = l16 * l14;
                    for (l = 1L; l < this.columnsl; l += 2L) {
                        l3 = l8 + l7 + l10 - l;
                        l2 = l5 + l4 + l;
                        floatLargeArray.setFloat(l3, -floatLargeArray.getFloat(l2 + 2L));
                        floatLargeArray.setFloat(l3 - 1L, floatLargeArray.getFloat(l2 + 1L));
                    }
                }
            }
            for (l17 = 0L; l17 < this.slicesl; ++l17) {
                l5 = (this.slicesl - l17) % this.slicesl * l13;
                l4 = l17 * l13;
                for (l16 = 1L; l16 < l11; ++l16) {
                    l7 = l4 + (this.rowsl - l16) * l14;
                    l3 = l5 + l16 * l14 + this.columnsl;
                    l2 = l7 + this.columnsl;
                    l8 = l7 + 1L;
                    floatLargeArray.setFloat(l3, floatLargeArray.getFloat(l8));
                    floatLargeArray.setFloat(l2, floatLargeArray.getFloat(l8));
                    floatLargeArray.setFloat(l3 + 1L, -floatLargeArray.getFloat(l7));
                    floatLargeArray.setFloat(l2 + 1L, floatLargeArray.getFloat(l7));
                }
            }
            for (l17 = 0L; l17 < this.slicesl; ++l17) {
                l8 = (this.slicesl - l17) % this.slicesl * l13;
                l7 = l17 * l13;
                for (l16 = 1L; l16 < l11; ++l16) {
                    l3 = l8 + (this.rowsl - l16) * l14;
                    l2 = l7 + l16 * l14;
                    floatLargeArray.setFloat(l3, floatLargeArray.getFloat(l2));
                    floatLargeArray.setFloat(l3 + 1L, -floatLargeArray.getFloat(l2 + 1L));
                }
            }
        }
        for (long i = 1L; i < l12; ++i) {
            l3 = i * l13;
            l2 = (this.slicesl - i) * l13;
            l8 = l11 * l14;
            l7 = l3 + l8;
            l5 = l2 + l8;
            floatLargeArray.setFloat(l3 + this.columnsl, floatLargeArray.getFloat(l2 + 1L));
            floatLargeArray.setFloat(l2 + this.columnsl, floatLargeArray.getFloat(l2 + 1L));
            floatLargeArray.setFloat(l3 + this.columnsl + 1L, -floatLargeArray.getFloat(l2));
            floatLargeArray.setFloat(l2 + this.columnsl + 1L, floatLargeArray.getFloat(l2));
            floatLargeArray.setFloat(l7 + this.columnsl, floatLargeArray.getFloat(l5 + 1L));
            floatLargeArray.setFloat(l5 + this.columnsl, floatLargeArray.getFloat(l5 + 1L));
            floatLargeArray.setFloat(l7 + this.columnsl + 1L, -floatLargeArray.getFloat(l5));
            floatLargeArray.setFloat(l5 + this.columnsl + 1L, floatLargeArray.getFloat(l5));
            floatLargeArray.setFloat(l2, floatLargeArray.getFloat(l3));
            floatLargeArray.setFloat(l2 + 1L, -floatLargeArray.getFloat(l3 + 1L));
            floatLargeArray.setFloat(l5, floatLargeArray.getFloat(l7));
            floatLargeArray.setFloat(l5 + 1L, -floatLargeArray.getFloat(l7 + 1L));
        }
        floatLargeArray.setFloat(this.columnsl, floatLargeArray.getFloat(1L));
        floatLargeArray.setFloat(1L, 0.0f);
        l3 = l11 * l14;
        l2 = l12 * l13;
        l8 = l3 + l2;
        floatLargeArray.setFloat(l3 + this.columnsl, floatLargeArray.getFloat(l3 + 1L));
        floatLargeArray.setFloat(l3 + 1L, 0.0f);
        floatLargeArray.setFloat(l2 + this.columnsl, floatLargeArray.getFloat(l2 + 1L));
        floatLargeArray.setFloat(l2 + 1L, 0.0f);
        floatLargeArray.setFloat(l8 + this.columnsl, floatLargeArray.getFloat(l8 + 1L));
        floatLargeArray.setFloat(l8 + 1L, 0.0f);
        floatLargeArray.setFloat(l2 + this.columnsl + 1L, 0.0f);
        floatLargeArray.setFloat(l8 + this.columnsl + 1L, 0.0f);
    }
}

