/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.SAMEntry;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import org.apache.log4j.Logger;

public class BAMFileWriter
implements Closeable {
    private static final Logger log = Logger.getLogger(BAMFileWriter.class);
    private final Path p;
    private final SAMFileWriter writer;
    private final SAMFileHeader header = new SAMFileHeader();

    public BAMFileWriter(Path p) {
        this.p = p;
        log.debug((Object)("Opening BAM file writer " + p));
        this.writer = new SAMFileWriterFactory().makeBAMWriter(this.header, false, p.toFile());
    }

    @Override
    public void close() throws IOException {
        log.debug((Object)("Closing BAM file writer " + this.p));
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SAMEntry entry) {
        SAMFileWriter sAMFileWriter = this.writer;
        synchronized (sAMFileWriter) {
            this.writer.addAlignment(entry.getSAMRecord());
        }
    }

    public Path getPath() {
        return this.p;
    }
}

