/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.BAMFileReader;
import edu.unc.genomics.io.BedFileReader;
import edu.unc.genomics.io.BedGraphFileReader;
import edu.unc.genomics.io.BigBedFileReader;
import edu.unc.genomics.io.GFFFileReader;
import edu.unc.genomics.io.GeneTrackFileReader;
import edu.unc.genomics.io.IntervalFileSniffer;
import edu.unc.genomics.io.IntervalFileSnifferException;
import edu.unc.genomics.io.SAMFileReader;
import edu.unc.genomics.io.VCFFileReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class IntervalFileReader<T extends Interval>
implements Iterable<T>,
Closeable {
    private static final Logger log = Logger.getLogger(IntervalFileReader.class);
    protected Path p;

    protected IntervalFileReader(Path p) {
        this.p = p;
    }

    public static IntervalFileReader<? extends Interval> autodetect(Path p) throws IntervalFileSnifferException, IOException {
        TrackHeader.Type type;
        IntervalFileSniffer sniffer = new IntervalFileSniffer(p);
        TrackHeader header = sniffer.getTrackHeader();
        if (header != null && (type = header.getType()) != null) {
            switch (type) {
                case BED: {
                    log.debug((Object)("track line indicates Bed filetype for: " + p));
                    return new BedFileReader(p);
                }
                case BEDGRAPH: {
                    log.debug((Object)("track line indicates BedGraph filetype for: " + p));
                    return new BedGraphFileReader(p);
                }
                case GFF: {
                    log.debug((Object)("track line indicates GFF filetype for: " + p));
                    return new GFFFileReader(p);
                }
            }
            log.warn((Object)("Unknown track type: " + (Object)((Object)type)));
            log.debug((Object)"Using heuristics to analyze first data line");
        }
        if (sniffer.isBigBed()) {
            log.debug((Object)("Autodetected BigBed filetype for: " + p));
            return new BigBedFileReader(p);
        }
        if (sniffer.isBAM()) {
            log.debug((Object)("Autodetected BAM filetype for: " + p));
            return new BAMFileReader(p);
        }
        if (sniffer.isGFF()) {
            log.debug((Object)("Autodetected GFF filetype for: " + p));
            return new GFFFileReader(p);
        }
        if (sniffer.isBedGraph()) {
            log.debug((Object)("Autodetected BedGraph filetype for: " + p));
            return new BedGraphFileReader(p);
        }
        if (sniffer.isBed()) {
            log.debug((Object)("Autodetected Bed filetype for: " + p));
            return new BedFileReader(p);
        }
        if (sniffer.isSAM()) {
            log.debug((Object)("Autodetected SAM filetype for: " + p));
            return new SAMFileReader(p);
        }
        if (sniffer.isGeneTrack()) {
            log.debug((Object)("Autodetected GeneTrack filetype for: " + p));
            return new GeneTrackFileReader(p);
        }
        if (sniffer.isVCF()) {
            log.debug((Object)("Autodetected VCF filetype for: " + p));
            return new VCFFileReader(p);
        }
        log.warn((Object)"Could not autodetect Interval file format");
        sniffer.diagnose();
        throw new IntervalFileSnifferException("Could not autodetect Interval file format");
    }

    public static List<Interval> loadAll(Path p) throws IntervalFileSnifferException, IOException {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        try (IntervalFileReader<Interval> intervalFile = IntervalFileReader.autodetect(p);){
            for (Interval interval : intervalFile) {
                intervals.add(interval);
            }
        }
        return intervals;
    }

    public final synchronized List<T> loadAll() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (Interval interval : this) {
            intervals.add(interval);
        }
        return intervals;
    }

    public abstract int count();

    public abstract Set<String> chromosomes();

    public final Iterator<T> query(Interval i) {
        return this.query(i.getChr(), i.low(), i.high());
    }

    public abstract Iterator<T> query(String var1, int var2, int var3);

    public final List<T> load(Interval i) {
        return this.load(i.getChr(), i.low(), i.high());
    }

    public final synchronized List<T> load(String chr, int start, int stop) {
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> it = this.query(chr, start, stop);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public final Path getPath() {
        return this.p;
    }
}

