/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import edu.unc.genomics.util.ExternalSort;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    public static final int DEFAULT_BLOCK_SIZE = 4096;

    public static boolean isAsciiText(Path p) throws IOException {
        char[] buf = new char[4096];
        try (BufferedReader reader = Files.newBufferedReader(p, Charset.forName("US-ASCII"));){
            reader.read(buf);
        }
        catch (MalformedInputException e) {
            return false;
        }
        return true;
    }

    public static int countLines(Path p) throws IOException {
        int count = 0;
        try (BufferedReader reader = Files.newBufferedReader(p, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                ++count;
            }
        }
        return count;
    }

    public static void sort(Path input, Path output, Comparator<String> cmp) throws IOException {
        log.debug((Object)("Sorting file " + input + " to " + output));
        List<Path> pieces = ExternalSort.sortInBatch(input, cmp);
        log.debug((Object)"Merging sorted chunks");
        ExternalSort.mergeSortedFiles(pieces, output, cmp);
    }
}

