/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Assembly;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class AssemblyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8225453782461913732L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "# Contigs"};
    private final List<Assembly> assemblies;

    public AssemblyTableModel(List<Assembly> assemblies) {
        this.assemblies = assemblies;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.assemblies.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Assembly a = this.assemblies.get(rowIndex);
        if (columnIndex == 0) {
            return a.toString();
        }
        if (columnIndex == 1) {
            return a.chromosomes().size();
        }
        return null;
    }

    public Assembly getRow(int rowIndex) {
        return this.assemblies.get(rowIndex);
    }

    public boolean containsAssembly(Assembly a) {
        String aName = a.toString();
        for (Assembly assembly : this.assemblies) {
            if (!assembly.toString().equalsIgnoreCase(aName)) continue;
            return true;
        }
        return false;
    }

    public void addAssembly(Assembly a) {
        this.assemblies.add(a);
        this.fireTableRowsInserted(this.assemblies.size() - 1, this.assemblies.size() - 1);
    }

    public void removeRow(int rowIndex) {
        this.assemblies.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }
}

