/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.sf.samtools.BAMIndexer;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;

public class Samtools {
    private static final Logger log = Logger.getLogger(Samtools.class);

    public static void samToBam(Path sam, Path bam) {
        log.debug((Object)("Converting SAM file " + sam + " to BAM file " + bam));
        SAMFileReader reader = new SAMFileReader(sam.toFile());
        reader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.coordinate);
        SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(reader.getFileHeader(), false, bam.toFile());
        for (SAMRecord samRecord : reader) {
            writer.addAlignment(samRecord);
        }
        writer.close();
        reader.close();
    }

    public static void indexBAMFile(Path bam, Path index) {
        log.debug((Object)("Creating BAM index for file: " + bam));
        SAMFileReader reader = new SAMFileReader(bam.toFile());
        BAMIndexer indexer = new BAMIndexer(index.toFile(), reader.getFileHeader());
        reader.enableFileSource(true);
        int count = 0;
        for (SAMRecord rec : reader) {
            indexer.processAlignment(rec);
            ++count;
        }
        indexer.finish();
        log.debug((Object)("Indexed " + count + " records in BAM file"));
    }

    public static Path findIndexFile(Path bamFile) {
        String bai;
        Path indexFile;
        String bamExtension = ".bam";
        String fileName = bamFile.toString();
        if (fileName.endsWith(".bam") && Files.exists(indexFile = bamFile.resolveSibling(bai = fileName.substring(0, fileName.length() - ".bam".length()) + ".bai"), new LinkOption[0])) {
            return indexFile;
        }
        indexFile = bamFile.resolveSibling(bamFile.getFileName() + ".bai");
        if (Files.exists(indexFile, new LinkOption[0])) {
            return indexFile;
        }
        return null;
    }
}

