/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.PrintStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBitStreamIndexWriter
implements IndexWriter {
    protected final int numberOfDocuments;
    public Map<CompressionFlags.Component, CompressionFlags.Coding> flags;
    protected CompressionFlags.Coding frequencyCoding;
    protected CompressionFlags.Coding pointerCoding;
    protected CompressionFlags.Coding countCoding;
    protected CompressionFlags.Coding positionCoding;
    protected final boolean hasPayloads;
    protected final boolean hasCounts;
    protected final boolean hasPositions;
    protected long numberOfPostings;
    protected long numberOfOccurrences;
    protected int currentTerm;
    public long bitsForFrequencies;
    public long bitsForPointers;
    public long bitsForCounts;
    public long bitsForPayloads;
    public long bitsForPositions;

    public AbstractBitStreamIndexWriter(int numberOfDocuments, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) {
        this.numberOfDocuments = numberOfDocuments;
        this.flags = flags;
        this.frequencyCoding = flags.get((Object)CompressionFlags.Component.FREQUENCIES);
        this.pointerCoding = flags.get((Object)CompressionFlags.Component.POINTERS);
        this.countCoding = flags.get((Object)CompressionFlags.Component.COUNTS);
        this.positionCoding = flags.get((Object)CompressionFlags.Component.POSITIONS);
        this.hasPayloads = flags.containsKey((Object)CompressionFlags.Component.PAYLOADS);
        this.hasCounts = this.countCoding != null;
        this.hasPositions = this.positionCoding != null;
    }

    @Override
    public void printStats(PrintStream stats) {
        stats.println("Number of documents: " + Fast.format(this.numberOfDocuments));
        stats.println("Number of terms: " + Fast.format(this.currentTerm + 1));
        stats.println("Frequencies: " + Fast.format(this.bitsForFrequencies) + " bits, " + Fast.format((double)this.bitsForFrequencies / ((double)this.currentTerm + 1.0)) + " bits/frequency.");
        stats.println("Document pointers: " + Fast.format(this.numberOfPostings) + " (" + Fast.format(this.bitsForPointers) + " bits, " + Fast.format((double)this.bitsForPointers / (double)this.numberOfPostings) + " bits/pointer).");
        if (this.hasCounts) {
            stats.println("Counts: " + Fast.format(this.numberOfPostings) + " (" + Fast.format(this.bitsForCounts) + " bits, " + Fast.format((double)this.bitsForCounts / (double)this.numberOfPostings) + " bits/count).");
        }
        if (this.hasPositions) {
            stats.println("Occurrences: " + Fast.format(this.numberOfOccurrences) + " (" + Fast.format(this.bitsForPositions) + " bits, " + Fast.format((double)this.bitsForPositions / (double)this.numberOfOccurrences) + " bits/occurrence).");
        }
        if (this.hasPayloads) {
            stats.println("Payloads: " + Fast.format(this.numberOfPostings) + " (" + Fast.format(this.bitsForPayloads) + " bits, " + Fast.format((double)this.bitsForPayloads / (double)this.numberOfPostings) + " bits/payload).");
        }
        if (this.hasPositions) {
            stats.println("Total: " + Fast.format(this.writtenBits()) + " bits, " + Fast.format((double)this.writtenBits() / (double)this.numberOfOccurrences) + " bits/occurrence");
        } else {
            stats.println("Total: " + Fast.format(this.writtenBits()) + " bits, " + Fast.format((double)this.writtenBits() / (double)this.numberOfPostings) + " bits/posting");
        }
    }
}

