/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.mg4j.index.AbstractBitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.FileIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InterpolativeCoding;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.Properties;
import jal.ints.Sorting;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitStreamIndexWriter
extends AbstractBitStreamIndexWriter {
    private static final boolean ASSERTS = false;
    protected static final int BEFORE_INVERTED_LIST = 0;
    protected static final int BEFORE_FREQUENCY = 1;
    protected static final int BEFORE_DOCUMENT_RECORD = 2;
    protected static final int BEFORE_POINTER = 3;
    protected static final int BEFORE_PAYLOAD = 4;
    protected static final int BEFORE_COUNT = 5;
    protected static final int BEFORE_POSITIONS = 6;
    protected static final int FIRST_UNUSED_STATE = 7;
    protected OutputBitStream obs;
    private OutputBitStream offset;
    protected int state;
    protected int frequency;
    protected int writtenDocuments;
    protected int currentDocument;
    protected int lastDocument;
    private long lastInvertedListPos;
    protected int b;
    protected int log2b;
    public int maxCount;
    private int[] sortedDeltas = IntArrays.EMPTY_ARRAY;

    public BitStreamIndexWriter(CharSequence basename, int numberOfDocuments, boolean writeOffsets, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) throws IOException {
        this(new OutputBitStream(new FileOutputStream(basename + ".index")), writeOffsets ? new OutputBitStream(new FileOutputStream(basename + ".offsets")) : null, numberOfDocuments, flags);
    }

    public BitStreamIndexWriter(OutputBitStream obs, OutputBitStream offset, int numberOfDocuments, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) {
        super(numberOfDocuments, flags);
        this.obs = obs;
        this.offset = offset;
        this.frequency = -1;
        this.currentTerm = -1;
        this.maxCount = 0;
        if (!this.hasCounts && this.hasPositions) {
            throw new IllegalArgumentException("Index would have positions but no counts (this can't happen)");
        }
    }

    public BitStreamIndexWriter(OutputBitStream obs, int numberOfDocuments, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) {
        this(obs, null, numberOfDocuments, flags);
    }

    @Override
    public long newInvertedList() throws IOException {
        if (this.frequency >= 0 && this.frequency != this.writtenDocuments) {
            throw new IllegalStateException("The number of document records (" + this.writtenDocuments + ") does not match the frequency (" + this.frequency + ")");
        }
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException("Trying to start new inverted list in state " + this.state);
        }
        long pos = this.obs.writtenBits();
        this.writtenDocuments = 0;
        ++this.currentTerm;
        this.currentDocument = -1;
        if (this.offset != null) {
            this.offset.writeLongGamma(pos - this.lastInvertedListPos);
        }
        this.lastInvertedListPos = pos;
        this.state = 1;
        return pos;
    }

    @Override
    public int writeFrequency(int frequency) throws IOException {
        int bitCount;
        if (this.state != 1) {
            throw new IllegalStateException("Trying to write frequency in state " + this.state);
        }
        switch (this.frequencyCoding) {
            case SHIFTED_GAMMA: {
                bitCount = this.obs.writeShiftedGamma(frequency - 1);
                break;
            }
            case GAMMA: {
                bitCount = this.obs.writeGamma(frequency - 1);
                break;
            }
            case DELTA: {
                bitCount = this.obs.writeDelta(frequency - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required frequency coding (" + (Object)((Object)this.frequencyCoding) + ") is not supported.");
            }
        }
        this.frequency = frequency;
        if (this.pointerCoding == CompressionFlags.Coding.GOLOMB) {
            this.b = Fast.golombModulus(frequency, this.numberOfDocuments);
            this.log2b = Fast.mostSignificantBit(this.b);
        }
        this.state = 2;
        this.bitsForFrequencies += (long)bitCount;
        return bitCount;
    }

    @Override
    public OutputBitStream newDocumentRecord() throws IOException {
        if (this.frequency == this.writtenDocuments) {
            throw new IllegalStateException("Document record overflow (written " + this.frequency + " already)");
        }
        if (this.state != 2) {
            throw new IllegalStateException("Trying to start new document record in state " + this.state);
        }
        ++this.writtenDocuments;
        ++this.numberOfPostings;
        this.lastDocument = this.currentDocument;
        this.state = 3;
        return this.obs;
    }

    @Override
    public int writeDocumentPointer(OutputBitStream out, int pointer) throws IOException {
        int bitCount;
        block9: {
            block8: {
                if (this.state != 3) {
                    throw new IllegalStateException("Trying to write pointer in state " + this.state);
                }
                this.currentDocument = pointer;
                bitCount = 0;
                if (this.frequency == this.numberOfDocuments) break block8;
                switch (this.pointerCoding) {
                    case SHIFTED_GAMMA: {
                        bitCount = out.writeShiftedGamma(pointer - this.lastDocument - 1);
                        break block9;
                    }
                    case GAMMA: {
                        bitCount = out.writeGamma(pointer - this.lastDocument - 1);
                        break block9;
                    }
                    case DELTA: {
                        bitCount = out.writeDelta(pointer - this.lastDocument - 1);
                        break block9;
                    }
                    case GOLOMB: {
                        bitCount = out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
                    }
                }
            }
            if (pointer - this.lastDocument != 1) {
                throw new IllegalStateException("Term " + this.currentTerm + " has frequency equal to the number of documents, but pointers are not consecutive integers");
            }
        }
        this.state = this.hasPayloads ? 4 : (this.hasCounts ? 5 : 2);
        this.bitsForPointers += (long)bitCount;
        return bitCount;
    }

    @Override
    public int writePayload(OutputBitStream out, Payload payload) throws IOException {
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write payload without calling newInvertedList");
        }
        if (this.state != 4) {
            throw new IllegalStateException("Trying to write payload in state " + this.state);
        }
        int count = payload.write(out);
        this.bitsForPayloads += (long)count;
        this.state = this.hasCounts ? 5 : 2;
        return count;
    }

    @Override
    public void close() throws IOException {
        if (this.state != 2 && this.state != 0) {
            throw new IllegalStateException("Trying to close index in state " + this.state);
        }
        if (this.frequency >= 0 && this.frequency != this.writtenDocuments) {
            throw new IllegalStateException("The number of document records (" + this.writtenDocuments + ") does not match the frequency (" + this.frequency + ")");
        }
        if (this.writtenBits() != this.obs.writtenBits()) {
            throw new IllegalStateException("Written bits count mismatch: we say " + this.writtenBits() + ", the stream says " + this.obs.writtenBits());
        }
        if (this.offset != null) {
            this.offset.writeLongGamma(this.obs.writtenBits() - this.lastInvertedListPos);
            this.offset.close();
        }
        this.obs.close();
    }

    @Override
    public int writePositionCount(OutputBitStream out, int count) throws IOException {
        int bitCount;
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write count without calling newInvertedList");
        }
        if (this.state != 5) {
            throw new IllegalStateException("Trying to write count in state " + this.state);
        }
        this.numberOfOccurrences += (long)count;
        switch (this.countCoding) {
            case SHIFTED_GAMMA: {
                bitCount = out.writeShiftedGamma(count - 1);
                break;
            }
            case GAMMA: {
                bitCount = out.writeGamma(count - 1);
                break;
            }
            case UNARY: {
                bitCount = out.writeUnary(count - 1);
                break;
            }
            case DELTA: {
                bitCount = out.writeDelta(count - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
            }
        }
        this.state = this.hasPositions ? 6 : 2;
        this.bitsForCounts += (long)bitCount;
        return bitCount;
    }

    @Override
    public int writeDocumentPositions(OutputBitStream out, int[] occ, int offset, int len, int docSize) throws IOException {
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write occurrences without calling newInvertedList");
        }
        if (this.state != 6) {
            throw new IllegalStateException("Trying to write positions in state " + this.state);
        }
        int prev = -1;
        int bitCount = 0;
        int end = offset + len;
        switch (this.positionCoding) {
            case GAMMA: {
                for (int i = offset; i < end; ++i) {
                    bitCount += out.writeGamma(occ[i] - prev - 1);
                    prev = occ[i];
                }
                break;
            }
            case DELTA: {
                for (int i = offset; i < end; ++i) {
                    bitCount += out.writeDelta(occ[i] - prev - 1);
                    prev = occ[i];
                }
                break;
            }
            case SHIFTED_GAMMA: {
                for (int i = offset; i < end; ++i) {
                    bitCount += out.writeShiftedGamma(occ[i] - prev - 1);
                    prev = occ[i];
                }
                break;
            }
            case GOLOMB: {
                if (len < 3) {
                    for (int i = 0; i < len; ++i) {
                        bitCount += out.writeMinimalBinary(occ[i], docSize);
                    }
                } else {
                    int positionB = Fast.golombModulus(len, docSize);
                    int positionLog2b = Fast.mostSignificantBit(positionB);
                    for (int i = offset; i < end; ++i) {
                        bitCount += out.writeGolomb(occ[i] - prev - 1, positionB, positionLog2b);
                        prev = occ[i];
                    }
                }
                break;
            }
            case SKEWED_GOLOMB: {
                if (len < 3) {
                    for (int i = 0; i < len; ++i) {
                        bitCount += out.writeMinimalBinary(occ[i], docSize);
                    }
                } else {
                    if (this.sortedDeltas.length < len) {
                        this.sortedDeltas = new int[len];
                    }
                    System.arraycopy(occ, offset, this.sortedDeltas, 0, len);
                    int i = len - 1;
                    while (i-- != 0) {
                        int n = i + 1;
                        this.sortedDeltas[n] = this.sortedDeltas[n] - (this.sortedDeltas[i] + 1);
                    }
                    Sorting.nth_element((int[])this.sortedDeltas, (int)0, (int)(len / 2), (int)len);
                    int sb = this.sortedDeltas[len / 2] + 1;
                    bitCount = out.writeMinimalBinary(sb - 1, docSize);
                    for (i = offset; i < end; ++i) {
                        bitCount += out.writeSkewedGolomb(occ[i] - prev - 1, sb);
                        prev = occ[i];
                    }
                }
                break;
            }
            case INTERPOLATIVE: {
                bitCount = InterpolativeCoding.write(out, occ, 0, len, 0, docSize - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required position coding (" + (Object)((Object)this.positionCoding) + ") is not supported.");
            }
        }
        this.state = 2;
        this.bitsForPositions += (long)bitCount;
        if (len > this.maxCount) {
            this.maxCount = len;
        }
        return bitCount;
    }

    @Override
    public long writtenBits() {
        return this.bitsForFrequencies + this.bitsForPointers + this.bitsForPayloads + this.bitsForCounts + this.bitsForPositions;
    }

    @Override
    public Properties properties() {
        Properties result = new Properties();
        result.setProperty((Enum<?>)Index.PropertyKeys.DOCUMENTS, this.numberOfDocuments);
        result.setProperty((Enum<?>)Index.PropertyKeys.TERMS, this.currentTerm + 1);
        result.setProperty((Enum<?>)Index.PropertyKeys.POSTINGS, this.numberOfPostings);
        result.setProperty((Enum<?>)Index.PropertyKeys.MAXCOUNT, this.maxCount);
        result.setProperty(Index.PropertyKeys.INDEXCLASS, FileIndex.class.getName());
        for (Map.Entry e : this.flags.entrySet()) {
            if (e.getKey() == CompressionFlags.Component.PAYLOADS) continue;
            result.addProperty(Index.PropertyKeys.CODING, new MutableString().append(e.getKey()).append(':').append(e.getValue()));
        }
        return result;
    }
}

