/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.mg4j.util.HashCodeSignedMinimalPerfectHash;
import it.unimi.dsi.mg4j.util.LiterallySignedMinimalPerfectHash;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ShiftAddXorLongSignedMinimalPerfectHash;
import it.unimi.dsi.mg4j.util.ShiftAddXorSignedMinimalPerfectHash;
import it.unimi.dsi.mg4j.util.SignedMinimalPerfectHash;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalPerfectHashTest
extends TestCase {
    final String[] word = new String[128];
    final String[] wordBinary = new String[128];

    public void setUp() {
        int i = this.word.length;
        while (i-- != 1) {
            this.word[i] = Integer.toString(i);
        }
        this.word[0] = "";
        i = this.wordBinary.length;
        while (i-- != 1) {
            this.wordBinary[i] = Integer.toBinaryString(i);
        }
        this.wordBinary[0] = "";
    }

    public void testSigned(int n) {
        HashCodeSignedMinimalPerfectHash mph = new HashCodeSignedMinimalPerfectHash(Arrays.asList(this.word).subList(0, n));
        HashCodeSignedMinimalPerfectHash mphBinary = new HashCodeSignedMinimalPerfectHash(Arrays.asList(this.wordBinary).subList(0, n));
        int i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mph.getNumber(this.word[i]));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mphBinary.getNumber(this.wordBinary[i]));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mph.getNumber(Integer.toString(i)));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mphBinary.getNumber(Integer.toBinaryString(i)));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mph.getNumber(new MutableString(this.word[i])));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mphBinary.getNumber(new MutableString(this.wordBinary[i])));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mph.getNumber(new MutableString(Integer.toString(i))));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mphBinary.getNumber(new MutableString(Integer.toBinaryString(i))));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mph.getNumber(this.word[i].getBytes()));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mphBinary.getNumber(this.wordBinary[i].getBytes()));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mph.getNumber(Integer.toString(i).getBytes()));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mphBinary.getNumber(Integer.toBinaryString(i).getBytes()));
        }
    }

    public void testSortedSigned(Class<?> klass, int n) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Arrays.sort(this.word);
        Arrays.sort(this.wordBinary);
        SignedMinimalPerfectHash mph = (SignedMinimalPerfectHash)klass.getConstructor(Iterable.class, Integer.TYPE).newInstance(Arrays.asList(this.word).subList(0, n), -2);
        SignedMinimalPerfectHash mphBinary = (SignedMinimalPerfectHash)klass.getConstructor(Iterable.class, Integer.TYPE).newInstance(Arrays.asList(this.wordBinary).subList(0, n), -2);
        int i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mph.getNumber(Integer.toString(i)));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mphBinary.getNumber(Integer.toBinaryString(i)));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mph.getNumber(new MutableString(this.word[i])));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mphBinary.getNumber(new MutableString(this.wordBinary[i])));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mph.getNumber(new MutableString(Integer.toString(i))));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mphBinary.getNumber(new MutableString(Integer.toBinaryString(i))));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mph.getNumber(this.word[i].getBytes()));
        }
        i = n;
        while (i-- != 0) {
            MinimalPerfectHashTest.assertEquals((int)i, (int)mphBinary.getNumber(this.wordBinary[i].getBytes()));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mph.getNumber(Integer.toString(i).getBytes()));
        }
        i = n + 1000;
        while (--i != 1000) {
            MinimalPerfectHashTest.assertEquals((int)-1, (int)mphBinary.getNumber(Integer.toBinaryString(i).getBytes()));
        }
    }

    public void testSigned() throws IllegalArgumentException, SecurityException {
        this.testSigned(this.word.length);
        this.testSigned(4);
    }

    public void testSortedSigned() throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.testSortedSigned(HashCodeSignedMinimalPerfectHash.class, 4);
        this.testSortedSigned(HashCodeSignedMinimalPerfectHash.class, this.word.length);
        this.testSortedSigned(ShiftAddXorSignedMinimalPerfectHash.class, this.word.length);
        this.testSortedSigned(ShiftAddXorLongSignedMinimalPerfectHash.class, this.word.length);
        this.testSortedSigned(LiterallySignedMinimalPerfectHash.class, this.word.length);
        this.testSortedSigned(ShiftAddXorSignedMinimalPerfectHash.class, 4);
        this.testSortedSigned(ShiftAddXorLongSignedMinimalPerfectHash.class, 4);
        this.testSortedSigned(LiterallySignedMinimalPerfectHash.class, 4);
    }
}

