/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import com.martiansoftware.jsap.JSAPException;
import it.unimi.dsi.mg4j.util.MinimalPerfectHash;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.SignedMinimalPerfectHash;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiterallySignedMinimalPerfectHash
extends SignedMinimalPerfectHash {
    private static final long serialVersionUID = 1L;
    CharSequence[] signature;

    public LiterallySignedMinimalPerfectHash(Iterable<? extends CharSequence> terms, int weightLength) {
        super(terms, weightLength);
    }

    public LiterallySignedMinimalPerfectHash(Iterable<? extends CharSequence> terms) {
        super(terms);
    }

    public LiterallySignedMinimalPerfectHash(String termFile, String encoding, int weightLength) {
        super(termFile, encoding, weightLength);
    }

    public LiterallySignedMinimalPerfectHash(String termFile, String encoding) {
        super(termFile, encoding);
    }

    @Override
    public void initSignatures(Iterable<? extends CharSequence> terms) {
        int i = 0;
        this.signature = new CharSequence[this.n];
        Iterator<? extends CharSequence> e = terms.iterator();
        while (e.hasNext()) {
            this.signature[i] = new MutableString(e.next());
            ++i;
        }
    }

    @Override
    public boolean checkSignature(CharSequence word, int index) {
        if (this.n == 0) {
            return false;
        }
        return this.signature[index].equals(word);
    }

    @Override
    public boolean checkSignature(byte[] a, int off, int len, int index) {
        if (this.n == 0) {
            return false;
        }
        try {
            return this.signature[index].equals(new String(a, off, len, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] arg) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        MinimalPerfectHash.main(LiterallySignedMinimalPerfectHash.class, arg);
    }
}

