/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.ngs.Autocorrelation;
import edu.unc.utils.FloatHistogram;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class ValueDistribution
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--min"}, description="Minimum bin value")
    public Float min;
    @Parameter(names={"-h", "--max"}, description="Maximum bin value")
    public Float max;
    @Parameter(names={"-n", "--bins"}, description="Number of bins")
    public int numBins = 40;
    @Parameter(names={"-o", "--output"}, description="Output file")
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Generating histogram of Wig values");
        if (this.min == null) {
            this.min = Float.valueOf((float)this.inputFile.min());
        }
        if (this.max == null) {
            this.max = Float.valueOf((float)this.inputFile.max());
        }
        FloatHistogram hist = new FloatHistogram(this.numBins, this.min.floatValue(), this.max.floatValue());
        for (String chr : this.inputFile.chromosomes()) {
            int start = this.inputFile.getChrStart(chr);
            int stop = this.inputFile.getChrStop(chr);
            log.debug((Object)("Processing chromosome " + chr + " region " + start + "-" + stop));
            int bp = start;
            while (bp < stop) {
                Iterator iter;
                int chunkStart = bp;
                int chunkStop = Math.min(bp + 300000 - 1, stop);
                log.debug((Object)("Processing chunk " + chr + ":" + chunkStart + "-" + chunkStop));
                try {
                    iter = this.inputFile.query(chr, chunkStart, chunkStop);
                }
                catch (WigFileException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error getting data from Wig file!");
                }
                while (iter.hasNext()) {
                    WigItem item = (WigItem)iter.next();
                    for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                        if (i < chunkStart || i > chunkStop) continue;
                        hist.addValue(item.getWigValue());
                    }
                }
                bp = chunkStop + 1;
            }
        }
        if (this.outputFile != null) {
            log.debug((Object)"Writing to output file");
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
                writer.write(hist.toString());
            }
        } else {
            System.out.println(hist.toString());
        }
        this.inputFile.close();
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new ValueDistribution().instanceMain(args);
    }
}

