/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ResourceManager;
import edu.unc.genomics.ToolsTreeNode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolsTreeModel
extends DefaultTreeModel {
    public static final Path DEFAULT_CONFIGURATION_FILE = Paths.get("toolConf.xml", new String[0]);
    private static final Logger log = Logger.getLogger(ToolsTreeModel.class);
    private static final long serialVersionUID = -6587614270922489960L;

    public ToolsTreeModel() {
        super(new DefaultMutableTreeNode("Tools"));
    }

    public static ToolsTreeModel loadDefaultConfig() throws ClassNotFoundException, ParserConfigurationException, SAXException, IOException {
        return ToolsTreeModel.loadConfig(ResourceManager.getResourceDirectory().resolve(DEFAULT_CONFIGURATION_FILE));
    }

    public static ToolsTreeModel loadConfig(Path p) throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        ToolsTreeModel model = new ToolsTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        log.debug((Object)("Loading tools from: " + DEFAULT_CONFIGURATION_FILE.toAbsolutePath()));
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(p.toFile());
        NodeList sections = doc.getElementsByTagName("section");
        log.debug((Object)("Found " + sections.getLength() + " sections"));
        for (int i = 0; i < sections.getLength(); ++i) {
            Node section = sections.item(i);
            String sectionName = section.getAttributes().getNamedItem("name").getNodeValue();
            log.debug((Object)("Loading section: " + sectionName));
            DefaultMutableTreeNode sectionNode = new DefaultMutableTreeNode(sectionName);
            root.add(sectionNode);
            NodeList tools = section.getChildNodes();
            for (int j = 0; j < tools.getLength(); ++j) {
                Node tool = tools.item(j);
                if (tool.getNodeType() != 1 || !tool.getNodeName().equalsIgnoreCase("tool")) continue;
                String toolName = tool.getAttributes().getNamedItem("name").getNodeValue();
                log.debug((Object)("Loading tool: " + toolName));
                String toolClassName = tool.getAttributes().getNamedItem("class").getNodeValue();
                Class<?> toolClass = Class.forName(toolClassName);
                ToolsTreeNode toolNode = new ToolsTreeNode(toolName, toolClass);
                sectionNode.add(toolNode);
            }
        }
        return model;
    }
}

