/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.query.FileSystemItem;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.util.Fast;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpQueryServer {
    private static final Logger LOGGER = Fast.getLogger(HttpQueryServer.class);
    public final HttpServer server;

    public HttpQueryServer(QueryEngine queryEngine, DocumentCollection collection, Class<? extends HttpServlet> itemClass, String itemMimeType, int port, List<? extends CharSequence> titleList) throws Exception {
        LOGGER.debug((Object)("itemClass: " + itemClass));
        LOGGER.debug((Object)("itemMimeType: " + itemMimeType));
        LOGGER.debug((Object)("queryEngine: " + queryEngine));
        LOGGER.debug((Object)("port: " + port));
        this.server = new HttpServer();
        SocketListener listener = new SocketListener();
        listener.setPort(port);
        this.server.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("");
        this.server.addContext(context);
        ServletHandler servlets = new ServletHandler();
        context.addHandler((HttpHandler)servlets);
        context.setAttribute("queryEngine", (Object)queryEngine);
        context.setAttribute("collection", (Object)collection);
        context.setAttribute("titleList", titleList);
        context.setAttribute("action", (Object)"/Query");
        context.setAttribute("template", (Object)System.getProperty("it.unimi.dsi.mg4j.query.QueryServlet.template"));
        servlets.addServlet("Query", "/Query", "it.unimi.dsi.mg4j.query.QueryServlet");
        servlets.addServlet("Help", "/Help", "it.unimi.dsi.mg4j.query.HelpPage");
        Properties properties = new Properties();
        properties.setProperty("resource.loader", "class");
        properties.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("input.encoding", "utf-8");
        properties.setProperty("output.encoding", "utf-8");
        properties.setProperty("default.contentType", "text/html; charset=UTF-8");
        Velocity.init((Properties)properties);
        if (itemClass != null) {
            servlets.addServlet("Item", "/Item", itemClass.getName());
            if (itemClass == FileSystemItem.class) {
                context.setAttribute("derelativise", (Object)Boolean.TRUE);
            }
        } else {
            context.setAttribute("uri", (Object)Boolean.TRUE);
        }
        context.setAttribute("mimeType", (Object)itemMimeType);
        this.server.start();
    }
}

