/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.search;

import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.query.parser.SimpleParser;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIteratorBuilderVisitor;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.OrderedAndDocumentIterator;
import it.unimi.dsi.mg4j.tool.IndexBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import test.it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;
import test.it.unimi.dsi.mg4j.search.IntArrayDocumentIterator;
import test.it.unimi.dsi.mg4j.search.IntArrayIndexIterator;

public class OrderedAndDocumentIteratorTest
extends TestCase {
    public void testSkipBug() throws QueryParserException, QueryBuilderVisitorException, IOException, ConfigurationException, SecurityException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String basename = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "test").getCanonicalPath();
        new IndexBuilder(basename, new StringArrayDocumentCollection("a a b c d e")).run();
        BitStreamIndex index = DiskBasedIndex.getInstance(basename + "-text", true, true);
        SimpleParser simpleParser = new SimpleParser(index.termProcessor);
        Query query = simpleParser.parse("(a|b|d)<(a|b|d)");
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(null, index, Integer.MAX_VALUE);
        DocumentIterator documentIterator = query.accept(documentIteratorBuilderVisitor);
        documentIterator.nextDocument();
        IntervalIterator intervalIterator = documentIterator.intervalIterator();
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)intervalIterator.nextInterval());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)intervalIterator.nextInterval());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(2, 4), (Object)intervalIterator.nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)intervalIterator.hasNext());
        documentIterator.dispose();
    }

    public void testTrue() throws IOException {
        IntArrayDocumentIterator i0 = new IntArrayDocumentIterator(new int[]{0, 1, 2, 3}, new int[][][]{new int[][]{{0, 1}, {1, 2}}, new int[][]{{0, 1}, {1, 2}}, new int[][]{new int[0]}, new int[][]{{0}, {1}, {2}}});
        IntArrayDocumentIterator i1 = new IntArrayDocumentIterator(new int[]{0, 1, 2, 3}, new int[][][]{new int[][]{new int[0]}, new int[][]{new int[0]}, new int[][]{{2}}, new int[][]{{0}, {1}, {2}}});
        IntArrayDocumentIterator i2 = new IntArrayDocumentIterator(new int[]{0, 1, 2, 3}, new int[][][]{new int[][]{new int[0]}, new int[][]{{3}}, new int[][]{new int[0]}, new int[][]{{0}, {1}, {2}}});
        DocumentIterator orderedAndDocumentIterator = OrderedAndDocumentIterator.getInstance(i0, i1, i2);
        OrderedAndDocumentIteratorTest.assertTrue((boolean)orderedAndDocumentIterator.hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)1, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)1, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 3), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)2, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)2, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(2), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)3, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)3, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.hasNext());
    }

    public void testAllAlignmentFailures() throws IOException {
        IntArrayDocumentIterator i0 = new IntArrayDocumentIterator(new int[]{0, 1, 2, 3, 4}, new int[][][]{new int[][]{{0, 1}, {1, 2}}, new int[][]{{0, 1}, {1, 4}}, new int[][]{{1}, {2}}, new int[][]{{0, 1}, {1, 4}}, new int[][]{{0, 1}, {1, 5}}});
        IntArrayDocumentIterator i1 = new IntArrayDocumentIterator(new int[]{0, 1, 2, 3, 4}, new int[][][]{new int[][]{{2, 4}}, new int[][]{{2, 4}, {5, 6}}, new int[][]{{2}, {3}}, new int[][]{{2, 3}, {5}}, new int[][]{{2, 3}, {5}}});
        IntArrayDocumentIterator i2 = new IntArrayDocumentIterator(new int[]{0, 1, 2, 3, 4}, new int[][][]{new int[][]{{6, 7}}, new int[][]{{6, 7}}, new int[][]{{1, 2}, {2, 3}, {4}}, new int[][]{{6, 7}}, new int[][]{{6, 7}}});
        DocumentIterator orderedAndDocumentIterator = OrderedAndDocumentIterator.getInstance(i0, i1, i2);
        OrderedAndDocumentIteratorTest.assertTrue((boolean)orderedAndDocumentIterator.hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 7), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)1, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 7), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)2, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(2, 4), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)3, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 7), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)4, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 7), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
    }

    public void testLoopcounterPersistence() throws IOException {
        IntArrayDocumentIterator i0 = new IntArrayDocumentIterator(new int[]{0}, new int[][][]{new int[][]{{10, 20}, {30, 40}, {87, 88}}});
        IntArrayDocumentIterator i1 = new IntArrayDocumentIterator(new int[]{0}, new int[][][]{new int[][]{{25, 27}, {45, 47}}});
        IntArrayDocumentIterator i2 = new IntArrayDocumentIterator(new int[]{0}, new int[][][]{new int[][]{{32, 40}, {35, 52}, {80, 90}, {120, 130}}});
        IntArrayDocumentIterator i3 = new IntArrayDocumentIterator(new int[]{0}, new int[][][]{new int[][]{{49, 50}, {92, 105}, {140, 150}}});
        DocumentIterator orderedAndDocumentIterator = OrderedAndDocumentIterator.getInstance(i0, i1, i2, i3);
        OrderedAndDocumentIteratorTest.assertTrue((boolean)orderedAndDocumentIterator.hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(10, 50), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(30, 105), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
    }

    public void testLoopcounterPersistenceSingleton() throws IOException {
        IntArrayIndexIterator i0 = new IntArrayIndexIterator(new int[]{0}, new int[][]{{1, 4, 11}});
        IntArrayIndexIterator i1 = new IntArrayIndexIterator(new int[]{0}, new int[][]{{2, 7}});
        IntArrayIndexIterator i2 = new IntArrayIndexIterator(new int[]{0}, new int[][]{{7, 10, 14, 20}});
        IntArrayIndexIterator i3 = new IntArrayIndexIterator(new int[]{0}, new int[][]{{10, 15, 30}});
        DocumentIterator orderedAndDocumentIterator = OrderedAndDocumentIterator.getInstance(i0, i1, i2, i3);
        OrderedAndDocumentIteratorTest.assertTrue((boolean)orderedAndDocumentIterator.hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 10), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(4, 15), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
    }

    public void testIndexIntervalIterator() throws IOException {
        IntArrayIndexIterator i0 = new IntArrayIndexIterator(new int[]{0, 1, 2, 3, 4, 5}, new int[][]{{0, 1, 2}, {0}, {3}, {1, 2}, {1, 2}, {1, 3}});
        IntArrayIndexIterator i1 = new IntArrayIndexIterator(new int[]{0, 1, 2, 3, 4, 5}, new int[][]{{0, 1, 2}, {1}, {4}, {2, 4}, {3}, {2, 3}});
        IntArrayIndexIterator i2 = new IntArrayIndexIterator(new int[]{0, 1, 2, 3, 4, 5}, new int[][]{{0, 1, 2}, {2}, {2}, {4, 8}, {4}, {5}});
        DocumentIterator orderedAndDocumentIterator = OrderedAndDocumentIterator.getInstance(i0, i1, i2);
        OrderedAndDocumentIteratorTest.assertTrue((boolean)orderedAndDocumentIterator.hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)0, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)1, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)1, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)3, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)3, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 4), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(2, 8), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)4, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)4, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(2, 4), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertEquals((int)5, (int)orderedAndDocumentIterator.nextDocument());
        OrderedAndDocumentIteratorTest.assertEquals((int)5, (int)orderedAndDocumentIterator.document());
        OrderedAndDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 5), (Object)orderedAndDocumentIterator.intervalIterator().nextInterval());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.intervalIterator().hasNext());
        OrderedAndDocumentIteratorTest.assertFalse((boolean)orderedAndDocumentIterator.hasNext());
    }
}

