/*
 * Decompiled with CFR 0.152.
 */
package it.unipi.di.util;

import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unipi.di.util.STUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ExternalSort {
    public static final long DEFAULT_RUN_SIZE = (long)(50.0 * Math.pow(2.0, 20.0));
    public static final int DEFAULT_PAGE_SIZE = 102400;
    public static final String VERSION = "0.1.3 - run!";
    protected HashMap<Long, Reader> runsMap;
    protected InputStream in = System.in;
    protected PrintStream out = System.out;
    protected String outfile;
    protected String infile;
    protected int[] columns = new int[0];
    protected char sep = (char)9;
    protected long runSize = DEFAULT_RUN_SIZE;
    protected int pageSize = 102400;
    protected long elapsedSecs = 0L;
    protected long numberOfDumpedRows = 0L;
    protected long numberOfInputRows = 0L;
    protected boolean reverse = false;
    protected boolean numeric = false;
    protected boolean uniq = false;
    protected String currKey = null;
    protected boolean dist = false;
    protected String prevKey = null;
    protected long rowsCount = 0L;
    protected boolean EOF = false;
    protected MutableString buff = new MutableString(1024);
    protected boolean extract = false;
    private TreeMap<String, Tuple> map;

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public void setKeysDistribution(boolean dist) {
        this.dist = dist;
    }

    public void setUniq(boolean uniq) {
        this.uniq = uniq;
    }

    public void setRunSize(long runSize) {
        this.runSize = runSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setColumns(int[] columns) {
        this.columns = columns;
    }

    public void setSeparator(char sep) {
        this.sep = sep;
    }

    public void setExtract(boolean extract) {
        this.extract = extract;
    }

    private void resetProgressInfos() {
        this.elapsedSecs = 0L;
        this.numberOfDumpedRows = 0L;
        this.numberOfInputRows = 0L;
    }

    public void setOutFile(String outfile) throws FileNotFoundException {
        this.outfile = outfile;
    }

    public void setInFile(String infile) throws FileNotFoundException {
        this.infile = infile;
        this.in = new FileInputStream(infile);
    }

    protected void updateProgressInfos(long start) {
        long rowsPerSec = 0L;
        this.elapsedSecs = (System.currentTimeMillis() - start) / 1000L;
        if (this.elapsedSecs > 0L) {
            rowsPerSec = this.numberOfDumpedRows / this.elapsedSecs;
        }
        System.out.println(" >> Input rows: " + this.numberOfInputRows + ", dumped rows: " + this.numberOfDumpedRows + " @ " + rowsPerSec + " rows/sec.");
    }

    public void run() throws IOException {
        FastBufferedReader fbr = new FastBufferedReader((Reader)new InputStreamReader(this.in));
        this.runsMap = new HashMap();
        ArrayList<SortingKey> chunk = new ArrayList<SortingKey>();
        long chunkCounter = 0L;
        long tmpFileSize = 0L;
        this.rowsCount = 0L;
        while (!this.EOF) {
            int currChunkSize = 0;
            while ((long)currChunkSize <= this.runSize) {
                if (fbr.readLine(this.buff) == null) {
                    this.EOF = true;
                    break;
                }
                String line = this.buff.toString();
                String key = STUtils.getKey(line, this.columns, this.sep, this.numeric);
                SortingKey s = new SortingKey(line, key, this.reverse);
                chunk.add(s);
                ++this.rowsCount;
                currChunkSize += this.buff.length();
            }
            File tmpFile = this.createSortedRun(chunk);
            this.runsMap.put(++chunkCounter, (Reader)new FastBufferedReader((Reader)new FileReader(tmpFile)));
            tmpFileSize += tmpFile.length();
            chunk.clear();
        }
        fbr.close();
        this.initDataStructure();
        this.resetProgressInfos();
        for (Long runNumber : this.runsMap.keySet()) {
            this.loadNextPage(runNumber);
        }
        this.dumpSortedRows();
        for (Reader r : this.runsMap.values()) {
            r.close();
        }
    }

    protected File createSortedRun(List<SortingKey> chunk) throws IOException {
        File tmp = File.createTempFile("run", ".txt");
        tmp.deleteOnExit();
        Collections.sort(chunk);
        BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
        for (SortingKey e : chunk) {
            bw.write(e.row);
            bw.write(10);
        }
        bw.close();
        return tmp;
    }

    protected void initDataStructure() {
        this.map = this.reverse ? new TreeMap(new ReverseComparator()) : new TreeMap();
    }

    protected void loadNextPage(long runNumber) throws IOException {
        int currPageSize = 0;
        String key = null;
        FastBufferedReader reader = (FastBufferedReader)this.runsMap.get(runNumber);
        MutableString row = reader.readLine(this.buff);
        while (row != null) {
            Tuple tuple;
            String line = this.buff.toString();
            ++this.numberOfInputRows;
            currPageSize += this.buff.length();
            key = STUtils.getKey(line, this.columns, this.sep, this.numeric);
            Tuple oldTuple = this.map.put(key, tuple = new Tuple());
            if (oldTuple != null) {
                tuple.run = oldTuple.run;
                tuple.lines = oldTuple.lines;
            }
            if (!this.uniq || tuple.lines.size() == 0 && !key.equals(this.currKey)) {
                tuple.append(line);
            }
            if (currPageSize >= this.pageSize) {
                tuple.appendRun(runNumber);
                break;
            }
            row = reader.readLine(this.buff);
        }
    }

    protected void dumpSortedRows() throws IOException {
        if (this.outfile != null) {
            this.out = new PrintStream(this.outfile);
        }
        BufferedWriter bw = new BufferedWriter(new PrintWriter(this.out, false), 16384);
        int freq = 0;
        while (!this.map.isEmpty()) {
            long[] toLoad = null;
            Set<Map.Entry<String, Tuple>> entrySet = this.map.entrySet();
            Iterator<Map.Entry<String, Tuple>> iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Tuple> entry = iter.next();
                iter.remove();
                this.currKey = entry.getKey();
                this.prevKey = this.prevKey == null ? this.currKey : this.prevKey;
                Tuple tuple = entry.getValue();
                List<String> lines = tuple.lines;
                for (int i = 0; i < lines.size(); ++i) {
                    if (this.dist) {
                        if (!this.currKey.equals(this.prevKey)) {
                            String str = this.numeric ? STUtils.trimLeftZeros(this.prevKey) : this.prevKey;
                            bw.write(str);
                            bw.write("\t");
                            bw.write("" + freq);
                            bw.write("\n");
                            freq = 0;
                            this.prevKey = this.currKey;
                            ++this.numberOfDumpedRows;
                        }
                        ++freq;
                        continue;
                    }
                    if (this.extract) {
                        bw.write(this.numeric ? STUtils.trimLeftZeros(this.currKey) : this.currKey);
                    } else {
                        bw.write(lines.get(i));
                    }
                    bw.write("\n");
                    ++this.numberOfDumpedRows;
                }
                if (tuple.run == null) continue;
                toLoad = tuple.run;
                break;
            }
            if (toLoad == null) continue;
            for (int i = 0; i < toLoad.length; ++i) {
                this.loadNextPage((long)toLoad[i]);
            }
        }
        if (this.dist) {
            String str = this.numeric ? STUtils.trimLeftZeros(this.prevKey) : this.prevKey;
            bw.write(str);
            bw.write("\t");
            bw.write("" + freq);
            bw.write("\n");
            ++this.numberOfDumpedRows;
        }
        bw.flush();
        if (this.out != System.out) {
            this.out.close();
        }
    }

    protected class SortingKey
    implements Comparable<SortingKey> {
        public String key;
        public String row;
        private boolean reverse = false;

        public SortingKey(String row, String key) {
            this.row = row;
            this.key = key;
        }

        public SortingKey(String row, String cols, boolean reverse) {
            this.row = row;
            this.key = cols;
            this.reverse = reverse;
        }

        public void setReverse(boolean reverse) {
            this.reverse = reverse;
        }

        public int length() {
            return this.key != this.row ? this.key.length() + this.row.length() : this.row.length();
        }

        @Override
        public final int compareTo(SortingKey k) {
            return this.reverse ? -this.key.compareTo(k.key) : this.key.compareTo(k.key);
        }
    }

    protected class Tuple {
        public List<String> lines = new ArrayList<String>();
        public long[] run;

        public final void appendRun(long runNumber) {
            if (this.run == null) {
                this.run = new long[]{runNumber};
                return;
            }
            int size = this.run.length + 1;
            long[] tmp = new long[size];
            System.arraycopy(this.run, 0, tmp, 0, this.run.length);
            tmp[size - 1] = runNumber;
            this.run = tmp;
        }

        public void append(String x) {
            this.lines.add(x);
        }
    }

    public class ReverseComparator
    implements Comparator<String> {
        @Override
        public final int compare(String o1, String o2) {
            return -o1.compareTo(o2);
        }
    }
}

