/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.IntervalFileWriter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import org.apache.log4j.Logger;

public class Subsample
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Subsample.class);
    @Parameter(names={"-i", "--input"}, required=true, description="Input file", validateWith=ReadablePathValidator.class)
    public Path input;
    @Parameter(names={"-n", "--select"}, required=true, description="Number of entries to select")
    public int n;
    @Parameter(names={"-o", "--output"}, required=true, description="Output file")
    public Path output;

    @Override
    public void run() throws IOException {
        try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.input);
             IntervalFileWriter writer = new IntervalFileWriter(this.output, new OpenOption[0]);){
            int nRemaining = reader.count();
            log.info((Object)("Input file has " + nRemaining + " entries"));
            if (this.n >= reader.count()) {
                throw new CommandLineToolException("Cannot select " + this.n + " entries from a file with " + nRemaining);
            }
            log.info((Object)("Randomly selecting " + this.n + " entries"));
            Random rng = new Random();
            for (Interval entry : reader) {
                if (this.n == 0) {
                    break;
                }
                if (rng.nextDouble() < (double)this.n / (double)nRemaining) {
                    writer.write(entry);
                    --this.n;
                }
                --nRemaining;
            }
        }
    }

    public static void main(String[] args) {
        new Subsample().instanceMain(args);
    }
}

