/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadMapperTool;
import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class IntervalToWig
extends ReadMapperTool {
    private static final Logger log = Logger.getLogger(IntervalToWig.class);
    @Parameter(names={"-z", "--zero"}, description="Assume zero where there is no data (default = NaN)")
    public boolean defaultZero = false;

    @Override
    public float[] compute(IntervalFileReader<? extends Interval> reader, Interval chunk) throws IOException {
        float[] sum = new float[chunk.length()];
        int[] count = new int[chunk.length()];
        Iterator it = reader.query(chunk);
        while (it.hasNext()) {
            ValuedInterval entry;
            try {
                entry = (ValuedInterval)it.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Input file does not appear to be a valued interval format (Bed/BedGraph/GFF/GeneTrack)!");
                throw new CommandLineToolException("Input file does not appear to be a valued interval format (Bed/BedGraph/GFF/GeneTrack)!");
            }
            if (entry.getValue() == null) continue;
            int entryStart = Math.max(chunk.getStart(), entry.low());
            int entryStop = Math.min(chunk.getStop(), entry.high());
            for (int i = entryStart; i <= entryStop; ++i) {
                int n = i - chunk.getStart();
                sum[n] = sum[n] + entry.getValue().floatValue();
                int n2 = i - chunk.getStart();
                count[n2] = count[n2] + 1;
            }
        }
        for (int i = 0; i < sum.length; ++i) {
            if (count[i] == 0 && this.defaultZero) continue;
            int n = i;
            sum[n] = sum[n] / (float)count[i];
        }
        return sum;
    }

    public static void main(String[] args) {
        new IntervalToWig().instanceMain(args);
    }
}

