/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;

public class ZScore
extends WigMathTool {
    private static final Logger log = Logger.getLogger(ZScore.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-b", "--bychr"}, description="Z-score each chromosome individually")
    public boolean byChromosome = false;
    WigFileReader reader;
    Map<String, Float> means = new HashMap<String, Float>();
    Map<String, Float> stdevs = new HashMap<String, Float>();

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
            for (String chr : this.reader.chromosomes()) {
                float stdev;
                float mean;
                if (this.byChromosome) {
                    SummaryStatistics stats = this.reader.queryStats(chr, this.reader.getChrStart(chr), this.reader.getChrStop(chr));
                    mean = (float)stats.getMean();
                    stdev = (float)stats.getStandardDeviation();
                    log.debug((Object)("Z-scoring " + chr + " to chromosome mean = " + mean + ", stdev = " + stdev));
                } else {
                    mean = (float)this.reader.mean();
                    stdev = (float)this.reader.stdev();
                }
                if (stdev == 0.0f) {
                    throw new CommandLineToolException("Cannot Z-score a file with stdev = 0!");
                }
                this.means.put(chr, Float.valueOf(mean));
                this.stdevs.put(chr, Float.valueOf(stdev));
            }
        }
        catch (WigFileException | IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
        if (!this.byChromosome) {
            log.debug((Object)("Z-scoring all chromosomes to global mean = " + this.reader.mean() + ", stdev = " + this.reader.stdev()));
        }
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] result = this.reader.query(chunk).getValues();
        float mean = this.means.get(chunk.getChr()).floatValue();
        float stdev = this.stdevs.get(chunk.getChr()).floatValue();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (result[i] - mean) / stdev;
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new ZScore().instanceMain(args);
    }
}

