/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.concurrent.Future;
import org.jtransforms.dct.FloatDCT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class FloatDST_1D {
    private final int n;
    private final long nl;
    private final FloatDCT_1D dct;
    private final boolean useLargeArrays;

    public FloatDST_1D(long l) {
        this.n = (int)l;
        this.nl = l;
        this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        this.dct = new FloatDCT_1D(l);
    }

    public void forward(float[] fArray, boolean bl) {
        this.forward(fArray, 0, bl);
    }

    public void forward(FloatLargeArray floatLargeArray, boolean bl) {
        this.forward(floatLargeArray, 0L, bl);
    }

    public void forward(final float[] fArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new FloatLargeArray(fArray), (long)n, bl);
        } else {
            int n2;
            int n3 = this.n / 2;
            int n4 = 1 + n;
            int n5 = n + this.n;
            for (n2 = n4; n2 < n5; n2 += 2) {
                fArray[n2] = -fArray[n2];
            }
            this.dct.forward(fArray, n, bl);
            n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && (long)n3 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n2 = 2;
                int n6 = n3 / n2;
                Future[] futureArray = new Future[n2];
                for (int i = 0; i < n2; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n2 - 1 ? n3 : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int n4 = n + FloatDST_1D.this.n - 1;
                            for (int i = n7; i < n8; ++i) {
                                int n2 = n + i;
                                float f = fArray[n2];
                                int n3 = n4 - i;
                                fArray[n2] = fArray[n3];
                                fArray[n3] = f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n9 = n + this.n - 1;
                for (int i = 0; i < n3; ++i) {
                    int n10 = n + i;
                    float f = fArray[n10];
                    int n11 = n9 - i;
                    fArray[n10] = fArray[n11];
                    fArray[n11] = f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final FloatLargeArray floatLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (floatLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(floatLargeArray.getData(), (int)l, bl);
            return;
        } else {
            long l2 = this.nl / 2L;
            long l3 = 1L + l;
            long l4 = l + this.nl;
            for (long i = l3; i < l4; i += 2L) {
                floatLargeArray.setFloat(i, -floatLargeArray.getFloat(i));
            }
            this.dct.forward(floatLargeArray, l, bl);
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && l2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l5 = l2 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l6 = (long)i * l5;
                    final long l7 = i == n - 1 ? l2 : l6 + l5;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            long l4 = l + FloatDST_1D.this.nl - 1L;
                            for (long i = l6; i < l7; ++i) {
                                long l2 = l + i;
                                float f = floatLargeArray.getFloat(l2);
                                long l3 = l4 - i;
                                floatLargeArray.setFloat(l2, floatLargeArray.getFloat(l3));
                                floatLargeArray.setFloat(l3, f);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                return;
            } else {
                long l8 = l + this.nl - 1L;
                for (long i = 0L; i < l2; ++i) {
                    long l9 = l + i;
                    float f = floatLargeArray.getFloat(l9);
                    long l10 = l8 - i;
                    floatLargeArray.setFloat(l9, floatLargeArray.getFloat(l10));
                    floatLargeArray.setFloat(l10, f);
                }
            }
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(FloatLargeArray floatLargeArray, boolean bl) {
        this.inverse(floatLargeArray, 0L, bl);
    }

    public void inverse(final float[] fArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new FloatLargeArray(fArray), (long)n, bl);
        } else {
            int n2;
            int n3;
            int n4 = this.n / 2;
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && (long)n4 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n5 = 2;
                n3 = n4 / n5;
                Future[] futureArray = new Future[n5];
                for (n2 = 0; n2 < n5; ++n2) {
                    final int n6 = n2 * n3;
                    final int n7 = n2 == n5 - 1 ? n4 : n6 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int n4 = n + FloatDST_1D.this.n - 1;
                            for (int i = n6; i < n7; ++i) {
                                int n2 = n + i;
                                float f = fArray[n2];
                                int n3 = n4 - i;
                                fArray[n2] = fArray[n3];
                                fArray[n3] = f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                n3 = n + this.n - 1;
                for (int i = 0; i < n4; ++i) {
                    float f = fArray[n + i];
                    fArray[n + i] = fArray[n3 - i];
                    fArray[n3 - i] = f;
                }
            }
            this.dct.inverse(fArray, n, bl);
            n3 = 1 + n;
            int n8 = n + this.n;
            for (n2 = n3; n2 < n8; n2 += 2) {
                fArray[n2] = -fArray[n2];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final FloatLargeArray floatLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (floatLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(floatLargeArray.getData(), (int)l, bl);
            return;
        } else {
            long l2;
            long l3;
            long l4 = this.nl / 2L;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && l4 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                l3 = l4 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    l2 = (long)i * l3;
                    final long l5 = i == n - 1 ? l4 : l2 + l3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            long l4 = l + FloatDST_1D.this.nl - 1L;
                            for (long i = l2; i < l5; ++i) {
                                long l22 = l + i;
                                float f = floatLargeArray.getFloat(l22);
                                long l3 = l4 - i;
                                floatLargeArray.setFloat(l22, floatLargeArray.getFloat(l3));
                                floatLargeArray.setFloat(l3, f);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                l3 = l + this.nl - 1L;
                for (long i = 0L; i < l4; ++i) {
                    float f = floatLargeArray.getFloat(l + i);
                    floatLargeArray.setFloat(l + i, floatLargeArray.getFloat(l3 - i));
                    floatLargeArray.setFloat(l3 - i, f);
                }
            }
            this.dct.inverse(floatLargeArray, l, bl);
            l3 = 1L + l;
            long l6 = l + this.nl;
            for (l2 = l3; l2 < l6; l2 += 2L) {
                floatLargeArray.setFloat(l2, -floatLargeArray.getFloat(l2));
            }
        }
    }
}

