/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.sf.samtools.TabixWriter;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.apache.log4j.Logger;

public class Tabix {
    private static final Logger log = Logger.getLogger(Tabix.class);

    public static void bgzip(Path input, Path output) throws IOException {
        log.debug((Object)("BGZipping " + input + " for Tabix indexing"));
        InputStream is = Files.newInputStream(input, new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(is);
        BlockCompressedOutputStream bcos = new BlockCompressedOutputStream(output.toFile());
        int data = -1;
        while ((data = bis.read()) != -1) {
            bcos.write(data);
        }
        bcos.close();
        bis.close();
        is.close();
    }

    public static Path index(Path file, TabixWriter.Conf conf) throws IOException, TabixWriter.TabixException {
        log.debug((Object)("Indexing " + file + " with Tabix"));
        TabixWriter writer = new TabixWriter(file, conf);
        return writer.createIndex();
    }
}

