/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import ed.javatools.BufferedRandomAccessFile;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.ContigIndex;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileFormatException;
import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

class VariableStepContigIndex
extends ContigIndex {
    private static final long serialVersionUID = 3139905829545756903L;

    public VariableStepContigIndex(String chr, int start, int stop, int span) {
        super(chr, start, stop, span);
    }

    public static VariableStepContigIndex parseHeader(String headerLine) throws WigFileFormatException {
        String[] tokens = headerLine.split("\\s+");
        if (tokens.length == 0 || !tokens[0].equals(Contig.Type.VARIABLESTEP.getId())) {
            throw new WigFileFormatException("Not a valid variableStep header line: " + headerLine);
        }
        String chr = "";
        int start = 1;
        int span = 1;
        block8: for (int i = 1; i < tokens.length; ++i) {
            String s = tokens[i];
            String[] pair = s.split("=");
            if (pair.length != 2) {
                throw new WigFileFormatException("Invalid keypair in variableStep header line: " + s);
            }
            String key = pair[0];
            String value = pair[1];
            switch (key) {
                case "chrom": {
                    chr = value;
                    continue block8;
                }
                case "span": {
                    span = Integer.parseInt(value);
                    continue block8;
                }
                default: {
                    throw new WigFileFormatException("Invalid attribute in variableStep header line: " + key);
                }
            }
        }
        return new VariableStepContigIndex(chr, start, -1, span);
    }

    @Override
    public String toOutput() {
        return Contig.Type.VARIABLESTEP.getId() + " chrom=" + this.getChr() + " span=" + this.getSpan();
    }

    @Override
    public boolean isFixedStep() {
        return false;
    }

    @Override
    public boolean isVariableStep() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(BufferedRandomAccessFile raf, Interval interval, float[] values) throws WigFileException, IOException {
        int low = Math.max(this.getStart(), interval.low());
        int high = Math.min(this.getStop(), interval.high());
        int closestUpstream = this.getUpstreamIndexedBP(low);
        BufferedRandomAccessFile bufferedRandomAccessFile = raf;
        synchronized (bufferedRandomAccessFile) {
            String line;
            raf.seek(this.getIndex(closestUpstream));
            int bp = low;
            while (!((line = raf.readLine2()) == null || bp > high || line.startsWith("track") || line.startsWith(Contig.Type.FIXEDSTEP.getId()) || line.startsWith(Contig.Type.VARIABLESTEP.getId()))) {
                float value;
                String[] entry = line.split("\\s+");
                bp = Integer.parseInt(entry[0]);
                if (bp + this.getSpan() - 1 < low || Float.isNaN(value = Float.parseFloat(entry[1]))) continue;
                for (int i = bp; i <= bp + this.getSpan() - 1; ++i) {
                    if (!interval.includes(i)) continue;
                    values[i - interval.low()] = value;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillStats(BufferedRandomAccessFile raf, Interval interval, SummaryStatistics stats) throws WigFileException, IOException {
        int low = Math.max(this.getStart(), interval.low());
        int high = Math.min(this.getStop(), interval.high());
        int closestUpstream = this.getUpstreamIndexedBP(low);
        BufferedRandomAccessFile bufferedRandomAccessFile = raf;
        synchronized (bufferedRandomAccessFile) {
            String line;
            raf.seek(this.getIndex(closestUpstream));
            int bp = low;
            while (!((line = raf.readLine2()) == null || bp > high || line.startsWith("track") || line.startsWith(Contig.Type.FIXEDSTEP.getId()) || line.startsWith(Contig.Type.VARIABLESTEP.getId()))) {
                float value;
                String[] entry = line.split("\\s+");
                bp = Integer.parseInt(entry[0]);
                if (bp + this.getSpan() - 1 < low || Float.isNaN(value = Float.parseFloat(entry[1]))) continue;
                for (int i = bp; i <= bp + this.getSpan() - 1; ++i) {
                    if (!interval.includes(i)) continue;
                    stats.addValue((double)value);
                }
            }
        }
    }
}

