/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.WigAnalysisTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Correlate
extends WigAnalysisTool {
    private static final Logger log = Logger.getLogger(Correlate.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"-z", "--assume-zero"}, description="Assume missing data is zero")
    public boolean assumeZero = false;
    @Parameter(names={"-o", "--output"}, description="Output file")
    public Path outputFile;
    private int[][] n;
    private double[][] sumX;
    private double[][] sumY;
    private double[][] sumSqX;
    private double[][] sumSqY;
    private double[][] sumXY;

    @Override
    protected void prepare() {
        if (this.inputFiles.size() < 2) {
            throw new CommandLineToolException("Cannot correlate < 2 input files.");
        }
        log.debug((Object)"Initializing input files");
        for (String inputFile : this.inputFiles) {
            try {
                this.addInputFile(WigFileReader.autodetect((Path)Paths.get(inputFile, new String[0])));
            }
            catch (IOException e) {
                throw new CommandLineToolException("IOError initializing input Wig file: " + inputFile, e);
            }
        }
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
        this.unionExtents = true;
        this.n = new int[this.inputs.size()][this.inputs.size()];
        this.sumX = new double[this.inputs.size()][this.inputs.size()];
        this.sumY = new double[this.inputs.size()][this.inputs.size()];
        this.sumSqX = new double[this.inputs.size()][this.inputs.size()];
        this.sumSqY = new double[this.inputs.size()][this.inputs.size()];
        this.sumXY = new double[this.inputs.size()][this.inputs.size()];
    }

    @Override
    protected void process(Interval chunk) throws IOException, WigFileException {
        float[][] values = new float[this.inputs.size()][chunk.length()];
        for (int i = 0; i < this.inputs.size(); ++i) {
            values[i] = ((WigFileReader)this.inputs.get(i)).query(chunk).getValues();
            if (this.assumeZero) {
                for (int k = 0; k < chunk.length(); ++k) {
                    if (!Float.isNaN(values[i][k])) continue;
                    values[i][k] = 0.0f;
                }
            }
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < chunk.length(); ++k) {
                    float x = values[i][k];
                    float y = values[j][k];
                    if (Float.isNaN(x) || Float.isInfinite(x) || Float.isNaN(y) || Float.isInfinite(y)) continue;
                    int[] nArray = this.n[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    double[] dArray = this.sumX[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + (double)x;
                    double[] dArray2 = this.sumY[i];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + (double)y;
                    double[] dArray3 = this.sumSqX[i];
                    int n4 = j;
                    dArray3[n4] = dArray3[n4] + (double)(x * x);
                    double[] dArray4 = this.sumSqY[i];
                    int n5 = j;
                    dArray4[n5] = dArray4[n5] + (double)(y * y);
                    double[] dArray5 = this.sumXY[i];
                    int n6 = j;
                    dArray5[n6] = dArray5[n6] + (double)(x * y);
                }
            }
        }
    }

    @Override
    protected void shutdown() throws IOException {
        float[][] correlation = new float[this.inputs.size()][this.inputs.size()];
        for (int i = 0; i < correlation.length; ++i) {
            correlation[i][i] = 1.0f;
            for (int j = 0; j < i; ++j) {
                double covarXY = (double)this.n[i][j] * this.sumXY[i][j] - this.sumX[i][j] * this.sumY[i][j];
                double stdX = Math.sqrt((double)this.n[i][j] * this.sumSqX[i][j] - this.sumX[i][j] * this.sumX[i][j]);
                double stdY = Math.sqrt((double)this.n[i][j] * this.sumSqY[i][j] - this.sumY[i][j] * this.sumY[i][j]);
                correlation[i][j] = (float)(covarXY / (stdX * stdY));
                correlation[j][i] = correlation[i][j];
            }
        }
        this.printCorrelationMatrix(correlation);
    }

    private void printCorrelationMatrix(float[][] correlation) throws IOException {
        int i;
        StringBuilder output = new StringBuilder();
        for (i = 0; i < this.inputs.size(); ++i) {
            output.append("\t" + ((WigFileReader)this.inputs.get(i)).getPath().getFileName());
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            output.append("\n" + ((WigFileReader)this.inputs.get(i)).getPath().getFileName());
            for (int j = 0; j < this.inputs.size(); ++j) {
                output.append("\t" + correlation[i][j]);
            }
        }
        if (this.outputFile != null) {
            log.debug((Object)"Writing to output file");
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
                writer.write(output.toString());
            }
        } else {
            System.out.println(output.toString());
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Correlate().instanceMain(args);
    }
}

