/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;

public class Scale
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Scale.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-m", "--multiplier"}, description="Multiplier (scale factor, default = 1/mean)")
    public Float multiplier;
    @Parameter(names={"-b", "--bychr"}, description="Scale to the mean of each chromosome")
    public boolean byChromosome = false;
    WigFileReader reader;
    Map<String, Float> scales = new HashMap<String, Float>();

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
            for (String chr : this.reader.chromosomes()) {
                float scale;
                if (this.multiplier == null || this.multiplier.floatValue() == 0.0f) {
                    if (this.byChromosome) {
                        SummaryStatistics stats = this.reader.queryStats(chr, this.reader.getChrStart(chr), this.reader.getChrStop(chr));
                        scale = (float)((double)stats.getN() / stats.getSum());
                        log.debug((Object)("Scaling " + chr + " to chromosome mean: " + stats.getMean()));
                    } else {
                        scale = (float)((double)this.reader.numBases() / this.reader.total());
                        log.debug((Object)("Scaling " + chr + " to global mean: " + this.reader.mean()));
                    }
                } else {
                    scale = this.multiplier.floatValue();
                    log.debug((Object)("Scaling " + chr + " by " + this.multiplier));
                }
                this.scales.put(chr, Float.valueOf(scale));
            }
        }
        catch (WigFileException | IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] result = this.reader.query(chunk).getValues();
        float scale = this.scales.get(chunk.getChr()).floatValue();
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] * scale;
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Scale().instanceMain(args);
    }
}

