/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.ucsc.genome.TrackHeader;
import edu.ucsc.genome.TrackHeaderException;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.BedGraphEntry;
import edu.unc.genomics.GFFEntry;
import edu.unc.genomics.VCFEntry;
import edu.unc.genomics.io.IntervalFileSnifferException;
import edu.unc.genomics.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileReader;

public class IntervalFileSniffer {
    private static final Logger log = Logger.getLogger(IntervalFileSniffer.class);
    protected Path p;
    protected String firstLine;
    protected TrackHeader trackHeader;
    protected Boolean isAscii;

    public IntervalFileSniffer(Path p) {
        this.p = p;
    }

    public void diagnose() throws IOException {
        log.info((Object)("Diagnosing " + this.p));
        if (this.isAscii().booleanValue()) {
            log.info((Object)"File appears to be ASCII");
            log.info((Object)("Data line used for diagnosis: " + this.getFirstLine()));
            try {
                log.info((Object)"Assessing if file is GFF format");
                this.sniffGFF();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
            try {
                log.info((Object)"Assessing if file is BedGraph format");
                this.sniffBedGraph();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
            try {
                log.info((Object)"Assessing if file is Bed format");
                this.sniffBed();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
            try {
                log.info((Object)"Assessing if file is SAM format");
                this.sniffSAM();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
            try {
                log.info((Object)"Assessing if file is GeneTrack format");
                this.sniffGeneTrack();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
            try {
                log.info((Object)"Assessing if file is VCF format");
                this.sniffVCF();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
        } else {
            log.info((Object)"File appears to be binary");
            try {
                log.info((Object)"Assessing if file is BigBed format");
                this.sniffBigBed();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
            try {
                log.info((Object)"Assessing if file is BAM format");
                this.sniffBAM();
            }
            catch (IntervalFileSnifferException e) {
                log.info((Object)e.getMessage());
            }
        }
    }

    public Boolean isAscii() throws IOException {
        if (this.isAscii == null) {
            this.isAscii = FileUtils.isAsciiText(this.p);
        }
        return this.isAscii;
    }

    public Boolean isBinary() throws IOException {
        return this.isAscii() == false;
    }

    public boolean isBigBed() {
        try {
            return this.sniffBigBed();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    public boolean sniffBigBed() throws IntervalFileSnifferException {
        try {
            BBFileReader reader = new BBFileReader(this.p.toString());
            return reader.isBigBedFile();
        }
        catch (Exception e) {
            throw new IntervalFileSnifferException("Error opening BigBed file: " + e.getMessage());
        }
    }

    public boolean isBed() throws IOException {
        try {
            return this.sniffBed();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    public boolean sniffBed() throws IOException, IntervalFileSnifferException {
        if (!this.isAscii().booleanValue()) {
            throw new IntervalFileSnifferException("Bed files must be ASCII");
        }
        if (this.numColumns() < 3 || this.numColumns() > 12) {
            throw new IntervalFileSnifferException("Bed files must have 3-12 columns. This file has " + this.numColumns());
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(2))) {
            throw new IntervalFileSnifferException("Bed column 2 must be an integer chromosome coordinate.");
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(3))) {
            throw new IntervalFileSnifferException("Bed column 3 must be an integer chromosome coordinate.");
        }
        if (this.isBedGraph()) {
            throw new IntervalFileSnifferException("Bed file appears to be BedGraph format");
        }
        try {
            BedEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            throw new IntervalFileSnifferException("Error parsing Bed entry: " + e.getMessage());
        }
        return true;
    }

    public boolean isBedGraph() throws IOException {
        try {
            return this.sniffBedGraph();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    public boolean sniffBedGraph() throws IOException, IntervalFileSnifferException {
        if (!this.isAscii().booleanValue()) {
            throw new IntervalFileSnifferException("BedGraph files must be ASCII");
        }
        if (this.numColumns() != 4) {
            throw new IntervalFileSnifferException("BedGraph files must have 4 columns. This file has " + this.numColumns());
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(2))) {
            throw new IntervalFileSnifferException("BedGraph column 2 must be an integer chromosome coordinate.");
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(3))) {
            throw new IntervalFileSnifferException("BedGraph column 3 must be an integer chromosome coordinate.");
        }
        try {
            Float.parseFloat(this.column(4));
        }
        catch (Exception e) {
            throw new IntervalFileSnifferException("BedGraph column 4 must be a float. Cannot parse: " + this.column(4));
        }
        try {
            BedGraphEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            throw new IntervalFileSnifferException("Error parsing BedGraph entry: " + e.getMessage());
        }
        return true;
    }

    public boolean isGFF() throws IOException {
        try {
            return this.sniffGFF();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    public boolean sniffGFF() throws IOException, IntervalFileSnifferException {
        if (!this.isAscii().booleanValue()) {
            throw new IntervalFileSnifferException("GFF files must be ASCII");
        }
        if (this.numColumns() < 9) {
            throw new IntervalFileSnifferException("GFF files must have at least 9 columns. This file has " + this.numColumns());
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(4))) {
            throw new IntervalFileSnifferException("BedGraph column 4 must be an integer chromosome coordinate.");
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(5))) {
            throw new IntervalFileSnifferException("BedGraph column 5 must be an integer chromosome coordinate.");
        }
        try {
            GFFEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            throw new IntervalFileSnifferException("Error parsing GFF entry: " + e.getMessage());
        }
        return true;
    }

    public boolean isGeneTrack() throws IOException {
        try {
            return this.sniffGeneTrack();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    public boolean sniffGeneTrack() throws IOException, IntervalFileSnifferException {
        if (!this.isAscii().booleanValue()) {
            throw new IntervalFileSnifferException("GeneTrack files must be ASCII");
        }
        if (this.numColumns() != 4) {
            throw new IntervalFileSnifferException("GeneTrack files must have 4 columns. This file has " + this.numColumns());
        }
        if (this.column(1).equalsIgnoreCase("chrom") && this.column(2).equalsIgnoreCase("index") && this.column(3).equalsIgnoreCase("forward") && this.column(4).equalsIgnoreCase("reverse")) {
            return true;
        }
        throw new IntervalFileSnifferException("The first line of a GeneTrack file must be: chrom index forward reverse");
    }

    public boolean isVCF() throws IOException {
        try {
            return this.sniffVCF();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    public boolean sniffVCF() throws IOException, IntervalFileSnifferException {
        if (!this.isAscii().booleanValue()) {
            throw new IntervalFileSnifferException("VCF files must be ASCII");
        }
        if (this.numColumns() < 8) {
            throw new IntervalFileSnifferException("VCF files must have at least 8 columns. This file has " + this.numColumns());
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(2))) {
            throw new IntervalFileSnifferException("VCF column 2 must be an integer chromosome coordinate.");
        }
        try {
            VCFEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            throw new IntervalFileSnifferException("Error parsing VCF entry: " + e.getMessage());
        }
        return true;
    }

    public boolean isBAM() {
        try {
            return this.sniffBAM();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean sniffBAM() throws IntervalFileSnifferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSAM() throws IOException {
        try {
            return this.sniffSAM();
        }
        catch (IntervalFileSnifferException e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean sniffSAM() throws IOException, IntervalFileSnifferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TrackHeader getTrackHeader() throws IOException {
        if (!this.isAscii().booleanValue()) {
            return null;
        }
        if (this.trackHeader == null) {
            String trackLine = null;
            try (BufferedReader reader = Files.newBufferedReader(this.p, Charset.defaultCharset());){
                trackLine = reader.readLine();
                if (trackLine.startsWith("track")) {
                    this.trackHeader = TrackHeader.parse(trackLine);
                }
            }
            catch (TrackHeaderException e) {
                log.warn((Object)("Error parsing track line: " + trackLine));
                log.warn((Object)"Please email this track line to tim@palpant.us");
            }
            log.debug((Object)("Loaded track header of interval file: " + this.trackHeader));
        }
        return this.trackHeader;
    }

    private String getFirstLine() throws IOException {
        if (!this.isAscii().booleanValue()) {
            return null;
        }
        if (this.firstLine == null) {
            try (BufferedReader reader = Files.newBufferedReader(this.p, Charset.defaultCharset());){
                this.firstLine = reader.readLine();
                while (this.firstLine != null && (this.firstLine.length() == 0 || this.firstLine.startsWith("track") || this.firstLine.startsWith("#") || this.firstLine.startsWith("@"))) {
                    this.firstLine = reader.readLine();
                }
            }
            log.debug((Object)("Loaded first line of interval file: " + this.firstLine));
        }
        return this.firstLine;
    }

    private int numColumns() throws IOException {
        return this.getFirstLine().split("\t").length;
    }

    private String column(int n) throws IOException {
        return this.getFirstLine().split("\t")[n - 1];
    }
}

