/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.Arrays;
import org.jtransforms.dct.DoubleDCT_1D;
import org.jtransforms.dct.DoubleDCT_2D;
import org.jtransforms.dct.DoubleDCT_3D;
import org.jtransforms.utils.ConcurrencyUtils;
import org.jtransforms.utils.IOUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class BenchmarkDoubleDCT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static long[] sizes1D = new long[]{262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 10368L, 27000L, 75600L, 165375L, 362880L, 1562500L, 0x310000L, 6250000L};
    private static long[] sizes2D = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 260L, 520L, 1050L, 1458L, 1960L, 2916L, 4116L, 5832L};
    private static long[] sizes3D = new long[]{16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 5L, 17L, 30L, 95L, 180L, 270L, 324L, 420L};
    private static boolean doScaling = false;

    private BenchmarkDoubleDCT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new long[nsize];
            sizes2D = new long[nsize];
            sizes3D = new long[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDCT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDCT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDCT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            double[] dArray3;
            System.out.println("Forward DCT 1D of size " + sizes1D[i]);
            if (doWarmup) {
                DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(sizes1D[i]);
                dArray3 = new double[(int)sizes1D[i]];
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                doubleDCT_1D.forward(dArray3, doScaling);
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                doubleDCT_1D.forward(dArray3, doScaling);
            }
            long l = System.nanoTime();
            DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(sizes1D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            dArray3 = new double[(int)sizes1D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                doubleDCT_1D.forward(dArray3, doScaling);
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                doubleDCT_1D.forward(dArray3, doScaling);
            }
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                l = System.nanoTime();
                doubleDCT_1D.forward(dArray3, doScaling);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            dArray3 = null;
            doubleDCT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray, dArray2);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            DoubleLargeArray doubleLargeArray;
            System.out.println("Forward DCT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(sizes2D[i], sizes2D[i]);
                doubleLargeArray = new DoubleLargeArray(sizes2D[i] * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], doubleLargeArray);
                doubleDCT_2D.forward(doubleLargeArray, doScaling);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], doubleLargeArray);
                doubleDCT_2D.forward(doubleLargeArray, doScaling);
            }
            long l = System.nanoTime();
            DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            doubleLargeArray = new DoubleLargeArray(sizes2D[i] * sizes2D[i], false);
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], doubleLargeArray);
                l = System.nanoTime();
                doubleDCT_2D.forward(doubleLargeArray, doScaling);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            doubleLargeArray = null;
            doubleDCT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            double[][] dArray3;
            System.out.println("Forward DCT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(sizes2D[i], sizes2D[i]);
                dArray3 = new double[(int)sizes2D[i]][(int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray3);
                doubleDCT_2D.forward(dArray3, doScaling);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray3);
                doubleDCT_2D.forward(dArray3, doScaling);
            }
            long l = System.nanoTime();
            DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            dArray3 = new double[(int)sizes2D[i]][(int)sizes2D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray3);
                l = System.nanoTime();
                doubleDCT_2D.forward(dArray3, doScaling);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            dArray3 = null;
            doubleDCT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            DoubleLargeArray doubleLargeArray;
            System.out.println("Forward DCT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                doubleLargeArray = new DoubleLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], doubleLargeArray);
                doubleDCT_3D.forward(doubleLargeArray, doScaling);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], doubleLargeArray);
                doubleDCT_3D.forward(doubleLargeArray, doScaling);
            }
            long l = System.nanoTime();
            DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            doubleLargeArray = new DoubleLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], doubleLargeArray);
                l = System.nanoTime();
                doubleDCT_3D.forward(doubleLargeArray, doScaling);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            doubleLargeArray = null;
            doubleDCT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            double[][][] dArray3;
            System.out.println("Forward DCT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                dArray3 = new double[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray3);
                doubleDCT_3D.forward(dArray3, doScaling);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray3);
                doubleDCT_3D.forward(dArray3, doScaling);
            }
            long l = System.nanoTime();
            DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            dArray3 = new double[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray3);
                l = System.nanoTime();
                doubleDCT_3D.forward(dArray3, doScaling);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            dArray3 = null;
            doubleDCT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleDCT.parseArguments(stringArray);
        BenchmarkDoubleDCT.benchmarkForward_1D();
        BenchmarkDoubleDCT.benchmarkForward_2D_input_1D();
        BenchmarkDoubleDCT.benchmarkForward_2D_input_2D();
        BenchmarkDoubleDCT.benchmarkForward_3D_input_1D();
        BenchmarkDoubleDCT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

