/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.Arrays;
import org.jtransforms.dht.DoubleDHT_1D;
import org.jtransforms.dht.DoubleDHT_2D;
import org.jtransforms.dht.DoubleDHT_3D;
import org.jtransforms.utils.ConcurrencyUtils;
import org.jtransforms.utils.IOUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class BenchmarkDoubleDHT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static long[] sizes1D = new long[]{262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 10368L, 27000L, 75600L, 165375L, 362880L, 1562500L, 0x310000L, 6250000L};
    private static long[] sizes2D = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 260L, 520L, 1050L, 1458L, 1960L, 2916L, 4116L, 5832L};
    private static long[] sizes3D = new long[]{16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 5L, 17L, 30L, 95L, 180L, 270L, 324L, 420L};
    private static boolean doScaling = false;

    private BenchmarkDoubleDHT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new long[nsize];
            sizes2D = new long[nsize];
            sizes3D = new long[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDHT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDHT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDHT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            double[] dArray3;
            System.out.println("Forward DHT 1D of size " + sizes1D[i]);
            if (doWarmup) {
                DoubleDHT_1D doubleDHT_1D = new DoubleDHT_1D(sizes1D[i]);
                dArray3 = new double[(int)sizes1D[i]];
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                doubleDHT_1D.forward(dArray3);
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                doubleDHT_1D.forward(dArray3);
            }
            long l = System.nanoTime();
            DoubleDHT_1D doubleDHT_1D = new DoubleDHT_1D(sizes1D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            dArray3 = new double[(int)sizes1D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], dArray3);
                l = System.nanoTime();
                doubleDHT_1D.forward(dArray3);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            dArray3 = null;
            doubleDHT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray, dArray2);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            DoubleLargeArray doubleLargeArray;
            System.out.println("Forward DHT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                DoubleDHT_2D doubleDHT_2D = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
                doubleLargeArray = new DoubleLargeArray(sizes2D[i] * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], doubleLargeArray);
                doubleDHT_2D.forward(doubleLargeArray);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], doubleLargeArray);
                doubleDHT_2D.forward(doubleLargeArray);
            }
            long l = System.nanoTime();
            DoubleDHT_2D doubleDHT_2D = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            doubleLargeArray = new DoubleLargeArray(sizes2D[i] * sizes2D[i], false);
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], doubleLargeArray);
                l = System.nanoTime();
                doubleDHT_2D.forward(doubleLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            doubleLargeArray = null;
            doubleDHT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            double[][] dArray3;
            System.out.println("Forward DHT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                DoubleDHT_2D doubleDHT_2D = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
                dArray3 = new double[(int)sizes2D[i]][(int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray3);
                doubleDHT_2D.forward(dArray3);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray3);
                doubleDHT_2D.forward(dArray3);
            }
            long l = System.nanoTime();
            DoubleDHT_2D doubleDHT_2D = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            dArray3 = new double[(int)sizes2D[i]][(int)sizes2D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray3);
                l = System.nanoTime();
                doubleDHT_2D.forward(dArray3);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            dArray3 = null;
            doubleDHT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            DoubleLargeArray doubleLargeArray;
            System.out.println("Forward DHT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                DoubleDHT_3D doubleDHT_3D = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                doubleLargeArray = new DoubleLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], doubleLargeArray);
                doubleDHT_3D.forward(doubleLargeArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], doubleLargeArray);
                doubleDHT_3D.forward(doubleLargeArray);
            }
            long l = System.nanoTime();
            DoubleDHT_3D doubleDHT_3D = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            doubleLargeArray = new DoubleLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], doubleLargeArray);
                l = System.nanoTime();
                doubleDHT_3D.forward(doubleLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            doubleLargeArray = null;
            doubleDHT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            double[][][] dArray3;
            System.out.println("Forward DHT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                DoubleDHT_3D doubleDHT_3D = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                dArray3 = new double[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray3);
                doubleDHT_3D.forward(dArray3);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray3);
                doubleDHT_3D.forward(dArray3);
            }
            long l = System.nanoTime();
            DoubleDHT_3D doubleDHT_3D = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            dArray3 = new double[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray3);
                l = System.nanoTime();
                doubleDHT_3D.forward(dArray3);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            dArray3 = null;
            doubleDHT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleDHT.parseArguments(stringArray);
        BenchmarkDoubleDHT.benchmarkForward_1D();
        BenchmarkDoubleDHT.benchmarkForward_2D_input_1D();
        BenchmarkDoubleDHT.benchmarkForward_2D_input_2D();
        BenchmarkDoubleDHT.benchmarkForward_3D_input_1D();
        BenchmarkDoubleDHT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

