/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.Future;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public final class DoubleFFT_1D {
    private int n;
    private long nl;
    private int nBluestein;
    private long nBluesteinl;
    private int[] ip;
    private LongLargeArray ipl;
    private double[] w;
    private DoubleLargeArray wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private double[] wtable;
    private DoubleLargeArray wtablel;
    private double[] wtable_r;
    private DoubleLargeArray wtable_rl;
    private double[] bk1;
    private DoubleLargeArray bk1l;
    private double[] bk2;
    private DoubleLargeArray bk2l;
    private Plans plan;
    private boolean useLargeArrays;
    private static final int[] factors = new int[]{4, 2, 3, 5};
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;

    public DoubleFFT_1D(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        boolean bl = this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        if (!this.useLargeArrays) {
            this.n = (int)l;
            if (!ConcurrencyUtils.isPowerOf2(l)) {
                if (CommonUtils.getReminder(l, factors) >= 211L) {
                    this.plan = Plans.BLUESTEIN;
                    this.nBluestein = ConcurrencyUtils.nextPow2(this.n * 2 - 1);
                    this.bk1 = new double[2 * this.nBluestein];
                    this.bk2 = new double[2 * this.nBluestein];
                    this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)this.nBluestein + 0.5) / Math.log(2.0)) / 2))];
                    this.w = new double[this.nBluestein];
                    int n = 2 * this.nBluestein;
                    this.nw = n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                    this.nc = this.nBluestein >> 2;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                    this.bluesteini();
                } else {
                    this.plan = Plans.MIXED_RADIX;
                    this.wtable = new double[4 * this.n + 15];
                    this.wtable_r = new double[2 * this.n + 15];
                    this.cffti();
                    this.rffti();
                }
            } else {
                this.plan = Plans.SPLIT_RADIX;
                this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)l + 0.5) / Math.log(2.0)) / 2))];
                this.w = new double[this.n];
                int n = 2 * this.n;
                this.nw = n >> 2;
                CommonUtils.makewt(this.nw, this.ip, this.w);
                this.nc = this.n >> 2;
                CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
            }
        } else {
            this.nl = l;
            if (!ConcurrencyUtils.isPowerOf2(this.nl)) {
                if (CommonUtils.getReminder(this.nl, factors) >= 211L) {
                    this.plan = Plans.BLUESTEIN;
                    this.nBluesteinl = ConcurrencyUtils.nextPow2(this.nl * 2L - 1L);
                    this.bk1l = new DoubleLargeArray(2L * this.nBluesteinl, false);
                    this.bk2l = new DoubleLargeArray(2L * this.nBluesteinl, false);
                    this.ipl = new LongLargeArray(2L + (long)Math.ceil(2L + (1L << (int)((long)(Math.log((double)this.nBluesteinl + 0.5) / Math.log(2.0)) / 2L))), false);
                    this.wl = new DoubleLargeArray(this.nBluesteinl, false);
                    long l2 = 2L * this.nBluesteinl;
                    this.nwl = l2 >> 2;
                    CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                    this.ncl = this.nBluesteinl >> 2;
                    CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
                    this.bluesteinil();
                } else {
                    this.plan = Plans.MIXED_RADIX;
                    this.wtablel = new DoubleLargeArray(4L * this.nl + 15L, false);
                    this.wtable_rl = new DoubleLargeArray(2L * this.nl + 15L, false);
                    this.cfftil();
                    this.rfftil();
                }
            } else {
                this.plan = Plans.SPLIT_RADIX;
                this.ipl = new LongLargeArray(2L + (long)Math.ceil(2L + (1L << (int)((long)(Math.log((double)this.nl + 0.5) / Math.log(2.0)) / 2L))), false);
                this.wl = new DoubleLargeArray(this.nl, false);
                long l3 = 2L * this.nl;
                this.nwl = l3 >> 2;
                CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                this.ncl = this.nl >> 2;
                CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
            }
        }
    }

    public void complexForward(double[] dArray) {
        this.complexForward(dArray, 0);
    }

    public void complexForward(DoubleLargeArray doubleLargeArray) {
        this.complexForward(doubleLargeArray, 0L);
    }

    public void complexForward(double[] dArray, int n) {
        if (this.useLargeArrays) {
            this.complexForward(new DoubleLargeArray(dArray), (long)n);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftbsub(2 * this.n, dArray, n, this.ip, this.nw, this.w);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(dArray, n, -1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(dArray, n, -1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complexForward(DoubleLargeArray doubleLargeArray, long l) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.complexForward(doubleLargeArray.getData(), (int)l);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftbsub(2L * this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                    return;
                }
                case MIXED_RADIX: {
                    this.cfftf(doubleLargeArray, l, -1);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(doubleLargeArray, l, -1);
                }
            }
        }
    }

    public void complexInverse(double[] dArray, boolean bl) {
        this.complexInverse(dArray, 0, bl);
    }

    public void complexInverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.complexInverse(doubleLargeArray, 0L, bl);
    }

    public void complexInverse(double[] dArray, int n, boolean bl) {
        if (this.useLargeArrays) {
            this.complexInverse(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftfsub(2 * this.n, dArray, n, this.ip, this.nw, this.w);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(dArray, n, 1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(dArray, n, 1);
                }
            }
            if (bl) {
                CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complexInverse(DoubleLargeArray doubleLargeArray, long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.complexInverse(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftfsub(2L * this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(doubleLargeArray, l, 1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(doubleLargeArray, l, 1);
                }
            }
            if (!bl) return;
            CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, true);
        }
    }

    public void realForward(double[] dArray) {
        this.realForward(dArray, 0);
    }

    public void realForward(DoubleLargeArray doubleLargeArray) {
        this.realForward(doubleLargeArray, 0L);
    }

    public void realForward(double[] dArray, int n) {
        if (this.useLargeArrays) {
            this.realForward(new DoubleLargeArray(dArray), (long)n);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.n > 4) {
                        CommonUtils.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                        CommonUtils.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
                    } else if (this.n == 4) {
                        CommonUtils.cftx020(dArray, n);
                    }
                    double d = dArray[n] - dArray[n + 1];
                    int n2 = n;
                    dArray[n2] = dArray[n2] + dArray[n + 1];
                    dArray[n + 1] = d;
                    break;
                }
                case MIXED_RADIX: {
                    this.rfftf(dArray, n);
                    for (int i = this.n - 1; i >= 2; --i) {
                        int n3 = n + i;
                        double d = dArray[n3];
                        dArray[n3] = dArray[n3 - 1];
                        dArray[n3 - 1] = d;
                    }
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(dArray, n);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForward(DoubleLargeArray doubleLargeArray, long l) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForward(doubleLargeArray.getData(), (int)l);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.nl > 4L) {
                        CommonUtils.cftfsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                        CommonUtils.rftfsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftx020(doubleLargeArray, l);
                    }
                    double d = doubleLargeArray.getDouble(l) - doubleLargeArray.getDouble(l + 1L);
                    doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) + doubleLargeArray.getDouble(l + 1L));
                    doubleLargeArray.setDouble(l + 1L, d);
                    return;
                }
                case MIXED_RADIX: {
                    this.rfftf(doubleLargeArray, l);
                    for (long i = this.nl - 1L; i >= 2L; --i) {
                        long l2 = l + i;
                        double d = doubleLargeArray.getDouble(l2);
                        doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l2 - 1L));
                        doubleLargeArray.setDouble(l2 - 1L, d);
                    }
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(doubleLargeArray, l);
                }
            }
        }
    }

    public void realForwardFull(double[] dArray) {
        this.realForwardFull(dArray, 0);
    }

    public void realForwardFull(DoubleLargeArray doubleLargeArray) {
        this.realForwardFull(doubleLargeArray, 0L);
    }

    public void realForwardFull(final double[] dArray, final int n) {
        if (this.useLargeArrays) {
            this.realForwardFull(new DoubleLargeArray(dArray), (long)n);
        } else {
            final int n2 = 2 * this.n;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realForward(dArray, n);
                    int n3 = ConcurrencyUtils.getNumberOfThreads();
                    if (n3 > 1 && (long)(this.n / 2) > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futureArray = new Future[n3];
                        int n4 = this.n / 2 / n3;
                        for (int i = 0; i < n3; ++i) {
                            final int n5 = i * n4;
                            final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (int i = n5; i < n6; ++i) {
                                        int n3 = 2 * i;
                                        int n22 = n + (n2 - n3) % n2;
                                        dArray[n22] = dArray[n + n3];
                                        dArray[n22 + 1] = -dArray[n + n3 + 1];
                                    }
                                }
                            });
                        }
                        ConcurrencyUtils.waitForCompletion(futureArray);
                    } else {
                        for (int i = 0; i < this.n / 2; ++i) {
                            int n7 = 2 * i;
                            int n8 = n + (n2 - n7) % n2;
                            dArray[n8] = dArray[n + n7];
                            dArray[n8 + 1] = -dArray[n + n7 + 1];
                        }
                    }
                    dArray[n + this.n] = -dArray[n + 1];
                    dArray[n + 1] = 0.0;
                    break;
                }
                case MIXED_RADIX: {
                    int n9;
                    int n10;
                    this.rfftf(dArray, n);
                    int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                    for (n10 = 1; n10 < n11; ++n10) {
                        n9 = n + n2 - 2 * n10;
                        int n12 = n + 2 * n10;
                        dArray[n9 + 1] = -dArray[n12];
                        dArray[n9] = dArray[n12 - 1];
                    }
                    for (n10 = 1; n10 < this.n; ++n10) {
                        n9 = n + this.n - n10;
                        double d = dArray[n9 + 1];
                        dArray[n9 + 1] = dArray[n9];
                        dArray[n9] = d;
                    }
                    dArray[n + 1] = 0.0;
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(dArray, n, -1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForwardFull(final DoubleLargeArray doubleLargeArray, final long l) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForwardFull(doubleLargeArray.getData(), (int)l);
            return;
        } else {
            final long l2 = 2L * this.nl;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realForward(doubleLargeArray, l);
                    int n = ConcurrencyUtils.getNumberOfThreads();
                    if (n > 1 && this.nl / 2L > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futureArray = new Future[n];
                        long l3 = this.nl / 2L / (long)n;
                        for (int i = 0; i < n; ++i) {
                            final long l4 = (long)i * l3;
                            final long l5 = i == n - 1 ? this.nl / 2L : l4 + l3;
                            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (long i = l4; i < l5; ++i) {
                                        long l3 = 2L * i;
                                        long l22 = l + (l2 - l3) % l2;
                                        doubleLargeArray.setDouble(l22, doubleLargeArray.getDouble(l + l3));
                                        doubleLargeArray.setDouble(l22 + 1L, -doubleLargeArray.getDouble(l + l3 + 1L));
                                    }
                                }
                            });
                        }
                        ConcurrencyUtils.waitForCompletion(futureArray);
                    } else {
                        for (long i = 0L; i < this.nl / 2L; ++i) {
                            long l6 = 2L * i;
                            long l7 = l + (l2 - l6) % l2;
                            doubleLargeArray.setDouble(l7, doubleLargeArray.getDouble(l + l6));
                            doubleLargeArray.setDouble(l7 + 1L, -doubleLargeArray.getDouble(l + l6 + 1L));
                        }
                    }
                    doubleLargeArray.setDouble(l + this.nl, -doubleLargeArray.getDouble(l + 1L));
                    doubleLargeArray.setDouble(l + 1L, 0.0);
                    return;
                }
                case MIXED_RADIX: {
                    long l8;
                    long l9;
                    this.rfftf(doubleLargeArray, l);
                    long l10 = this.nl % 2L == 0L ? this.nl / 2L : (this.nl + 1L) / 2L;
                    for (l9 = 1L; l9 < l10; ++l9) {
                        l8 = l + l2 - 2L * l9;
                        long l11 = l + 2L * l9;
                        doubleLargeArray.setDouble(l8 + 1L, -doubleLargeArray.getDouble(l11));
                        doubleLargeArray.setDouble(l8, doubleLargeArray.getDouble(l11 - 1L));
                    }
                    for (l9 = 1L; l9 < this.nl; ++l9) {
                        l8 = l + this.nl - l9;
                        double d = doubleLargeArray.getDouble(l8 + 1L);
                        doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray.getDouble(l8));
                        doubleLargeArray.setDouble(l8, d);
                    }
                    doubleLargeArray.setDouble(l + 1L, 0.0);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(doubleLargeArray, l, -1L);
                }
            }
        }
    }

    public void realInverse(double[] dArray, boolean bl) {
        this.realInverse(dArray, 0, bl);
    }

    public void realInverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.realInverse(doubleLargeArray, 0L, bl);
    }

    public void realInverse(double[] dArray, int n, boolean bl) {
        if (this.useLargeArrays) {
            this.realInverse(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    dArray[n + 1] = 0.5 * (dArray[n] - dArray[n + 1]);
                    int n2 = n;
                    dArray[n2] = dArray[n2] - dArray[n + 1];
                    if (this.n > 4) {
                        CommonUtils.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
                        CommonUtils.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
                    } else if (this.n == 4) {
                        CommonUtils.cftxc020(dArray, n);
                    }
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / ((double)this.n / 2.0), dArray, n, false);
                    break;
                }
                case MIXED_RADIX: {
                    for (int i = 2; i < this.n; ++i) {
                        int n3 = n + i;
                        double d = dArray[n3 - 1];
                        dArray[n3 - 1] = dArray[n3];
                        dArray[n3] = d;
                    }
                    this.rfftb(dArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(dArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realInverse(DoubleLargeArray doubleLargeArray, long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverse(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    doubleLargeArray.setDouble(l + 1L, 0.5 * (doubleLargeArray.getDouble(l) - doubleLargeArray.getDouble(l + 1L)));
                    doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) - doubleLargeArray.getDouble(l + 1L));
                    if (this.nl > 4L) {
                        CommonUtils.rftfsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
                        CommonUtils.cftbsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftxc020(doubleLargeArray, l);
                    }
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / ((double)this.nl / 2.0), doubleLargeArray, l, false);
                    return;
                }
                case MIXED_RADIX: {
                    for (long i = 2L; i < this.nl; ++i) {
                        long l2 = l + i;
                        double d = doubleLargeArray.getDouble(l2 - 1L);
                        doubleLargeArray.setDouble(l2 - 1L, doubleLargeArray.getDouble(l2));
                        doubleLargeArray.setDouble(l2, d);
                    }
                    this.rfftb(doubleLargeArray, l);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, false);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(doubleLargeArray, l);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, false);
                }
            }
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        this.realInverseFull(dArray, 0, bl);
    }

    public void realInverseFull(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.realInverseFull(doubleLargeArray, 0L, bl);
    }

    public void realInverseFull(final double[] dArray, final int n, boolean bl) {
        if (this.useLargeArrays) {
            this.realInverseFull(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            final int n2 = 2 * this.n;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realInverse2(dArray, n, bl);
                    int n3 = ConcurrencyUtils.getNumberOfThreads();
                    if (n3 > 1 && (long)(this.n / 2) > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futureArray = new Future[n3];
                        int n4 = this.n / 2 / n3;
                        for (int i = 0; i < n3; ++i) {
                            final int n5 = i * n4;
                            final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (int i = n5; i < n6; ++i) {
                                        int n3 = 2 * i;
                                        int n22 = n + (n2 - n3) % n2;
                                        dArray[n22] = dArray[n + n3];
                                        dArray[n22 + 1] = -dArray[n + n3 + 1];
                                    }
                                }
                            });
                        }
                        ConcurrencyUtils.waitForCompletion(futureArray);
                    } else {
                        for (int i = 0; i < this.n / 2; ++i) {
                            int n7 = 2 * i;
                            int n8 = n + (n2 - n7) % n2;
                            dArray[n8] = dArray[n + n7];
                            dArray[n8 + 1] = -dArray[n + n7 + 1];
                        }
                    }
                    dArray[n + this.n] = -dArray[n + 1];
                    dArray[n + 1] = 0.0;
                    break;
                }
                case MIXED_RADIX: {
                    int n9;
                    int n10;
                    this.rfftf(dArray, n);
                    if (bl) {
                        CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                    }
                    int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                    for (n10 = 1; n10 < n11; ++n10) {
                        n9 = n + 2 * n10;
                        int n12 = n + n2 - 2 * n10;
                        dArray[n9] = -dArray[n9];
                        dArray[n12 + 1] = -dArray[n9];
                        dArray[n12] = dArray[n9 - 1];
                    }
                    for (n10 = 1; n10 < this.n; ++n10) {
                        n9 = n + this.n - n10;
                        double d = dArray[n9 + 1];
                        dArray[n9 + 1] = dArray[n9];
                        dArray[n9] = d;
                    }
                    dArray[n + 1] = 0.0;
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(dArray, n, 1);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, true);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realInverseFull(final DoubleLargeArray doubleLargeArray, final long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverseFull(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else {
            final long l2 = 2L * this.nl;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realInverse2(doubleLargeArray, l, bl);
                    int n = ConcurrencyUtils.getNumberOfThreads();
                    if (n > 1 && this.nl / 2L > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futureArray = new Future[n];
                        long l3 = this.nl / 2L / (long)n;
                        for (int i = 0; i < n; ++i) {
                            final long l4 = (long)i * l3;
                            final long l5 = i == n - 1 ? this.nl / 2L : l4 + l3;
                            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (long i = l4; i < l5; ++i) {
                                        long l3 = 2L * i;
                                        long l22 = l + (l2 - l3) % l2;
                                        doubleLargeArray.setDouble(l22, doubleLargeArray.getDouble(l + l3));
                                        doubleLargeArray.setDouble(l22 + 1L, -doubleLargeArray.getDouble(l + l3 + 1L));
                                    }
                                }
                            });
                        }
                        ConcurrencyUtils.waitForCompletion(futureArray);
                    } else {
                        for (long i = 0L; i < this.nl / 2L; ++i) {
                            long l6 = 2L * i;
                            long l7 = l + (l2 - l6) % l2;
                            doubleLargeArray.setDouble(l7, doubleLargeArray.getDouble(l + l6));
                            doubleLargeArray.setDouble(l7 + 1L, -doubleLargeArray.getDouble(l + l6 + 1L));
                        }
                    }
                    doubleLargeArray.setDouble(l + this.nl, -doubleLargeArray.getDouble(l + 1L));
                    doubleLargeArray.setDouble(l + 1L, 0.0);
                    return;
                }
                case MIXED_RADIX: {
                    long l8;
                    long l9;
                    this.rfftf(doubleLargeArray, l);
                    if (bl) {
                        CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, false);
                    }
                    long l10 = this.nl % 2L == 0L ? this.nl / 2L : (this.nl + 1L) / 2L;
                    for (l9 = 1L; l9 < l10; ++l9) {
                        l8 = l + 2L * l9;
                        long l11 = l + l2 - 2L * l9;
                        doubleLargeArray.setDouble(l8, -doubleLargeArray.getDouble(l8));
                        doubleLargeArray.setDouble(l11 + 1L, -doubleLargeArray.getDouble(l8));
                        doubleLargeArray.setDouble(l11, doubleLargeArray.getDouble(l8 - 1L));
                    }
                    for (l9 = 1L; l9 < this.nl; ++l9) {
                        l8 = l + this.nl - l9;
                        double d = doubleLargeArray.getDouble(l8 + 1L);
                        doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray.getDouble(l8));
                        doubleLargeArray.setDouble(l8, d);
                    }
                    doubleLargeArray.setDouble(l + 1L, 0.0);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(doubleLargeArray, l, 1L);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, true);
                }
            }
        }
    }

    protected void realInverse2(double[] dArray, int n, boolean bl) {
        if (this.useLargeArrays) {
            this.realInverse2(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.n > 4) {
                        CommonUtils.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                        CommonUtils.rftbsub(this.n, dArray, n, this.nc, this.w, this.nw);
                    } else if (this.n == 4) {
                        CommonUtils.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
                    }
                    double d = dArray[n] - dArray[n + 1];
                    int n2 = n;
                    dArray[n2] = dArray[n2] + dArray[n + 1];
                    dArray[n + 1] = d;
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                    break;
                }
                case MIXED_RADIX: {
                    int n3;
                    int n4;
                    this.rfftf(dArray, n);
                    for (n4 = this.n - 1; n4 >= 2; --n4) {
                        n3 = n + n4;
                        double d = dArray[n3];
                        dArray[n3] = dArray[n3 - 1];
                        dArray[n3 - 1] = d;
                    }
                    if (bl) {
                        CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                    }
                    if (this.n % 2 == 0) {
                        n4 = this.n / 2;
                        for (n3 = 1; n3 < n4; ++n3) {
                            int n5 = n + 2 * n3 + 1;
                            dArray[n5] = -dArray[n5];
                        }
                    } else {
                        n4 = (this.n - 1) / 2;
                        for (n3 = 0; n3 < n4; ++n3) {
                            int n6 = n + 2 * n3 + 1;
                            dArray[n6] = -dArray[n6];
                        }
                    }
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse2(dArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void realInverse2(DoubleLargeArray doubleLargeArray, long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverse2(doubleLargeArray.getData(), (int)l, bl);
            return;
        }
        if (this.nl == 1L) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.nl > 4L) {
                    CommonUtils.cftfsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                    CommonUtils.rftbsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
                } else if (this.nl == 4L) {
                    CommonUtils.cftbsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                }
                double d = doubleLargeArray.getDouble(l) - doubleLargeArray.getDouble(l + 1L);
                doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) + doubleLargeArray.getDouble(l + 1L));
                doubleLargeArray.setDouble(l + 1L, d);
                if (!bl) return;
                CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, false);
                return;
            }
            case MIXED_RADIX: {
                long l2;
                long l3;
                this.rfftf(doubleLargeArray, l);
                for (l3 = this.nl - 1L; l3 >= 2L; --l3) {
                    l2 = l + l3;
                    double d = doubleLargeArray.getDouble(l2);
                    doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l2 - 1L));
                    doubleLargeArray.setDouble(l2 - 1L, d);
                }
                if (bl) {
                    CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, false);
                }
                if (this.nl % 2L == 0L) {
                    l3 = this.nl / 2L;
                    for (l2 = 1L; l2 < l3; ++l2) {
                        long l4 = l + 2L * l2 + 1L;
                        doubleLargeArray.setDouble(l4, -doubleLargeArray.getDouble(l4));
                    }
                    return;
                } else {
                    l3 = (this.nl - 1L) / 2L;
                    for (l2 = 0L; l2 < l3; ++l2) {
                        long l5 = l + 2L * l2 + 1L;
                        doubleLargeArray.setDouble(l5, -doubleLargeArray.getDouble(l5));
                    }
                }
                return;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse2(doubleLargeArray, l);
                if (!bl) return;
                CommonUtils.scale(this.nl, 1.0 / (double)this.nl, doubleLargeArray, l, false);
            }
        }
    }

    void cffti(int n, int n2) {
        int n3;
        int n4;
        if (n == 1) {
            return;
        }
        int n5 = 2 * n;
        int n6 = 4 * n;
        int n7 = 0;
        int n8 = n;
        int n9 = 0;
        int n10 = 0;
        block0: while (true) {
            n7 = ++n10 <= 4 ? factors[n10 - 1] : (n7 += 2);
            do {
                int n11;
                int n12;
                if ((n12 = n8 - n7 * (n11 = n8 / n7)) != 0) continue block0;
                this.wtable[n2 + ++n9 + 1 + n6] = n7;
                n8 = n11;
                if (n7 != 2 || n9 == 1) continue;
                for (n4 = 2; n4 <= n9; ++n4) {
                    int n13 = n9 - n4 + 2;
                    n3 = n13 + n6;
                    this.wtable[n2 + n3 + 1] = this.wtable[n2 + n3];
                }
                this.wtable[n2 + 2 + n6] = 2.0;
            } while (n8 != 1);
            break;
        }
        this.wtable[n2 + n6] = n;
        this.wtable[n2 + 1 + n6] = n9;
        double d = Math.PI * 2 / (double)n;
        n4 = 1;
        int n14 = 1;
        for (int i = 1; i <= n9; ++i) {
            int n15 = (int)this.wtable[n2 + i + 1 + n6];
            int n16 = 0;
            int n17 = n14 * n15;
            int n18 = n / n17;
            int n19 = n18 + n18 + 2;
            int n20 = n15 - 1;
            for (n10 = 1; n10 <= n20; ++n10) {
                int n21 = n4;
                this.wtable[n2 + n4 - 1 + n5] = 1.0;
                this.wtable[n2 + n4 + n5] = 0.0;
                double d2 = 0.0;
                double d3 = (double)(n16 += n14) * d;
                for (int j = 4; j <= n19; j += 2) {
                    double d4 = (d2 += 1.0) * d3;
                    n3 = (n4 += 2) + n5;
                    this.wtable[n2 + n3 - 1] = Math.cos(d4);
                    this.wtable[n2 + n3] = Math.sin(d4);
                }
                if (n15 <= 5) continue;
                n3 = n21 + n5;
                int n22 = n4 + n5;
                this.wtable[n2 + n3 - 1] = this.wtable[n2 + n22 - 1];
                this.wtable[n2 + n3] = this.wtable[n2 + n22];
            }
            n14 = n17;
        }
    }

    final void cffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 4 * this.n;
        int n5 = 0;
        int n6 = this.n;
        int n7 = 0;
        int n8 = 0;
        block0: while (true) {
            n5 = ++n8 <= 4 ? factors[n8 - 1] : (n5 += 2);
            do {
                int n9;
                int n10;
                if ((n10 = n6 - n5 * (n9 = n6 / n5)) != 0) continue block0;
                this.wtable[++n7 + 1 + n4] = n5;
                n6 = n9;
                if (n5 != 2 || n7 == 1) continue;
                for (n2 = 2; n2 <= n7; ++n2) {
                    int n11 = n7 - n2 + 2;
                    n = n11 + n4;
                    this.wtable[n + 1] = this.wtable[n];
                }
                this.wtable[2 + n4] = 2.0;
            } while (n6 != 1);
            break;
        }
        this.wtable[n4] = this.n;
        this.wtable[1 + n4] = n7;
        double d = Math.PI * 2 / (double)this.n;
        n2 = 1;
        int n12 = 1;
        for (int i = 1; i <= n7; ++i) {
            int n13 = (int)this.wtable[i + 1 + n4];
            int n14 = 0;
            int n15 = n12 * n13;
            int n16 = this.n / n15;
            int n17 = n16 + n16 + 2;
            int n18 = n13 - 1;
            for (n8 = 1; n8 <= n18; ++n8) {
                int n19 = n2;
                this.wtable[n2 - 1 + n3] = 1.0;
                this.wtable[n2 + n3] = 0.0;
                double d2 = 0.0;
                double d3 = (double)(n14 += n12) * d;
                for (int j = 4; j <= n17; j += 2) {
                    double d4 = (d2 += 1.0) * d3;
                    n = (n2 += 2) + n3;
                    this.wtable[n - 1] = Math.cos(d4);
                    this.wtable[n] = Math.sin(d4);
                }
                if (n13 <= 5) continue;
                n = n19 + n3;
                int n20 = n2 + n3;
                this.wtable[n - 1] = this.wtable[n20 - 1];
                this.wtable[n] = this.wtable[n20];
            }
            n12 = n15;
        }
    }

    final void cfftil() {
        long l;
        long l2;
        if (this.nl == 1L) {
            return;
        }
        long l3 = 2L * this.nl;
        long l4 = 4L * this.nl;
        long l5 = 0L;
        long l6 = this.nl;
        long l7 = 0L;
        long l8 = 0L;
        block0: while (true) {
            l5 = ++l8 <= 4L ? (long)factors[(int)(l8 - 1L)] : (l5 += 2L);
            do {
                long l9;
                long l10;
                if ((l10 = l6 - l5 * (l9 = l6 / l5)) != 0L) continue block0;
                this.wtablel.setDouble(++l7 + 1L + l4, (double)l5);
                l6 = l9;
                if (l5 != 2L || l7 == 1L) continue;
                for (l2 = 2L; l2 <= l7; ++l2) {
                    long l11 = l7 - l2 + 2L;
                    l = l11 + l4;
                    this.wtablel.setDouble(l + 1L, this.wtablel.getDouble(l));
                }
                this.wtablel.setDouble(2L + l4, 2.0);
            } while (l6 != 1L);
            break;
        }
        this.wtablel.setDouble(l4, (double)this.nl);
        this.wtablel.setDouble(1L + l4, (double)l7);
        double d = Math.PI * 2 / (double)this.nl;
        l2 = 1L;
        long l12 = 1L;
        for (long i = 1L; i <= l7; ++i) {
            long l13 = (long)this.wtablel.getDouble(i + 1L + l4);
            long l14 = 0L;
            long l15 = l12 * l13;
            long l16 = this.nl / l15;
            long l17 = l16 + l16 + 2L;
            long l18 = l13 - 1L;
            for (l8 = 1L; l8 <= l18; ++l8) {
                long l19 = l2;
                this.wtablel.setDouble(l2 - 1L + l3, 1.0);
                this.wtablel.setDouble(l2 + l3, 0.0);
                double d2 = 0.0;
                double d3 = (double)(l14 += l12) * d;
                for (long j = 4L; j <= l17; j += 2L) {
                    double d4 = (d2 += 1.0) * d3;
                    l = (l2 += 2L) + l3;
                    this.wtablel.setDouble(l - 1L, Math.cos(d4));
                    this.wtablel.setDouble(l, Math.sin(d4));
                }
                if (l13 <= 5L) continue;
                l = l19 + l3;
                long l20 = l2 + l3;
                this.wtablel.setDouble(l - 1L, this.wtablel.getDouble(l20 - 1L));
                this.wtablel.setDouble(l, this.wtablel.getDouble(l20));
            }
            l12 = l15;
        }
    }

    void rffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 0;
        int n5 = this.n;
        int n6 = 0;
        int n7 = 0;
        block0: while (true) {
            n4 = ++n7 <= 4 ? factors[n7 - 1] : (n4 += 2);
            do {
                int n8;
                int n9;
                if ((n9 = n5 - n4 * (n8 = n5 / n4)) != 0) continue block0;
                this.wtable_r[++n6 + 1 + n3] = n4;
                n5 = n8;
                if (n4 != 2 || n6 == 1) continue;
                for (n2 = 2; n2 <= n6; ++n2) {
                    int n10 = n6 - n2 + 2;
                    n = n10 + n3;
                    this.wtable_r[n + 1] = this.wtable_r[n];
                }
                this.wtable_r[2 + n3] = 2.0;
            } while (n5 != 1);
            break;
        }
        this.wtable_r[n3] = this.n;
        this.wtable_r[1 + n3] = n6;
        double d = Math.PI * 2 / (double)this.n;
        int n11 = 0;
        int n12 = n6 - 1;
        int n13 = 1;
        if (n12 == 0) {
            return;
        }
        for (int i = 1; i <= n12; ++i) {
            int n14 = (int)this.wtable_r[i + 1 + n3];
            int n15 = 0;
            int n16 = n13 * n14;
            int n17 = this.n / n16;
            int n18 = n14 - 1;
            for (n7 = 1; n7 <= n18; ++n7) {
                n2 = n11;
                double d2 = (double)(n15 += n13) * d;
                double d3 = 0.0;
                for (int j = 3; j <= n17; j += 2) {
                    double d4 = (d3 += 1.0) * d2;
                    n = (n2 += 2) + this.n;
                    this.wtable_r[n - 2] = Math.cos(d4);
                    this.wtable_r[n - 1] = Math.sin(d4);
                }
                n11 += n17;
            }
            n13 = n16;
        }
    }

    void rfftil() {
        long l;
        long l2;
        if (this.nl == 1L) {
            return;
        }
        long l3 = 2L * this.nl;
        long l4 = 0L;
        long l5 = this.nl;
        long l6 = 0L;
        long l7 = 0L;
        block0: while (true) {
            l4 = ++l7 <= 4L ? (long)factors[(int)(l7 - 1L)] : (l4 += 2L);
            do {
                long l8;
                long l9;
                if ((l9 = l5 - l4 * (l8 = l5 / l4)) != 0L) continue block0;
                this.wtable_rl.setDouble(++l6 + 1L + l3, (double)l4);
                l5 = l8;
                if (l4 != 2L || l6 == 1L) continue;
                for (l2 = 2L; l2 <= l6; ++l2) {
                    long l10 = l6 - l2 + 2L;
                    l = l10 + l3;
                    this.wtable_rl.setDouble(l + 1L, this.wtable_rl.getDouble(l));
                }
                this.wtable_rl.setDouble(2L + l3, 2.0);
            } while (l5 != 1L);
            break;
        }
        this.wtable_rl.setDouble(l3, (double)this.nl);
        this.wtable_rl.setDouble(1L + l3, (double)l6);
        double d = Math.PI * 2 / (double)this.nl;
        long l11 = 0L;
        long l12 = l6 - 1L;
        long l13 = 1L;
        if (l12 == 0L) {
            return;
        }
        for (long i = 1L; i <= l12; ++i) {
            long l14 = (long)this.wtable_rl.getDouble(i + 1L + l3);
            long l15 = 0L;
            long l16 = l13 * l14;
            long l17 = this.nl / l16;
            long l18 = l14 - 1L;
            for (l7 = 1L; l7 <= l18; ++l7) {
                l2 = l11;
                double d2 = (double)(l15 += l13) * d;
                double d3 = 0.0;
                for (long j = 3L; j <= l17; j += 2L) {
                    double d4 = (d3 += 1.0) * d2;
                    l = (l2 += 2L) + this.nl;
                    this.wtable_rl.setDouble(l - 2L, Math.cos(d4));
                    this.wtable_rl.setDouble(l - 1L, Math.sin(d4));
                }
                l11 += l17;
            }
            l13 = l16;
        }
    }

    private void bluesteini() {
        int n = 0;
        double d = Math.PI / (double)this.n;
        this.bk1[0] = 1.0;
        this.bk1[1] = 0.0;
        for (int i = 1; i < this.n; ++i) {
            if ((n += 2 * i - 1) >= 2 * this.n) {
                n -= 2 * this.n;
            }
            double d2 = d * (double)n;
            this.bk1[2 * i] = Math.cos(d2);
            this.bk1[2 * i + 1] = Math.sin(d2);
        }
        double d3 = 1.0 / (double)this.nBluestein;
        this.bk2[0] = this.bk1[0] * d3;
        this.bk2[1] = this.bk1[1] * d3;
        for (int i = 2; i < 2 * this.n; i += 2) {
            this.bk2[i] = this.bk1[i] * d3;
            this.bk2[i + 1] = this.bk1[i + 1] * d3;
            this.bk2[2 * this.nBluestein - i] = this.bk2[i];
            this.bk2[2 * this.nBluestein - i + 1] = this.bk2[i + 1];
        }
        CommonUtils.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void bluesteinil() {
        long l = 0L;
        double d = Math.PI / (double)this.nl;
        this.bk1l.setDouble(0L, 1.0);
        this.bk1l.setDouble(1L, 0.0);
        int n = 1;
        while ((long)n < this.nl) {
            if ((l += (long)(2 * n - 1)) >= 2L * this.nl) {
                l -= 2L * this.nl;
            }
            double d2 = d * (double)l;
            this.bk1l.setDouble((long)(2 * n), Math.cos(d2));
            this.bk1l.setDouble((long)(2 * n + 1), Math.sin(d2));
            ++n;
        }
        double d3 = 1.0 / (double)this.nBluesteinl;
        this.bk2l.setDouble(0L, this.bk1l.getDouble(0L) * d3);
        this.bk2l.setDouble(1L, this.bk1l.getDouble(1L) * d3);
        int n2 = 2;
        while ((long)n2 < 2L * this.nl) {
            this.bk2l.setDouble((long)n2, this.bk1l.getDouble((long)n2) * d3);
            this.bk2l.setDouble((long)(n2 + 1), this.bk1l.getDouble((long)(n2 + 1)) * d3);
            this.bk2l.setDouble(2L * this.nBluesteinl - (long)n2, this.bk2l.getDouble((long)n2));
            this.bk2l.setDouble(2L * this.nBluesteinl - (long)n2 + 1L, this.bk2l.getDouble((long)(n2 + 1)));
            n2 += 2;
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, this.bk2l, 0L, this.ipl, this.nwl, this.wl);
    }

    private void bluestein_complex(final double[] dArray, final int n, final int n2) {
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6;
            int n7 = 2;
            if (n3 >= 4 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n7 = 4;
            }
            Future[] futureArray = new Future[n7];
            int n8 = this.n / n7;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n6 * n8;
                n4 = n6 == n7 - 1 ? this.n : n5 + n8;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                dArray2[n8] = dArray[n3] * DoubleFFT_1D.this.bk1[n8] - dArray[n42] * DoubleFFT_1D.this.bk1[n22];
                                dArray2[n22] = dArray[n3] * DoubleFFT_1D.this.bk1[n22] + dArray[n42] * DoubleFFT_1D.this.bk1[n8];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                dArray2[n9] = dArray[n6] * DoubleFFT_1D.this.bk1[n9] + dArray[n7] * DoubleFFT_1D.this.bk1[n52];
                                dArray2[n52] = -dArray[n6] * DoubleFFT_1D.this.bk1[n52] + dArray[n7] * DoubleFFT_1D.this.bk1[n9];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n8 = this.nBluestein / n7;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n6 * n8;
                n4 = n6 == n7 - 1 ? this.nBluestein : n5 + n8;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n22] + dArray2[n22] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n22] * DoubleFFT_1D.this.bk2[n22];
                                dArray2[n22] = d;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                double d = dArray2[n] * DoubleFFT_1D.this.bk2[n3] + dArray2[n3] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n3] * DoubleFFT_1D.this.bk2[n3];
                                dArray2[n3] = d;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n8 = this.n / n7;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n6 * n8;
                n4 = n6 == n7 - 1 ? this.n : n5 + n8;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                dArray[n3] = DoubleFFT_1D.this.bk1[n8] * dArray2[n8] - DoubleFFT_1D.this.bk1[n22] * dArray2[n22];
                                dArray[n42] = DoubleFFT_1D.this.bk1[n22] * dArray2[n8] + DoubleFFT_1D.this.bk1[n8] * dArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                dArray[n6] = DoubleFFT_1D.this.bk1[n9] * dArray2[n9] + DoubleFFT_1D.this.bk1[n52] * dArray2[n52];
                                dArray[n7] = -DoubleFFT_1D.this.bk1[n52] * dArray2[n9] + DoubleFFT_1D.this.bk1[n9] * dArray2[n52];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            if (n2 > 0) {
                for (n13 = 0; n13 < this.n; ++n13) {
                    n12 = 2 * n13;
                    n11 = n12 + 1;
                    n10 = n + n12;
                    n9 = n + n11;
                    dArray2[n12] = dArray[n10] * this.bk1[n12] - dArray[n9] * this.bk1[n11];
                    dArray2[n11] = dArray[n10] * this.bk1[n11] + dArray[n9] * this.bk1[n12];
                }
            } else {
                for (n13 = 0; n13 < this.n; ++n13) {
                    n12 = 2 * n13;
                    n11 = n12 + 1;
                    n10 = n + n12;
                    n9 = n + n11;
                    dArray2[n12] = dArray[n10] * this.bk1[n12] + dArray[n9] * this.bk1[n11];
                    dArray2[n11] = -dArray[n10] * this.bk1[n11] + dArray[n9] * this.bk1[n12];
                }
            }
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n13 = 0; n13 < this.nBluestein; ++n13) {
                    n12 = 2 * n13;
                    n11 = n12 + 1;
                    double d = -dArray2[n12] * this.bk2[n11] + dArray2[n11] * this.bk2[n12];
                    dArray2[n12] = dArray2[n12] * this.bk2[n12] + dArray2[n11] * this.bk2[n11];
                    dArray2[n11] = d;
                }
            } else {
                for (n13 = 0; n13 < this.nBluestein; ++n13) {
                    n12 = 2 * n13;
                    n11 = n12 + 1;
                    double d = dArray2[n12] * this.bk2[n11] + dArray2[n11] * this.bk2[n12];
                    dArray2[n12] = dArray2[n12] * this.bk2[n12] - dArray2[n11] * this.bk2[n11];
                    dArray2[n11] = d;
                }
            }
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n13 = 0; n13 < this.n; ++n13) {
                    n12 = 2 * n13;
                    n11 = n12 + 1;
                    int n14 = n + n12;
                    n9 = n + n11;
                    dArray[n14] = this.bk1[n12] * dArray2[n12] - this.bk1[n11] * dArray2[n11];
                    dArray[n9] = this.bk1[n11] * dArray2[n12] + this.bk1[n12] * dArray2[n11];
                }
            } else {
                for (n13 = 0; n13 < this.n; ++n13) {
                    n12 = 2 * n13;
                    n11 = n12 + 1;
                    int n15 = n + n12;
                    n9 = n + n11;
                    dArray[n15] = this.bk1[n12] * dArray2[n12] + this.bk1[n11] * dArray2[n11];
                    dArray[n9] = -this.bk1[n11] * dArray2[n12] + this.bk1[n12] * dArray2[n11];
                }
            }
        }
    }

    private void bluestein_complex(final DoubleLargeArray doubleLargeArray, final long l, final int n) {
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.nBluesteinl, false);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l2;
            long l3;
            int n3;
            int n4 = 2;
            if (n2 >= 4 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n4 = 4;
            }
            Future[] futureArray = new Future[n4];
            long l4 = this.nl / (long)n4;
            for (n3 = 0; n3 < n4; ++n3) {
                l3 = (long)n3 * l4;
                l2 = n3 == n4 - 1 ? this.nl : l3 + l4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n > 0) {
                            for (long i = l3; i < l2; ++i) {
                                long l8 = 2L * i;
                                long l22 = l8 + 1L;
                                long l32 = l + l8;
                                long l4 = l + l22;
                                doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l8) - doubleLargeArray.getDouble(l4) * DoubleFFT_1D.this.bk1l.getDouble(l22));
                                doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l22) + doubleLargeArray.getDouble(l4) * DoubleFFT_1D.this.bk1l.getDouble(l8));
                            }
                        } else {
                            for (long i = l3; i < l2; ++i) {
                                long l9 = 2L * i;
                                long l5 = l9 + 1L;
                                long l6 = l + l9;
                                long l7 = l + l5;
                                doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l6) * DoubleFFT_1D.this.bk1l.getDouble(l9) + doubleLargeArray.getDouble(l7) * DoubleFFT_1D.this.bk1l.getDouble(l5));
                                doubleLargeArray2.setDouble(l5, -doubleLargeArray.getDouble(l6) * DoubleFFT_1D.this.bk1l.getDouble(l5) + doubleLargeArray.getDouble(l7) * DoubleFFT_1D.this.bk1l.getDouble(l9));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l4 = this.nBluesteinl / (long)n4;
            for (n3 = 0; n3 < n4; ++n3) {
                l3 = (long)n3 * l4;
                l2 = n3 == n4 - 1 ? this.nBluesteinl : l3 + l4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n > 0) {
                            for (long i = l3; i < l2; ++i) {
                                long l = 2L * i;
                                long l22 = l + 1L;
                                double d = -doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l22) + doubleLargeArray2.getDouble(l22) * DoubleFFT_1D.this.bk2l.getDouble(l);
                                doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) + doubleLargeArray2.getDouble(l22) * DoubleFFT_1D.this.bk2l.getDouble(l22));
                                doubleLargeArray2.setDouble(l22, d);
                            }
                        } else {
                            for (long i = l3; i < l2; ++i) {
                                long l = 2L * i;
                                long l32 = l + 1L;
                                double d = doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l32) + doubleLargeArray2.getDouble(l32) * DoubleFFT_1D.this.bk2l.getDouble(l);
                                doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) - doubleLargeArray2.getDouble(l32) * DoubleFFT_1D.this.bk2l.getDouble(l32));
                                doubleLargeArray2.setDouble(l32, d);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l4 = this.nl / (long)n4;
            for (n3 = 0; n3 < n4; ++n3) {
                l3 = (long)n3 * l4;
                l2 = n3 == n4 - 1 ? this.nl : l3 + l4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n > 0) {
                            for (long i = l3; i < l2; ++i) {
                                long l8 = 2L * i;
                                long l22 = l8 + 1L;
                                long l32 = l + l8;
                                long l4 = l + l22;
                                doubleLargeArray.setDouble(l32, DoubleFFT_1D.this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8) - DoubleFFT_1D.this.bk1l.getDouble(l22) * doubleLargeArray2.getDouble(l22));
                                doubleLargeArray.setDouble(l4, DoubleFFT_1D.this.bk1l.getDouble(l22) * doubleLargeArray2.getDouble(l8) + DoubleFFT_1D.this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l22));
                            }
                        } else {
                            for (long i = l3; i < l2; ++i) {
                                long l9 = 2L * i;
                                long l5 = l9 + 1L;
                                long l6 = l + l9;
                                long l7 = l + l5;
                                doubleLargeArray.setDouble(l6, DoubleFFT_1D.this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l9) + DoubleFFT_1D.this.bk1l.getDouble(l5) * doubleLargeArray2.getDouble(l5));
                                doubleLargeArray.setDouble(l7, -DoubleFFT_1D.this.bk1l.getDouble(l5) * doubleLargeArray2.getDouble(l9) + DoubleFFT_1D.this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l5));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l5;
            long l6;
            long l7;
            long l8;
            long l9;
            if (n > 0) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l8;
                    l5 = l + l7;
                    doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l8) - doubleLargeArray.getDouble(l5) * this.bk1l.getDouble(l7));
                    doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l7) + doubleLargeArray.getDouble(l5) * this.bk1l.getDouble(l8));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l8;
                    l5 = l + l7;
                    doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l8) + doubleLargeArray.getDouble(l5) * this.bk1l.getDouble(l7));
                    doubleLargeArray2.setDouble(l7, -doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l7) + doubleLargeArray.getDouble(l5) * this.bk1l.getDouble(l8));
                }
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            if (n > 0) {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    double d = -doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l7) + doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l8);
                    doubleLargeArray2.setDouble(l8, doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l8) + doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l7));
                    doubleLargeArray2.setDouble(l7, d);
                }
            } else {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    double d = doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l7) + doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l8);
                    doubleLargeArray2.setDouble(l8, doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l8) - doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l7));
                    doubleLargeArray2.setDouble(l7, d);
                }
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            if (n > 0) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    long l10 = l + l8;
                    l5 = l + l7;
                    doubleLargeArray.setDouble(l10, this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8) - this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l7));
                    doubleLargeArray.setDouble(l5, this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l8) + this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l7));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    long l11 = l + l8;
                    l5 = l + l7;
                    doubleLargeArray.setDouble(l11, this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8) + this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l7));
                    doubleLargeArray.setDouble(l5, -this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l8) + this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l7));
                }
            }
        }
    }

    private void bluestein_real_full(final double[] dArray, final int n, final int n2) {
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6;
            int n7 = 2;
            if (n3 >= 4 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n7 = 4;
            }
            Future[] futureArray = new Future[n7];
            int n8 = this.n / n7;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n6 * n8;
                n4 = n6 == n7 - 1 ? this.n : n5 + n8;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                int n3 = n + i;
                                dArray2[n6] = dArray[n3] * DoubleFFT_1D.this.bk1[n6];
                                dArray2[n22] = dArray[n3] * DoubleFFT_1D.this.bk1[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n42 = n7 + 1;
                                int n52 = n + i;
                                dArray2[n7] = dArray[n52] * DoubleFFT_1D.this.bk1[n7];
                                dArray2[n42] = -dArray[n52] * DoubleFFT_1D.this.bk1[n42];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n8 = this.nBluestein / n7;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n6 * n8;
                n4 = n6 == n7 - 1 ? this.nBluestein : n5 + n8;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n22] + dArray2[n22] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n22] * DoubleFFT_1D.this.bk2[n22];
                                dArray2[n22] = d;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                double d = dArray2[n] * DoubleFFT_1D.this.bk2[n3] + dArray2[n3] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n3] * DoubleFFT_1D.this.bk2[n3];
                                dArray2[n3] = d;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n8 = this.n / n7;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n6 * n8;
                n4 = n6 == n7 - 1 ? this.n : n5 + n8;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                dArray[n + n6] = DoubleFFT_1D.this.bk1[n6] * dArray2[n6] - DoubleFFT_1D.this.bk1[n22] * dArray2[n22];
                                dArray[n + n22] = DoubleFFT_1D.this.bk1[n22] * dArray2[n6] + DoubleFFT_1D.this.bk1[n6] * dArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n3 = n7 + 1;
                                dArray[n + n7] = DoubleFFT_1D.this.bk1[n7] * dArray2[n7] + DoubleFFT_1D.this.bk1[n3] * dArray2[n3];
                                dArray[n + n3] = -DoubleFFT_1D.this.bk1[n3] * dArray2[n7] + DoubleFFT_1D.this.bk1[n7] * dArray2[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n12;
                    dArray2[n11] = dArray[n9] * this.bk1[n11];
                    dArray2[n10] = dArray[n9] * this.bk1[n10];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n12;
                    dArray2[n11] = dArray[n9] * this.bk1[n11];
                    dArray2[n10] = -dArray[n9] * this.bk1[n10];
                }
            }
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    double d = -dArray2[n11] * this.bk2[n10] + dArray2[n10] * this.bk2[n11];
                    dArray2[n11] = dArray2[n11] * this.bk2[n11] + dArray2[n10] * this.bk2[n10];
                    dArray2[n10] = d;
                }
            } else {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    double d = dArray2[n11] * this.bk2[n10] + dArray2[n10] * this.bk2[n11];
                    dArray2[n11] = dArray2[n11] * this.bk2[n11] - dArray2[n10] * this.bk2[n10];
                    dArray2[n10] = d;
                }
            }
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    dArray[n + n11] = this.bk1[n11] * dArray2[n11] - this.bk1[n10] * dArray2[n10];
                    dArray[n + n10] = this.bk1[n10] * dArray2[n11] + this.bk1[n11] * dArray2[n10];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    dArray[n + n11] = this.bk1[n11] * dArray2[n11] + this.bk1[n10] * dArray2[n10];
                    dArray[n + n10] = -this.bk1[n10] * dArray2[n11] + this.bk1[n11] * dArray2[n10];
                }
            }
        }
    }

    private void bluestein_real_full(final DoubleLargeArray doubleLargeArray, final long l, final long l2) {
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.nBluesteinl, false);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l3;
            long l4;
            int n2;
            int n3 = 2;
            if (n >= 4 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            long l5 = this.nl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l5;
                l3 = n2 == n3 - 1 ? this.nl : l4 + l5;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (l2 > 0L) {
                            for (long i = l4; i < l3; ++i) {
                                long l6 = 2L * i;
                                long l22 = l6 + 1L;
                                long l32 = l + i;
                                doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l6));
                                doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l22));
                            }
                        } else {
                            for (long i = l4; i < l3; ++i) {
                                long l7 = 2L * i;
                                long l42 = l7 + 1L;
                                long l5 = l + i;
                                doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l5) * DoubleFFT_1D.this.bk1l.getDouble(l7));
                                doubleLargeArray2.setDouble(l42, -doubleLargeArray.getDouble(l5) * DoubleFFT_1D.this.bk1l.getDouble(l42));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l5 = this.nBluesteinl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l5;
                l3 = n2 == n3 - 1 ? this.nBluesteinl : l4 + l5;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (l2 > 0L) {
                            for (long i = l4; i < l3; ++i) {
                                long l = 2L * i;
                                long l22 = l + 1L;
                                double d = -doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l22) + doubleLargeArray2.getDouble(l22) * DoubleFFT_1D.this.bk2l.getDouble(l);
                                doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) + doubleLargeArray2.getDouble(l22) * DoubleFFT_1D.this.bk2l.getDouble(l22));
                                doubleLargeArray2.setDouble(l22, d);
                            }
                        } else {
                            for (long i = l4; i < l3; ++i) {
                                long l = 2L * i;
                                long l32 = l + 1L;
                                double d = doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l32) + doubleLargeArray2.getDouble(l32) * DoubleFFT_1D.this.bk2l.getDouble(l);
                                doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) - doubleLargeArray2.getDouble(l32) * DoubleFFT_1D.this.bk2l.getDouble(l32));
                                doubleLargeArray2.setDouble(l32, d);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l5 = this.nl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l5;
                l3 = n2 == n3 - 1 ? this.nl : l4 + l5;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (l2 > 0L) {
                            for (long i = l4; i < l3; ++i) {
                                long l5 = 2L * i;
                                long l22 = l5 + 1L;
                                doubleLargeArray.setDouble(l + l5, DoubleFFT_1D.this.bk1l.getDouble(l5) * doubleLargeArray2.getDouble(l5) - DoubleFFT_1D.this.bk1l.getDouble(l22) * doubleLargeArray2.getDouble(l22));
                                doubleLargeArray.setDouble(l + l22, DoubleFFT_1D.this.bk1l.getDouble(l22) * doubleLargeArray2.getDouble(l5) + DoubleFFT_1D.this.bk1l.getDouble(l5) * doubleLargeArray2.getDouble(l22));
                            }
                        } else {
                            for (long i = l4; i < l3; ++i) {
                                long l6 = 2L * i;
                                long l32 = l6 + 1L;
                                doubleLargeArray.setDouble(l + l6, DoubleFFT_1D.this.bk1l.getDouble(l6) * doubleLargeArray2.getDouble(l6) + DoubleFFT_1D.this.bk1l.getDouble(l32) * doubleLargeArray2.getDouble(l32));
                                doubleLargeArray.setDouble(l + l32, -DoubleFFT_1D.this.bk1l.getDouble(l32) * doubleLargeArray2.getDouble(l6) + DoubleFFT_1D.this.bk1l.getDouble(l6) * doubleLargeArray2.getDouble(l32));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l6;
            long l7;
            long l8;
            long l9;
            if (l2 > 0L) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l9;
                    doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l8));
                    doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l7));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l9;
                    doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l8));
                    doubleLargeArray2.setDouble(l7, -doubleLargeArray.getDouble(l6) * this.bk1l.getDouble(l7));
                }
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            if (l2 > 0L) {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    double d = -doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l7) + doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l8);
                    doubleLargeArray2.setDouble(l8, doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l8) + doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l7));
                    doubleLargeArray2.setDouble(l7, d);
                }
            } else {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    double d = doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l7) + doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l8);
                    doubleLargeArray2.setDouble(l8, doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l8) - doubleLargeArray2.getDouble(l7) * this.bk2l.getDouble(l7));
                    doubleLargeArray2.setDouble(l7, d);
                }
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            if (l2 > 0L) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    doubleLargeArray.setDouble(l + l8, this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8) - this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l7));
                    doubleLargeArray.setDouble(l + l7, this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l8) + this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l7));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    doubleLargeArray.setDouble(l + l8, this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8) + this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l7));
                    doubleLargeArray.setDouble(l + l7, -this.bk1l.getDouble(l7) * doubleLargeArray2.getDouble(l8) + this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l7));
                }
            }
        }
    }

    private void bluestein_real_forward(final double[] dArray, final int n) {
        int n2;
        int n3;
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            int n7;
            n3 = 2;
            if (n4 >= 4 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            n2 = this.n / n3;
            for (n7 = 0; n7 < n3; ++n7) {
                n6 = n7 * n2;
                n5 = n7 == n3 - 1 ? this.n : n6 + n2;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            dArray2[n4] = dArray[n3] * DoubleFFT_1D.this.bk1[n4];
                            dArray2[n2] = -dArray[n3] * DoubleFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n2 = this.nBluestein / n3;
            for (n7 = 0; n7 < n3; ++n7) {
                n6 = n7 * n2;
                n5 = n7 == n3 - 1 ? this.nBluestein : n6 + n2;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8;
            for (n3 = 0; n3 < this.n; ++n3) {
                n8 = 2 * n3;
                n2 = n8 + 1;
                int n9 = n + n3;
                dArray2[n8] = dArray[n9] * this.bk1[n8];
                dArray2[n2] = -dArray[n9] * this.bk1[n2];
            }
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n3 = 0; n3 < this.nBluestein; ++n3) {
                n8 = 2 * n3;
                n2 = n8 + 1;
                double d = dArray2[n8] * this.bk2[n2] + dArray2[n2] * this.bk2[n8];
                dArray2[n8] = dArray2[n8] * this.bk2[n8] - dArray2[n2] * this.bk2[n2];
                dArray2[n2] = d;
            }
        }
        CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            dArray[n] = this.bk1[0] * dArray2[0] + this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n] + this.bk1[this.n + 1] * dArray2[this.n + 1];
            for (n3 = 1; n3 < this.n / 2; ++n3) {
                int n10 = 2 * n3;
                n2 = n10 + 1;
                dArray[n + n10] = this.bk1[n10] * dArray2[n10] + this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = -this.bk1[n2] * dArray2[n10] + this.bk1[n10] * dArray2[n2];
            }
        } else {
            dArray[n] = this.bk1[0] * dArray2[0] + this.bk1[1] * dArray2[1];
            dArray[n + 1] = -this.bk1[this.n] * dArray2[this.n - 1] + this.bk1[this.n - 1] * dArray2[this.n];
            for (n3 = 1; n3 < (this.n - 1) / 2; ++n3) {
                int n11 = 2 * n3;
                n2 = n11 + 1;
                dArray[n + n11] = this.bk1[n11] * dArray2[n11] + this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = -this.bk1[n2] * dArray2[n11] + this.bk1[n11] * dArray2[n2];
            }
            dArray[n + this.n - 1] = this.bk1[this.n - 1] * dArray2[this.n - 1] + this.bk1[this.n] * dArray2[this.n];
        }
    }

    private void bluestein_real_forward(final DoubleLargeArray doubleLargeArray, final long l) {
        long l2;
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.nBluesteinl, false);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l3;
            long l4;
            int n2;
            int n3 = 2;
            if (n >= 4 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            l2 = this.nl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l2;
                l3 = n2 == n3 - 1 ? this.nl : l4 + l2;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l5 = 2L * i;
                            long l2 = l5 + 1L;
                            long l32 = l + i;
                            doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l5));
                            doubleLargeArray2.setDouble(l2, -doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l2));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l2 = this.nBluesteinl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l2;
                l3 = n2 == n3 - 1 ? this.nBluesteinl : l4 + l2;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l = 2L * i;
                            long l2 = l + 1L;
                            double d = doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l2) + doubleLargeArray2.getDouble(l2) * DoubleFFT_1D.this.bk2l.getDouble(l);
                            doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) - doubleLargeArray2.getDouble(l2) * DoubleFFT_1D.this.bk2l.getDouble(l2));
                            doubleLargeArray2.setDouble(l2, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l5;
            long l6;
            for (l6 = 0L; l6 < this.nl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                long l7 = l + l6;
                doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l7) * this.bk1l.getDouble(l2));
                doubleLargeArray2.setDouble(l5, -doubleLargeArray.getDouble(l7) * this.bk1l.getDouble(l5));
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            for (l6 = 0L; l6 < this.nBluesteinl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                double d = doubleLargeArray2.getDouble(l2) * this.bk2l.getDouble(l5) + doubleLargeArray2.getDouble(l5) * this.bk2l.getDouble(l2);
                doubleLargeArray2.setDouble(l2, doubleLargeArray2.getDouble(l2) * this.bk2l.getDouble(l2) - doubleLargeArray2.getDouble(l5) * this.bk2l.getDouble(l5));
                doubleLargeArray2.setDouble(l5, d);
            }
        }
        CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
        if (this.nl % 2L == 0L) {
            doubleLargeArray.setDouble(l, this.bk1l.getDouble(0L) * doubleLargeArray2.getDouble(0L) + this.bk1l.getDouble(1L) * doubleLargeArray2.getDouble(1L));
            doubleLargeArray.setDouble(l + 1L, this.bk1l.getDouble(this.nl) * doubleLargeArray2.getDouble(this.nl) + this.bk1l.getDouble(this.nl + 1L) * doubleLargeArray2.getDouble(this.nl + 1L));
            for (long i = 1L; i < this.nl / 2L; ++i) {
                l2 = 2L * i;
                long l8 = l2 + 1L;
                doubleLargeArray.setDouble(l + l2, this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l2) + this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8));
                doubleLargeArray.setDouble(l + l8, -this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l2) + this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l8));
            }
        } else {
            doubleLargeArray.setDouble(l, this.bk1l.getDouble(0L) * doubleLargeArray2.getDouble(0L) + this.bk1l.getDouble(1L) * doubleLargeArray2.getDouble(1L));
            doubleLargeArray.setDouble(l + 1L, -this.bk1l.getDouble(this.nl) * doubleLargeArray2.getDouble(this.nl - 1L) + this.bk1l.getDouble(this.nl - 1L) * doubleLargeArray2.getDouble(this.nl));
            for (long i = 1L; i < (this.nl - 1L) / 2L; ++i) {
                l2 = 2L * i;
                long l9 = l2 + 1L;
                doubleLargeArray.setDouble(l + l2, this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l2) + this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l9));
                doubleLargeArray.setDouble(l + l9, -this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l2) + this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l9));
            }
            doubleLargeArray.setDouble(l + this.nl - 1L, this.bk1l.getDouble(this.nl - 1L) * doubleLargeArray2.getDouble(this.nl - 1L) + this.bk1l.getDouble(this.nl) * doubleLargeArray2.getDouble(this.nl));
        }
    }

    private void bluestein_real_inverse(final double[] dArray, final int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        final double[] dArray2 = new double[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            dArray2[0] = dArray[n] * this.bk1[0];
            dArray2[1] = dArray[n] * this.bk1[1];
            for (n6 = 1; n6 < this.n / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                dArray2[n5] = dArray[n3] * this.bk1[n5] - dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] + dArray[n2] * this.bk1[n5];
            }
            dArray2[this.n] = dArray[n + 1] * this.bk1[this.n];
            dArray2[this.n + 1] = dArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = this.n / 2 + 1; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                dArray2[n5] = dArray[n3] * this.bk1[n5] + dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] - dArray[n2] * this.bk1[n5];
            }
        } else {
            dArray2[0] = dArray[n] * this.bk1[0];
            dArray2[1] = dArray[n] * this.bk1[1];
            for (n6 = 1; n6 < (this.n - 1) / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                dArray2[n5] = dArray[n3] * this.bk1[n5] - dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] + dArray[n2] * this.bk1[n5];
            }
            dArray2[this.n - 1] = dArray[n + this.n - 1] * this.bk1[this.n - 1] - dArray[n + 1] * this.bk1[this.n];
            dArray2[this.n] = dArray[n + this.n - 1] * this.bk1[this.n] + dArray[n + 1] * this.bk1[this.n - 1];
            dArray2[this.n + 1] = dArray[n + this.n - 1] * this.bk1[this.n + 1] + dArray[n + 1] * this.bk1[this.n + 2];
            dArray2[this.n + 2] = dArray[n + this.n - 1] * this.bk1[this.n + 2] - dArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = (this.n - 1) / 2 + 2; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                dArray2[n5] = dArray[n3] * this.bk1[n5] + dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] - dArray[n2] * this.bk1[n5];
            }
        }
        CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            int n8;
            n5 = 2;
            if (n6 >= 4 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n5 = 4;
            }
            Future[] futureArray = new Future[n5];
            n3 = this.nBluestein / n5;
            for (n2 = 0; n2 < n5; ++n2) {
                n8 = n2 * n3;
                n7 = n2 == n5 - 1 ? this.nBluestein : n8 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n8; i < n7; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n3 = this.n / n5;
            for (n2 = 0; n2 < n5; ++n2) {
                n8 = n2 * n3;
                n7 = n2 == n5 - 1 ? this.n : n8 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n8; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            dArray[n + i] = DoubleFFT_1D.this.bk1[n3] * dArray2[n3] - DoubleFFT_1D.this.bk1[n2] * dArray2[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (n5 = 0; n5 < this.nBluestein; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                double d = -dArray2[n4] * this.bk2[n3] + dArray2[n3] * this.bk2[n4];
                dArray2[n4] = dArray2[n4] * this.bk2[n4] + dArray2[n3] * this.bk2[n3];
                dArray2[n3] = d;
            }
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n5 = 0; n5 < this.n; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                dArray[n + n5] = this.bk1[n4] * dArray2[n4] - this.bk1[n3] * dArray2[n3];
            }
        }
    }

    private void bluestein_real_inverse(final DoubleLargeArray doubleLargeArray, final long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.nBluesteinl, false);
        if (this.nl % 2L == 0L) {
            doubleLargeArray2.setDouble(0L, doubleLargeArray.getDouble(l) * this.bk1l.getDouble(0L));
            doubleLargeArray2.setDouble(1L, doubleLargeArray.getDouble(l) * this.bk1l.getDouble(1L));
            for (l6 = 1L; l6 < this.nl / 2L; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + l5;
                l2 = l + l4;
                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l5) - doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l4));
                doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l4) + doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l5));
            }
            doubleLargeArray2.setDouble(this.nl, doubleLargeArray.getDouble(l + 1L) * this.bk1l.getDouble(this.nl));
            doubleLargeArray2.setDouble(this.nl + 1L, doubleLargeArray.getDouble(l + 1L) * this.bk1l.getDouble(this.nl + 1L));
            for (l6 = this.nl / 2L + 1L; l6 < this.nl; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + 2L * this.nl - l5;
                l2 = l3 + 1L;
                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l5) + doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l4));
                doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l4) - doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l5));
            }
        } else {
            doubleLargeArray2.setDouble(0L, doubleLargeArray.getDouble(l) * this.bk1l.getDouble(0L));
            doubleLargeArray2.setDouble(1L, doubleLargeArray.getDouble(l) * this.bk1l.getDouble(1L));
            for (l6 = 1L; l6 < (this.nl - 1L) / 2L; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + l5;
                l2 = l + l4;
                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l5) - doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l4));
                doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l4) + doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l5));
            }
            doubleLargeArray2.setDouble(this.nl - 1L, doubleLargeArray.getDouble(l + this.nl - 1L) * this.bk1l.getDouble(this.nl - 1L) - doubleLargeArray.getDouble(l + 1L) * this.bk1l.getDouble(this.nl));
            doubleLargeArray2.setDouble(this.nl, doubleLargeArray.getDouble(l + this.nl - 1L) * this.bk1l.getDouble(this.nl) + doubleLargeArray.getDouble(l + 1L) * this.bk1l.getDouble(this.nl - 1L));
            doubleLargeArray2.setDouble(this.nl + 1L, doubleLargeArray.getDouble(l + this.nl - 1L) * this.bk1l.getDouble(this.nl + 1L) + doubleLargeArray.getDouble(l + 1L) * this.bk1l.getDouble(this.nl + 2L));
            doubleLargeArray2.setDouble(this.nl + 2L, doubleLargeArray.getDouble(l + this.nl - 1L) * this.bk1l.getDouble(this.nl + 2L) - doubleLargeArray.getDouble(l + 1L) * this.bk1l.getDouble(this.nl + 1L));
            for (l6 = (this.nl - 1L) / 2L + 2L; l6 < this.nl; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + 2L * this.nl - l5;
                l2 = l3 + 1L;
                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l5) + doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l4));
                doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l3) * this.bk1l.getDouble(l4) - doubleLargeArray.getDouble(l2) * this.bk1l.getDouble(l5));
            }
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n2;
            int n3 = 2;
            if (n >= 4 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            long l7 = this.nBluesteinl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l3 = (long)n2 * l7;
                l2 = n2 == n3 - 1 ? this.nBluesteinl : l3 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l2; ++i) {
                            long l = 2L * i;
                            long l22 = l + 1L;
                            double d = -doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l22) + doubleLargeArray2.getDouble(l22) * DoubleFFT_1D.this.bk2l.getDouble(l);
                            doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) + doubleLargeArray2.getDouble(l22) * DoubleFFT_1D.this.bk2l.getDouble(l22));
                            doubleLargeArray2.setDouble(l22, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l7 = this.nl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l3 = (long)n2 * l7;
                l2 = n2 == n3 - 1 ? this.nl : l3 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l2; ++i) {
                            long l4 = 2L * i;
                            long l22 = l4 + 1L;
                            doubleLargeArray.setDouble(l + i, DoubleFFT_1D.this.bk1l.getDouble(l4) * doubleLargeArray2.getDouble(l4) - DoubleFFT_1D.this.bk1l.getDouble(l22) * doubleLargeArray2.getDouble(l22));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l8;
            long l9;
            long l10;
            for (l10 = 0L; l10 < this.nBluesteinl; ++l10) {
                l9 = 2L * l10;
                l8 = l9 + 1L;
                double d = -doubleLargeArray2.getDouble(l9) * this.bk2l.getDouble(l8) + doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l9);
                doubleLargeArray2.setDouble(l9, doubleLargeArray2.getDouble(l9) * this.bk2l.getDouble(l9) + doubleLargeArray2.getDouble(l8) * this.bk2l.getDouble(l8));
                doubleLargeArray2.setDouble(l8, d);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            for (l10 = 0L; l10 < this.nl; ++l10) {
                l9 = 2L * l10;
                l8 = l9 + 1L;
                doubleLargeArray.setDouble(l + l10, this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l9) - this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8));
            }
        }
    }

    private void bluestein_real_inverse2(final double[] dArray, final int n) {
        int n2;
        int n3;
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            int n7;
            n3 = 2;
            if (n4 >= 4 && (long)this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            n2 = this.n / n3;
            for (n7 = 0; n7 < n3; ++n7) {
                n6 = n7 * n2;
                n5 = n7 == n3 - 1 ? this.n : n6 + n2;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            dArray2[n4] = dArray[n3] * DoubleFFT_1D.this.bk1[n4];
                            dArray2[n2] = dArray[n3] * DoubleFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n2 = this.nBluestein / n3;
            for (n7 = 0; n7 < n3; ++n7) {
                n6 = n7 * n2;
                n5 = n7 == n3 - 1 ? this.nBluestein : n6 + n2;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8;
            for (n3 = 0; n3 < this.n; ++n3) {
                n8 = 2 * n3;
                n2 = n8 + 1;
                int n9 = n + n3;
                dArray2[n8] = dArray[n9] * this.bk1[n8];
                dArray2[n2] = dArray[n9] * this.bk1[n2];
            }
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n3 = 0; n3 < this.nBluestein; ++n3) {
                n8 = 2 * n3;
                n2 = n8 + 1;
                double d = -dArray2[n8] * this.bk2[n2] + dArray2[n2] * this.bk2[n8];
                dArray2[n8] = dArray2[n8] * this.bk2[n8] + dArray2[n2] * this.bk2[n2];
                dArray2[n2] = d;
            }
        }
        CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            dArray[n] = this.bk1[0] * dArray2[0] - this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n] - this.bk1[this.n + 1] * dArray2[this.n + 1];
            for (n3 = 1; n3 < this.n / 2; ++n3) {
                int n10 = 2 * n3;
                n2 = n10 + 1;
                dArray[n + n10] = this.bk1[n10] * dArray2[n10] - this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = this.bk1[n2] * dArray2[n10] + this.bk1[n10] * dArray2[n2];
            }
        } else {
            dArray[n] = this.bk1[0] * dArray2[0] - this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n - 1] + this.bk1[this.n - 1] * dArray2[this.n];
            for (n3 = 1; n3 < (this.n - 1) / 2; ++n3) {
                int n11 = 2 * n3;
                n2 = n11 + 1;
                dArray[n + n11] = this.bk1[n11] * dArray2[n11] - this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = this.bk1[n2] * dArray2[n11] + this.bk1[n11] * dArray2[n2];
            }
            dArray[n + this.n - 1] = this.bk1[this.n - 1] * dArray2[this.n - 1] - this.bk1[this.n] * dArray2[this.n];
        }
    }

    private void bluestein_real_inverse2(final DoubleLargeArray doubleLargeArray, final long l) {
        long l2;
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.nBluesteinl, false);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l3;
            long l4;
            int n2;
            int n3 = 2;
            if (n >= 4 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            l2 = this.nl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l2;
                l3 = n2 == n3 - 1 ? this.nl : l4 + l2;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l5 = 2L * i;
                            long l2 = l5 + 1L;
                            long l32 = l + i;
                            doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l5));
                            doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32) * DoubleFFT_1D.this.bk1l.getDouble(l2));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            l2 = this.nBluesteinl / (long)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                l4 = (long)n2 * l2;
                l3 = n2 == n3 - 1 ? this.nBluesteinl : l4 + l2;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l = 2L * i;
                            long l2 = l + 1L;
                            double d = -doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l2) + doubleLargeArray2.getDouble(l2) * DoubleFFT_1D.this.bk2l.getDouble(l);
                            doubleLargeArray2.setDouble(l, doubleLargeArray2.getDouble(l) * DoubleFFT_1D.this.bk2l.getDouble(l) + doubleLargeArray2.getDouble(l2) * DoubleFFT_1D.this.bk2l.getDouble(l2));
                            doubleLargeArray2.setDouble(l2, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l5;
            long l6;
            for (l6 = 0L; l6 < this.nl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                long l7 = l + l6;
                doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l7) * this.bk1l.getDouble(l2));
                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l7) * this.bk1l.getDouble(l5));
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
            for (l6 = 0L; l6 < this.nBluesteinl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                double d = -doubleLargeArray2.getDouble(l2) * this.bk2l.getDouble(l5) + doubleLargeArray2.getDouble(l5) * this.bk2l.getDouble(l2);
                doubleLargeArray2.setDouble(l2, doubleLargeArray2.getDouble(l2) * this.bk2l.getDouble(l2) + doubleLargeArray2.getDouble(l5) * this.bk2l.getDouble(l5));
                doubleLargeArray2.setDouble(l5, d);
            }
        }
        CommonUtils.cftfsub(2L * this.nBluesteinl, doubleLargeArray2, 0L, this.ipl, this.nwl, this.wl);
        if (this.nl % 2L == 0L) {
            doubleLargeArray.setDouble(l, this.bk1l.getDouble(0L) * doubleLargeArray2.getDouble(0L) - this.bk1l.getDouble(1L) * doubleLargeArray2.getDouble(1L));
            doubleLargeArray.setDouble(l + 1L, this.bk1l.getDouble(this.nl) * doubleLargeArray2.getDouble(this.nl) - this.bk1l.getDouble(this.nl + 1L) * doubleLargeArray2.getDouble(this.nl + 1L));
            for (long i = 1L; i < this.nl / 2L; ++i) {
                l2 = 2L * i;
                long l8 = l2 + 1L;
                doubleLargeArray.setDouble(l + l2, this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l2) - this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l8));
                doubleLargeArray.setDouble(l + l8, this.bk1l.getDouble(l8) * doubleLargeArray2.getDouble(l2) + this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l8));
            }
        } else {
            doubleLargeArray.setDouble(l, this.bk1l.getDouble(0L) * doubleLargeArray2.getDouble(0L) - this.bk1l.getDouble(1L) * doubleLargeArray2.getDouble(1L));
            doubleLargeArray.setDouble(l + 1L, this.bk1l.getDouble(this.nl) * doubleLargeArray2.getDouble(this.nl - 1L) + this.bk1l.getDouble(this.nl - 1L) * doubleLargeArray2.getDouble(this.nl));
            for (long i = 1L; i < (this.nl - 1L) / 2L; ++i) {
                l2 = 2L * i;
                long l9 = l2 + 1L;
                doubleLargeArray.setDouble(l + l2, this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l2) - this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l9));
                doubleLargeArray.setDouble(l + l9, this.bk1l.getDouble(l9) * doubleLargeArray2.getDouble(l2) + this.bk1l.getDouble(l2) * doubleLargeArray2.getDouble(l9));
            }
            doubleLargeArray.setDouble(l + this.nl - 1L, this.bk1l.getDouble(this.nl - 1L) * doubleLargeArray2.getDouble(this.nl - 1L) - this.bk1l.getDouble(this.nl) * doubleLargeArray2.getDouble(this.nl));
        }
    }

    void rfftf(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 1;
        int n5 = this.n;
        int n6 = n2 - 1;
        for (int i = 1; i <= n3; ++i) {
            int n7 = n3 - i;
            int n8 = (int)this.wtable_r[n7 + 2 + n2];
            int n9 = n5 / n8;
            int n10 = this.n / n5;
            int n11 = n10 * n9;
            n6 -= (n8 - 1) * n10;
            n4 = 1 - n4;
            switch (n8) {
                case 2: {
                    if (n4 == 0) {
                        this.radf2(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf2(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radf3(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf3(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radf4(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf4(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radf5(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf5(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                default: {
                    if (n10 == 1) {
                        n4 = 1 - n4;
                    }
                    if (n4 == 0) {
                        this.radfg(n10, n8, n9, n11, dArray, n, dArray2, 0, n6);
                        n4 = 1;
                        break;
                    }
                    this.radfg(n10, n8, n9, n11, dArray2, 0, dArray, n, n6);
                    n4 = 0;
                }
            }
            n5 = n9;
        }
        if (n4 == 1) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, this.n);
    }

    void rfftf(DoubleLargeArray doubleLargeArray, long l) {
        if (this.nl == 1L) {
            return;
        }
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.nl, false);
        long l2 = 2L * this.nl;
        long l3 = (long)this.wtable_rl.getDouble(1L + l2);
        long l4 = 1L;
        long l5 = this.nl;
        long l6 = l2 - 1L;
        for (long i = 1L; i <= l3; ++i) {
            long l7 = l3 - i;
            int n = (int)this.wtable_rl.getDouble(l7 + 2L + l2);
            long l8 = l5 / (long)n;
            long l9 = this.nl / l5;
            long l10 = l9 * l8;
            l6 -= (long)(n - 1) * l9;
            l4 = 1L - l4;
            switch (n) {
                case 2: {
                    if (l4 == 0L) {
                        this.radf2(l9, l8, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                        break;
                    }
                    this.radf2(l9, l8, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    break;
                }
                case 3: {
                    if (l4 == 0L) {
                        this.radf3(l9, l8, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                        break;
                    }
                    this.radf3(l9, l8, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    break;
                }
                case 4: {
                    if (l4 == 0L) {
                        this.radf4(l9, l8, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                        break;
                    }
                    this.radf4(l9, l8, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    break;
                }
                case 5: {
                    if (l4 == 0L) {
                        this.radf5(l9, l8, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                        break;
                    }
                    this.radf5(l9, l8, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    break;
                }
                default: {
                    if (l9 == 1L) {
                        l4 = 1L - l4;
                    }
                    if (l4 == 0L) {
                        this.radfg(l9, (long)n, l8, l10, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                        l4 = 1L;
                        break;
                    }
                    this.radfg(l9, (long)n, l8, l10, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    l4 = 0L;
                }
            }
            l5 = l8;
        }
        if (l4 == 1L) {
            return;
        }
        Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)l, (long)this.nl);
    }

    void rfftb(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 0;
        int n5 = 1;
        int n6 = this.n;
        for (int i = 1; i <= n3; ++i) {
            int n7 = (int)this.wtable_r[i + 1 + n2];
            int n8 = n7 * n5;
            int n9 = this.n / n8;
            int n10 = n9 * n5;
            switch (n7) {
                case 2: {
                    if (n4 == 0) {
                        this.radb2(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb2(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radb3(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb3(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radb4(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb4(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radb5(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb5(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                default: {
                    if (n4 == 0) {
                        this.radbg(n9, n7, n5, n10, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radbg(n9, n7, n5, n10, dArray2, 0, dArray, n, n6);
                    }
                    if (n9 != 1) break;
                    n4 = 1 - n4;
                }
            }
            n5 = n8;
            n6 += (n7 - 1) * n9;
        }
        if (n4 == 0) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, this.n);
    }

    void rfftb(DoubleLargeArray doubleLargeArray, long l) {
        if (this.nl == 1L) {
            return;
        }
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.nl, false);
        long l2 = 2L * this.nl;
        long l3 = (long)this.wtable_rl.getDouble(1L + l2);
        long l4 = 0L;
        long l5 = 1L;
        long l6 = this.nl;
        for (long i = 1L; i <= l3; ++i) {
            int n = (int)this.wtable_rl.getDouble(i + 1L + l2);
            long l7 = (long)n * l5;
            long l8 = this.nl / l7;
            long l9 = l8 * l5;
            switch (n) {
                case 2: {
                    if (l4 == 0L) {
                        this.radb2(l8, l5, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                    } else {
                        this.radb2(l8, l5, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 3: {
                    if (l4 == 0L) {
                        this.radb3(l8, l5, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                    } else {
                        this.radb3(l8, l5, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 4: {
                    if (l4 == 0L) {
                        this.radb4(l8, l5, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                    } else {
                        this.radb4(l8, l5, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 5: {
                    if (l4 == 0L) {
                        this.radb5(l8, l5, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                    } else {
                        this.radb5(l8, l5, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                default: {
                    if (l4 == 0L) {
                        this.radbg(l8, (long)n, l5, l9, doubleLargeArray, l, doubleLargeArray2, 0L, l6);
                    } else {
                        this.radbg(l8, (long)n, l5, l9, doubleLargeArray2, 0L, doubleLargeArray, l, l6);
                    }
                    if (l8 != 1L) break;
                    l4 = 1L - l4;
                }
            }
            l5 = l7;
            l6 += (long)(n - 1) * l8;
        }
        if (l4 == 0L) {
            return;
        }
        Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)l, (long)this.nl);
    }

    void radf2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n5;
        int n13 = n2 * n;
        int n14 = 2 * n;
        for (n11 = 0; n11 < n2; ++n11) {
            n10 = n4 + n11 * n14;
            n9 = n10 + n14 - 1;
            n8 = n3 + n11 * n;
            n7 = n8 + n13;
            double d = dArray[n8];
            double d2 = dArray[n7];
            dArray2[n10] = d + d2;
            dArray2[n9] = d - d2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n11 = 0; n11 < n2; ++n11) {
                n14 = n11 * n;
                n6 = 2 * n14;
                int n15 = n6 + n;
                int n16 = n14 + n13;
                for (int i = 2; i < n; i += 2) {
                    int n17 = n - i;
                    n10 = i - 1 + n12;
                    n9 = n4 + i + n6;
                    n8 = n4 + n17 + n15;
                    n7 = n3 + i + n14;
                    int n18 = n3 + i + n16;
                    double d = dArray[n7 - 1];
                    double d3 = dArray[n7];
                    double d4 = dArray[n18 - 1];
                    double d5 = dArray[n18];
                    double d6 = this.wtable_r[n10 - 1];
                    double d7 = this.wtable_r[n10];
                    double d8 = d6 * d4 + d7 * d5;
                    double d9 = d6 * d5 - d7 * d4;
                    dArray2[n9] = d3 + d9;
                    dArray2[n9 - 1] = d + d8;
                    dArray2[n8] = d9 - d3;
                    dArray2[n8 - 1] = d - d8;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        n6 = 2 * n14;
        for (n11 = 0; n11 < n2; ++n11) {
            n14 = n11 * n;
            n10 = n4 + n6 + n;
            n9 = n3 + n - 1 + n14;
            dArray2[n10] = -dArray[n9 + n13];
            dArray2[n10 - 1] = dArray[n9];
        }
    }

    void radf2(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        long l6;
        double d;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12 = l5;
        long l13 = l2 * l;
        long l14 = 2L * l;
        for (l11 = 0L; l11 < l2; ++l11) {
            l10 = l4 + l11 * l14;
            l9 = l10 + l14 - 1L;
            l8 = l3 + l11 * l;
            l7 = l8 + l13;
            double d2 = doubleLargeArray.getDouble(l8);
            d = doubleLargeArray.getDouble(l7);
            doubleLargeArray2.setDouble(l10, d2 + d);
            doubleLargeArray2.setDouble(l9, d2 - d);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l11 = 0L; l11 < l2; ++l11) {
                l14 = l11 * l;
                l6 = 2L * l14;
                long l15 = l6 + l;
                long l16 = l14 + l13;
                for (long i = 2L; i < l; i += 2L) {
                    long l17 = l - i;
                    l10 = i - 1L + l12;
                    l9 = l4 + i + l6;
                    l8 = l4 + l17 + l15;
                    l7 = l3 + i + l14;
                    long l18 = l3 + i + l16;
                    d = doubleLargeArray.getDouble(l7 - 1L);
                    double d3 = doubleLargeArray.getDouble(l7);
                    double d4 = doubleLargeArray.getDouble(l18 - 1L);
                    double d5 = doubleLargeArray.getDouble(l18);
                    double d6 = this.wtable_rl.getDouble(l10 - 1L);
                    double d7 = this.wtable_rl.getDouble(l10);
                    double d8 = d6 * d4 + d7 * d5;
                    double d9 = d6 * d5 - d7 * d4;
                    doubleLargeArray2.setDouble(l9, d3 + d9);
                    doubleLargeArray2.setDouble(l9 - 1L, d + d8);
                    doubleLargeArray2.setDouble(l8, d9 - d3);
                    doubleLargeArray2.setDouble(l8 - 1L, d - d8);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        l6 = 2L * l14;
        for (l11 = 0L; l11 < l2; ++l11) {
            l14 = l11 * l;
            l10 = l4 + l6 + l;
            l9 = l3 + l - 1L + l14;
            doubleLargeArray2.setDouble(l10, -doubleLargeArray.getDouble(l9 + l13));
            doubleLargeArray2.setDouble(l10 - 1L, doubleLargeArray.getDouble(l9));
        }
    }

    void radb2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n10 + n;
            n8 = n4 + n11;
            n7 = n3 + n10;
            n6 = n3 + n - 1 + n9;
            double d = dArray[n7];
            double d2 = dArray[n6];
            dArray2[n8] = d + d2;
            dArray2[n8 + n14] = d - d2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n12 * n;
                n10 = 2 * n11;
                n9 = n10 + n;
                n8 = n11 + n14;
                for (int i = 2; i < n; i += 2) {
                    int n15 = n - i;
                    n7 = i - 1 + n13;
                    n6 = n4 + i;
                    int n16 = n3 + i;
                    int n17 = n3 + n15;
                    double d = this.wtable_r[n7 - 1];
                    double d3 = this.wtable_r[n7];
                    int n18 = n16 + n10;
                    int n19 = n17 + n9;
                    int n20 = n6 + n11;
                    int n21 = n6 + n8;
                    double d4 = dArray[n18 - 1] - dArray[n19 - 1];
                    double d5 = dArray[n18] + dArray[n19];
                    double d6 = dArray[n18];
                    double d7 = dArray[n18 - 1];
                    double d8 = dArray[n19];
                    double d9 = dArray[n19 - 1];
                    dArray2[n20 - 1] = d7 + d9;
                    dArray2[n20] = d6 - d8;
                    dArray2[n21 - 1] = d * d4 - d3 * d5;
                    dArray2[n21] = d * d5 + d3 * d4;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n4 + n - 1 + n11;
            n8 = n3 + n10 + n;
            dArray2[n9] = 2.0 * dArray[n8 - 1];
            dArray2[n9 + n14] = -2.0 * dArray[n8];
        }
    }

    void radb2(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13 = l5;
        long l14 = l2 * l;
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l11;
            l9 = l10 + l;
            l8 = l4 + l11;
            l7 = l3 + l10;
            l6 = l3 + l - 1L + l9;
            double d = doubleLargeArray.getDouble(l7);
            double d2 = doubleLargeArray.getDouble(l6);
            doubleLargeArray2.setDouble(l8, d + d2);
            doubleLargeArray2.setDouble(l8 + l14, d - d2);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l12 = 0L; l12 < l2; ++l12) {
                l11 = l12 * l;
                l10 = 2L * l11;
                l9 = l10 + l;
                l8 = l11 + l14;
                for (long i = 2L; i < l; i += 2L) {
                    long l15 = l - i;
                    l7 = i - 1L + l13;
                    l6 = l4 + i;
                    long l16 = l3 + i;
                    long l17 = l3 + l15;
                    double d = this.wtable_rl.getDouble(l7 - 1L);
                    double d3 = this.wtable_rl.getDouble(l7);
                    long l18 = l16 + l10;
                    long l19 = l17 + l9;
                    long l20 = l6 + l11;
                    long l21 = l6 + l8;
                    double d4 = doubleLargeArray.getDouble(l18 - 1L) - doubleLargeArray.getDouble(l19 - 1L);
                    double d5 = doubleLargeArray.getDouble(l18) + doubleLargeArray.getDouble(l19);
                    double d6 = doubleLargeArray.getDouble(l18);
                    double d7 = doubleLargeArray.getDouble(l18 - 1L);
                    double d8 = doubleLargeArray.getDouble(l19);
                    double d9 = doubleLargeArray.getDouble(l19 - 1L);
                    doubleLargeArray2.setDouble(l20 - 1L, d7 + d9);
                    doubleLargeArray2.setDouble(l20, d6 - d8);
                    doubleLargeArray2.setDouble(l21 - 1L, d * d4 - d3 * d5);
                    doubleLargeArray2.setDouble(l21, d * d5 + d3 * d4);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l11;
            l9 = l4 + l - 1L + l11;
            l8 = l3 + l10 + l;
            doubleLargeArray2.setDouble(l9, 2.0 * doubleLargeArray.getDouble(l8 - 1L));
            doubleLargeArray2.setDouble(l9 + l14, -2.0 * doubleLargeArray.getDouble(l8));
        }
    }

    void radf3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n13 + n;
        int n15 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n15;
            n9 = (3 * n12 + 1) * n;
            n8 = n3 + n11;
            n7 = n8 + n15;
            n6 = n8 + n10;
            double d2 = dArray[n8];
            double d3 = dArray[n7];
            double d4 = dArray[n6];
            d = d3 + d4;
            dArray2[n4 + 3 * n11] = d2 + d;
            dArray2[n4 + n9 + n] = 0.8660254037844387 * (d4 - d3);
            dArray2[n4 + n - 1 + n9] = d2 + -0.5 * d;
        }
        if (n == 1) {
            return;
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 3 * n11;
            n9 = n11 + n15;
            n8 = n9 + n15;
            n7 = n10 + n;
            n6 = n7 + n;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = i - 1 + n13;
                int n18 = i - 1 + n14;
                double d5 = this.wtable_r[n17 - 1];
                double d6 = this.wtable_r[n17];
                double d7 = this.wtable_r[n18 - 1];
                double d8 = this.wtable_r[n18];
                int n19 = n3 + i;
                int n20 = n4 + i;
                int n21 = n4 + n16;
                int n22 = n19 + n11;
                int n23 = n19 + n9;
                int n24 = n19 + n8;
                double d9 = dArray[n22 - 1];
                double d10 = dArray[n22];
                double d11 = dArray[n23 - 1];
                double d12 = dArray[n23];
                double d13 = dArray[n24 - 1];
                double d14 = dArray[n24];
                double d15 = d5 * d11 + d6 * d12;
                double d16 = d5 * d12 - d6 * d11;
                double d17 = d7 * d13 + d8 * d14;
                double d18 = d7 * d14 - d8 * d13;
                d = d15 + d17;
                double d19 = d16 + d18;
                double d20 = d9 + -0.5 * d;
                double d21 = d10 + -0.5 * d19;
                double d22 = 0.8660254037844387 * (d16 - d18);
                double d23 = 0.8660254037844387 * (d17 - d15);
                int n25 = n20 + n10;
                int n26 = n21 + n7;
                int n27 = n20 + n6;
                dArray2[n25 - 1] = d9 + d;
                dArray2[n25] = d10 + d19;
                dArray2[n26 - 1] = d20 - d22;
                dArray2[n26] = d23 - d21;
                dArray2[n27 - 1] = d20 + d22;
                dArray2[n27] = d21 + d23;
            }
        }
    }

    void radf3(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        double d;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13 = l5;
        long l14 = l13 + l;
        long l15 = l2 * l;
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l15;
            l9 = (3L * l12 + 1L) * l;
            l8 = l3 + l11;
            l7 = l8 + l15;
            l6 = l8 + l10;
            double d2 = doubleLargeArray.getDouble(l8);
            double d3 = doubleLargeArray.getDouble(l7);
            double d4 = doubleLargeArray.getDouble(l6);
            d = d3 + d4;
            doubleLargeArray2.setDouble(l4 + 3L * l11, d2 + d);
            doubleLargeArray2.setDouble(l4 + l9 + l, 0.8660254037844387 * (d4 - d3));
            doubleLargeArray2.setDouble(l4 + l - 1L + l9, d2 + -0.5 * d);
        }
        if (l == 1L) {
            return;
        }
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 3L * l11;
            l9 = l11 + l15;
            l8 = l9 + l15;
            l7 = l10 + l;
            l6 = l7 + l;
            for (long i = 2L; i < l; i += 2L) {
                long l16 = l - i;
                long l17 = i - 1L + l13;
                long l18 = i - 1L + l14;
                double d5 = this.wtable_rl.getDouble(l17 - 1L);
                double d6 = this.wtable_rl.getDouble(l17);
                double d7 = this.wtable_rl.getDouble(l18 - 1L);
                double d8 = this.wtable_rl.getDouble(l18);
                long l19 = l3 + i;
                long l20 = l4 + i;
                long l21 = l4 + l16;
                long l22 = l19 + l11;
                long l23 = l19 + l9;
                long l24 = l19 + l8;
                double d9 = doubleLargeArray.getDouble(l22 - 1L);
                double d10 = doubleLargeArray.getDouble(l22);
                double d11 = doubleLargeArray.getDouble(l23 - 1L);
                double d12 = doubleLargeArray.getDouble(l23);
                double d13 = doubleLargeArray.getDouble(l24 - 1L);
                double d14 = doubleLargeArray.getDouble(l24);
                double d15 = d5 * d11 + d6 * d12;
                double d16 = d5 * d12 - d6 * d11;
                double d17 = d7 * d13 + d8 * d14;
                double d18 = d7 * d14 - d8 * d13;
                d = d15 + d17;
                double d19 = d16 + d18;
                double d20 = d9 + -0.5 * d;
                double d21 = d10 + -0.5 * d19;
                double d22 = 0.8660254037844387 * (d16 - d18);
                double d23 = 0.8660254037844387 * (d17 - d15);
                long l25 = l20 + l10;
                long l26 = l21 + l7;
                long l27 = l20 + l6;
                doubleLargeArray2.setDouble(l25 - 1L, d9 + d);
                doubleLargeArray2.setDouble(l25, d10 + d19);
                doubleLargeArray2.setDouble(l26 - 1L, d20 - d22);
                doubleLargeArray2.setDouble(l26, d23 - d21);
                doubleLargeArray2.setDouble(l27 - 1L, d20 + d22);
                doubleLargeArray2.setDouble(l27, d21 + d23);
            }
        }
    }

    void radb3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n5;
        int n11 = n10 + n;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = n9 * n;
            n7 = n3 + 3 * n8;
            n6 = n7 + 2 * n;
            double d4 = dArray[n7];
            d3 = 2.0 * dArray[n6 - 1];
            d2 = d4 + -0.5 * d3;
            d = 1.7320508075688774 * dArray[n6];
            dArray2[n4 + n8] = d4 + d3;
            dArray2[n4 + (n9 + n2) * n] = d2 - d;
            dArray2[n4 + (n9 + 2 * n2) * n] = d2 + d;
        }
        if (n == 1) {
            return;
        }
        n9 = n2 * n;
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n8 * n;
            n6 = 3 * n7;
            int n12 = n6 + n;
            int n13 = n12 + n;
            int n14 = n7 + n9;
            int n15 = n14 + n9;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = n3 + i;
                int n18 = n3 + n16;
                int n19 = n4 + i;
                int n20 = n17 + n6;
                int n21 = n17 + n13;
                int n22 = n18 + n12;
                double d5 = dArray[n20 - 1];
                double d6 = dArray[n20];
                double d7 = dArray[n21 - 1];
                double d8 = dArray[n21];
                double d9 = dArray[n22 - 1];
                double d10 = dArray[n22];
                d3 = d7 + d9;
                d2 = d5 + -0.5 * d3;
                double d11 = d8 - d10;
                double d12 = d6 + -0.5 * d11;
                double d13 = 0.8660254037844387 * (d7 - d9);
                d = 0.8660254037844387 * (d8 + d10);
                double d14 = d2 - d;
                double d15 = d2 + d;
                double d16 = d12 + d13;
                double d17 = d12 - d13;
                int n23 = i - 1 + n10;
                int n24 = i - 1 + n11;
                double d18 = this.wtable_r[n23 - 1];
                double d19 = this.wtable_r[n23];
                double d20 = this.wtable_r[n24 - 1];
                double d21 = this.wtable_r[n24];
                int n25 = n19 + n7;
                int n26 = n19 + n14;
                int n27 = n19 + n15;
                dArray2[n25 - 1] = d5 + d3;
                dArray2[n25] = d6 + d11;
                dArray2[n26 - 1] = d18 * d14 - d19 * d16;
                dArray2[n26] = d18 * d16 + d19 * d14;
                dArray2[n27 - 1] = d20 * d15 - d21 * d17;
                dArray2[n27] = d20 * d17 + d21 * d15;
            }
        }
    }

    void radb3(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10 = l5;
        long l11 = l10 + l;
        for (l9 = 0L; l9 < l2; ++l9) {
            l8 = l9 * l;
            l7 = l3 + 3L * l8;
            l6 = l7 + 2L * l;
            double d4 = doubleLargeArray.getDouble(l7);
            d3 = 2.0 * doubleLargeArray.getDouble(l6 - 1L);
            d2 = d4 + -0.5 * d3;
            d = 1.7320508075688774 * doubleLargeArray.getDouble(l6);
            doubleLargeArray2.setDouble(l4 + l8, d4 + d3);
            doubleLargeArray2.setDouble(l4 + (l9 + l2) * l, d2 - d);
            doubleLargeArray2.setDouble(l4 + (l9 + 2L * l2) * l, d2 + d);
        }
        if (l == 1L) {
            return;
        }
        l9 = l2 * l;
        for (l8 = 0L; l8 < l2; ++l8) {
            l7 = l8 * l;
            l6 = 3L * l7;
            long l12 = l6 + l;
            long l13 = l12 + l;
            long l14 = l7 + l9;
            long l15 = l14 + l9;
            for (long i = 2L; i < l; i += 2L) {
                long l16 = l - i;
                long l17 = l3 + i;
                long l18 = l3 + l16;
                long l19 = l4 + i;
                long l20 = l17 + l6;
                long l21 = l17 + l13;
                long l22 = l18 + l12;
                double d5 = doubleLargeArray.getDouble(l20 - 1L);
                double d6 = doubleLargeArray.getDouble(l20);
                double d7 = doubleLargeArray.getDouble(l21 - 1L);
                double d8 = doubleLargeArray.getDouble(l21);
                double d9 = doubleLargeArray.getDouble(l22 - 1L);
                double d10 = doubleLargeArray.getDouble(l22);
                d3 = d7 + d9;
                d2 = d5 + -0.5 * d3;
                double d11 = d8 - d10;
                double d12 = d6 + -0.5 * d11;
                double d13 = 0.8660254037844387 * (d7 - d9);
                d = 0.8660254037844387 * (d8 + d10);
                double d14 = d2 - d;
                double d15 = d2 + d;
                double d16 = d12 + d13;
                double d17 = d12 - d13;
                long l23 = i - 1L + l10;
                long l24 = i - 1L + l11;
                double d18 = this.wtable_rl.getDouble(l23 - 1L);
                double d19 = this.wtable_rl.getDouble(l23);
                double d20 = this.wtable_rl.getDouble(l24 - 1L);
                double d21 = this.wtable_rl.getDouble(l24);
                long l25 = l19 + l7;
                long l26 = l19 + l14;
                long l27 = l19 + l15;
                doubleLargeArray2.setDouble(l25 - 1L, d5 + d3);
                doubleLargeArray2.setDouble(l25, d6 + d11);
                doubleLargeArray2.setDouble(l26 - 1L, d18 * d14 - d19 * d16);
                doubleLargeArray2.setDouble(l26, d18 * d16 + d19 * d14);
                doubleLargeArray2.setDouble(l27 - 1L, d20 * d15 - d21 * d17);
                doubleLargeArray2.setDouble(l27, d20 * d17 + d21 * d15);
            }
        }
    }

    void radf4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        int n6;
        int n7;
        int n8;
        int n9;
        double d2;
        double d3;
        double d4;
        double d5;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = n5;
        int n18 = n5 + n;
        int n19 = n18 + n;
        int n20 = n2 * n;
        for (n16 = 0; n16 < n2; ++n16) {
            n15 = n16 * n;
            n14 = 4 * n15;
            n13 = n15 + n20;
            n12 = n13 + n20;
            n11 = n12 + n20;
            n10 = n14 + n;
            double d6 = dArray[n3 + n15];
            double d7 = dArray[n3 + n13];
            d5 = dArray[n3 + n12];
            d4 = dArray[n3 + n11];
            d3 = d7 + d4;
            d2 = d6 + d5;
            n9 = n4 + n14;
            n8 = n4 + n10 + n;
            dArray2[n9] = d3 + d2;
            dArray2[n8 - 1 + n + n] = d2 - d3;
            dArray2[n8 - 1] = d6 - d5;
            dArray2[n8] = d4 - d7;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n16 = 0; n16 < n2; ++n16) {
                n15 = n16 * n;
                n14 = n15 + n20;
                n13 = n14 + n20;
                n12 = n13 + n20;
                n11 = 4 * n15;
                n10 = n11 + n;
                int n21 = n10 + n;
                n7 = n21 + n;
                for (int i = 2; i < n; i += 2) {
                    int n22 = n - i;
                    int n23 = i - 1 + n17;
                    n6 = i - 1 + n18;
                    int n24 = i - 1 + n19;
                    double d8 = this.wtable_r[n23 - 1];
                    double d9 = this.wtable_r[n23];
                    double d10 = this.wtable_r[n6 - 1];
                    double d11 = this.wtable_r[n6];
                    double d12 = this.wtable_r[n24 - 1];
                    double d13 = this.wtable_r[n24];
                    int n25 = n3 + i;
                    int n26 = n4 + i;
                    int n27 = n4 + n22;
                    n9 = n25 + n15;
                    n8 = n25 + n14;
                    int n28 = n25 + n13;
                    int n29 = n25 + n12;
                    double d14 = dArray[n9 - 1];
                    double d15 = dArray[n9];
                    double d16 = dArray[n8 - 1];
                    double d17 = dArray[n8];
                    double d18 = dArray[n28 - 1];
                    double d19 = dArray[n28];
                    double d20 = dArray[n29 - 1];
                    double d21 = dArray[n29];
                    double d22 = d8 * d16 + d9 * d17;
                    double d23 = d8 * d17 - d9 * d16;
                    double d24 = d10 * d18 + d11 * d19;
                    double d25 = d10 * d19 - d11 * d18;
                    double d26 = d12 * d20 + d13 * d21;
                    double d27 = d12 * d21 - d13 * d20;
                    d3 = d22 + d26;
                    double d28 = d26 - d22;
                    d = d23 + d27;
                    double d29 = d23 - d27;
                    double d30 = d15 + d25;
                    double d31 = d15 - d25;
                    d2 = d14 + d24;
                    double d32 = d14 - d24;
                    int n30 = n26 + n11;
                    int n31 = n27 + n10;
                    int n32 = n26 + n21;
                    int n33 = n27 + n7;
                    dArray2[n30 - 1] = d3 + d2;
                    dArray2[n33 - 1] = d2 - d3;
                    dArray2[n30] = d + d30;
                    dArray2[n33] = d - d30;
                    dArray2[n32 - 1] = d29 + d32;
                    dArray2[n31 - 1] = d32 - d29;
                    dArray2[n32] = d28 + d31;
                    dArray2[n31] = d28 - d31;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n16 = 0; n16 < n2; ++n16) {
            n15 = n16 * n;
            n14 = 4 * n15;
            n13 = n15 + n20;
            n12 = n13 + n20;
            n11 = n12 + n20;
            n10 = n14 + n;
            int n34 = n10 + n;
            n7 = n34 + n;
            int n35 = n3 + n;
            n6 = n4 + n;
            d5 = dArray[n35 - 1 + n15];
            d4 = dArray[n35 - 1 + n13];
            double d33 = dArray[n35 - 1 + n12];
            double d34 = dArray[n35 - 1 + n11];
            d = -0.7071067811865476 * (d4 + d34);
            d3 = 0.7071067811865476 * (d4 - d34);
            dArray2[n6 - 1 + n14] = d3 + d5;
            dArray2[n6 - 1 + n34] = d5 - d3;
            dArray2[n4 + n10] = d - d33;
            dArray2[n4 + n7] = d + d33;
        }
    }

    void radf4(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        double d;
        long l6;
        long l7;
        double d2;
        double d3;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15 = l5;
        long l16 = l5 + l;
        long l17 = l16 + l;
        long l18 = l2 * l;
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            double d4 = doubleLargeArray.getDouble(l3 + l13);
            double d5 = doubleLargeArray.getDouble(l3 + l11);
            double d6 = doubleLargeArray.getDouble(l3 + l10);
            double d7 = doubleLargeArray.getDouble(l3 + l9);
            d3 = d5 + d7;
            d2 = d4 + d6;
            l7 = l4 + l12;
            l6 = l4 + l8 + l;
            doubleLargeArray2.setDouble(l7, d3 + d2);
            doubleLargeArray2.setDouble(l6 - 1L + l + l, d2 - d3);
            doubleLargeArray2.setDouble(l6 - 1L, d4 - d6);
            doubleLargeArray2.setDouble(l6, d7 - d5);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l14 = 0L; l14 < l2; ++l14) {
                l13 = l14 * l;
                l12 = l13 + l18;
                l11 = l12 + l18;
                l10 = l11 + l18;
                l9 = 4L * l13;
                l8 = l9 + l;
                long l19 = l8 + l;
                long l20 = l19 + l;
                for (long i = 2L; i < l; i += 2L) {
                    long l21 = l - i;
                    long l22 = i - 1L + l15;
                    long l23 = i - 1L + l16;
                    l7 = i - 1L + l17;
                    double d8 = this.wtable_rl.getDouble(l22 - 1L);
                    double d9 = this.wtable_rl.getDouble(l22);
                    double d10 = this.wtable_rl.getDouble(l23 - 1L);
                    double d11 = this.wtable_rl.getDouble(l23);
                    double d12 = this.wtable_rl.getDouble(l7 - 1L);
                    double d13 = this.wtable_rl.getDouble(l7);
                    l6 = l3 + i;
                    long l24 = l4 + i;
                    long l25 = l4 + l21;
                    long l26 = l6 + l13;
                    long l27 = l6 + l12;
                    long l28 = l6 + l11;
                    long l29 = l6 + l10;
                    double d14 = doubleLargeArray.getDouble(l26 - 1L);
                    double d15 = doubleLargeArray.getDouble(l26);
                    double d16 = doubleLargeArray.getDouble(l27 - 1L);
                    double d17 = doubleLargeArray.getDouble(l27);
                    double d18 = doubleLargeArray.getDouble(l28 - 1L);
                    double d19 = doubleLargeArray.getDouble(l28);
                    double d20 = doubleLargeArray.getDouble(l29 - 1L);
                    double d21 = doubleLargeArray.getDouble(l29);
                    double d22 = d8 * d16 + d9 * d17;
                    double d23 = d8 * d17 - d9 * d16;
                    double d24 = d10 * d18 + d11 * d19;
                    double d25 = d10 * d19 - d11 * d18;
                    double d26 = d12 * d20 + d13 * d21;
                    double d27 = d12 * d21 - d13 * d20;
                    d3 = d22 + d26;
                    double d28 = d26 - d22;
                    d = d23 + d27;
                    double d29 = d23 - d27;
                    double d30 = d15 + d25;
                    double d31 = d15 - d25;
                    d2 = d14 + d24;
                    double d32 = d14 - d24;
                    long l30 = l24 + l9;
                    long l31 = l25 + l8;
                    long l32 = l24 + l19;
                    long l33 = l25 + l20;
                    doubleLargeArray2.setDouble(l30 - 1L, d3 + d2);
                    doubleLargeArray2.setDouble(l33 - 1L, d2 - d3);
                    doubleLargeArray2.setDouble(l30, d + d30);
                    doubleLargeArray2.setDouble(l33, d - d30);
                    doubleLargeArray2.setDouble(l32 - 1L, d29 + d32);
                    doubleLargeArray2.setDouble(l31 - 1L, d32 - d29);
                    doubleLargeArray2.setDouble(l32, d28 + d31);
                    doubleLargeArray2.setDouble(l31, d28 - d31);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            long l34 = l8 + l;
            long l35 = l34 + l;
            long l36 = l3 + l;
            long l37 = l4 + l;
            double d33 = doubleLargeArray.getDouble(l36 - 1L + l13);
            double d34 = doubleLargeArray.getDouble(l36 - 1L + l11);
            double d35 = doubleLargeArray.getDouble(l36 - 1L + l10);
            double d36 = doubleLargeArray.getDouble(l36 - 1L + l9);
            d = -0.7071067811865476 * (d34 + d36);
            d3 = 0.7071067811865476 * (d34 - d36);
            doubleLargeArray2.setDouble(l37 - 1L + l12, d3 + d33);
            doubleLargeArray2.setDouble(l37 - 1L + l34, d33 - d3);
            doubleLargeArray2.setDouble(l4 + l8, d - d35);
            doubleLargeArray2.setDouble(l4 + l35, d + d35);
        }
    }

    void radb4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        int n6;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16 = n5;
        int n17 = n16 + n;
        int n18 = n17 + n;
        int n19 = n2 * n;
        for (n15 = 0; n15 < n2; ++n15) {
            n14 = n15 * n;
            n13 = 4 * n14;
            n12 = n14 + n19;
            n11 = n12 + n19;
            n10 = n11 + n19;
            n9 = n13 + n;
            n8 = n9 + n;
            n7 = n8 + n;
            double d10 = dArray[n3 + n13];
            d9 = dArray[n3 + n8];
            d8 = dArray[n3 + n - 1 + n7];
            d7 = dArray[n3 + n - 1 + n9];
            d6 = d10 - d8;
            d5 = d10 + d8;
            d4 = d7 + d7;
            d3 = d9 + d9;
            dArray2[n4 + n14] = d5 + d4;
            dArray2[n4 + n12] = d6 - d3;
            dArray2[n4 + n11] = d5 - d4;
            dArray2[n4 + n10] = d6 + d3;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n15 = 0; n15 < n2; ++n15) {
                n14 = n15 * n;
                n13 = n14 + n19;
                n12 = n13 + n19;
                n11 = n12 + n19;
                n10 = 4 * n14;
                n9 = n10 + n;
                n8 = n9 + n;
                n7 = n8 + n;
                for (int i = 2; i < n; i += 2) {
                    int n20 = n - i;
                    int n21 = i - 1 + n16;
                    n6 = i - 1 + n17;
                    int n22 = i - 1 + n18;
                    double d11 = this.wtable_r[n21 - 1];
                    double d12 = this.wtable_r[n21];
                    double d13 = this.wtable_r[n6 - 1];
                    double d14 = this.wtable_r[n6];
                    double d15 = this.wtable_r[n22 - 1];
                    double d16 = this.wtable_r[n22];
                    int n23 = n3 + i;
                    int n24 = n3 + n20;
                    int n25 = n4 + i;
                    int n26 = n23 + n10;
                    int n27 = n24 + n9;
                    int n28 = n23 + n8;
                    int n29 = n24 + n7;
                    double d17 = dArray[n26 - 1];
                    double d18 = dArray[n26];
                    double d19 = dArray[n27 - 1];
                    double d20 = dArray[n27];
                    double d21 = dArray[n28 - 1];
                    double d22 = dArray[n28];
                    double d23 = dArray[n29 - 1];
                    double d24 = dArray[n29];
                    d2 = d18 + d24;
                    d = d18 - d24;
                    double d25 = d22 - d20;
                    d3 = d22 + d20;
                    d6 = d17 - d23;
                    d5 = d17 + d23;
                    double d26 = d21 - d19;
                    d4 = d21 + d19;
                    double d27 = d5 - d4;
                    double d28 = d - d25;
                    double d29 = d6 - d3;
                    double d30 = d6 + d3;
                    double d31 = d2 + d26;
                    double d32 = d2 - d26;
                    int n30 = n25 + n14;
                    int n31 = n25 + n13;
                    int n32 = n25 + n12;
                    int n33 = n25 + n11;
                    dArray2[n30 - 1] = d5 + d4;
                    dArray2[n30] = d + d25;
                    dArray2[n31 - 1] = d11 * d29 - d12 * d31;
                    dArray2[n31] = d11 * d31 + d12 * d29;
                    dArray2[n32 - 1] = d13 * d27 - d14 * d28;
                    dArray2[n32] = d13 * d28 + d14 * d27;
                    dArray2[n33 - 1] = d15 * d30 - d16 * d32;
                    dArray2[n33] = d15 * d32 + d16 * d30;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n15 = 0; n15 < n2; ++n15) {
            n14 = n15 * n;
            n13 = 4 * n14;
            n12 = n14 + n19;
            n11 = n12 + n19;
            n10 = n11 + n19;
            n9 = n13 + n;
            n8 = n9 + n;
            n7 = n8 + n;
            int n34 = n3 + n;
            n6 = n4 + n;
            d9 = dArray[n34 - 1 + n13];
            d8 = dArray[n34 - 1 + n8];
            d7 = dArray[n3 + n9];
            double d33 = dArray[n3 + n7];
            d2 = d7 + d33;
            d = d33 - d7;
            d6 = d9 - d8;
            d5 = d9 + d8;
            dArray2[n6 - 1 + n14] = d5 + d5;
            dArray2[n6 - 1 + n12] = 1.4142135623730951 * (d6 - d2);
            dArray2[n6 - 1 + n11] = d + d;
            dArray2[n6 - 1 + n10] = -1.4142135623730951 * (d6 + d2);
        }
    }

    void radb4(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15 = l5;
        long l16 = l15 + l;
        long l17 = l16 + l;
        long l18 = l2 * l;
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            l7 = l8 + l;
            l6 = l7 + l;
            double d9 = doubleLargeArray.getDouble(l3 + l12);
            double d10 = doubleLargeArray.getDouble(l3 + l7);
            d8 = doubleLargeArray.getDouble(l3 + l - 1L + l6);
            d7 = doubleLargeArray.getDouble(l3 + l - 1L + l8);
            d6 = d9 - d8;
            d5 = d9 + d8;
            d4 = d7 + d7;
            d3 = d10 + d10;
            doubleLargeArray2.setDouble(l4 + l13, d5 + d4);
            doubleLargeArray2.setDouble(l4 + l11, d6 - d3);
            doubleLargeArray2.setDouble(l4 + l10, d5 - d4);
            doubleLargeArray2.setDouble(l4 + l9, d6 + d3);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l14 = 0L; l14 < l2; ++l14) {
                l13 = l14 * l;
                l12 = l13 + l18;
                l11 = l12 + l18;
                l10 = l11 + l18;
                l9 = 4L * l13;
                l8 = l9 + l;
                l7 = l8 + l;
                l6 = l7 + l;
                for (long i = 2L; i < l; i += 2L) {
                    long l19 = l - i;
                    long l20 = i - 1L + l15;
                    long l21 = i - 1L + l16;
                    long l22 = i - 1L + l17;
                    double d11 = this.wtable_rl.getDouble(l20 - 1L);
                    double d12 = this.wtable_rl.getDouble(l20);
                    double d13 = this.wtable_rl.getDouble(l21 - 1L);
                    double d14 = this.wtable_rl.getDouble(l21);
                    double d15 = this.wtable_rl.getDouble(l22 - 1L);
                    double d16 = this.wtable_rl.getDouble(l22);
                    long l23 = l3 + i;
                    long l24 = l3 + l19;
                    long l25 = l4 + i;
                    long l26 = l23 + l9;
                    long l27 = l24 + l8;
                    long l28 = l23 + l7;
                    long l29 = l24 + l6;
                    double d17 = doubleLargeArray.getDouble(l26 - 1L);
                    double d18 = doubleLargeArray.getDouble(l26);
                    double d19 = doubleLargeArray.getDouble(l27 - 1L);
                    double d20 = doubleLargeArray.getDouble(l27);
                    double d21 = doubleLargeArray.getDouble(l28 - 1L);
                    double d22 = doubleLargeArray.getDouble(l28);
                    double d23 = doubleLargeArray.getDouble(l29 - 1L);
                    double d24 = doubleLargeArray.getDouble(l29);
                    d2 = d18 + d24;
                    d = d18 - d24;
                    double d25 = d22 - d20;
                    d3 = d22 + d20;
                    d6 = d17 - d23;
                    d5 = d17 + d23;
                    double d26 = d21 - d19;
                    d4 = d21 + d19;
                    double d27 = d5 - d4;
                    double d28 = d - d25;
                    double d29 = d6 - d3;
                    double d30 = d6 + d3;
                    double d31 = d2 + d26;
                    double d32 = d2 - d26;
                    long l30 = l25 + l13;
                    long l31 = l25 + l12;
                    long l32 = l25 + l11;
                    long l33 = l25 + l10;
                    doubleLargeArray2.setDouble(l30 - 1L, d5 + d4);
                    doubleLargeArray2.setDouble(l30, d + d25);
                    doubleLargeArray2.setDouble(l31 - 1L, d11 * d29 - d12 * d31);
                    doubleLargeArray2.setDouble(l31, d11 * d31 + d12 * d29);
                    doubleLargeArray2.setDouble(l32 - 1L, d13 * d27 - d14 * d28);
                    doubleLargeArray2.setDouble(l32, d13 * d28 + d14 * d27);
                    doubleLargeArray2.setDouble(l33 - 1L, d15 * d30 - d16 * d32);
                    doubleLargeArray2.setDouble(l33, d15 * d32 + d16 * d30);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            l7 = l8 + l;
            l6 = l7 + l;
            long l34 = l3 + l;
            long l35 = l4 + l;
            d8 = doubleLargeArray.getDouble(l34 - 1L + l12);
            d7 = doubleLargeArray.getDouble(l34 - 1L + l7);
            double d33 = doubleLargeArray.getDouble(l3 + l8);
            double d34 = doubleLargeArray.getDouble(l3 + l6);
            d2 = d33 + d34;
            d = d34 - d33;
            d6 = d8 - d7;
            d5 = d8 + d7;
            doubleLargeArray2.setDouble(l35 - 1L + l13, d5 + d5);
            doubleLargeArray2.setDouble(l35 - 1L + l11, 1.4142135623730951 * (d6 - d2));
            doubleLargeArray2.setDouble(l35 - 1L + l10, d + d);
            doubleLargeArray2.setDouble(l35 - 1L + l9, -1.4142135623730951 * (d6 + d2));
        }
    }

    void radf5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n4 + n - 1;
            double d5 = dArray[n3 + n16];
            double d6 = dArray[n3 + n10];
            double d7 = dArray[n3 + n9];
            double d8 = dArray[n3 + n8];
            double d9 = dArray[n3 + n7];
            d4 = d9 + d6;
            d3 = d9 - d6;
            d2 = d8 + d7;
            d = d8 - d7;
            dArray2[n4 + n15] = d5 + d4 + d2;
            dArray2[n6 + n14] = d5 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
            dArray2[n4 + n13] = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
            dArray2[n6 + n12] = d5 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
            dArray2[n4 + n11] = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                n6 = i - 1 + n18;
                int n23 = i - 1 + n19;
                int n24 = i - 1 + n20;
                int n25 = i - 1 + n21;
                double d10 = this.wtable_r[n6 - 1];
                double d11 = this.wtable_r[n6];
                double d12 = this.wtable_r[n23 - 1];
                double d13 = this.wtable_r[n23];
                double d14 = this.wtable_r[n24 - 1];
                double d15 = this.wtable_r[n24];
                double d16 = this.wtable_r[n25 - 1];
                double d17 = this.wtable_r[n25];
                int n26 = n - i;
                int n27 = n3 + i;
                int n28 = n4 + i;
                int n29 = n4 + n26;
                int n30 = n27 + n16;
                int n31 = n27 + n10;
                int n32 = n27 + n9;
                int n33 = n27 + n8;
                int n34 = n27 + n7;
                double d18 = dArray[n30 - 1];
                double d19 = dArray[n30];
                double d20 = dArray[n31 - 1];
                double d21 = dArray[n31];
                double d22 = dArray[n32 - 1];
                double d23 = dArray[n32];
                double d24 = dArray[n33 - 1];
                double d25 = dArray[n33];
                double d26 = dArray[n34 - 1];
                double d27 = dArray[n34];
                double d28 = d10 * d20 + d11 * d21;
                double d29 = d10 * d21 - d11 * d20;
                double d30 = d12 * d22 + d13 * d23;
                double d31 = d12 * d23 - d13 * d22;
                double d32 = d14 * d24 + d15 * d25;
                double d33 = d14 * d25 - d15 * d24;
                double d34 = d16 * d26 + d17 * d27;
                double d35 = d16 * d27 - d17 * d26;
                d4 = d28 + d34;
                d3 = d34 - d28;
                double d36 = d29 - d35;
                double d37 = d29 + d35;
                d2 = d30 + d32;
                d = d32 - d30;
                double d38 = d31 - d33;
                double d39 = d31 + d33;
                double d40 = d18 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
                double d41 = d19 + 0.30901699437494745 * d37 + -0.8090169943749473 * d39;
                double d42 = d18 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
                double d43 = d19 + -0.8090169943749473 * d37 + 0.30901699437494745 * d39;
                double d44 = 0.9510565162951535 * d36 + 0.5877852522924732 * d38;
                double d45 = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
                double d46 = 0.5877852522924732 * d36 - 0.9510565162951535 * d38;
                double d47 = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
                int n35 = n28 + n15;
                int n36 = n29 + n14;
                int n37 = n28 + n13;
                int n38 = n29 + n12;
                int n39 = n28 + n11;
                dArray2[n35 - 1] = d18 + d4 + d2;
                dArray2[n35] = d19 + d37 + d39;
                dArray2[n37 - 1] = d40 + d44;
                dArray2[n36 - 1] = d40 - d44;
                dArray2[n37] = d41 + d45;
                dArray2[n36] = d45 - d41;
                dArray2[n39 - 1] = d42 + d46;
                dArray2[n38 - 1] = d42 - d46;
                dArray2[n39] = d43 + d47;
                dArray2[n38] = d47 - d43;
            }
        }
    }

    void radf5(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        double d4;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18 = l5;
        long l19 = l18 + l;
        long l20 = l19 + l;
        long l21 = l20 + l;
        long l22 = l2 * l;
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            l6 = l4 + l - 1L;
            double d5 = doubleLargeArray.getDouble(l3 + l16);
            double d6 = doubleLargeArray.getDouble(l3 + l10);
            double d7 = doubleLargeArray.getDouble(l3 + l9);
            double d8 = doubleLargeArray.getDouble(l3 + l8);
            double d9 = doubleLargeArray.getDouble(l3 + l7);
            d4 = d9 + d6;
            d3 = d9 - d6;
            d2 = d8 + d7;
            d = d8 - d7;
            doubleLargeArray2.setDouble(l4 + l15, d5 + d4 + d2);
            doubleLargeArray2.setDouble(l6 + l14, d5 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2);
            doubleLargeArray2.setDouble(l4 + l13, 0.9510565162951535 * d3 + 0.5877852522924732 * d);
            doubleLargeArray2.setDouble(l6 + l12, d5 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2);
            doubleLargeArray2.setDouble(l4 + l11, 0.5877852522924732 * d3 - 0.9510565162951535 * d);
        }
        if (l == 1L) {
            return;
        }
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            for (long i = 2L; i < l; i += 2L) {
                l6 = i - 1L + l18;
                long l23 = i - 1L + l19;
                long l24 = i - 1L + l20;
                long l25 = i - 1L + l21;
                double d10 = this.wtable_rl.getDouble(l6 - 1L);
                double d11 = this.wtable_rl.getDouble(l6);
                double d12 = this.wtable_rl.getDouble(l23 - 1L);
                double d13 = this.wtable_rl.getDouble(l23);
                double d14 = this.wtable_rl.getDouble(l24 - 1L);
                double d15 = this.wtable_rl.getDouble(l24);
                double d16 = this.wtable_rl.getDouble(l25 - 1L);
                double d17 = this.wtable_rl.getDouble(l25);
                long l26 = l - i;
                long l27 = l3 + i;
                long l28 = l4 + i;
                long l29 = l4 + l26;
                long l30 = l27 + l16;
                long l31 = l27 + l10;
                long l32 = l27 + l9;
                long l33 = l27 + l8;
                long l34 = l27 + l7;
                double d18 = doubleLargeArray.getDouble(l30 - 1L);
                double d19 = doubleLargeArray.getDouble(l30);
                double d20 = doubleLargeArray.getDouble(l31 - 1L);
                double d21 = doubleLargeArray.getDouble(l31);
                double d22 = doubleLargeArray.getDouble(l32 - 1L);
                double d23 = doubleLargeArray.getDouble(l32);
                double d24 = doubleLargeArray.getDouble(l33 - 1L);
                double d25 = doubleLargeArray.getDouble(l33);
                double d26 = doubleLargeArray.getDouble(l34 - 1L);
                double d27 = doubleLargeArray.getDouble(l34);
                double d28 = d10 * d20 + d11 * d21;
                double d29 = d10 * d21 - d11 * d20;
                double d30 = d12 * d22 + d13 * d23;
                double d31 = d12 * d23 - d13 * d22;
                double d32 = d14 * d24 + d15 * d25;
                double d33 = d14 * d25 - d15 * d24;
                double d34 = d16 * d26 + d17 * d27;
                double d35 = d16 * d27 - d17 * d26;
                d4 = d28 + d34;
                d3 = d34 - d28;
                double d36 = d29 - d35;
                double d37 = d29 + d35;
                d2 = d30 + d32;
                d = d32 - d30;
                double d38 = d31 - d33;
                double d39 = d31 + d33;
                double d40 = d18 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
                double d41 = d19 + 0.30901699437494745 * d37 + -0.8090169943749473 * d39;
                double d42 = d18 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
                double d43 = d19 + -0.8090169943749473 * d37 + 0.30901699437494745 * d39;
                double d44 = 0.9510565162951535 * d36 + 0.5877852522924732 * d38;
                double d45 = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
                double d46 = 0.5877852522924732 * d36 - 0.9510565162951535 * d38;
                double d47 = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
                long l35 = l28 + l15;
                long l36 = l29 + l14;
                long l37 = l28 + l13;
                long l38 = l29 + l12;
                long l39 = l28 + l11;
                doubleLargeArray2.setDouble(l35 - 1L, d18 + d4 + d2);
                doubleLargeArray2.setDouble(l35, d19 + d37 + d39);
                doubleLargeArray2.setDouble(l37 - 1L, d40 + d44);
                doubleLargeArray2.setDouble(l36 - 1L, d40 - d44);
                doubleLargeArray2.setDouble(l37, d41 + d45);
                doubleLargeArray2.setDouble(l36, d45 - d41);
                doubleLargeArray2.setDouble(l39 - 1L, d42 + d46);
                doubleLargeArray2.setDouble(l38 - 1L, d42 - d46);
                doubleLargeArray2.setDouble(l39, d43 + d47);
                doubleLargeArray2.setDouble(l38, d47 - d43);
            }
        }
    }

    void radb5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n3 + n - 1;
            double d9 = dArray[n3 + n15];
            d8 = 2.0 * dArray[n3 + n13];
            d7 = 2.0 * dArray[n3 + n11];
            d6 = 2.0 * dArray[n6 + n14];
            d5 = 2.0 * dArray[n6 + n12];
            d4 = d9 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
            d3 = d9 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
            d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
            d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
            dArray2[n4 + n16] = d9 + d6 + d5;
            dArray2[n4 + n10] = d4 - d2;
            dArray2[n4 + n9] = d3 - d;
            dArray2[n4 + n8] = d3 + d;
            dArray2[n4 + n7] = d4 + d2;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                int n23 = n - i;
                n6 = i - 1 + n18;
                int n24 = i - 1 + n19;
                int n25 = i - 1 + n20;
                int n26 = i - 1 + n21;
                double d10 = this.wtable_r[n6 - 1];
                double d11 = this.wtable_r[n6];
                double d12 = this.wtable_r[n24 - 1];
                double d13 = this.wtable_r[n24];
                double d14 = this.wtable_r[n25 - 1];
                double d15 = this.wtable_r[n25];
                double d16 = this.wtable_r[n26 - 1];
                double d17 = this.wtable_r[n26];
                int n27 = n3 + i;
                int n28 = n3 + n23;
                int n29 = n4 + i;
                int n30 = n27 + n15;
                int n31 = n28 + n14;
                int n32 = n27 + n13;
                int n33 = n28 + n12;
                int n34 = n27 + n11;
                double d18 = dArray[n30 - 1];
                double d19 = dArray[n30];
                double d20 = dArray[n31 - 1];
                double d21 = dArray[n31];
                double d22 = dArray[n32 - 1];
                double d23 = dArray[n32];
                double d24 = dArray[n33 - 1];
                double d25 = dArray[n33];
                double d26 = dArray[n34 - 1];
                double d27 = dArray[n34];
                d8 = d23 + d21;
                double d28 = d23 - d21;
                d7 = d27 + d25;
                double d29 = d27 - d25;
                double d30 = d22 - d20;
                d6 = d22 + d20;
                double d31 = d26 - d24;
                d5 = d26 + d24;
                d4 = d18 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
                double d32 = d19 + 0.30901699437494745 * d28 + -0.8090169943749473 * d29;
                d3 = d18 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
                double d33 = d19 + -0.8090169943749473 * d28 + 0.30901699437494745 * d29;
                double d34 = 0.9510565162951535 * d30 + 0.5877852522924732 * d31;
                d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
                double d35 = 0.5877852522924732 * d30 - 0.9510565162951535 * d31;
                d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
                double d36 = d3 - d;
                double d37 = d3 + d;
                double d38 = d33 + d35;
                double d39 = d33 - d35;
                double d40 = d4 + d2;
                double d41 = d4 - d2;
                double d42 = d32 - d34;
                double d43 = d32 + d34;
                int n35 = n29 + n16;
                int n36 = n29 + n10;
                int n37 = n29 + n9;
                int n38 = n29 + n8;
                int n39 = n29 + n7;
                dArray2[n35 - 1] = d18 + d6 + d5;
                dArray2[n35] = d19 + d28 + d29;
                dArray2[n36 - 1] = d10 * d41 - d11 * d43;
                dArray2[n36] = d10 * d43 + d11 * d41;
                dArray2[n37 - 1] = d12 * d36 - d13 * d38;
                dArray2[n37] = d12 * d38 + d13 * d36;
                dArray2[n38 - 1] = d14 * d37 - d15 * d39;
                dArray2[n38] = d14 * d39 + d15 * d37;
                dArray2[n39 - 1] = d16 * d40 - d17 * d42;
                dArray2[n39] = d16 * d42 + d17 * d40;
            }
        }
    }

    void radb5(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18 = l5;
        long l19 = l18 + l;
        long l20 = l19 + l;
        long l21 = l20 + l;
        long l22 = l2 * l;
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            l6 = l3 + l - 1L;
            double d9 = doubleLargeArray.getDouble(l3 + l15);
            d8 = 2.0 * doubleLargeArray.getDouble(l3 + l13);
            d7 = 2.0 * doubleLargeArray.getDouble(l3 + l11);
            d6 = 2.0 * doubleLargeArray.getDouble(l6 + l14);
            d5 = 2.0 * doubleLargeArray.getDouble(l6 + l12);
            d4 = d9 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
            d3 = d9 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
            d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
            d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
            doubleLargeArray2.setDouble(l4 + l16, d9 + d6 + d5);
            doubleLargeArray2.setDouble(l4 + l10, d4 - d2);
            doubleLargeArray2.setDouble(l4 + l9, d3 - d);
            doubleLargeArray2.setDouble(l4 + l8, d3 + d);
            doubleLargeArray2.setDouble(l4 + l7, d4 + d2);
        }
        if (l == 1L) {
            return;
        }
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            for (long i = 2L; i < l; i += 2L) {
                long l23 = l - i;
                l6 = i - 1L + l18;
                long l24 = i - 1L + l19;
                long l25 = i - 1L + l20;
                long l26 = i - 1L + l21;
                double d10 = this.wtable_rl.getDouble(l6 - 1L);
                double d11 = this.wtable_rl.getDouble(l6);
                double d12 = this.wtable_rl.getDouble(l24 - 1L);
                double d13 = this.wtable_rl.getDouble(l24);
                double d14 = this.wtable_rl.getDouble(l25 - 1L);
                double d15 = this.wtable_rl.getDouble(l25);
                double d16 = this.wtable_rl.getDouble(l26 - 1L);
                double d17 = this.wtable_rl.getDouble(l26);
                long l27 = l3 + i;
                long l28 = l3 + l23;
                long l29 = l4 + i;
                long l30 = l27 + l15;
                long l31 = l28 + l14;
                long l32 = l27 + l13;
                long l33 = l28 + l12;
                long l34 = l27 + l11;
                double d18 = doubleLargeArray.getDouble(l30 - 1L);
                double d19 = doubleLargeArray.getDouble(l30);
                double d20 = doubleLargeArray.getDouble(l31 - 1L);
                double d21 = doubleLargeArray.getDouble(l31);
                double d22 = doubleLargeArray.getDouble(l32 - 1L);
                double d23 = doubleLargeArray.getDouble(l32);
                double d24 = doubleLargeArray.getDouble(l33 - 1L);
                double d25 = doubleLargeArray.getDouble(l33);
                double d26 = doubleLargeArray.getDouble(l34 - 1L);
                double d27 = doubleLargeArray.getDouble(l34);
                d8 = d23 + d21;
                double d28 = d23 - d21;
                d7 = d27 + d25;
                double d29 = d27 - d25;
                double d30 = d22 - d20;
                d6 = d22 + d20;
                double d31 = d26 - d24;
                d5 = d26 + d24;
                d4 = d18 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
                double d32 = d19 + 0.30901699437494745 * d28 + -0.8090169943749473 * d29;
                d3 = d18 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
                double d33 = d19 + -0.8090169943749473 * d28 + 0.30901699437494745 * d29;
                double d34 = 0.9510565162951535 * d30 + 0.5877852522924732 * d31;
                d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
                double d35 = 0.5877852522924732 * d30 - 0.9510565162951535 * d31;
                d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
                double d36 = d3 - d;
                double d37 = d3 + d;
                double d38 = d33 + d35;
                double d39 = d33 - d35;
                double d40 = d4 + d2;
                double d41 = d4 - d2;
                double d42 = d32 - d34;
                double d43 = d32 + d34;
                long l35 = l29 + l16;
                long l36 = l29 + l10;
                long l37 = l29 + l9;
                long l38 = l29 + l8;
                long l39 = l29 + l7;
                doubleLargeArray2.setDouble(l35 - 1L, d18 + d6 + d5);
                doubleLargeArray2.setDouble(l35, d19 + d28 + d29);
                doubleLargeArray2.setDouble(l36 - 1L, d10 * d41 - d11 * d43);
                doubleLargeArray2.setDouble(l36, d10 * d43 + d11 * d41);
                doubleLargeArray2.setDouble(l37 - 1L, d12 * d36 - d13 * d38);
                doubleLargeArray2.setDouble(l37, d12 * d38 + d13 * d36);
                doubleLargeArray2.setDouble(l38 - 1L, d14 * d37 - d15 * d39);
                doubleLargeArray2.setDouble(l38, d14 * d39 + d15 * d37);
                doubleLargeArray2.setDouble(l39 - 1L, d16 * d40 - d17 * d42);
                doubleLargeArray2.setDouble(l39, d16 * d42 + d17 * d40);
            }
        }
    }

    void radfg(int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7) {
        int n8;
        double d;
        double d2;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        double d3 = Math.PI * 2 / (double)n2;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        int n21 = (n2 + 1) / 2;
        int n22 = (n - 1) / 2;
        if (n != 1) {
            double d6;
            double d7;
            double d8;
            int n23;
            double d9;
            double d10;
            int n24;
            int n25;
            for (n19 = 0; n19 < n4; ++n19) {
                dArray2[n6 + n19] = dArray[n5 + n19];
            }
            for (n19 = 1; n19 < n2; ++n19) {
                n18 = n19 * n3 * n;
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n + n18;
                    dArray2[n6 + n16] = dArray[n5 + n16];
                }
            }
            if (n22 <= n3) {
                n25 = -n;
                for (n19 = 1; n19 < n2; ++n19) {
                    n24 = (n25 += n) - 1;
                    n18 = n19 * n3 * n;
                    for (n17 = 2; n17 < n; n17 += 2) {
                        n16 = (n24 += 2) + n20;
                        n15 = n5 + n17;
                        n14 = n6 + n17;
                        d10 = this.wtable_r[n16 - 1];
                        d9 = this.wtable_r[n16];
                        for (n13 = 0; n13 < n3; ++n13) {
                            n12 = n13 * n + n18;
                            n23 = n14 + n12;
                            n11 = n15 + n12;
                            d8 = dArray[n11 - 1];
                            double d11 = dArray[n11];
                            dArray2[n23 - 1] = d10 * d8 + d9 * d11;
                            dArray2[n23] = d10 * d11 - d9 * d8;
                        }
                    }
                }
            } else {
                n25 = -n;
                for (n19 = 1; n19 < n2; ++n19) {
                    n25 += n;
                    n18 = n19 * n3 * n;
                    for (n17 = 0; n17 < n3; ++n17) {
                        n24 = n25 - 1;
                        n16 = n17 * n + n18;
                        for (n15 = 2; n15 < n; n15 += 2) {
                            n14 = (n24 += 2) + n20;
                            d10 = this.wtable_r[n14 - 1];
                            d9 = this.wtable_r[n14];
                            n13 = n6 + n15 + n16;
                            n12 = n5 + n15 + n16;
                            double d12 = dArray[n12 - 1];
                            d8 = dArray[n12];
                            dArray2[n13 - 1] = d10 * d12 + d9 * d8;
                            dArray2[n13] = d10 * d8 - d9 * d12;
                        }
                    }
                }
            }
            if (n22 >= n3) {
                for (n19 = 1; n19 < n21; ++n19) {
                    n10 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n10 * n3 * n;
                    for (n16 = 0; n16 < n3; ++n16) {
                        n15 = n16 * n + n18;
                        n14 = n16 * n + n17;
                        for (n13 = 2; n13 < n; n13 += 2) {
                            n12 = n5 + n13;
                            n23 = n6 + n13;
                            n11 = n12 + n15;
                            int n26 = n12 + n14;
                            n9 = n23 + n15;
                            int n27 = n23 + n14;
                            d7 = dArray2[n9 - 1];
                            d6 = dArray2[n9];
                            d2 = dArray2[n27 - 1];
                            d = dArray2[n27];
                            dArray[n11 - 1] = d7 + d2;
                            dArray[n11] = d6 + d;
                            dArray[n26 - 1] = d6 - d;
                            dArray[n26] = d2 - d7;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n21; ++n19) {
                    n10 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n10 * n3 * n;
                    for (n16 = 2; n16 < n; n16 += 2) {
                        n15 = n5 + n16;
                        n14 = n6 + n16;
                        for (n13 = 0; n13 < n3; ++n13) {
                            n12 = n13 * n + n18;
                            n23 = n13 * n + n17;
                            n11 = n15 + n12;
                            int n28 = n15 + n23;
                            n9 = n14 + n12;
                            int n29 = n14 + n23;
                            d7 = dArray2[n9 - 1];
                            d6 = dArray2[n9];
                            d2 = dArray2[n29 - 1];
                            d = dArray2[n29];
                            dArray[n11 - 1] = d7 + d2;
                            dArray[n11] = d6 + d;
                            dArray[n28 - 1] = d6 - d;
                            dArray[n28] = d2 - d7;
                        }
                    }
                }
            }
        } else {
            System.arraycopy(dArray2, n6, dArray, n5, n4);
        }
        for (n19 = 1; n19 < n21; ++n19) {
            n10 = n2 - n19;
            n18 = n19 * n3 * n;
            n17 = n10 * n3 * n;
            for (n16 = 0; n16 < n3; ++n16) {
                n15 = n16 * n + n18;
                n14 = n16 * n + n17;
                n13 = n6 + n15;
                n12 = n6 + n14;
                double d13 = dArray2[n13];
                double d14 = dArray2[n12];
                dArray[n5 + n15] = d13 + d14;
                dArray[n5 + n14] = d14 - d13;
            }
        }
        double d15 = 1.0;
        double d16 = 0.0;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n21; ++n18) {
            int n30 = n2 - n18;
            double d17 = d4 * d15 - d5 * d16;
            d16 = d4 * d16 + d5 * d15;
            d15 = d17;
            n17 = n18 * n4;
            n16 = n30 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                n14 = n6 + n15;
                n13 = n5 + n15;
                dArray2[n14 + n17] = dArray[n13] + d15 * dArray[n13 + n4];
                dArray2[n14 + n16] = d16 * dArray[n13 + n19];
            }
            double d18 = d15;
            double d19 = d16;
            double d20 = d15;
            double d21 = d16;
            for (n15 = 2; n15 < n21; ++n15) {
                n10 = n2 - n15;
                double d22 = d18 * d20 - d19 * d21;
                d21 = d18 * d21 + d19 * d20;
                d20 = d22;
                n14 = n15 * n4;
                n13 = n10 * n4;
                for (n12 = 0; n12 < n4; ++n12) {
                    int n31 = n6 + n12;
                    n11 = n5 + n12;
                    int n32 = n31 + n17;
                    dArray2[n32] = dArray2[n32] + d20 * dArray[n11 + n14];
                    int n33 = n31 + n16;
                    dArray2[n33] = dArray2[n33] + d21 * dArray[n11 + n13];
                }
            }
        }
        for (n18 = 1; n18 < n21; ++n18) {
            n17 = n18 * n4;
            for (n16 = 0; n16 < n4; ++n16) {
                int n34 = n6 + n16;
                dArray2[n34] = dArray2[n34] + dArray[n5 + n16 + n17];
            }
        }
        if (n >= n3) {
            for (n18 = 0; n18 < n3; ++n18) {
                n17 = n18 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    dArray[n5 + n15 + n16] = dArray2[n6 + n15 + n17];
                }
            }
        } else {
            for (n18 = 0; n18 < n; ++n18) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    dArray[n5 + n18 + n16 * n2] = dArray2[n6 + n18 + n16];
                }
            }
        }
        n18 = n2 * n;
        for (n17 = 1; n17 < n21; ++n17) {
            n10 = n2 - n17;
            n8 = 2 * n17;
            n16 = n17 * n3 * n;
            n15 = n10 * n3 * n;
            n14 = n8 * n;
            for (n13 = 0; n13 < n3; ++n13) {
                n12 = n13 * n;
                int n35 = n12 + n16;
                n11 = n12 + n15;
                int n36 = n13 * n18;
                dArray[n5 + n - 1 + n14 - n + n36] = dArray2[n6 + n35];
                dArray[n5 + n14 + n36] = dArray2[n6 + n11];
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n17 = 1; n17 < n21; ++n17) {
                n10 = n2 - n17;
                n8 = 2 * n17;
                n16 = n17 * n3 * n;
                n15 = n10 * n3 * n;
                n14 = n8 * n;
                for (n13 = 0; n13 < n3; ++n13) {
                    n12 = n13 * n18;
                    int n37 = n13 * n;
                    for (n11 = 2; n11 < n; n11 += 2) {
                        int n38 = n - n11;
                        int n39 = n5 + n11;
                        n9 = n5 + n38;
                        int n40 = n6 + n11;
                        int n41 = n39 + n14 + n12;
                        int n42 = n9 + n14 - n + n12;
                        int n43 = n40 + n37 + n16;
                        int n44 = n40 + n37 + n15;
                        d2 = dArray2[n43 - 1];
                        d = dArray2[n43];
                        double d23 = dArray2[n44 - 1];
                        double d24 = dArray2[n44];
                        dArray[n41 - 1] = d2 + d23;
                        dArray[n42 - 1] = d2 - d23;
                        dArray[n41] = d + d24;
                        dArray[n42] = d24 - d;
                    }
                }
            }
        } else {
            for (n17 = 1; n17 < n21; ++n17) {
                n10 = n2 - n17;
                n8 = 2 * n17;
                n16 = n17 * n3 * n;
                n15 = n10 * n3 * n;
                n14 = n8 * n;
                for (n13 = 2; n13 < n; n13 += 2) {
                    int n45 = n - n13;
                    n12 = n5 + n13;
                    int n46 = n5 + n45;
                    n11 = n6 + n13;
                    for (int i = 0; i < n3; ++i) {
                        n9 = i * n18;
                        int n47 = i * n;
                        int n48 = n12 + n14 + n9;
                        int n49 = n46 + n14 - n + n9;
                        int n50 = n11 + n47 + n16;
                        int n51 = n11 + n47 + n15;
                        d2 = dArray2[n50 - 1];
                        d = dArray2[n50];
                        double d25 = dArray2[n51 - 1];
                        double d26 = dArray2[n51];
                        dArray[n48 - 1] = d2 + d25;
                        dArray[n49 - 1] = d2 - d25;
                        dArray[n48] = d + d26;
                        dArray[n49] = d26 - d;
                    }
                }
            }
        }
    }

    void radfg(long l, long l2, long l3, long l4, DoubleLargeArray doubleLargeArray, long l5, DoubleLargeArray doubleLargeArray2, long l6, long l7) {
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19 = l7;
        double d = Math.PI * 2 / (double)l2;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        long l20 = (l2 + 1L) / 2L;
        long l21 = (l - 1L) / 2L;
        if (l != 1L) {
            double d4;
            double d5;
            double d6;
            double d7;
            long l22;
            long l23;
            double d8;
            double d9;
            long l24;
            long l25;
            for (l18 = 0L; l18 < l4; ++l18) {
                doubleLargeArray2.setDouble(l6 + l18, doubleLargeArray.getDouble(l5 + l18));
            }
            for (l18 = 1L; l18 < l2; ++l18) {
                l17 = l18 * l3 * l;
                for (l16 = 0L; l16 < l3; ++l16) {
                    l15 = l16 * l + l17;
                    doubleLargeArray2.setDouble(l6 + l15, doubleLargeArray.getDouble(l5 + l15));
                }
            }
            if (l21 <= l3) {
                l25 = -l;
                for (l18 = 1L; l18 < l2; ++l18) {
                    l24 = (l25 += l) - 1L;
                    l17 = l18 * l3 * l;
                    for (l16 = 2L; l16 < l; l16 += 2L) {
                        l15 = (l24 += 2L) + l19;
                        l14 = l5 + l16;
                        l13 = l6 + l16;
                        d9 = this.wtable_rl.getDouble(l15 - 1L);
                        d8 = this.wtable_rl.getDouble(l15);
                        for (l12 = 0L; l12 < l3; ++l12) {
                            l11 = l12 * l + l17;
                            l23 = l13 + l11;
                            l22 = l14 + l11;
                            double d10 = doubleLargeArray.getDouble(l22 - 1L);
                            double d11 = doubleLargeArray.getDouble(l22);
                            doubleLargeArray2.setDouble(l23 - 1L, d9 * d10 + d8 * d11);
                            doubleLargeArray2.setDouble(l23, d9 * d11 - d8 * d10);
                        }
                    }
                }
            } else {
                l25 = -l;
                for (l18 = 1L; l18 < l2; ++l18) {
                    l25 += l;
                    l17 = l18 * l3 * l;
                    for (l16 = 0L; l16 < l3; ++l16) {
                        l24 = l25 - 1L;
                        l15 = l16 * l + l17;
                        for (l14 = 2L; l14 < l; l14 += 2L) {
                            l13 = (l24 += 2L) + l19;
                            d9 = this.wtable_rl.getDouble(l13 - 1L);
                            d8 = this.wtable_rl.getDouble(l13);
                            l12 = l6 + l14 + l15;
                            l11 = l5 + l14 + l15;
                            double d12 = doubleLargeArray.getDouble(l11 - 1L);
                            double d13 = doubleLargeArray.getDouble(l11);
                            doubleLargeArray2.setDouble(l12 - 1L, d9 * d12 + d8 * d13);
                            doubleLargeArray2.setDouble(l12, d9 * d13 - d8 * d12);
                        }
                    }
                }
            }
            if (l21 >= l3) {
                for (l18 = 1L; l18 < l20; ++l18) {
                    l10 = l2 - l18;
                    l17 = l18 * l3 * l;
                    l16 = l10 * l3 * l;
                    for (l15 = 0L; l15 < l3; ++l15) {
                        l14 = l15 * l + l17;
                        l13 = l15 * l + l16;
                        for (l12 = 2L; l12 < l; l12 += 2L) {
                            l11 = l5 + l12;
                            l23 = l6 + l12;
                            l22 = l11 + l14;
                            long l26 = l11 + l13;
                            long l27 = l23 + l14;
                            l9 = l23 + l13;
                            d7 = doubleLargeArray2.getDouble(l27 - 1L);
                            d6 = doubleLargeArray2.getDouble(l27);
                            d5 = doubleLargeArray2.getDouble(l9 - 1L);
                            d4 = doubleLargeArray2.getDouble(l9);
                            doubleLargeArray.setDouble(l22 - 1L, d7 + d5);
                            doubleLargeArray.setDouble(l22, d6 + d4);
                            doubleLargeArray.setDouble(l26 - 1L, d6 - d4);
                            doubleLargeArray.setDouble(l26, d5 - d7);
                        }
                    }
                }
            } else {
                for (l18 = 1L; l18 < l20; ++l18) {
                    l10 = l2 - l18;
                    l17 = l18 * l3 * l;
                    l16 = l10 * l3 * l;
                    for (l15 = 2L; l15 < l; l15 += 2L) {
                        l14 = l5 + l15;
                        l13 = l6 + l15;
                        for (l12 = 0L; l12 < l3; ++l12) {
                            l11 = l12 * l + l17;
                            l23 = l12 * l + l16;
                            l22 = l14 + l11;
                            long l28 = l14 + l23;
                            long l29 = l13 + l11;
                            l9 = l13 + l23;
                            d7 = doubleLargeArray2.getDouble(l29 - 1L);
                            d6 = doubleLargeArray2.getDouble(l29);
                            d5 = doubleLargeArray2.getDouble(l9 - 1L);
                            d4 = doubleLargeArray2.getDouble(l9);
                            doubleLargeArray.setDouble(l22 - 1L, d7 + d5);
                            doubleLargeArray.setDouble(l22, d6 + d4);
                            doubleLargeArray.setDouble(l28 - 1L, d6 - d4);
                            doubleLargeArray.setDouble(l28, d5 - d7);
                        }
                    }
                }
            }
        } else {
            Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)l6, (DoubleLargeArray)doubleLargeArray, (long)l5, (long)l4);
        }
        for (l18 = 1L; l18 < l20; ++l18) {
            l10 = l2 - l18;
            l17 = l18 * l3 * l;
            l16 = l10 * l3 * l;
            for (l15 = 0L; l15 < l3; ++l15) {
                l14 = l15 * l + l17;
                l13 = l15 * l + l16;
                l12 = l6 + l14;
                l11 = l6 + l13;
                double d14 = doubleLargeArray2.getDouble(l12);
                double d15 = doubleLargeArray2.getDouble(l11);
                doubleLargeArray.setDouble(l5 + l14, d14 + d15);
                doubleLargeArray.setDouble(l5 + l13, d15 - d14);
            }
        }
        double d16 = 1.0;
        double d17 = 0.0;
        l18 = (l2 - 1L) * l4;
        for (l17 = 1L; l17 < l20; ++l17) {
            long l30 = l2 - l17;
            double d18 = d2 * d16 - d3 * d17;
            d17 = d2 * d17 + d3 * d16;
            d16 = d18;
            l16 = l17 * l4;
            l15 = l30 * l4;
            for (l14 = 0L; l14 < l4; ++l14) {
                l13 = l6 + l14;
                l12 = l5 + l14;
                doubleLargeArray2.setDouble(l13 + l16, doubleLargeArray.getDouble(l12) + d16 * doubleLargeArray.getDouble(l12 + l4));
                doubleLargeArray2.setDouble(l13 + l15, d17 * doubleLargeArray.getDouble(l12 + l18));
            }
            double d19 = d16;
            double d20 = d17;
            double d21 = d16;
            double d22 = d17;
            for (l14 = 2L; l14 < l20; ++l14) {
                l10 = l2 - l14;
                double d23 = d19 * d21 - d20 * d22;
                d22 = d19 * d22 + d20 * d21;
                d21 = d23;
                l13 = l14 * l4;
                l12 = l10 * l4;
                for (l11 = 0L; l11 < l4; ++l11) {
                    long l31 = l6 + l11;
                    long l32 = l5 + l11;
                    doubleLargeArray2.setDouble(l31 + l16, doubleLargeArray2.getDouble(l31 + l16) + d21 * doubleLargeArray.getDouble(l32 + l13));
                    doubleLargeArray2.setDouble(l31 + l15, doubleLargeArray2.getDouble(l31 + l15) + d22 * doubleLargeArray.getDouble(l32 + l12));
                }
            }
        }
        for (l17 = 1L; l17 < l20; ++l17) {
            l16 = l17 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                doubleLargeArray2.setDouble(l6 + l15, doubleLargeArray2.getDouble(l6 + l15) + doubleLargeArray.getDouble(l5 + l15 + l16));
            }
        }
        if (l >= l3) {
            for (l17 = 0L; l17 < l3; ++l17) {
                l16 = l17 * l;
                l15 = l16 * l2;
                for (l14 = 0L; l14 < l; ++l14) {
                    doubleLargeArray.setDouble(l5 + l14 + l15, doubleLargeArray2.getDouble(l6 + l14 + l16));
                }
            }
        } else {
            for (l17 = 0L; l17 < l; ++l17) {
                for (l16 = 0L; l16 < l3; ++l16) {
                    l15 = l16 * l;
                    doubleLargeArray.setDouble(l5 + l17 + l15 * l2, doubleLargeArray2.getDouble(l6 + l17 + l15));
                }
            }
        }
        l17 = l2 * l;
        for (l16 = 1L; l16 < l20; ++l16) {
            l10 = l2 - l16;
            l8 = 2L * l16;
            l15 = l16 * l3 * l;
            l14 = l10 * l3 * l;
            l13 = l8 * l;
            for (l12 = 0L; l12 < l3; ++l12) {
                l11 = l12 * l;
                long l33 = l11 + l15;
                long l34 = l11 + l14;
                long l35 = l12 * l17;
                doubleLargeArray.setDouble(l5 + l - 1L + l13 - l + l35, doubleLargeArray2.getDouble(l6 + l33));
                doubleLargeArray.setDouble(l5 + l13 + l35, doubleLargeArray2.getDouble(l6 + l34));
            }
        }
        if (l == 1L) {
            return;
        }
        if (l21 >= l3) {
            for (l16 = 1L; l16 < l20; ++l16) {
                l10 = l2 - l16;
                l8 = 2L * l16;
                l15 = l16 * l3 * l;
                l14 = l10 * l3 * l;
                l13 = l8 * l;
                for (l12 = 0L; l12 < l3; ++l12) {
                    l11 = l12 * l17;
                    long l36 = l12 * l;
                    for (long i = 2L; i < l; i += 2L) {
                        long l37 = l - i;
                        long l38 = l5 + i;
                        long l39 = l5 + l37;
                        l9 = l6 + i;
                        long l40 = l38 + l13 + l11;
                        long l41 = l39 + l13 - l + l11;
                        long l42 = l9 + l36 + l15;
                        long l43 = l9 + l36 + l14;
                        double d24 = doubleLargeArray2.getDouble(l42 - 1L);
                        double d25 = doubleLargeArray2.getDouble(l42);
                        double d26 = doubleLargeArray2.getDouble(l43 - 1L);
                        double d27 = doubleLargeArray2.getDouble(l43);
                        doubleLargeArray.setDouble(l40 - 1L, d24 + d26);
                        doubleLargeArray.setDouble(l41 - 1L, d24 - d26);
                        doubleLargeArray.setDouble(l40, d25 + d27);
                        doubleLargeArray.setDouble(l41, d27 - d25);
                    }
                }
            }
        } else {
            for (l16 = 1L; l16 < l20; ++l16) {
                l10 = l2 - l16;
                l8 = 2L * l16;
                l15 = l16 * l3 * l;
                l14 = l10 * l3 * l;
                l13 = l8 * l;
                for (l12 = 2L; l12 < l; l12 += 2L) {
                    long l44 = l - l12;
                    l11 = l5 + l12;
                    long l45 = l5 + l44;
                    long l46 = l6 + l12;
                    for (long i = 0L; i < l3; ++i) {
                        long l47 = i * l17;
                        l9 = i * l;
                        long l48 = l11 + l13 + l47;
                        long l49 = l45 + l13 - l + l47;
                        long l50 = l46 + l9 + l15;
                        long l51 = l46 + l9 + l14;
                        double d28 = doubleLargeArray2.getDouble(l50 - 1L);
                        double d29 = doubleLargeArray2.getDouble(l50);
                        double d30 = doubleLargeArray2.getDouble(l51 - 1L);
                        double d31 = doubleLargeArray2.getDouble(l51);
                        doubleLargeArray.setDouble(l48 - 1L, d28 + d30);
                        doubleLargeArray.setDouble(l49 - 1L, d28 - d30);
                        doubleLargeArray.setDouble(l48, d29 + d31);
                        doubleLargeArray.setDouble(l49, d31 - d29);
                    }
                }
            }
        }
    }

    void radbg(int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7) {
        double d;
        double d2;
        int n8;
        int n9;
        double d3;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = n7;
        double d4 = Math.PI * 2 / (double)n2;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        int n22 = (n - 1) / 2;
        int n23 = (n2 + 1) / 2;
        int n24 = n2 * n;
        if (n >= n3) {
            for (n20 = 0; n20 < n3; ++n20) {
                n19 = n20 * n;
                n18 = n20 * n24;
                for (n17 = 0; n17 < n; ++n17) {
                    dArray2[n6 + n17 + n19] = dArray[n5 + n17 + n18];
                }
            }
        } else {
            for (n20 = 0; n20 < n; ++n20) {
                n19 = n6 + n20;
                n18 = n5 + n20;
                for (n17 = 0; n17 < n3; ++n17) {
                    dArray2[n19 + n17 * n] = dArray[n18 + n17 * n24];
                }
            }
        }
        n20 = n5 + n - 1;
        for (n19 = 1; n19 < n23; ++n19) {
            n16 = n2 - n19;
            int n25 = 2 * n19;
            n18 = n19 * n3 * n;
            n17 = n16 * n3 * n;
            n15 = n25 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n13 * n2;
                n11 = n20 + n15 + n12 - n;
                n10 = n5 + n15 + n12;
                double d7 = dArray[n11];
                d3 = dArray[n10];
                dArray2[n6 + n13 + n18] = d7 + d7;
                dArray2[n6 + n13 + n17] = d3 + d3;
            }
        }
        if (n != 1) {
            double d8;
            double d9;
            double d10;
            double d11;
            int n26;
            int n27;
            int n28;
            int n29;
            if (n22 >= n3) {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 0; n14 < n3; ++n14) {
                        n13 = n14 * n + n18;
                        n12 = n14 * n + n17;
                        n11 = n14 * n2 * n + n15;
                        for (n10 = 2; n10 < n; n10 += 2) {
                            n29 = n - n10;
                            int n30 = n6 + n10;
                            n9 = n5 + n29;
                            int n31 = n5 + n10;
                            n8 = n30 + n13;
                            n28 = n30 + n12;
                            n27 = n31 + n11;
                            n26 = n9 + n11 - n;
                            d11 = dArray[n27 - 1];
                            d10 = dArray[n27];
                            d9 = dArray[n26 - 1];
                            d8 = dArray[n26];
                            dArray2[n8 - 1] = d11 + d9;
                            dArray2[n28 - 1] = d11 - d9;
                            dArray2[n8] = d10 - d8;
                            dArray2[n28] = d10 + d8;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 2; n14 < n; n14 += 2) {
                        n29 = n - n14;
                        n13 = n6 + n14;
                        n12 = n5 + n29;
                        n11 = n5 + n14;
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n32 = n10 * n + n18;
                            n9 = n10 * n + n17;
                            int n33 = n10 * n2 * n + n15;
                            n8 = n13 + n32;
                            n28 = n13 + n9;
                            n27 = n11 + n33;
                            n26 = n12 + n33 - n;
                            d11 = dArray[n27 - 1];
                            d10 = dArray[n27];
                            d9 = dArray[n26 - 1];
                            d8 = dArray[n26];
                            dArray2[n8 - 1] = d11 + d9;
                            dArray2[n28 - 1] = d11 - d9;
                            dArray2[n8] = d10 - d8;
                            dArray2[n28] = d10 + d8;
                        }
                    }
                }
            }
        }
        double d12 = 1.0;
        double d13 = 0.0;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n23; ++n18) {
            int n34 = n2 - n18;
            double d14 = d5 * d12 - d6 * d13;
            d13 = d5 * d13 + d6 * d12;
            d12 = d14;
            n17 = n18 * n4;
            n15 = n34 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                dArray[n13 + n17] = dArray2[n12] + d12 * dArray2[n12 + n4];
                dArray[n13 + n15] = d13 * dArray2[n12 + n19];
            }
            double d15 = d12;
            double d16 = d13;
            double d17 = d12;
            double d18 = d13;
            for (n14 = 2; n14 < n23; ++n14) {
                n16 = n2 - n14;
                double d19 = d15 * d17 - d16 * d18;
                d18 = d15 * d18 + d16 * d17;
                d17 = d19;
                n13 = n14 * n4;
                n12 = n16 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    n10 = n5 + n11;
                    int n35 = n6 + n11;
                    int n36 = n10 + n17;
                    dArray[n36] = dArray[n36] + d17 * dArray2[n35 + n13];
                    int n37 = n10 + n15;
                    dArray[n37] = dArray[n37] + d18 * dArray2[n35 + n12];
                }
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n17 = n18 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n38 = n14 = n6 + n15;
                dArray2[n38] = dArray2[n38] + dArray2[n14 + n17];
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n16 = n2 - n18;
            n17 = n18 * n3 * n;
            n15 = n16 * n3 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13;
                n11 = n5 + n13 + n17;
                n10 = n5 + n13 + n15;
                double d20 = dArray[n11];
                d3 = dArray[n10];
                dArray2[n12 + n17] = d20 - d3;
                dArray2[n12 + n15] = d20 + d3;
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    n13 = n14 * n;
                    for (n12 = 2; n12 < n; n12 += 2) {
                        n11 = n6 + n12;
                        n10 = n5 + n12;
                        int n39 = n11 + n13 + n17;
                        n9 = n11 + n13 + n15;
                        int n40 = n10 + n13 + n17;
                        n8 = n10 + n13 + n15;
                        double d21 = dArray[n40 - 1];
                        double d22 = dArray[n40];
                        d2 = dArray[n8 - 1];
                        d = dArray[n8];
                        dArray2[n39 - 1] = d21 - d;
                        dArray2[n9 - 1] = d21 + d;
                        dArray2[n39] = d22 + d2;
                        dArray2[n9] = d22 - d2;
                    }
                }
            }
        } else {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 2; n14 < n; n14 += 2) {
                    n13 = n6 + n14;
                    n12 = n5 + n14;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n;
                        int n41 = n13 + n10 + n17;
                        n9 = n13 + n10 + n15;
                        int n42 = n12 + n10 + n17;
                        n8 = n12 + n10 + n15;
                        double d23 = dArray[n42 - 1];
                        double d24 = dArray[n42];
                        d2 = dArray[n8 - 1];
                        d = dArray[n8];
                        dArray2[n41 - 1] = d23 - d;
                        dArray2[n9 - 1] = d23 + d;
                        dArray2[n41] = d24 + d2;
                        dArray2[n9] = d24 - d2;
                    }
                }
            }
        }
        System.arraycopy(dArray2, n6, dArray, n5, n4);
        for (n18 = 1; n18 < n2; ++n18) {
            n17 = n18 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                dArray[n5 + n14] = dArray2[n6 + n14];
            }
        }
        if (n22 <= n3) {
            int n43 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                int n44 = (n43 += n) - 1;
                n17 = n18 * n3 * n;
                for (n15 = 2; n15 < n; n15 += 2) {
                    n14 = (n44 += 2) + n21;
                    double d25 = this.wtable_r[n14 - 1];
                    double d26 = this.wtable_r[n14];
                    n13 = n5 + n15;
                    n12 = n6 + n15;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n + n17;
                        int n45 = n13 + n10;
                        n9 = n12 + n10;
                        double d27 = dArray2[n9 - 1];
                        double d28 = dArray2[n9];
                        dArray[n45 - 1] = d25 * d27 - d26 * d28;
                        dArray[n45] = d25 * d28 + d26 * d27;
                    }
                }
            }
        } else {
            int n46 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                n46 += n;
                n17 = n18 * n3 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    int n47 = n46 - 1;
                    n14 = n15 * n + n17;
                    for (n13 = 2; n13 < n; n13 += 2) {
                        n12 = (n47 += 2) + n21;
                        double d29 = this.wtable_r[n12 - 1];
                        double d30 = this.wtable_r[n12];
                        n11 = n5 + n13;
                        n10 = n6 + n13;
                        int n48 = n11 + n14;
                        n9 = n10 + n14;
                        double d31 = dArray2[n9 - 1];
                        double d32 = dArray2[n9];
                        dArray[n48 - 1] = d29 * d31 - d30 * d32;
                        dArray[n48] = d29 * d32 + d30 * d31;
                    }
                }
            }
        }
    }

    void radbg(long l, long l2, long l3, long l4, DoubleLargeArray doubleLargeArray, long l5, DoubleLargeArray doubleLargeArray2, long l6, long l7) {
        double d;
        long l8;
        long l9;
        double d2;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        long l20;
        long l21 = l7;
        double d3 = Math.PI * 2 / (double)l2;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        long l22 = (l - 1L) / 2L;
        long l23 = (l2 + 1L) / 2L;
        long l24 = l2 * l;
        if (l >= l3) {
            for (l20 = 0L; l20 < l3; ++l20) {
                l19 = l20 * l;
                l18 = l20 * l24;
                for (l17 = 0L; l17 < l; ++l17) {
                    doubleLargeArray2.setDouble(l6 + l17 + l19, doubleLargeArray.getDouble(l5 + l17 + l18));
                }
            }
        } else {
            for (l20 = 0L; l20 < l; ++l20) {
                l19 = l6 + l20;
                l18 = l5 + l20;
                for (l17 = 0L; l17 < l3; ++l17) {
                    doubleLargeArray2.setDouble(l19 + l17 * l, doubleLargeArray.getDouble(l18 + l17 * l24));
                }
            }
        }
        l20 = l5 + l - 1L;
        for (l19 = 1L; l19 < l23; ++l19) {
            l16 = l2 - l19;
            long l25 = 2L * l19;
            l18 = l19 * l3 * l;
            l17 = l16 * l3 * l;
            l15 = l25 * l;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                l12 = l13 * l2;
                l11 = l20 + l15 + l12 - l;
                l10 = l5 + l15 + l12;
                double d6 = doubleLargeArray.getDouble(l11);
                d2 = doubleLargeArray.getDouble(l10);
                doubleLargeArray2.setDouble(l6 + l13 + l18, d6 + d6);
                doubleLargeArray2.setDouble(l6 + l13 + l17, d2 + d2);
            }
        }
        if (l != 1L) {
            double d7;
            double d8;
            double d9;
            long l26;
            long l27;
            long l28;
            long l29;
            if (l22 >= l3) {
                for (l19 = 1L; l19 < l23; ++l19) {
                    l16 = l2 - l19;
                    l18 = l19 * l3 * l;
                    l17 = l16 * l3 * l;
                    l15 = 2L * l19 * l;
                    for (l14 = 0L; l14 < l3; ++l14) {
                        l13 = l14 * l + l18;
                        l12 = l14 * l + l17;
                        l11 = l14 * l2 * l + l15;
                        for (l10 = 2L; l10 < l; l10 += 2L) {
                            l29 = l - l10;
                            long l30 = l6 + l10;
                            long l31 = l5 + l29;
                            l9 = l5 + l10;
                            l8 = l30 + l13;
                            l28 = l30 + l12;
                            l27 = l9 + l11;
                            l26 = l31 + l11 - l;
                            d = doubleLargeArray.getDouble(l27 - 1L);
                            d9 = doubleLargeArray.getDouble(l27);
                            d8 = doubleLargeArray.getDouble(l26 - 1L);
                            d7 = doubleLargeArray.getDouble(l26);
                            doubleLargeArray2.setDouble(l8 - 1L, d + d8);
                            doubleLargeArray2.setDouble(l28 - 1L, d - d8);
                            doubleLargeArray2.setDouble(l8, d9 - d7);
                            doubleLargeArray2.setDouble(l28, d9 + d7);
                        }
                    }
                }
            } else {
                for (l19 = 1L; l19 < l23; ++l19) {
                    l16 = l2 - l19;
                    l18 = l19 * l3 * l;
                    l17 = l16 * l3 * l;
                    l15 = 2L * l19 * l;
                    for (l14 = 2L; l14 < l; l14 += 2L) {
                        l29 = l - l14;
                        l13 = l6 + l14;
                        l12 = l5 + l29;
                        l11 = l5 + l14;
                        for (l10 = 0L; l10 < l3; ++l10) {
                            long l32 = l10 * l + l18;
                            long l33 = l10 * l + l17;
                            l9 = l10 * l2 * l + l15;
                            l8 = l13 + l32;
                            l28 = l13 + l33;
                            l27 = l11 + l9;
                            l26 = l12 + l9 - l;
                            d = doubleLargeArray.getDouble(l27 - 1L);
                            d9 = doubleLargeArray.getDouble(l27);
                            d8 = doubleLargeArray.getDouble(l26 - 1L);
                            d7 = doubleLargeArray.getDouble(l26);
                            doubleLargeArray2.setDouble(l8 - 1L, d + d8);
                            doubleLargeArray2.setDouble(l28 - 1L, d - d8);
                            doubleLargeArray2.setDouble(l8, d9 - d7);
                            doubleLargeArray2.setDouble(l28, d9 + d7);
                        }
                    }
                }
            }
        }
        double d10 = 1.0;
        double d11 = 0.0;
        l19 = (l2 - 1L) * l4;
        for (l18 = 1L; l18 < l23; ++l18) {
            long l34 = l2 - l18;
            double d12 = d4 * d10 - d5 * d11;
            d11 = d4 * d11 + d5 * d10;
            d10 = d12;
            l17 = l18 * l4;
            l15 = l34 * l4;
            for (l14 = 0L; l14 < l4; ++l14) {
                l13 = l5 + l14;
                l12 = l6 + l14;
                doubleLargeArray.setDouble(l13 + l17, doubleLargeArray2.getDouble(l12) + d10 * doubleLargeArray2.getDouble(l12 + l4));
                doubleLargeArray.setDouble(l13 + l15, d11 * doubleLargeArray2.getDouble(l12 + l19));
            }
            double d13 = d10;
            double d14 = d11;
            double d15 = d10;
            double d16 = d11;
            for (l14 = 2L; l14 < l23; ++l14) {
                l16 = l2 - l14;
                double d17 = d13 * d15 - d14 * d16;
                d16 = d13 * d16 + d14 * d15;
                d15 = d17;
                l13 = l14 * l4;
                l12 = l16 * l4;
                for (l11 = 0L; l11 < l4; ++l11) {
                    l10 = l5 + l11;
                    long l35 = l6 + l11;
                    doubleLargeArray.setDouble(l10 + l17, doubleLargeArray.getDouble(l10 + l17) + d15 * doubleLargeArray2.getDouble(l35 + l13));
                    doubleLargeArray.setDouble(l10 + l15, doubleLargeArray.getDouble(l10 + l15) + d16 * doubleLargeArray2.getDouble(l35 + l12));
                }
            }
        }
        for (l18 = 1L; l18 < l23; ++l18) {
            l17 = l18 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                l14 = l6 + l15;
                doubleLargeArray2.setDouble(l14, doubleLargeArray2.getDouble(l14) + doubleLargeArray2.getDouble(l14 + l17));
            }
        }
        for (l18 = 1L; l18 < l23; ++l18) {
            l16 = l2 - l18;
            l17 = l18 * l3 * l;
            l15 = l16 * l3 * l;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                l12 = l6 + l13;
                l11 = l5 + l13 + l17;
                l10 = l5 + l13 + l15;
                double d18 = doubleLargeArray.getDouble(l11);
                d2 = doubleLargeArray.getDouble(l10);
                doubleLargeArray2.setDouble(l12 + l17, d18 - d2);
                doubleLargeArray2.setDouble(l12 + l15, d18 + d2);
            }
        }
        if (l == 1L) {
            return;
        }
        if (l22 >= l3) {
            for (l18 = 1L; l18 < l23; ++l18) {
                l16 = l2 - l18;
                l17 = l18 * l3 * l;
                l15 = l16 * l3 * l;
                for (l14 = 0L; l14 < l3; ++l14) {
                    l13 = l14 * l;
                    for (l12 = 2L; l12 < l; l12 += 2L) {
                        l11 = l6 + l12;
                        l10 = l5 + l12;
                        long l36 = l11 + l13 + l17;
                        long l37 = l11 + l13 + l15;
                        l9 = l10 + l13 + l17;
                        l8 = l10 + l13 + l15;
                        double d19 = doubleLargeArray.getDouble(l9 - 1L);
                        double d20 = doubleLargeArray.getDouble(l9);
                        double d21 = doubleLargeArray.getDouble(l8 - 1L);
                        d = doubleLargeArray.getDouble(l8);
                        doubleLargeArray2.setDouble(l36 - 1L, d19 - d);
                        doubleLargeArray2.setDouble(l37 - 1L, d19 + d);
                        doubleLargeArray2.setDouble(l36, d20 + d21);
                        doubleLargeArray2.setDouble(l37, d20 - d21);
                    }
                }
            }
        } else {
            for (l18 = 1L; l18 < l23; ++l18) {
                l16 = l2 - l18;
                l17 = l18 * l3 * l;
                l15 = l16 * l3 * l;
                for (l14 = 2L; l14 < l; l14 += 2L) {
                    l13 = l6 + l14;
                    l12 = l5 + l14;
                    for (l11 = 0L; l11 < l3; ++l11) {
                        l10 = l11 * l;
                        long l38 = l13 + l10 + l17;
                        long l39 = l13 + l10 + l15;
                        l9 = l12 + l10 + l17;
                        l8 = l12 + l10 + l15;
                        double d22 = doubleLargeArray.getDouble(l9 - 1L);
                        double d23 = doubleLargeArray.getDouble(l9);
                        double d24 = doubleLargeArray.getDouble(l8 - 1L);
                        d = doubleLargeArray.getDouble(l8);
                        doubleLargeArray2.setDouble(l38 - 1L, d22 - d);
                        doubleLargeArray2.setDouble(l39 - 1L, d22 + d);
                        doubleLargeArray2.setDouble(l38, d23 + d24);
                        doubleLargeArray2.setDouble(l39, d23 - d24);
                    }
                }
            }
        }
        Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)l6, (DoubleLargeArray)doubleLargeArray, (long)l5, (long)l4);
        for (l18 = 1L; l18 < l2; ++l18) {
            l17 = l18 * l3 * l;
            for (l15 = 0L; l15 < l3; ++l15) {
                l14 = l15 * l + l17;
                doubleLargeArray.setDouble(l5 + l14, doubleLargeArray2.getDouble(l6 + l14));
            }
        }
        if (l22 <= l3) {
            long l40 = -l;
            for (l18 = 1L; l18 < l2; ++l18) {
                long l41 = (l40 += l) - 1L;
                l17 = l18 * l3 * l;
                for (l15 = 2L; l15 < l; l15 += 2L) {
                    l14 = (l41 += 2L) + l21;
                    double d25 = this.wtable_rl.getDouble(l14 - 1L);
                    double d26 = this.wtable_rl.getDouble(l14);
                    l13 = l5 + l15;
                    l12 = l6 + l15;
                    for (l11 = 0L; l11 < l3; ++l11) {
                        l10 = l11 * l + l17;
                        long l42 = l13 + l10;
                        long l43 = l12 + l10;
                        double d27 = doubleLargeArray2.getDouble(l43 - 1L);
                        double d28 = doubleLargeArray2.getDouble(l43);
                        doubleLargeArray.setDouble(l42 - 1L, d25 * d27 - d26 * d28);
                        doubleLargeArray.setDouble(l42, d25 * d28 + d26 * d27);
                    }
                }
            }
        } else {
            long l44 = -l;
            for (l18 = 1L; l18 < l2; ++l18) {
                l44 += l;
                l17 = l18 * l3 * l;
                for (l15 = 0L; l15 < l3; ++l15) {
                    long l45 = l44 - 1L;
                    l14 = l15 * l + l17;
                    for (l13 = 2L; l13 < l; l13 += 2L) {
                        l12 = (l45 += 2L) + l21;
                        double d29 = this.wtable_rl.getDouble(l12 - 1L);
                        double d30 = this.wtable_rl.getDouble(l12);
                        l11 = l5 + l13;
                        l10 = l6 + l13;
                        long l46 = l11 + l14;
                        long l47 = l10 + l14;
                        double d31 = doubleLargeArray2.getDouble(l47 - 1L);
                        double d32 = doubleLargeArray2.getDouble(l47);
                        doubleLargeArray.setDouble(l46 - 1L, d29 * d31 - d30 * d32);
                        doubleLargeArray.setDouble(l46, d29 * d32 + d30 * d31);
                    }
                }
            }
        }
    }

    void cfftf(double[] dArray, int n, int n2) {
        int[] nArray = new int[1];
        int n3 = 2 * this.n;
        double[] dArray2 = new double[n3];
        int n4 = n3;
        int n5 = 4 * this.n;
        nArray[0] = 0;
        int n6 = (int)this.wtable[1 + n5];
        int n7 = 0;
        int n8 = 1;
        int n9 = n4;
        for (int i = 2; i <= n6 + 1; ++i) {
            int n10 = (int)this.wtable[i + n5];
            int n11 = n10 * n8;
            int n12 = this.n / n11;
            int n13 = n12 + n12;
            int n14 = n13 * n8;
            switch (n10) {
                case 4: {
                    if (n7 == 0) {
                        this.passf4(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf4(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 2: {
                    if (n7 == 0) {
                        this.passf2(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf2(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 3: {
                    if (n7 == 0) {
                        this.passf3(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf3(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 5: {
                    if (n7 == 0) {
                        this.passf5(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf5(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                default: {
                    if (n7 == 0) {
                        this.passfg(nArray, n13, n10, n8, n14, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passfg(nArray, n13, n10, n8, n14, dArray2, 0, dArray, n, n9, n2);
                    }
                    if (nArray[0] == 0) break;
                    n7 = 1 - n7;
                }
            }
            n8 = n11;
            n9 += (n10 - 1) * n13;
        }
        if (n7 == 0) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, n3);
    }

    void cfftf(DoubleLargeArray doubleLargeArray, long l, int n) {
        int[] nArray = new int[1];
        long l2 = 2L * this.nl;
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2, false);
        long l3 = l2;
        long l4 = 4L * this.nl;
        nArray[0] = 0;
        long l5 = (long)this.wtablel.getDouble(1L + l4);
        long l6 = 0L;
        long l7 = 1L;
        long l8 = l3;
        for (long i = 2L; i <= l5 + 1L; ++i) {
            int n2 = (int)this.wtablel.getDouble(i + l4);
            long l9 = (long)n2 * l7;
            long l10 = this.nl / l9;
            long l11 = l10 + l10;
            long l12 = l11 * l7;
            switch (n2) {
                case 4: {
                    if (l6 == 0L) {
                        this.passf4(l11, l7, doubleLargeArray, l, doubleLargeArray2, 0L, l8, n);
                    } else {
                        this.passf4(l11, l7, doubleLargeArray2, 0L, doubleLargeArray, l, l8, n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                case 2: {
                    if (l6 == 0L) {
                        this.passf2(l11, l7, doubleLargeArray, l, doubleLargeArray2, 0L, l8, (long)n);
                    } else {
                        this.passf2(l11, l7, doubleLargeArray2, 0L, doubleLargeArray, l, l8, (long)n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                case 3: {
                    if (l6 == 0L) {
                        this.passf3(l11, l7, doubleLargeArray, l, doubleLargeArray2, 0L, l8, (long)n);
                    } else {
                        this.passf3(l11, l7, doubleLargeArray2, 0L, doubleLargeArray, l, l8, (long)n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                case 5: {
                    if (l6 == 0L) {
                        this.passf5(l11, l7, doubleLargeArray, l, doubleLargeArray2, 0L, l8, (long)n);
                    } else {
                        this.passf5(l11, l7, doubleLargeArray2, 0L, doubleLargeArray, l, l8, (long)n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                default: {
                    if (l6 == 0L) {
                        this.passfg(nArray, l11, (long)n2, l7, l12, doubleLargeArray, l, doubleLargeArray2, 0L, l8, (long)n);
                    } else {
                        this.passfg(nArray, l11, (long)n2, l7, l12, doubleLargeArray2, 0L, doubleLargeArray, l, l8, (long)n);
                    }
                    if (nArray[0] == 0) break;
                    l6 = 1L - l6;
                }
            }
            l7 = l9;
            l8 += (long)(n2 - 1) * l11;
        }
        if (l6 == 0L) {
            return;
        }
        Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)l, (long)l2);
    }

    void passf2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n * n2;
        if (n <= 2) {
            for (int i = 0; i < n2; ++i) {
                int n9 = i * n;
                int n10 = n3 + 2 * n9;
                int n11 = n10 + n;
                double d = dArray[n10];
                double d2 = dArray[n10 + 1];
                double d3 = dArray[n11];
                double d4 = dArray[n11 + 1];
                int n12 = n4 + n9;
                int n13 = n12 + n8;
                dArray2[n12] = d + d3;
                dArray2[n12 + 1] = d2 + d4;
                dArray2[n13] = d - d3;
                dArray2[n13 + 1] = d2 - d4;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n - 1; j += 2) {
                    int n14 = i * n;
                    int n15 = n3 + j + 2 * n14;
                    int n16 = n15 + n;
                    double d = dArray[n15];
                    double d5 = dArray[n15 + 1];
                    double d6 = dArray[n16];
                    double d7 = dArray[n16 + 1];
                    int n17 = j + n7;
                    double d8 = this.wtable[n17];
                    double d9 = (double)n6 * this.wtable[n17 + 1];
                    double d10 = d - d6;
                    double d11 = d5 - d7;
                    int n18 = n4 + j + n14;
                    int n19 = n18 + n8;
                    dArray2[n18] = d + d6;
                    dArray2[n18 + 1] = d5 + d7;
                    dArray2[n19] = d8 * d10 - d9 * d11;
                    dArray2[n19 + 1] = d8 * d11 + d9 * d10;
                }
            }
        }
    }

    void passf2(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5, long l6) {
        long l7 = l5;
        long l8 = l * l2;
        if (l <= 2L) {
            for (long i = 0L; i < l2; ++i) {
                long l9 = i * l;
                long l10 = l3 + 2L * l9;
                long l11 = l10 + l;
                double d = doubleLargeArray.getDouble(l10);
                double d2 = doubleLargeArray.getDouble(l10 + 1L);
                double d3 = doubleLargeArray.getDouble(l11);
                double d4 = doubleLargeArray.getDouble(l11 + 1L);
                long l12 = l4 + l9;
                long l13 = l12 + l8;
                doubleLargeArray2.setDouble(l12, d + d3);
                doubleLargeArray2.setDouble(l12 + 1L, d2 + d4);
                doubleLargeArray2.setDouble(l13, d - d3);
                doubleLargeArray2.setDouble(l13 + 1L, d2 - d4);
            }
        } else {
            for (long i = 0L; i < l2; ++i) {
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l14 = i * l;
                    long l15 = l3 + j + 2L * l14;
                    long l16 = l15 + l;
                    double d = doubleLargeArray.getDouble(l15);
                    double d5 = doubleLargeArray.getDouble(l15 + 1L);
                    double d6 = doubleLargeArray.getDouble(l16);
                    double d7 = doubleLargeArray.getDouble(l16 + 1L);
                    long l17 = j + l7;
                    double d8 = this.wtablel.getDouble(l17);
                    double d9 = (double)l6 * this.wtablel.getDouble(l17 + 1L);
                    double d10 = d - d6;
                    double d11 = d5 - d7;
                    long l18 = l4 + j + l14;
                    long l19 = l18 + l8;
                    doubleLargeArray2.setDouble(l18, d + d6);
                    doubleLargeArray2.setDouble(l18 + 1L, d5 + d7);
                    doubleLargeArray2.setDouble(l19, d8 * d10 - d9 * d11);
                    doubleLargeArray2.setDouble(l19 + 1L, d8 * d11 + d9 * d10);
                }
            }
        }
    }

    void passf3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n10 = n3 + (3 * i - 2) * n;
                int n11 = n10 + n;
                int n12 = n10 - n;
                double d = dArray[n10];
                double d2 = dArray[n10 + 1];
                double d3 = dArray[n11];
                double d4 = dArray[n11 + 1];
                double d5 = dArray[n12];
                double d6 = dArray[n12 + 1];
                double d7 = d + d3;
                double d8 = d5 + -0.5 * d7;
                double d9 = d2 + d4;
                double d10 = d6 + -0.5 * d9;
                double d11 = (double)n6 * 0.8660254037844387 * (d - d3);
                double d12 = (double)n6 * 0.8660254037844387 * (d2 - d4);
                int n13 = n4 + (i - 1) * n;
                int n14 = n13 + n9;
                int n15 = n14 + n9;
                dArray2[n13] = dArray[n12] + d7;
                dArray2[n13 + 1] = d6 + d9;
                dArray2[n14] = d8 - d12;
                dArray2[n14 + 1] = d10 + d11;
                dArray2[n15] = d8 + d12;
                dArray2[n15 + 1] = d10 - d11;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n16 = n3 + (3 * i - 2) * n;
                int n17 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n18 = j + n16;
                    int n19 = n18 + n;
                    int n20 = n18 - n;
                    double d = dArray[n18];
                    double d13 = dArray[n18 + 1];
                    double d14 = dArray[n19];
                    double d15 = dArray[n19 + 1];
                    double d16 = dArray[n20];
                    double d17 = dArray[n20 + 1];
                    double d18 = d + d14;
                    double d19 = d16 + -0.5 * d18;
                    double d20 = d13 + d15;
                    double d21 = d17 + -0.5 * d20;
                    double d22 = (double)n6 * 0.8660254037844387 * (d - d14);
                    double d23 = (double)n6 * 0.8660254037844387 * (d13 - d15);
                    double d24 = d19 - d23;
                    double d25 = d19 + d23;
                    double d26 = d21 + d22;
                    double d27 = d21 - d22;
                    int n21 = j + n7;
                    int n22 = j + n8;
                    double d28 = this.wtable[n21];
                    double d29 = (double)n6 * this.wtable[n21 + 1];
                    double d30 = this.wtable[n22];
                    double d31 = (double)n6 * this.wtable[n22 + 1];
                    int n23 = j + n17;
                    int n24 = n23 + n9;
                    int n25 = n24 + n9;
                    dArray2[n23] = d16 + d18;
                    dArray2[n23 + 1] = d17 + d20;
                    dArray2[n24] = d28 * d24 - d29 * d26;
                    dArray2[n24 + 1] = d28 * d26 + d29 * d24;
                    dArray2[n25] = d30 * d25 - d31 * d27;
                    dArray2[n25 + 1] = d30 * d27 + d31 * d25;
                }
            }
        }
    }

    void passf3(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5, long l6) {
        long l7 = l5;
        long l8 = l7 + l;
        long l9 = l2 * l;
        if (l == 2L) {
            for (long i = 1L; i <= l2; ++i) {
                long l10 = l3 + (3L * i - 2L) * l;
                long l11 = l10 + l;
                long l12 = l10 - l;
                double d = doubleLargeArray.getDouble(l10);
                double d2 = doubleLargeArray.getDouble(l10 + 1L);
                double d3 = doubleLargeArray.getDouble(l11);
                double d4 = doubleLargeArray.getDouble(l11 + 1L);
                double d5 = doubleLargeArray.getDouble(l12);
                double d6 = doubleLargeArray.getDouble(l12 + 1L);
                double d7 = d + d3;
                double d8 = d5 + -0.5 * d7;
                double d9 = d2 + d4;
                double d10 = d6 + -0.5 * d9;
                double d11 = (double)l6 * 0.8660254037844387 * (d - d3);
                double d12 = (double)l6 * 0.8660254037844387 * (d2 - d4);
                long l13 = l4 + (i - 1L) * l;
                long l14 = l13 + l9;
                long l15 = l14 + l9;
                doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l12) + d7);
                doubleLargeArray2.setDouble(l13 + 1L, d6 + d9);
                doubleLargeArray2.setDouble(l14, d8 - d12);
                doubleLargeArray2.setDouble(l14 + 1L, d10 + d11);
                doubleLargeArray2.setDouble(l15, d8 + d12);
                doubleLargeArray2.setDouble(l15 + 1L, d10 - d11);
            }
        } else {
            for (long i = 1L; i <= l2; ++i) {
                long l16 = l3 + (3L * i - 2L) * l;
                long l17 = l4 + (i - 1L) * l;
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l18 = j + l16;
                    long l19 = l18 + l;
                    long l20 = l18 - l;
                    double d = doubleLargeArray.getDouble(l18);
                    double d13 = doubleLargeArray.getDouble(l18 + 1L);
                    double d14 = doubleLargeArray.getDouble(l19);
                    double d15 = doubleLargeArray.getDouble(l19 + 1L);
                    double d16 = doubleLargeArray.getDouble(l20);
                    double d17 = doubleLargeArray.getDouble(l20 + 1L);
                    double d18 = d + d14;
                    double d19 = d16 + -0.5 * d18;
                    double d20 = d13 + d15;
                    double d21 = d17 + -0.5 * d20;
                    double d22 = (double)l6 * 0.8660254037844387 * (d - d14);
                    double d23 = (double)l6 * 0.8660254037844387 * (d13 - d15);
                    double d24 = d19 - d23;
                    double d25 = d19 + d23;
                    double d26 = d21 + d22;
                    double d27 = d21 - d22;
                    long l21 = j + l7;
                    long l22 = j + l8;
                    double d28 = this.wtablel.getDouble(l21);
                    double d29 = (double)l6 * this.wtablel.getDouble(l21 + 1L);
                    double d30 = this.wtablel.getDouble(l22);
                    double d31 = (double)l6 * this.wtablel.getDouble(l22 + 1L);
                    long l23 = j + l17;
                    long l24 = l23 + l9;
                    long l25 = l24 + l9;
                    doubleLargeArray2.setDouble(l23, d16 + d18);
                    doubleLargeArray2.setDouble(l23 + 1L, d17 + d20);
                    doubleLargeArray2.setDouble(l24, d28 * d24 - d29 * d26);
                    doubleLargeArray2.setDouble(l24 + 1L, d28 * d26 + d29 * d24);
                    doubleLargeArray2.setDouble(l25, d30 * d25 - d31 * d27);
                    doubleLargeArray2.setDouble(l25 + 1L, d30 * d27 + d31 * d25);
                }
            }
        }
    }

    void passf4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n2 * n;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                int n11 = i * n;
                int n12 = n3 + 4 * n11 + 1;
                int n13 = n12 + n;
                int n14 = n13 + n;
                int n15 = n14 + n;
                double d = dArray[n12 - 1];
                double d2 = dArray[n12];
                double d3 = dArray[n13 - 1];
                double d4 = dArray[n13];
                double d5 = dArray[n14 - 1];
                double d6 = dArray[n14];
                double d7 = dArray[n15 - 1];
                double d8 = dArray[n15];
                double d9 = d2 - d6;
                double d10 = d2 + d6;
                double d11 = d8 - d4;
                double d12 = d4 + d8;
                double d13 = d - d5;
                double d14 = d + d5;
                double d15 = d3 - d7;
                double d16 = d3 + d7;
                int n16 = n4 + n11;
                int n17 = n16 + n10;
                int n18 = n17 + n10;
                int n19 = n18 + n10;
                dArray2[n16] = d14 + d16;
                dArray2[n16 + 1] = d10 + d12;
                dArray2[n17] = d13 + (double)n6 * d11;
                dArray2[n17 + 1] = d9 + (double)n6 * d15;
                dArray2[n18] = d14 - d16;
                dArray2[n18 + 1] = d10 - d12;
                dArray2[n19] = d13 - (double)n6 * d11;
                dArray2[n19 + 1] = d9 - (double)n6 * d15;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n20 = i * n;
                int n21 = n3 + 1 + 4 * n20;
                for (int j = 0; j < n - 1; j += 2) {
                    int n22 = j + n21;
                    int n23 = n22 + n;
                    int n24 = n23 + n;
                    int n25 = n24 + n;
                    double d = dArray[n22 - 1];
                    double d17 = dArray[n22];
                    double d18 = dArray[n23 - 1];
                    double d19 = dArray[n23];
                    double d20 = dArray[n24 - 1];
                    double d21 = dArray[n24];
                    double d22 = dArray[n25 - 1];
                    double d23 = dArray[n25];
                    double d24 = d17 - d21;
                    double d25 = d17 + d21;
                    double d26 = d19 + d23;
                    double d27 = d23 - d19;
                    double d28 = d - d20;
                    double d29 = d + d20;
                    double d30 = d18 - d22;
                    double d31 = d18 + d22;
                    double d32 = d29 - d31;
                    double d33 = d25 - d26;
                    double d34 = d28 + (double)n6 * d27;
                    double d35 = d28 - (double)n6 * d27;
                    double d36 = d24 + (double)n6 * d30;
                    double d37 = d24 - (double)n6 * d30;
                    int n26 = j + n7;
                    int n27 = j + n8;
                    int n28 = j + n9;
                    double d38 = this.wtable[n26];
                    double d39 = (double)n6 * this.wtable[n26 + 1];
                    double d40 = this.wtable[n27];
                    double d41 = (double)n6 * this.wtable[n27 + 1];
                    double d42 = this.wtable[n28];
                    double d43 = (double)n6 * this.wtable[n28 + 1];
                    int n29 = n4 + j + n20;
                    int n30 = n29 + n10;
                    int n31 = n30 + n10;
                    int n32 = n31 + n10;
                    dArray2[n29] = d29 + d31;
                    dArray2[n29 + 1] = d25 + d26;
                    dArray2[n30] = d38 * d34 - d39 * d36;
                    dArray2[n30 + 1] = d38 * d36 + d39 * d34;
                    dArray2[n31] = d40 * d32 - d41 * d33;
                    dArray2[n31 + 1] = d40 * d33 + d41 * d32;
                    dArray2[n32] = d42 * d35 - d43 * d37;
                    dArray2[n32 + 1] = d42 * d37 + d43 * d35;
                }
            }
        }
    }

    void passf4(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5, int n) {
        long l6 = l5;
        long l7 = l6 + l;
        long l8 = l7 + l;
        long l9 = l2 * l;
        if (l == 2L) {
            for (long i = 0L; i < l2; ++i) {
                long l10 = i * l;
                long l11 = l3 + 4L * l10 + 1L;
                long l12 = l11 + l;
                long l13 = l12 + l;
                long l14 = l13 + l;
                double d = doubleLargeArray.getDouble(l11 - 1L);
                double d2 = doubleLargeArray.getDouble(l11);
                double d3 = doubleLargeArray.getDouble(l12 - 1L);
                double d4 = doubleLargeArray.getDouble(l12);
                double d5 = doubleLargeArray.getDouble(l13 - 1L);
                double d6 = doubleLargeArray.getDouble(l13);
                double d7 = doubleLargeArray.getDouble(l14 - 1L);
                double d8 = doubleLargeArray.getDouble(l14);
                double d9 = d2 - d6;
                double d10 = d2 + d6;
                double d11 = d8 - d4;
                double d12 = d4 + d8;
                double d13 = d - d5;
                double d14 = d + d5;
                double d15 = d3 - d7;
                double d16 = d3 + d7;
                long l15 = l4 + l10;
                long l16 = l15 + l9;
                long l17 = l16 + l9;
                long l18 = l17 + l9;
                doubleLargeArray2.setDouble(l15, d14 + d16);
                doubleLargeArray2.setDouble(l15 + 1L, d10 + d12);
                doubleLargeArray2.setDouble(l16, d13 + (double)n * d11);
                doubleLargeArray2.setDouble(l16 + 1L, d9 + (double)n * d15);
                doubleLargeArray2.setDouble(l17, d14 - d16);
                doubleLargeArray2.setDouble(l17 + 1L, d10 - d12);
                doubleLargeArray2.setDouble(l18, d13 - (double)n * d11);
                doubleLargeArray2.setDouble(l18 + 1L, d9 - (double)n * d15);
            }
        } else {
            for (long i = 0L; i < l2; ++i) {
                long l19 = i * l;
                long l20 = l3 + 1L + 4L * l19;
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l21 = j + l20;
                    long l22 = l21 + l;
                    long l23 = l22 + l;
                    long l24 = l23 + l;
                    double d = doubleLargeArray.getDouble(l21 - 1L);
                    double d17 = doubleLargeArray.getDouble(l21);
                    double d18 = doubleLargeArray.getDouble(l22 - 1L);
                    double d19 = doubleLargeArray.getDouble(l22);
                    double d20 = doubleLargeArray.getDouble(l23 - 1L);
                    double d21 = doubleLargeArray.getDouble(l23);
                    double d22 = doubleLargeArray.getDouble(l24 - 1L);
                    double d23 = doubleLargeArray.getDouble(l24);
                    double d24 = d17 - d21;
                    double d25 = d17 + d21;
                    double d26 = d19 + d23;
                    double d27 = d23 - d19;
                    double d28 = d - d20;
                    double d29 = d + d20;
                    double d30 = d18 - d22;
                    double d31 = d18 + d22;
                    double d32 = d29 - d31;
                    double d33 = d25 - d26;
                    double d34 = d28 + (double)n * d27;
                    double d35 = d28 - (double)n * d27;
                    double d36 = d24 + (double)n * d30;
                    double d37 = d24 - (double)n * d30;
                    long l25 = j + l6;
                    long l26 = j + l7;
                    long l27 = j + l8;
                    double d38 = this.wtablel.getDouble(l25);
                    double d39 = (double)n * this.wtablel.getDouble(l25 + 1L);
                    double d40 = this.wtablel.getDouble(l26);
                    double d41 = (double)n * this.wtablel.getDouble(l26 + 1L);
                    double d42 = this.wtablel.getDouble(l27);
                    double d43 = (double)n * this.wtablel.getDouble(l27 + 1L);
                    long l28 = l4 + j + l19;
                    long l29 = l28 + l9;
                    long l30 = l29 + l9;
                    long l31 = l30 + l9;
                    doubleLargeArray2.setDouble(l28, d29 + d31);
                    doubleLargeArray2.setDouble(l28 + 1L, d25 + d26);
                    doubleLargeArray2.setDouble(l29, d38 * d34 - d39 * d36);
                    doubleLargeArray2.setDouble(l29 + 1L, d38 * d36 + d39 * d34);
                    doubleLargeArray2.setDouble(l30, d40 * d32 - d41 * d33);
                    doubleLargeArray2.setDouble(l30 + 1L, d40 * d33 + d41 * d32);
                    doubleLargeArray2.setDouble(l31, d42 * d35 - d43 * d37);
                    doubleLargeArray2.setDouble(l31 + 1L, d42 * d37 + d43 * d35);
                }
            }
        }
    }

    void passf5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n9 + n;
        int n11 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n12 = n3 + (5 * i - 4) * n + 1;
                int n13 = n12 + n;
                int n14 = n12 - n;
                int n15 = n13 + n;
                int n16 = n15 + n;
                double d = dArray[n12 - 1];
                double d2 = dArray[n12];
                double d3 = dArray[n13 - 1];
                double d4 = dArray[n13];
                double d5 = dArray[n14 - 1];
                double d6 = dArray[n14];
                double d7 = dArray[n15 - 1];
                double d8 = dArray[n15];
                double d9 = dArray[n16 - 1];
                double d10 = dArray[n16];
                double d11 = d2 - d10;
                double d12 = d2 + d10;
                double d13 = d4 - d8;
                double d14 = d4 + d8;
                double d15 = d - d9;
                double d16 = d + d9;
                double d17 = d3 - d7;
                double d18 = d3 + d7;
                double d19 = d5 + 0.30901699437494745 * d16 + -0.8090169943749473 * d18;
                double d20 = d6 + 0.30901699437494745 * d12 + -0.8090169943749473 * d14;
                double d21 = d5 + -0.8090169943749473 * d16 + 0.30901699437494745 * d18;
                double d22 = d6 + -0.8090169943749473 * d12 + 0.30901699437494745 * d14;
                double d23 = (double)n6 * (0.9510565162951535 * d15 + 0.5877852522924732 * d17);
                double d24 = (double)n6 * (0.9510565162951535 * d11 + 0.5877852522924732 * d13);
                double d25 = (double)n6 * (0.5877852522924732 * d15 - 0.9510565162951535 * d17);
                double d26 = (double)n6 * (0.5877852522924732 * d11 - 0.9510565162951535 * d13);
                int n17 = n4 + (i - 1) * n;
                int n18 = n17 + n11;
                int n19 = n18 + n11;
                int n20 = n19 + n11;
                int n21 = n20 + n11;
                dArray2[n17] = d5 + d16 + d18;
                dArray2[n17 + 1] = d6 + d12 + d14;
                dArray2[n18] = d19 - d24;
                dArray2[n18 + 1] = d20 + d23;
                dArray2[n19] = d21 - d26;
                dArray2[n19 + 1] = d22 + d25;
                dArray2[n20] = d21 + d26;
                dArray2[n20 + 1] = d22 - d25;
                dArray2[n21] = d19 + d24;
                dArray2[n21 + 1] = d20 - d23;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n22 = n3 + 1 + (i * 5 - 4) * n;
                int n23 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n24 = j + n22;
                    int n25 = n24 + n;
                    int n26 = n24 - n;
                    int n27 = n25 + n;
                    int n28 = n27 + n;
                    double d = dArray[n24 - 1];
                    double d27 = dArray[n24];
                    double d28 = dArray[n25 - 1];
                    double d29 = dArray[n25];
                    double d30 = dArray[n26 - 1];
                    double d31 = dArray[n26];
                    double d32 = dArray[n27 - 1];
                    double d33 = dArray[n27];
                    double d34 = dArray[n28 - 1];
                    double d35 = dArray[n28];
                    double d36 = d27 - d35;
                    double d37 = d27 + d35;
                    double d38 = d29 - d33;
                    double d39 = d29 + d33;
                    double d40 = d - d34;
                    double d41 = d + d34;
                    double d42 = d28 - d32;
                    double d43 = d28 + d32;
                    double d44 = d30 + 0.30901699437494745 * d41 + -0.8090169943749473 * d43;
                    double d45 = d31 + 0.30901699437494745 * d37 + -0.8090169943749473 * d39;
                    double d46 = d30 + -0.8090169943749473 * d41 + 0.30901699437494745 * d43;
                    double d47 = d31 + -0.8090169943749473 * d37 + 0.30901699437494745 * d39;
                    double d48 = (double)n6 * (0.9510565162951535 * d40 + 0.5877852522924732 * d42);
                    double d49 = (double)n6 * (0.9510565162951535 * d36 + 0.5877852522924732 * d38);
                    double d50 = (double)n6 * (0.5877852522924732 * d40 - 0.9510565162951535 * d42);
                    double d51 = (double)n6 * (0.5877852522924732 * d36 - 0.9510565162951535 * d38);
                    double d52 = d46 - d51;
                    double d53 = d46 + d51;
                    double d54 = d47 + d50;
                    double d55 = d47 - d50;
                    double d56 = d44 + d49;
                    double d57 = d44 - d49;
                    double d58 = d45 - d48;
                    double d59 = d45 + d48;
                    int n29 = j + n7;
                    int n30 = j + n8;
                    int n31 = j + n9;
                    int n32 = j + n10;
                    double d60 = this.wtable[n29];
                    double d61 = (double)n6 * this.wtable[n29 + 1];
                    double d62 = this.wtable[n30];
                    double d63 = (double)n6 * this.wtable[n30 + 1];
                    double d64 = this.wtable[n31];
                    double d65 = (double)n6 * this.wtable[n31 + 1];
                    double d66 = this.wtable[n32];
                    double d67 = (double)n6 * this.wtable[n32 + 1];
                    int n33 = j + n23;
                    int n34 = n33 + n11;
                    int n35 = n34 + n11;
                    int n36 = n35 + n11;
                    int n37 = n36 + n11;
                    dArray2[n33] = d30 + d41 + d43;
                    dArray2[n33 + 1] = d31 + d37 + d39;
                    dArray2[n34] = d60 * d57 - d61 * d59;
                    dArray2[n34 + 1] = d60 * d59 + d61 * d57;
                    dArray2[n35] = d62 * d52 - d63 * d54;
                    dArray2[n35 + 1] = d62 * d54 + d63 * d52;
                    dArray2[n36] = d64 * d53 - d65 * d55;
                    dArray2[n36 + 1] = d64 * d55 + d65 * d53;
                    dArray2[n37] = d66 * d56 - d67 * d58;
                    dArray2[n37 + 1] = d66 * d58 + d67 * d56;
                }
            }
        }
    }

    void passf5(long l, long l2, DoubleLargeArray doubleLargeArray, long l3, DoubleLargeArray doubleLargeArray2, long l4, long l5, long l6) {
        long l7 = l5;
        long l8 = l7 + l;
        long l9 = l8 + l;
        long l10 = l9 + l;
        long l11 = l2 * l;
        if (l == 2L) {
            for (long i = 1L; i <= l2; ++i) {
                long l12 = l3 + (5L * i - 4L) * l + 1L;
                long l13 = l12 + l;
                long l14 = l12 - l;
                long l15 = l13 + l;
                long l16 = l15 + l;
                double d = doubleLargeArray.getDouble(l12 - 1L);
                double d2 = doubleLargeArray.getDouble(l12);
                double d3 = doubleLargeArray.getDouble(l13 - 1L);
                double d4 = doubleLargeArray.getDouble(l13);
                double d5 = doubleLargeArray.getDouble(l14 - 1L);
                double d6 = doubleLargeArray.getDouble(l14);
                double d7 = doubleLargeArray.getDouble(l15 - 1L);
                double d8 = doubleLargeArray.getDouble(l15);
                double d9 = doubleLargeArray.getDouble(l16 - 1L);
                double d10 = doubleLargeArray.getDouble(l16);
                double d11 = d2 - d10;
                double d12 = d2 + d10;
                double d13 = d4 - d8;
                double d14 = d4 + d8;
                double d15 = d - d9;
                double d16 = d + d9;
                double d17 = d3 - d7;
                double d18 = d3 + d7;
                double d19 = d5 + 0.30901699437494745 * d16 + -0.8090169943749473 * d18;
                double d20 = d6 + 0.30901699437494745 * d12 + -0.8090169943749473 * d14;
                double d21 = d5 + -0.8090169943749473 * d16 + 0.30901699437494745 * d18;
                double d22 = d6 + -0.8090169943749473 * d12 + 0.30901699437494745 * d14;
                double d23 = (double)l6 * (0.9510565162951535 * d15 + 0.5877852522924732 * d17);
                double d24 = (double)l6 * (0.9510565162951535 * d11 + 0.5877852522924732 * d13);
                double d25 = (double)l6 * (0.5877852522924732 * d15 - 0.9510565162951535 * d17);
                double d26 = (double)l6 * (0.5877852522924732 * d11 - 0.9510565162951535 * d13);
                long l17 = l4 + (i - 1L) * l;
                long l18 = l17 + l11;
                long l19 = l18 + l11;
                long l20 = l19 + l11;
                long l21 = l20 + l11;
                doubleLargeArray2.setDouble(l17, d5 + d16 + d18);
                doubleLargeArray2.setDouble(l17 + 1L, d6 + d12 + d14);
                doubleLargeArray2.setDouble(l18, d19 - d24);
                doubleLargeArray2.setDouble(l18 + 1L, d20 + d23);
                doubleLargeArray2.setDouble(l19, d21 - d26);
                doubleLargeArray2.setDouble(l19 + 1L, d22 + d25);
                doubleLargeArray2.setDouble(l20, d21 + d26);
                doubleLargeArray2.setDouble(l20 + 1L, d22 - d25);
                doubleLargeArray2.setDouble(l21, d19 + d24);
                doubleLargeArray2.setDouble(l21 + 1L, d20 - d23);
            }
        } else {
            for (long i = 1L; i <= l2; ++i) {
                long l22 = l3 + 1L + (i * 5L - 4L) * l;
                long l23 = l4 + (i - 1L) * l;
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l24 = j + l22;
                    long l25 = l24 + l;
                    long l26 = l24 - l;
                    long l27 = l25 + l;
                    long l28 = l27 + l;
                    double d = doubleLargeArray.getDouble(l24 - 1L);
                    double d27 = doubleLargeArray.getDouble(l24);
                    double d28 = doubleLargeArray.getDouble(l25 - 1L);
                    double d29 = doubleLargeArray.getDouble(l25);
                    double d30 = doubleLargeArray.getDouble(l26 - 1L);
                    double d31 = doubleLargeArray.getDouble(l26);
                    double d32 = doubleLargeArray.getDouble(l27 - 1L);
                    double d33 = doubleLargeArray.getDouble(l27);
                    double d34 = doubleLargeArray.getDouble(l28 - 1L);
                    double d35 = doubleLargeArray.getDouble(l28);
                    double d36 = d27 - d35;
                    double d37 = d27 + d35;
                    double d38 = d29 - d33;
                    double d39 = d29 + d33;
                    double d40 = d - d34;
                    double d41 = d + d34;
                    double d42 = d28 - d32;
                    double d43 = d28 + d32;
                    double d44 = d30 + 0.30901699437494745 * d41 + -0.8090169943749473 * d43;
                    double d45 = d31 + 0.30901699437494745 * d37 + -0.8090169943749473 * d39;
                    double d46 = d30 + -0.8090169943749473 * d41 + 0.30901699437494745 * d43;
                    double d47 = d31 + -0.8090169943749473 * d37 + 0.30901699437494745 * d39;
                    double d48 = (double)l6 * (0.9510565162951535 * d40 + 0.5877852522924732 * d42);
                    double d49 = (double)l6 * (0.9510565162951535 * d36 + 0.5877852522924732 * d38);
                    double d50 = (double)l6 * (0.5877852522924732 * d40 - 0.9510565162951535 * d42);
                    double d51 = (double)l6 * (0.5877852522924732 * d36 - 0.9510565162951535 * d38);
                    double d52 = d46 - d51;
                    double d53 = d46 + d51;
                    double d54 = d47 + d50;
                    double d55 = d47 - d50;
                    double d56 = d44 + d49;
                    double d57 = d44 - d49;
                    double d58 = d45 - d48;
                    double d59 = d45 + d48;
                    long l29 = j + l7;
                    long l30 = j + l8;
                    long l31 = j + l9;
                    long l32 = j + l10;
                    double d60 = this.wtablel.getDouble(l29);
                    double d61 = (double)l6 * this.wtablel.getDouble(l29 + 1L);
                    double d62 = this.wtablel.getDouble(l30);
                    double d63 = (double)l6 * this.wtablel.getDouble(l30 + 1L);
                    double d64 = this.wtablel.getDouble(l31);
                    double d65 = (double)l6 * this.wtablel.getDouble(l31 + 1L);
                    double d66 = this.wtablel.getDouble(l32);
                    double d67 = (double)l6 * this.wtablel.getDouble(l32 + 1L);
                    long l33 = j + l23;
                    long l34 = l33 + l11;
                    long l35 = l34 + l11;
                    long l36 = l35 + l11;
                    long l37 = l36 + l11;
                    doubleLargeArray2.setDouble(l33, d30 + d41 + d43);
                    doubleLargeArray2.setDouble(l33 + 1L, d31 + d37 + d39);
                    doubleLargeArray2.setDouble(l34, d60 * d57 - d61 * d59);
                    doubleLargeArray2.setDouble(l34 + 1L, d60 * d59 + d61 * d57);
                    doubleLargeArray2.setDouble(l35, d62 * d52 - d63 * d54);
                    doubleLargeArray2.setDouble(l35 + 1L, d62 * d54 + d63 * d52);
                    doubleLargeArray2.setDouble(l36, d64 * d53 - d65 * d55);
                    doubleLargeArray2.setDouble(l36 + 1L, d64 * d55 + d65 * d53);
                    doubleLargeArray2.setDouble(l37, d66 * d56 - d67 * d58);
                    doubleLargeArray2.setDouble(l37 + 1L, d66 * d58 + d67 * d56);
                }
            }
        }
    }

    void passfg(int[] nArray, int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7, int n8) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        int n21 = n / 2;
        int n22 = (n2 + 1) / 2;
        int n23 = n2 * n;
        if (n >= n3) {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n;
                n16 = n18 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    n14 = n15 * n;
                    n13 = n14 + n17 * n3;
                    n12 = n14 + n16 * n3;
                    n11 = n14 * n2;
                    for (n10 = 0; n10 < n; ++n10) {
                        n9 = n6 + n10;
                        double d6 = dArray[n5 + n10 + n17 + n11];
                        d5 = dArray[n5 + n10 + n16 + n11];
                        dArray2[n9 + n13] = d6 + d5;
                        dArray2[n9 + n12] = d6 - d5;
                    }
                }
            }
            for (n19 = 0; n19 < n3; ++n19) {
                n17 = n19 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    dArray2[n6 + n15 + n17] = dArray[n5 + n15 + n16];
                }
            }
        } else {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n3 * n;
                n16 = n18 * n3 * n;
                n15 = n19 * n;
                n14 = n18 * n;
                for (n13 = 0; n13 < n; ++n13) {
                    for (n12 = 0; n12 < n3; ++n12) {
                        n11 = n12 * n;
                        n10 = n11 * n2;
                        n9 = n6 + n13;
                        int n24 = n5 + n13;
                        d4 = dArray[n24 + n15 + n10];
                        d3 = dArray[n24 + n14 + n10];
                        dArray2[n9 + n11 + n17] = d4 + d3;
                        dArray2[n9 + n11 + n16] = d4 - d3;
                    }
                }
            }
            for (n19 = 0; n19 < n; ++n19) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    dArray2[n6 + n19 + n16] = dArray[n5 + n19 + n16 * n2];
                }
            }
        }
        int n25 = 2 - n;
        int n26 = 0;
        n19 = (n2 - 1) * n4;
        for (int i = 1; i < n22; ++i) {
            int n27 = n2 - i;
            n17 = i * n4;
            n16 = n27 * n4;
            n15 = (n25 += n) + n20;
            d2 = this.wtable[n15 - 2];
            d = (double)n8 * this.wtable[n15 - 1];
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                dArray[n13 + n17] = dArray2[n12] + d2 * dArray2[n12 + n4];
                dArray[n13 + n16] = d * dArray2[n12 + n19];
            }
            int n28 = n25;
            n26 += n;
            for (n14 = 2; n14 < n22; ++n14) {
                n18 = n2 - n14;
                if ((n28 += n26) > n23) {
                    n28 -= n23;
                }
                n13 = n28 + n20;
                double d7 = this.wtable[n13 - 2];
                double d8 = (double)n8 * this.wtable[n13 - 1];
                n12 = n14 * n4;
                n11 = n18 * n4;
                for (n10 = 0; n10 < n4; ++n10) {
                    n9 = n5 + n10;
                    int n29 = n6 + n10;
                    int n30 = n9 + n17;
                    dArray[n30] = dArray[n30] + d7 * dArray2[n29 + n12];
                    int n31 = n9 + n16;
                    dArray[n31] = dArray[n31] + d8 * dArray2[n29 + n11];
                }
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n16 = n17 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n32 = n14 = n6 + n15;
                dArray2[n32] = dArray2[n32] + dArray2[n14 + n16];
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n18 = n2 - n17;
            n16 = n17 * n4;
            n15 = n18 * n4;
            for (n14 = 1; n14 < n4; n14 += 2) {
                n13 = n6 + n14;
                n12 = n5 + n14;
                n11 = n12 + n16;
                n10 = n12 + n15;
                double d9 = dArray[n11 - 1];
                d4 = dArray[n11];
                d3 = dArray[n10 - 1];
                double d10 = dArray[n10];
                int n33 = n13 + n16;
                int n34 = n13 + n15;
                dArray2[n33 - 1] = d9 - d10;
                dArray2[n34 - 1] = d9 + d10;
                dArray2[n33] = d4 + d3;
                dArray2[n34] = d4 - d3;
            }
        }
        nArray[0] = 1;
        if (n == 2) {
            return;
        }
        nArray[0] = 0;
        System.arraycopy(dArray2, n6, dArray, n5, n4);
        n17 = n3 * n;
        for (n16 = 1; n16 < n2; ++n16) {
            n15 = n16 * n17;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13 + n15;
                n11 = n5 + n13 + n15;
                dArray[n11] = dArray2[n12];
                dArray[n11 + 1] = dArray2[n12 + 1];
            }
        }
        if (n21 <= n3) {
            int n35 = 0;
            for (n16 = 1; n16 < n2; ++n16) {
                n35 += 2;
                n15 = n16 * n3 * n;
                for (n14 = 3; n14 < n; n14 += 2) {
                    n13 = (n35 += 2) + n20 - 1;
                    d2 = this.wtable[n13 - 1];
                    d = (double)n8 * this.wtable[n13];
                    n12 = n5 + n14;
                    n11 = n6 + n14;
                    for (n10 = 0; n10 < n3; ++n10) {
                        int n36 = n10 * n + n15;
                        int n37 = n12 + n36;
                        int n38 = n11 + n36;
                        d5 = dArray2[n38 - 1];
                        double d11 = dArray2[n38];
                        dArray[n37 - 1] = d2 * d5 - d * d11;
                        dArray[n37] = d2 * d11 + d * d5;
                    }
                }
            }
        } else {
            int n39 = 2 - n;
            for (n16 = 1; n16 < n2; ++n16) {
                n39 += n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    int n40 = n39;
                    n13 = n14 * n + n15;
                    for (n12 = 3; n12 < n; n12 += 2) {
                        n11 = (n40 += 2) - 1 + n20;
                        d2 = this.wtable[n11 - 1];
                        d = (double)n8 * this.wtable[n11];
                        n10 = n5 + n12 + n13;
                        int n41 = n6 + n12 + n13;
                        double d12 = dArray2[n41 - 1];
                        d5 = dArray2[n41];
                        dArray[n10 - 1] = d2 * d12 - d * d5;
                        dArray[n10] = d2 * d5 + d * d12;
                    }
                }
            }
        }
    }

    void passfg(int[] nArray, long l, long l2, long l3, long l4, DoubleLargeArray doubleLargeArray, long l5, DoubleLargeArray doubleLargeArray2, long l6, long l7, long l8) {
        double d;
        double d2;
        double d3;
        double d4;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        long l20 = l7;
        long l21 = l / 2L;
        long l22 = (l2 + 1L) / 2L;
        long l23 = l2 * l;
        if (l >= l3) {
            for (l19 = 1L; l19 < l22; ++l19) {
                l18 = l2 - l19;
                l17 = l19 * l;
                l16 = l18 * l;
                for (l15 = 0L; l15 < l3; ++l15) {
                    l14 = l15 * l;
                    l13 = l14 + l17 * l3;
                    l12 = l14 + l16 * l3;
                    l11 = l14 * l2;
                    for (l10 = 0L; l10 < l; ++l10) {
                        l9 = l6 + l10;
                        double d5 = doubleLargeArray.getDouble(l5 + l10 + l17 + l11);
                        d4 = doubleLargeArray.getDouble(l5 + l10 + l16 + l11);
                        doubleLargeArray2.setDouble(l9 + l13, d5 + d4);
                        doubleLargeArray2.setDouble(l9 + l12, d5 - d4);
                    }
                }
            }
            for (l19 = 0L; l19 < l3; ++l19) {
                l17 = l19 * l;
                l16 = l17 * l2;
                for (l15 = 0L; l15 < l; ++l15) {
                    doubleLargeArray2.setDouble(l6 + l15 + l17, doubleLargeArray.getDouble(l5 + l15 + l16));
                }
            }
        } else {
            for (l19 = 1L; l19 < l22; ++l19) {
                l18 = l2 - l19;
                l17 = l19 * l3 * l;
                l16 = l18 * l3 * l;
                l15 = l19 * l;
                l14 = l18 * l;
                for (l13 = 0L; l13 < l; ++l13) {
                    for (l12 = 0L; l12 < l3; ++l12) {
                        l11 = l12 * l;
                        l10 = l11 * l2;
                        l9 = l6 + l13;
                        long l24 = l5 + l13;
                        d4 = doubleLargeArray.getDouble(l24 + l15 + l10);
                        d3 = doubleLargeArray.getDouble(l24 + l14 + l10);
                        doubleLargeArray2.setDouble(l9 + l11 + l17, d4 + d3);
                        doubleLargeArray2.setDouble(l9 + l11 + l16, d4 - d3);
                    }
                }
            }
            for (l19 = 0L; l19 < l; ++l19) {
                for (l17 = 0L; l17 < l3; ++l17) {
                    l16 = l17 * l;
                    doubleLargeArray2.setDouble(l6 + l19 + l16, doubleLargeArray.getDouble(l5 + l19 + l16 * l2));
                }
            }
        }
        long l25 = 2L - l;
        long l26 = 0L;
        l19 = (l2 - 1L) * l4;
        for (long i = 1L; i < l22; ++i) {
            long l27 = l2 - i;
            l17 = i * l4;
            l16 = l27 * l4;
            l15 = (l25 += l) + l20;
            d2 = this.wtablel.getDouble(l15 - 2L);
            d = (double)l8 * this.wtablel.getDouble(l15 - 1L);
            for (l14 = 0L; l14 < l4; ++l14) {
                l13 = l5 + l14;
                l12 = l6 + l14;
                doubleLargeArray.setDouble(l13 + l17, doubleLargeArray2.getDouble(l12) + d2 * doubleLargeArray2.getDouble(l12 + l4));
                doubleLargeArray.setDouble(l13 + l16, d * doubleLargeArray2.getDouble(l12 + l19));
            }
            long l28 = l25;
            l26 += l;
            for (l14 = 2L; l14 < l22; ++l14) {
                l18 = l2 - l14;
                if ((l28 += l26) > l23) {
                    l28 -= l23;
                }
                l13 = l28 + l20;
                double d6 = this.wtablel.getDouble(l13 - 2L);
                double d7 = (double)l8 * this.wtablel.getDouble(l13 - 1L);
                l12 = l14 * l4;
                l11 = l18 * l4;
                for (l10 = 0L; l10 < l4; ++l10) {
                    l9 = l5 + l10;
                    long l29 = l6 + l10;
                    doubleLargeArray.setDouble(l9 + l17, doubleLargeArray.getDouble(l9 + l17) + d6 * doubleLargeArray2.getDouble(l29 + l12));
                    doubleLargeArray.setDouble(l9 + l16, doubleLargeArray.getDouble(l9 + l16) + d7 * doubleLargeArray2.getDouble(l29 + l11));
                }
            }
        }
        for (l17 = 1L; l17 < l22; ++l17) {
            l16 = l17 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                l14 = l6 + l15;
                doubleLargeArray2.setDouble(l14, doubleLargeArray2.getDouble(l14) + doubleLargeArray2.getDouble(l14 + l16));
            }
        }
        for (l17 = 1L; l17 < l22; ++l17) {
            l18 = l2 - l17;
            l16 = l17 * l4;
            l15 = l18 * l4;
            for (l14 = 1L; l14 < l4; l14 += 2L) {
                l13 = l6 + l14;
                l12 = l5 + l14;
                l11 = l12 + l16;
                l10 = l12 + l15;
                double d8 = doubleLargeArray.getDouble(l11 - 1L);
                double d9 = doubleLargeArray.getDouble(l11);
                d4 = doubleLargeArray.getDouble(l10 - 1L);
                d3 = doubleLargeArray.getDouble(l10);
                long l30 = l13 + l16;
                long l31 = l13 + l15;
                doubleLargeArray2.setDouble(l30 - 1L, d8 - d3);
                doubleLargeArray2.setDouble(l31 - 1L, d8 + d3);
                doubleLargeArray2.setDouble(l30, d9 + d4);
                doubleLargeArray2.setDouble(l31, d9 - d4);
            }
        }
        nArray[0] = 1;
        if (l == 2L) {
            return;
        }
        nArray[0] = 0;
        Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)l6, (DoubleLargeArray)doubleLargeArray, (long)l5, (long)l4);
        l17 = l3 * l;
        for (l16 = 1L; l16 < l2; ++l16) {
            l15 = l16 * l17;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                l12 = l6 + l13 + l15;
                l11 = l5 + l13 + l15;
                doubleLargeArray.setDouble(l11, doubleLargeArray2.getDouble(l12));
                doubleLargeArray.setDouble(l11 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
            }
        }
        if (l21 <= l3) {
            long l32 = 0L;
            for (l16 = 1L; l16 < l2; ++l16) {
                l32 += 2L;
                l15 = l16 * l3 * l;
                for (l14 = 3L; l14 < l; l14 += 2L) {
                    l13 = (l32 += 2L) + l20 - 1L;
                    d2 = this.wtablel.getDouble(l13 - 1L);
                    d = (double)l8 * this.wtablel.getDouble(l13);
                    l12 = l5 + l14;
                    l11 = l6 + l14;
                    for (l10 = 0L; l10 < l3; ++l10) {
                        long l33 = l10 * l + l15;
                        long l34 = l12 + l33;
                        long l35 = l11 + l33;
                        d3 = doubleLargeArray2.getDouble(l35 - 1L);
                        double d10 = doubleLargeArray2.getDouble(l35);
                        doubleLargeArray.setDouble(l34 - 1L, d2 * d3 - d * d10);
                        doubleLargeArray.setDouble(l34, d2 * d10 + d * d3);
                    }
                }
            }
        } else {
            long l36 = 2L - l;
            for (l16 = 1L; l16 < l2; ++l16) {
                l36 += l;
                l15 = l16 * l3 * l;
                for (l14 = 0L; l14 < l3; ++l14) {
                    long l37 = l36;
                    l13 = l14 * l + l15;
                    for (l12 = 3L; l12 < l; l12 += 2L) {
                        l11 = (l37 += 2L) - 1L + l20;
                        d2 = this.wtablel.getDouble(l11 - 1L);
                        d = (double)l8 * this.wtablel.getDouble(l11);
                        l10 = l5 + l12 + l13;
                        long l38 = l6 + l12 + l13;
                        double d11 = doubleLargeArray2.getDouble(l38 - 1L);
                        d4 = doubleLargeArray2.getDouble(l38);
                        doubleLargeArray.setDouble(l10 - 1L, d2 * d11 - d * d4);
                        doubleLargeArray.setDouble(l10, d2 * d4 + d * d11);
                    }
                }
            }
        }
    }

    private static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

