/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.utils;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;

public class IOUtils {
    private static final String FF = "%.4f";

    private IOUtils() {
    }

    public static void fillMatrix_1D(int n, double[] dArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            dArray[i] = random.nextDouble();
        }
    }

    public static void fillMatrix_1D(int n, float[] fArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            fArray[i] = random.nextFloat();
        }
    }

    public static void fillMatrix_2D(int n, int n2, double[] dArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i * n2 + j] = random.nextDouble();
            }
        }
    }

    public static void fillMatrix_2D(int n, int n2, float[] fArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i * n2 + j] = random.nextFloat();
            }
        }
    }

    public static void fillMatrix_2D(int n, int n2, double[][] dArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = random.nextDouble();
            }
        }
    }

    public static void fillMatrix_2D(int n, int n2, float[][] fArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = random.nextFloat();
            }
        }
    }

    public static void fillMatrix_3D(int n, int n2, int n3, double[] dArray) {
        Random random = new Random(2L);
        int n4 = n2 * n3;
        int n5 = n3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray[i * n4 + j * n5 + k] = random.nextDouble();
                }
            }
        }
    }

    public static void fillMatrix_3D(int n, int n2, int n3, float[] fArray) {
        Random random = new Random(2L);
        int n4 = n2 * n3;
        int n5 = n3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i * n4 + j * n5 + k] = random.nextFloat();
                }
            }
        }
    }

    public static void fillMatrix_3D(int n, int n2, int n3, double[][][] dArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray[i][j][k] = random.nextDouble();
                }
            }
        }
    }

    public static void fillMatrix_3D(int n, int n2, int n3, float[][][] fArray) {
        Random random = new Random(2L);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i][j][k] = random.nextFloat();
                }
            }
        }
    }

    public static void showComplex_1D(double[] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < dArray.length; i += 2) {
            if (dArray[i + 1] == 0.0) {
                System.out.println(String.format(FF, dArray[i]));
                continue;
            }
            if (dArray[i] == 0.0) {
                System.out.println(String.format(FF, dArray[i + 1]) + "i");
                continue;
            }
            if (dArray[i + 1] < 0.0) {
                System.out.println(String.format(FF, dArray[i]) + " - " + String.format(FF, -dArray[i + 1]) + "i");
                continue;
            }
            System.out.println(String.format(FF, dArray[i]) + " + " + String.format(FF, dArray[i + 1]) + "i");
        }
        System.out.println();
    }

    public static void showComplex_2D(int n, int n2, double[] dArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format(string + ": complex array 2D: %d rows, %d columns\n\n", n, n2));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2 * n2; j += 2) {
                if (dArray[i * 2 * n2 + j + 1] == 0.0) {
                    stringBuffer.append(String.format("%.4f\t", dArray[i * 2 * n2 + j]));
                    continue;
                }
                if (dArray[i * 2 * n2 + j] == 0.0) {
                    stringBuffer.append(String.format("%.4fi\t", dArray[i * 2 * n2 + j + 1]));
                    continue;
                }
                if (dArray[i * 2 * n2 + j + 1] < 0.0) {
                    stringBuffer.append(String.format("%.4f - %.4fi\t", dArray[i * 2 * n2 + j], -dArray[i * 2 * n2 + j + 1]));
                    continue;
                }
                stringBuffer.append(String.format("%.4f + %.4fi\t", dArray[i * 2 * n2 + j], dArray[i * 2 * n2 + j + 1]));
            }
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer.toString());
    }

    public static void showComplex_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * 2 * n3;
        int n5 = 2 * n3;
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < 2 * n3; i += 2) {
            System.out.println("(:,:," + i / 2 + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (dArray[j * n4 + k * n5 + i + 1] == 0.0) {
                        System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                        continue;
                    }
                    if (dArray[j * n4 + k * n5 + i] == 0.0) {
                        System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[j * n4 + k * n5 + i + 1] < 0.0) {
                        System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + " - " + String.format(FF, -dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + " + " + String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showComplex_3D(int n, int n2, int n3, double[][][] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < 2 * n3; i += 2) {
            System.out.println("(:,:," + i / 2 + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (dArray[j][k][i + 1] == 0.0) {
                        System.out.print(String.format(FF, dArray[j][k][i]) + "\t");
                        continue;
                    }
                    if (dArray[j][k][i] == 0.0) {
                        System.out.print(String.format(FF, dArray[j][k][i + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[j][k][i + 1] < 0.0) {
                        System.out.print(String.format(FF, dArray[j][k][i]) + " - " + String.format(FF, -dArray[j][k][i + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j][k][i]) + " + " + String.format(FF, dArray[j][k][i + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showComplex_3D(int n, int n2, int n3, float[] fArray, String string) {
        int n4 = n2 * 2 * n3;
        int n5 = 2 * n3;
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < 2 * n3; i += 2) {
            System.out.println("(:,:," + i / 2 + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (fArray[j * n4 + k * n5 + i + 1] == 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i])) + "\t");
                        continue;
                    }
                    if (fArray[j * n4 + k * n5 + i] == 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i + 1])) + "i\t");
                        continue;
                    }
                    if (fArray[j * n4 + k * n5 + i + 1] < 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i])) + " - " + String.format(FF, Float.valueOf(-fArray[j * n4 + k * n5 + i + 1])) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i])) + " + " + String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i + 1])) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showReal_1D(double[] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println(String.format(FF, dArray[i]));
        }
        System.out.println();
    }

    public static void showReal_2D(int n, int n2, double[] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (Math.abs(dArray[i * n2 + j]) < 5.0E-5) {
                    System.out.print("0\t");
                    continue;
                }
                System.out.print(String.format(FF, dArray[i * n2 + j]) + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void showReal_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * n3;
        int n5 = n3;
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < n3; ++i) {
            System.out.println();
            System.out.println("(:,:," + i + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (Math.abs(dArray[j * n4 + k * n5 + i]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void showReal_3D(int n, int n2, int n3, double[][][] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < n3; ++i) {
            System.out.println();
            System.out.println("(:,:," + i + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (Math.abs(dArray[j][k][i]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j][k][i]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void writeToFileComplex_1D(double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < dArray.length; i += 2) {
                if (dArray[i + 1] == 0.0) {
                    bufferedWriter.write(String.format(FF, dArray[i]));
                    bufferedWriter.newLine();
                    continue;
                }
                if (dArray[i] == 0.0) {
                    bufferedWriter.write(String.format(FF, dArray[i + 1]) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                if (dArray[i + 1] < 0.0) {
                    bufferedWriter.write(String.format(FF, dArray[i]) + " - " + String.format(FF, -dArray[i + 1]) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(String.format(FF, dArray[i]) + " + " + String.format(FF, dArray[i + 1]) + "i");
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_1D(float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < fArray.length; i += 2) {
                if (fArray[i + 1] == 0.0f) {
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])));
                    bufferedWriter.newLine();
                    continue;
                }
                if (fArray[i] == 0.0f) {
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i + 1])) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                if (fArray[i + 1] < 0.0f) {
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])) + " - " + String.format(FF, Float.valueOf(-fArray[i + 1])) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])) + " + " + String.format(FF, Float.valueOf(fArray[i + 1])) + "i");
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n, int n2, double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if (Math.abs(dArray[i * 2 * n2 + j]) < 5.0E-5 && Math.abs(dArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (dArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + 0i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (dArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " + 0i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i * 2 * n2 + j]) < 5.0E-5) {
                        if (dArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + " + String.format(FF, dArray[i * 2 * n2 + j + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - " + String.format(FF, -dArray[i * 2 * n2 + j + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[i * 2 * n2 + j + 1] < 0.0) {
                        bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " - " + String.format(FF, -dArray[i * 2 * n2 + j + 1]) + "i\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " + " + String.format(FF, dArray[i * 2 * n2 + j + 1]) + "i\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n, int n2, float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if ((double)Math.abs(fArray[i * 2 * n2 + j]) < 5.0E-5 && (double)Math.abs(fArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if ((double)fArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + 0i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - 0i\t");
                        continue;
                    }
                    if ((double)Math.abs(fArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if ((double)fArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " + 0i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " - 0i\t");
                        continue;
                    }
                    if ((double)Math.abs(fArray[i * 2 * n2 + j]) < 5.0E-5) {
                        if ((double)fArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + " + String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j + 1])) + "i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - " + String.format(FF, Float.valueOf(-fArray[i * 2 * n2 + j + 1])) + "i\t");
                        continue;
                    }
                    if (fArray[i * 2 * n2 + j + 1] < 0.0f) {
                        bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " - " + String.format(FF, Float.valueOf(-fArray[i * 2 * n2 + j + 1])) + "i\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " + " + String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j + 1])) + "i\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n, int n2, double[][] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if (Math.abs(dArray[i][j]) < 5.0E-5 && Math.abs(dArray[i][j + 1]) < 5.0E-5) {
                        if (dArray[i][j + 1] >= 0.0) {
                            bufferedWriter.write("0 + 0i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i][j + 1]) < 5.0E-5) {
                        if (dArray[i][j + 1] >= 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[i][j]) + " + 0i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[i][j]) + " - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i][j]) < 5.0E-5) {
                        if (dArray[i][j + 1] >= 0.0) {
                            bufferedWriter.write("0 + " + String.format(FF, dArray[i][j + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - " + String.format(FF, -dArray[i][j + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[i][j + 1] < 0.0) {
                        bufferedWriter.write(String.format(FF, dArray[i][j]) + " - " + String.format(FF, -dArray[i][j + 1]) + "i\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, dArray[i][j]) + " + " + String.format(FF, dArray[i][j + 1]) + "i\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * n3 * 2;
        int n5 = n3 * 2;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < 2 * n3; i += 2) {
                bufferedWriter.newLine();
                bufferedWriter.write("(:,:," + i / 2 + ")=");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        if (dArray[j * n4 + k * n5 + i + 1] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                            continue;
                        }
                        if (dArray[j * n4 + k * n5 + i] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                            continue;
                        }
                        if (dArray[j * n4 + k * n5 + i + 1] < 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + " - " + String.format(FF, -dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + " + " + String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(int n, int n2, int n3, double[][][] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < 2 * n3; i += 2) {
                bufferedWriter.newLine();
                bufferedWriter.write("(:,:," + i / 2 + ")=");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        if (dArray[j][k][i + 1] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j][k][i]) + "\t");
                            continue;
                        }
                        if (dArray[j][k][i] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j][k][i + 1]) + "i\t");
                            continue;
                        }
                        if (dArray[j][k][i + 1] < 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j][k][i]) + " - " + String.format(FF, -dArray[j][k][i + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[j][k][i]) + " + " + String.format(FF, dArray[j][k][i + 1]) + "i\t");
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < dArray.length; ++i) {
                bufferedWriter.write(String.format(FF, dArray[i]));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < fArray.length; ++i) {
                bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n, int n2, double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (Math.abs(dArray[i * n2 + j]) < 5.0E-5) {
                        bufferedWriter.write("0\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, dArray[i * n2 + j]) + "\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n, int n2, float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if ((double)Math.abs(fArray[i * n2 + j]) < 5.0E-5) {
                        bufferedWriter.write("0\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * n2 + j])) + "\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * n3;
        int n5 = n3;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n3; ++i) {
                bufferedWriter.newLine();
                bufferedWriter.write("(:,:," + i + ")=");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                    }
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeFFTBenchmarkResultsToFile(String string, int n, int n2, boolean bl, boolean bl2, int[] nArray, double[] dArray) {
        String[] stringArray = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            int n3;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, false));
            bufferedWriter.write(new Date().toString());
            bufferedWriter.newLine();
            bufferedWriter.write("System properties:");
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.name = " + System.getProperty(stringArray[0]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.version = " + System.getProperty(stringArray[1]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.arch = " + System.getProperty(stringArray[2]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tjava.vendor = " + System.getProperty(stringArray[3]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tjava.version = " + System.getProperty(stringArray[4]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            bufferedWriter.newLine();
            bufferedWriter.write("Settings:");
            bufferedWriter.newLine();
            bufferedWriter.write("\tused processors = " + n);
            bufferedWriter.newLine();
            bufferedWriter.write("\tTHREADS_BEGIN_N_2D = " + ConcurrencyUtils.getThreadsBeginN_2D());
            bufferedWriter.newLine();
            bufferedWriter.write("\tTHREADS_BEGIN_N_3D = " + ConcurrencyUtils.getThreadsBeginN_3D());
            bufferedWriter.newLine();
            bufferedWriter.write("\tnumber of iterations = " + n2);
            bufferedWriter.newLine();
            bufferedWriter.write("\twarm-up performed = " + bl);
            bufferedWriter.newLine();
            bufferedWriter.write("\tscaling performed = " + bl2);
            bufferedWriter.newLine();
            bufferedWriter.write("--------------------------------------------------------------------------------------------------");
            bufferedWriter.newLine();
            bufferedWriter.write("sizes=[");
            for (n3 = 0; n3 < nArray.length; ++n3) {
                bufferedWriter.write(Integer.toString(nArray[n3]));
                if (n3 < nArray.length - 1) {
                    bufferedWriter.write(", ");
                    continue;
                }
                bufferedWriter.write("]");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("times(in msec)=[");
            for (n3 = 0; n3 < dArray.length; ++n3) {
                bufferedWriter.write(String.format("%.2f", dArray[n3]));
                if (n3 < dArray.length - 1) {
                    bufferedWriter.write(", ");
                    continue;
                }
                bufferedWriter.write("]");
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

